/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.logging;

import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static final String CONFIGURE_BY_LOGGING_PROPERTIES_FILE = "java.util.logging.configureByLoggingPropertiesFile";
    private static boolean configureByServer = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByServer", "true"));
    private static boolean configureByLoggingProperties = "true".equalsIgnoreCase(System.getProperty("java.util.logging.configureByLoggingPropertiesFile"));
    private static volatile Constructor<?> wsLogger;
    private boolean resetEnabled = true;
    private static boolean svBinaryLoggingEnable;

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        boolean configureByServerLocal = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.parseBoolean(System.getProperty(WsLogManager.CONFIGURE_BY_SERVER_PROPERTY_NAME, "true"));
            }
        });
        boolean configureByLoggingPropertiesLocal = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.parseBoolean(System.getProperty(WsLogManager.CONFIGURE_BY_LOGGING_PROPERTIES_FILE));
            }
        });
        configureByServer = configureByServerLocal;
        configureByLoggingProperties = configureByLoggingPropertiesLocal;
        if (!configureByServer || configureByLoggingProperties) {
            super.readConfiguration();
        } else {
            LoggerHandlerManager.initialize();
        }
    }

    @Override
    public Logger getLogger(String name) {
        Logger logger = super.getLogger(name);
        if (wsLogger == null) {
            return logger;
        }
        if (logger == null) {
            boolean createNewLogger = false;
            Class<?> caller = null;
            Class<?>[] callStack = StackFinderSingleton.instance.getCallStack();
            String className = callStack[2].getName();
            if ("java.util.logging.LogManager".equals(className) || "java.util.logging.Logger".equals(className)) {
                createNewLogger = true;
                for (int i = 2; i < callStack.length; ++i) {
                    className = callStack[i].getName();
                    if ("java.util.logging.LogManager".equals(className) || "java.util.logging.Logger".equals(className)) continue;
                    caller = callStack[i];
                    break;
                }
            }
            if (createNewLogger) {
                try {
                    logger = (Logger)wsLogger.newInstance(name, caller, null);
                    Logger checkLogger = super.getLogger(name);
                    if (checkLogger != null) {
                        logger = checkLogger;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return logger;
    }

    @Override
    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }

    public static boolean isConfiguredByLoggingProperties() {
        return configureByLoggingProperties;
    }

    public static boolean isBinaryLoggingEnabled() {
        return svBinaryLoggingEnable;
    }

    public static void setBinaryLoggingEnabled(boolean binaryLogEnable) {
        svBinaryLoggingEnable = binaryLogEnable;
    }

    public static void setWsLogger(Class<?> clazz) {
        try {
            Class[] classParams = new Class[]{String.class, Class.class, String.class};
            wsLogger = clazz == null ? null : clazz.getConstructor(classParams);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        svBinaryLoggingEnable = false;
    }

    private static class StackFinderSingleton {
        static final StackFinder instance = AccessController.doPrivileged(new PrivilegedAction<StackFinder>(){

            @Override
            public StackFinder run() {
                return new StackFinder();
            }
        });

        private StackFinderSingleton() {
        }
    }

    public static class StackFinder
    extends SecurityManager {
        public Class<?>[] getCallStack() {
            return this.getClassContext();
        }
    }
}

