/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.filter;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.filter.FilterException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class IPAddressRange {
    private static Logger log = Logger.getLogger(IPAddressRange.class.getName());
    InetAddress ipHigher;
    InetAddress ipLower;
    String ipRange;
    static final long serialVersionUID = -4350213726064111723L;

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IPAddressRange(String iprange) throws FilterException {
        String msg;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "<init>", new Object[]{iprange});
        }
        this.ipRange = iprange;
        log.log(Level.FINE, "ip range is {0}", iprange);
        String lowerAddr = new String();
        String upperAddr = new String();
        StringTokenizer tokens = new StringTokenizer(iprange, ".:", true);
        boolean foundRange = false;
        String currentTop = "FFFF";
        while (tokens.hasMoreTokens()) {
            String ipPiece = tokens.nextToken();
            if (ipPiece.equals(":")) {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
                continue;
            }
            String delim = tokens.hasMoreElements() ? tokens.nextToken() : "";
            ipPiece = ipPiece.trim();
            if (".".equals(delim)) {
                currentTop = "255";
            }
            if (foundRange) {
                if (!ipPiece.equals("*")) {
                    throw new FilterException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages", (String)"security.tai.malformed.iprange", (Object[])new Object[]{ipPiece}, (String)"CWTAI0046E: Malformed IP range specified. Found {0} rather than a wildcard."));
                }
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
            } else if (ipPiece.startsWith("[") && ipPiece.endsWith("]")) {
                int dash = ipPiece.indexOf(45);
                String startStr = ipPiece.substring(1, dash);
                lowerAddr = lowerAddr + startStr;
                int bracket = ipPiece.lastIndexOf(93);
                String lastStr = ipPiece.substring(dash + 1, bracket);
                upperAddr = upperAddr + lastStr;
                foundRange = true;
            } else if (ipPiece.equals("*")) {
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
                foundRange = true;
            } else {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
            }
            upperAddr = upperAddr + delim;
            lowerAddr = lowerAddr + delim;
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "upperAddr is " + upperAddr);
            log.log(Level.FINEST, "lowerAddr is " + lowerAddr);
        }
        try {
            this.ipHigher = InetAddress.getByName(upperAddr);
        }
        catch (UnknownHostException ipPiece) {
            void e;
            FFDCFilter.processException((Throwable)ipPiece, (String)"com.ibm.ws.security.oauth20.filter.IPAddressRange", (String)"190", (Object)this, (Object[])new Object[]{iprange});
            msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages", (String)"security.tai.unknown.host", (Object[])new Object[]{upperAddr}, (String)"CWTAI0047E: Unknown host exception raised for IP address {0}.");
            throw new FilterException(msg, (Throwable)e);
        }
        try {
            this.ipLower = InetAddress.getByName(lowerAddr);
        }
        catch (UnknownHostException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.filter.IPAddressRange", (String)"200", (Object)this, (Object[])new Object[]{iprange});
            msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages", (String)"security.tai.unknown.host", (Object[])new Object[]{lowerAddr}, (String)"CWTAI0047E: Unknown host exception raised for IP address {0}.");
            throw new FilterException(msg, e);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean inRange(InetAddress ip) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "inRange", new Object[]{ip});
        }
        if (IPAddressRange.greaterThan(ip, this.ipHigher)) {
            boolean bl = false;
            if (log != null && log.isLoggable(Level.FINER)) {
                bl = bl;
                log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "inRange", bl);
            }
            return bl;
        }
        if (IPAddressRange.lessThan(ip, this.ipLower)) {
            boolean bl = false;
            if (log != null && log.isLoggable(Level.FINER)) {
                bl = bl;
                log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "inRange", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "inRange", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean aboveRange(InetAddress ip) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "aboveRange", new Object[]{ip});
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "aboveRange, ip is " + ip);
            log.log(Level.FINEST, "aboveRange, ipHigher is " + this.ipHigher);
        }
        boolean bl = IPAddressRange.greaterThan(ip, this.ipHigher);
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "aboveRange", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean belowRange(InetAddress ip) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "belowRange", new Object[]{ip});
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "belowRange, ip is " + ip);
            log.log(Level.FINEST, "belowRange, ipLower is " + this.ipLower);
        }
        boolean bl = IPAddressRange.lessThan(ip, this.ipLower);
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "belowRange", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean greaterThan(InetAddress a1, InetAddress a2) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "greaterThan", new Object[]{a1, a2});
        }
        boolean bl = IPAddressRange.compare(a1, a2) > 0;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "greaterThan", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean lessThan(InetAddress a1, InetAddress a2) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "lessThan", new Object[]{a1, a2});
        }
        boolean bl = IPAddressRange.compare(a1, a2) < 0;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "lessThan", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int compare(InetAddress a1, InetAddress a2) {
        int len;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", new Object[]{a1, a2});
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "compare, a1 is " + a1);
            log.log(Level.FINEST, "compare, a2 is " + a2);
        }
        byte[] byte1 = a1.getAddress();
        byte[] byte2 = a2.getAddress();
        int base1 = 0;
        int base2 = 0;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "compare, byte1.length is " + byte1.length);
            log.log(Level.FINEST, "compare, byte2.length is " + byte2.length);
        }
        if (byte1.length > byte2.length) {
            len = byte2.length;
            base1 = byte1.length - len;
            if (!IPAddressRange.isZeros(byte1, byte1.length - len)) {
                int n = 1;
                if (log != null && log.isLoggable(Level.FINER)) {
                    n = n;
                    log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", n);
                }
                return n;
            }
        } else if (byte1.length < byte2.length) {
            len = byte1.length;
            base2 = byte2.length - len;
            if (!IPAddressRange.isZeros(byte2, byte2.length - len)) {
                int n = -1;
                if (log != null && log.isLoggable(Level.FINER)) {
                    n = n;
                    log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", n);
                }
                return n;
            }
        } else {
            len = byte1.length;
        }
        for (int i = 0; i < len; ++i) {
            if (byte1[base1] != byte2[base2]) {
                int b2;
                int b1 = byte1[base1];
                if (b1 < 0) {
                    b1 += 256;
                }
                if ((b2 = byte2[base2]) < 0) {
                    b2 += 256;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "compare, b1 is " + b1);
                    log.log(Level.FINEST, "compare, b2 is " + b2);
                }
                if (b1 > b2) {
                    int n = 1;
                    if (log != null && log.isLoggable(Level.FINER)) {
                        n = n;
                        log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", n);
                    }
                    return n;
                }
                int n = -1;
                if (log != null && log.isLoggable(Level.FINER)) {
                    n = n;
                    log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", n);
                }
                return n;
            }
            ++base1;
            ++base2;
        }
        int n = 0;
        if (log != null && log.isLoggable(Level.FINER)) {
            n = n;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "compare", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isZeros(byte[] bytes, int len) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.security.oauth20.filter.IPAddressRange", "isZeros", new Object[]{bytes, len});
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == 0) continue;
            boolean bl = false;
            if (log != null && log.isLoggable(Level.FINER)) {
                bl = bl;
                log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "isZeros", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting("com.ibm.ws.security.oauth20.filter.IPAddressRange", "isZeros", bl);
        }
        return bl;
    }

    public String toString() {
        return this.ipRange;
    }
}

