/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.metrics.impl.ConcurrentGaugeImpl;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import com.ibm.ws.microprofile.metrics.impl.HistogramImpl;
import com.ibm.ws.microprofile.metrics.impl.MeterImpl;
import com.ibm.ws.microprofile.metrics.impl.TimerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricRegistryImpl
extends MetricRegistry {
    protected final ConcurrentMap<String, Metric> metrics = this.buildMap();
    protected final ConcurrentMap<String, Metadata> metadata;
    protected final ConcurrentMap<MetricID, Metric> metricsMID = new ConcurrentHashMap<MetricID, Metric>();
    protected final ConcurrentMap<String, Metadata> metadataMID;
    protected final ConcurrentHashMap<String, ConcurrentLinkedQueue<MetricID>> applicationMap;
    private final ConfigProviderResolver configResolver;
    private static final boolean usingJava2Security;
    static final long serialVersionUID = -1821654231765263775L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MetricRegistryImpl(ConfigProviderResolver configResolver) {
        this.metadata = new ConcurrentHashMap<String, Metadata>();
        this.metadataMID = new ConcurrentHashMap<String, Metadata>();
        this.applicationMap = new ConcurrentHashMap();
        this.configResolver = configResolver;
    }

    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricRegistryImpl.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricRegistryImpl.append(builder, s);
            }
        }
        return builder.toString();
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistryImpl.name(klass.getName(), names);
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public static MetricType from(Metric in) {
        if (Gauge.class.isInstance(in)) {
            return MetricType.GAUGE;
        }
        if (Counter.class.isInstance(in)) {
            return MetricType.COUNTER;
        }
        if (Histogram.class.isInstance(in)) {
            return MetricType.HISTOGRAM;
        }
        if (Meter.class.isInstance(in)) {
            return MetricType.METERED;
        }
        if (Timer.class.isInstance(in)) {
            return MetricType.TIMER;
        }
        return MetricType.INVALID;
    }

    protected ConcurrentMap<String, Metric> buildMap() {
        return new ConcurrentHashMap<String, Metric>();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.register(Metadata.builder().withName(name).withType(MetricRegistryImpl.from(metric)).build(), metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, metric, null);
    }

    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        Metadata existingMetadata;
        if (this.metadataMID.keySet().contains(metadata.getName()) && !metadata.equals(existingMetadata = (Metadata)this.metadataMID.get(metadata.getName()))) {
            throw new IllegalArgumentException("Metadata does not match for existing Metadata for " + metadata.getName());
        }
        MetadataBuilder metadataBuilder = Metadata.builder((Metadata)metadata);
        ArrayList cumulativeTags = tags == null ? new ArrayList() : new ArrayList<Tag>(Arrays.asList(tags));
        MetricID MetricID2 = new MetricID(metadata.getName(), tags);
        Class<T> metricClass = this.determineMetricClass(metric);
        this.validateMetricNameToSingleType(MetricID2.getName(), metricClass);
        Metric existingMetric = this.metricsMID.putIfAbsent(MetricID2, metric);
        if (existingMetric != null) {
            throw new IllegalArgumentException("A metric named " + MetricID2.getName() + " with tags " + MetricID2.getTagsAsString() + " already exists");
        }
        this.metadataMID.putIfAbsent(metadata.getName(), metadataBuilder.build());
        this.addNameToApplicationMap(MetricID2);
        return metric;
    }

    protected void addNameToApplicationMap(MetricID metricID) {
        String appName = this.getApplicationName();
        this.addNameToApplicationMap(metricID, appName);
    }

    public void addNameToApplicationMap(MetricID metricID, String appName) {
        ConcurrentLinkedQueue newList;
        if (appName == null) {
            return;
        }
        ConcurrentLinkedQueue<Object> list = this.applicationMap.get(appName);
        if (list == null && (list = this.applicationMap.putIfAbsent(appName, newList = new ConcurrentLinkedQueue())) == null) {
            list = newList;
        }
        list.add(metricID);
    }

    public void unRegisterApplicationMetrics() {
        this.unRegisterApplicationMetrics(this.getApplicationName());
    }

    public void unRegisterApplicationMetrics(String appName) {
        ConcurrentLinkedQueue<MetricID> list = this.applicationMap.remove(appName);
        if (list != null) {
            for (MetricID metricID : list) {
                this.remove(metricID);
            }
        }
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    public Counter counter(String name) {
        return this.counter(name, null);
    }

    public Counter counter(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.COUNTER).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.COUNTER)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.counter(metadata, tags);
    }

    public Counter counter(Metadata metadata) {
        return this.counter(metadata, null);
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder.COUNTERS, tags);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, null);
    }

    public Histogram histogram(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.HISTOGRAM).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.HISTOGRAM)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.histogram(metadata, tags);
    }

    public Histogram histogram(Metadata metadata) {
        return this.histogram(metadata, null);
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder.HISTOGRAMS, tags);
    }

    public Meter meter(String name) {
        return this.meter(name, null);
    }

    public Meter meter(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.METERED).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.METERED)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.meter(metadata, tags);
    }

    public Meter meter(Metadata metadata) {
        return this.meter(metadata, null);
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder.METERS, tags);
    }

    public Timer timer(String name) {
        return this.timer(name, null);
    }

    public Timer timer(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.TIMER).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.TIMER)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        return this.timer(metadata, tags);
    }

    public Timer timer(Metadata metadata) {
        return this.timer(metadata, null);
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder.TIMERS, tags);
    }

    public boolean remove(String name) {
        Iterator iterator = this.metricsMID.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MetricID tempMID = (MetricID)entry.getKey();
            if (!tempMID.getName().equals(name)) continue;
            iterator.remove();
        }
        this.metadataMID.remove(name);
        return true;
    }

    public boolean remove(MetricID metricID) {
        Metric metric = (Metric)this.metricsMID.remove(metricID);
        String name = metricID.getName();
        if (metric != null) {
            boolean isLastOne = true;
            for (MetricID mid : this.metricsMID.keySet()) {
                if (!mid.getName().equals(name)) continue;
                isLastOne = false;
                break;
            }
            if (isLastOne) {
                this.metadataMID.remove(name);
            }
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter filter) {
        for (Map.Entry entry : this.metricsMID.entrySet()) {
            if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
            this.remove((MetricID)entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metadataMID.keySet()));
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(Gauge.class, filter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(Counter.class, filter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.getMetrics(Meter.class, filter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    protected <T extends Metric> T getOrAdd(Metadata metadata, MetricBuilder<T> builder, Tag ... tags) {
        block4: {
            this.validateMetricNameToSingleType(metadata.getName(), builder);
            MetricID metricID = new MetricID(metadata.getName(), tags);
            Metric metric = (Metric)this.metricsMID.get(metricID);
            if (builder.isInstance(metric)) {
                return (T)metric;
            }
            if (metric == null) {
                try {
                    return this.register(metadata, builder.newMetric(), tags);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl", (String)"637", (Object)((Object)this), (Object[])new Object[]{metadata, builder, tags});
                    this.validateMetricNameToSingleType(metadata.getName(), builder);
                    Metric added = (Metric)this.metricsMID.get(metricID);
                    if (!builder.isInstance(added)) break block4;
                    return (T)added;
                }
            }
        }
        throw new IllegalArgumentException(metadata.getName() + " is already used for a different type of metric");
    }

    private <T extends Metric> void validateMetricNameToSingleType(String name, MetricBuilder<T> builder) {
        for (MetricID mid : this.metricsMID.keySet()) {
            if (!mid.getName().equals(name) || builder.isInstance((Metric)this.metricsMID.get(mid))) continue;
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
    }

    private <T extends Metric> void validateMetricNameToSingleType(String name, Class<T> metricClass) {
        for (Map.Entry entrySet : this.metricsMID.entrySet()) {
            if (!((MetricID)entrySet.getKey()).getName().equals(name) || metricClass.isAssignableFrom(((Metric)entrySet.getValue()).getClass())) continue;
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
    }

    protected <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> klass, MetricFilter filter) {
        TreeMap<MetricID, Metric> timers = new TreeMap<MetricID, Metric>();
        for (Map.Entry entry : this.metricsMID.entrySet()) {
            if (!klass.isInstance(entry.getValue()) || !filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
            timers.put((MetricID)entry.getKey(), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(timers);
    }

    public Map<MetricID, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsMID);
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadataMID);
    }

    public Metadata getMetadata(String name) {
        return (Metadata)this.metadata.get(name);
    }

    protected <T extends Metric> Class<T> determineMetricClass(T metric) {
        if (Counter.class.isInstance(metric)) {
            return Counter.class;
        }
        if (ConcurrentGauge.class.isInstance(metric)) {
            return ConcurrentGauge.class;
        }
        if (Histogram.class.isInstance(metric)) {
            return Histogram.class;
        }
        if (Meter.class.isInstance(metric)) {
            return Meter.class;
        }
        if (Timer.class.isInstance(metric)) {
            return Timer.class;
        }
        if (Gauge.class.isInstance(metric)) {
            return Gauge.class;
        }
        return null;
    }

    public SortedSet<MetricID> getMetricIDs() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metricsMID.keySet()));
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.concurrentGauge(name, null);
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.CONCURRENT_GAUGE).build();
        if (this.metadataMID.keySet().contains(name) && !(metadata = (Metadata)this.metadataMID.get(name)).getTypeRaw().equals((Object)MetricType.CONCURRENT_GAUGE)) {
            throw new IllegalArgumentException(name + " is CONCURRENT_GAUGE used for a different type of metric");
        }
        return this.concurrentGauge(metadata, tags);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.concurrentGauge(metadata, null);
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.getOrAdd(metadata, MetricBuilder.CONCURRENT_GAUGE, tags);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.getMetrics(ConcurrentGauge.class, filter);
    }

    private ClassLoader getThreadContextClassLoader() {
        if (usingJava2Security) {
            return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl", MetricRegistryImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        usingJava2Security = System.getSecurityManager() != null;
    }

    public static interface MetricBuilder<T extends Metric> {
        public static final MetricBuilder<Counter> COUNTERS = new MetricBuilder<Counter>(){
            static final long serialVersionUID = -3814174454516349407L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Counter newMetric() {
                return new CounterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Counter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl$MetricBuilder$1", 1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder<ConcurrentGauge> CONCURRENT_GAUGE = new MetricBuilder<ConcurrentGauge>(){
            static final long serialVersionUID = -7077747670998205499L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ConcurrentGauge newMetric() {
                return new ConcurrentGaugeImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return ConcurrentGauge.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl$MetricBuilder$2", 2.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder<Histogram> HISTOGRAMS = new MetricBuilder<Histogram>(){
            static final long serialVersionUID = 2281810740086010271L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Histogram newMetric() {
                return new HistogramImpl(new ExponentiallyDecayingReservoir());
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Histogram.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl$MetricBuilder$3", 3.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder<Meter> METERS = new MetricBuilder<Meter>(){
            static final long serialVersionUID = 4467001891001704983L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Meter newMetric() {
                return new MeterImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Meter.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl$MetricBuilder$4", 4.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };
        public static final MetricBuilder<Timer> TIMERS = new MetricBuilder<Timer>(){
            static final long serialVersionUID = -5243604256162905217L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Timer newMetric() {
                return new TimerImpl();
            }

            @Override
            public boolean isInstance(Metric metric) {
                return Timer.class.isInstance(metric);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics.impl.MetricRegistryImpl$MetricBuilder$5", 5.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        };

        public T newMetric();

        public boolean isInstance(Metric var1);
    }
}

