/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginWebappConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.OidcLoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.RequestUtil;
import com.ibm.ws.security.social.internal.utils.SocialTaiRequest;
import com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator;
import com.ibm.ws.security.social.tai.OAuthLoginFlow;
import com.ibm.ws.security.social.tai.TAIRequestHelper;
import com.ibm.ws.security.social.tai.TAISubjectUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.ws.security.social.tai.TwitterLoginFlow;
import com.ibm.ws.security.social.twitter.TwitterConstants;
import com.ibm.ws.security.social.web.EndpointServices;
import com.ibm.ws.security.social.web.SelectionPageGenerator;
import com.ibm.ws.security.social.web.utils.ObscuredConfigIdManager;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.ibm.wsspi.ssl.SSLSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialLoginTAI
implements TrustAssociationInterceptor,
UnprotectedResourceService {
    public static final TraceComponent tc = Tr.register(SocialLoginTAI.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    protected static final String KEY_SERVICE_PID = "service.pid";
    protected static final String KEY_PROVIDER_ID = "id";
    protected static final String KEY_ID = "id";
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    static final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    static final AtomicServiceReference<AuthCacheService> authCacheServiceRef = new AtomicServiceReference("authCacheService");
    static final String KEY_SECURITY_SERVICE = "securityService";
    static final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    public static final String KEY_FILTER = "authFilter";
    protected static final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authFilter");
    public static final String KEY_SOCIAL_LOGIN_CONFIG = "socialLoginConfig";
    protected static final ConcurrentServiceReferenceMap<String, SocialLoginConfig> socialLoginConfigRef = new ConcurrentServiceReferenceMap("socialLoginConfig");
    static final String KEY_SOCIAL_WEB_APP_SERVICE = "socialLoginWebappConfig";
    static final AtomicServiceReference<SocialLoginWebappConfig> socialWebappConfigRef = new AtomicServiceReference("socialLoginWebappConfig");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    static WebProviderAuthenticatorHelper authHelper;
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    TAIRequestHelper taiRequestHelper = new TAIRequestHelper();
    SocialWebUtils webUtils = new SocialWebUtils();
    static ObscuredConfigIdManager configIdManager;
    private static boolean issuedBetaMessage;
    static final long serialVersionUID = -349073858207970054L;

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedtSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    public void setSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.setReference(reference);
    }

    public void unsetSecurityService(ServiceReference<SecurityService> reference) {
        securityServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setFilter pid:" + pid), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.putReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setFilter pid:" + pid), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, AuthenticationFilter> concurrentServiceReferenceMap = authFilterServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            authFilterServiceRef.removeReference((Object)pid, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetFilter pid:" + pid), (Object[])new Object[0]);
        }
    }

    public static AuthenticationFilter getAuthFilter(String pid) {
        return (AuthenticationFilter)authFilterServiceRef.getService((Object)pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSocialLoginConfig(ServiceReference<SocialLoginConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SocialLoginConfig> concurrentServiceReferenceMap = socialLoginConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            socialLoginConfigRef.putReference((Object)id, ref);
        }
        this.trackSocialLoginId(id);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setSocialLoginConfig id:" + id + " Number of references is now: " + socialLoginConfigRef.size()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSocialLoginConfig(ServiceReference<SocialLoginConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SocialLoginConfig> concurrentServiceReferenceMap = socialLoginConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            socialLoginConfigRef.putReference((Object)id, ref);
        }
        this.trackSocialLoginId(id);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateSocialLoginConfig id:" + id), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetSocialLoginConfig(ServiceReference<SocialLoginConfig> ref) {
        String id = (String)ref.getProperty("id");
        ConcurrentServiceReferenceMap<String, SocialLoginConfig> concurrentServiceReferenceMap = socialLoginConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            socialLoginConfigRef.removeReference((Object)id, ref);
        }
        this.untrackSocialLoginId(id);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetSocialLoginConfig id:" + id), (Object[])new Object[0]);
        }
    }

    void trackSocialLoginId(String id) {
        configIdManager.addId(id);
    }

    void untrackSocialLoginId(String id) {
        configIdManager.removeId(id);
    }

    public static String getObscuredIdFromConfigId(String configId) {
        return configIdManager.getObscuredIdFromConfigId(configId);
    }

    public static String getConfigIdFromObscuredId(String obscuredConfigId) {
        return configIdManager.getConfigIdFromObscuredId(obscuredConfigId);
    }

    public static SocialLoginConfig getSocialLoginConfig(String key) {
        return (SocialLoginConfig)socialLoginConfigRef.getService((Object)key);
    }

    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        locationAdminRef.unsetReference(ref);
    }

    protected void setAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.setReference(reference);
    }

    protected void unsetAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.unsetReference(reference);
    }

    public void setSocialLoginWebappConfig(ServiceReference<SocialLoginWebappConfig> reference) {
        socialWebappConfigRef.setReference(reference);
    }

    public void unsetSocialLoginWebappConfig(ServiceReference<SocialLoginWebappConfig> reference) {
        socialWebappConfigRef.unsetReference(reference);
    }

    public static SocialLoginWebappConfig getSocialLoginWebappConfig() {
        return (SocialLoginWebappConfig)socialWebappConfigRef.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            this.sslSupportRef.activate(cc);
            authFilterServiceRef.activate(cc);
        }
        object = socialLoginConfigRef;
        synchronized (object) {
            socialLoginConfigRef.activate(cc);
        }
        locationAdminRef.activate(cc);
        authCacheServiceRef.activate(cc);
        securityServiceRef.activate(cc);
        socialWebappConfigRef.activate(cc);
        authHelper = new WebProviderAuthenticatorHelper(securityServiceRef);
        EndpointServices.setActivatedSocialLoginConfigRef(socialLoginConfigRef);
        EndpointServices.setActivatedSecurityServiceRef(securityServiceRef);
        RequestUtil.setSocialLoginConfigRef(socialLoginConfigRef);
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Object object = authFilterServiceRef;
        synchronized (object) {
            this.sslSupportRef.deactivate(cc);
            authFilterServiceRef.deactivate(cc);
        }
        object = socialLoginConfigRef;
        synchronized (object) {
            for (String key : socialLoginConfigRef.keySet()) {
                ServiceReference configref = socialLoginConfigRef.getReference((Object)key);
                socialLoginConfigRef.removeReference((Object)key, configref);
            }
            socialLoginConfigRef.deactivate(cc);
        }
        locationAdminRef.deactivate(cc);
        authCacheServiceRef.deactivate(cc);
        securityServiceRef.deactivate(cc);
        socialWebappConfigRef.deactivate(cc);
    }

    public boolean isTargetInterceptor(HttpServletRequest request) throws WebTrustAssociationException {
        SocialTaiRequest socialTaiRequest = this.taiRequestHelper.createSocialTaiRequestAndSetRequestAttribute(request);
        return this.taiRequestHelper.requestShouldBeHandledByTAI(request, socialTaiRequest);
    }

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest request, HttpServletResponse response) throws WebTrustAssociationFailedException {
        TAIResult taiResult = TAIResult.create((int)403);
        SocialTaiRequest socialTaiRequest = (SocialTaiRequest)request.getAttribute("SocialTaiRequest");
        if (socialTaiRequest == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request is missing SocialTaiRequest attribute.", (Object[])new Object[0]);
            }
            return this.taiWebUtils.sendToErrorPage(response, taiResult);
        }
        return this.getAssociatedConfigAndHandleRequest(request, response, socialTaiRequest, taiResult);
    }

    @FFDCIgnore(value={SocialLoginException.class})
    TAIResult getAssociatedConfigAndHandleRequest(HttpServletRequest request, HttpServletResponse response, SocialTaiRequest socialTaiRequest, TAIResult defaultTaiResult) throws WebTrustAssociationFailedException {
        SocialLoginConfig clientConfig = null;
        try {
            clientConfig = socialTaiRequest.getTheOnlySocialLoginConfig();
        }
        catch (SocialLoginException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("A unique social login config wasn't found for this request. Exception was " + e.getMessage()), (Object[])new Object[0]);
            }
            return this.displaySocialMediaSelectionPage(request, response, socialTaiRequest);
        }
        return this.handleRequestBasedOnSocialLoginConfig(request, response, clientConfig, defaultTaiResult);
    }

    TAIResult displaySocialMediaSelectionPage(HttpServletRequest request, HttpServletResponse response, SocialTaiRequest socialTaiRequest) throws WebTrustAssociationFailedException {
        SelectionPageGenerator selectionPageGenerator = this.getSelectionPageGenerator();
        try {
            selectionPageGenerator.displaySelectionPage(request, response, socialTaiRequest);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.tai.SocialLoginTAI", (String)"359", (Object)this, (Object[])new Object[]{request, response, socialTaiRequest});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)403));
        }
        return TAIResult.create((int)403);
    }

    SelectionPageGenerator getSelectionPageGenerator() {
        return new SelectionPageGenerator();
    }

    TAIResult handleRequestBasedOnSocialLoginConfig(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config, TAIResult defaultTaiResult) throws WebTrustAssociationFailedException {
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client config for request could not be found. An error must have occurred initializing this request.", (Object[])new Object[0]);
            }
            return this.taiWebUtils.sendToErrorPage(response, defaultTaiResult);
        }
        this.removeCachedDataFromLocalAuthentication(request, response);
        if (this.isTwitterConfig(config)) {
            return this.handleTwitterLoginRequest(request, response, config);
        }
        if (config instanceof OidcLoginConfigImpl) {
            return this.handleOidc(request, response, (OidcLoginConfigImpl)config);
        }
        return this.handleOAuthLoginRequest(request, response, config);
    }

    void removeCachedDataFromLocalAuthentication(HttpServletRequest request, HttpServletResponse response) {
        this.webUtils.removeRequestUrlAndParameters(request, response);
    }

    boolean isTwitterConfig(SocialLoginConfig config) {
        return config.getClass().getName().contains(TwitterConstants.TWITTER_CONFIG_CLASS);
    }

    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public String getType() {
        return null;
    }

    public void cleanup() {
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        String ctxPath = request.getContextPath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Context path:" + ctxPath), (Object[])new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout(HttpServletRequest request, HttpServletResponse response, String userName) {
        boolean bSetSubject = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logout() userName:" + userName), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SocialLoginConfig> concurrentServiceReferenceMap = socialLoginConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            Iterator services = socialLoginConfigRef.getServices();
            SocialLoginConfig socialLoginConfig = null;
            while (services.hasNext()) {
                socialLoginConfig = (SocialLoginConfig)services.next();
                if (!(socialLoginConfig instanceof OidcLoginConfigImpl) || !this.isRunningBetaMode()) continue;
                OidcSessionUtils.removeOidcSession((HttpServletRequest)request, (HttpServletResponse)response, (ConvergedClientConfig)((OidcLoginConfigImpl)socialLoginConfig));
            }
        }
        return bSetSubject;
    }

    boolean isRunningBetaMode() {
        if (!ProductInfo.getBetaEdition()) {
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        return true;
    }

    TAIResult handleOAuthLoginRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        OAuthLoginFlow oauthLoginFlow = this.getOAuthLoginFlow();
        return oauthLoginFlow.handleOAuthRequest(request, response, clientConfig);
    }

    OAuthLoginFlow getOAuthLoginFlow() {
        return new OAuthLoginFlow();
    }

    TAIResult handleTwitterLoginRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws WebTrustAssociationFailedException {
        TwitterLoginFlow twitterLoginFlow = this.getTwitterLoginFlow();
        return twitterLoginFlow.handleTwitterRequest(request, response, config);
    }

    TwitterLoginFlow getTwitterLoginFlow() {
        return new TwitterLoginFlow();
    }

    /*
     * WARNING - void declaration
     */
    TAIResult handleOidc(HttpServletRequest request, HttpServletResponse response, OidcLoginConfigImpl clientConfig) throws WebTrustAssociationFailedException {
        if (!this.isConfigValid(clientConfig)) {
            return TAIResult.create((int)403);
        }
        OIDCClientAuthenticatorUtil oidccau = new OIDCClientAuthenticatorUtil((SSLSupport)this.sslSupportRef.getService());
        OidcClientRequest clientRequest = new OidcClientRequest(request, response, (ConvergedClientConfig)clientConfig, null);
        request.setAttribute("com.ibm.wsspi.security.oidc.client.request", (Object)clientRequest);
        ProviderAuthenticationResult presult = oidccau.authenticate(request, response, (ConvergedClientConfig)clientConfig);
        this.discoverOPAgain(presult, clientConfig);
        if (presult.getStatus().compareTo((Enum)AuthResult.REDIRECT_TO_PROVIDER) == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.event((TraceComponent)tc, (String)("redirecting to provider, javascript redirect supported = " + clientConfig.isClientSideRedirect()), (Object[])new Object[0]);
            }
            if (!clientConfig.isClientSideRedirect()) {
                try {
                    response.sendRedirect(presult.getRedirectUrl());
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.social.tai.SocialLoginTAI", (String)"518", (Object)this, (Object[])new Object[]{request, response, clientConfig});
                }
            }
            return TAIResult.create((int)403);
        }
        if (presult.getStatus().compareTo((Enum)AuthResult.SUCCESS) != 0) {
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        String idToken = (String)presult.getCustomProperties().get("id_token");
        AuthorizationCodeAuthenticator aca = new AuthorizationCodeAuthenticator(clientConfig, presult.getCustomProperties());
        TAIResult authnResult = null;
        try {
            aca.createJwtUserApiResponseAndIssuedJwtFromIdToken(idToken);
            TAISubjectUtils subjectUtils = this.getTAISubjectUtils(aca);
            String userInfo = (String)presult.getCustomProperties().get("userinfo_string");
            if (userInfo != null) {
                subjectUtils.setUserInfo(userInfo);
            }
            authnResult = subjectUtils.createResult(response, clientConfig);
        }
        catch (Exception subjectUtils) {
            void e;
            FFDCFilter.processException((Throwable)subjectUtils, (String)"com.ibm.ws.security.social.tai.SocialLoginTAI", (String)"544", (Object)this, (Object[])new Object[]{request, response, clientConfig});
            Tr.error((TraceComponent)tc, (String)"AUTH_CODE_ERROR_CREATING_RESULT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        this.taiWebUtils.restorePostParameters(request);
        return authnResult;
    }

    private void discoverOPAgain(ProviderAuthenticationResult presult, OidcLoginConfigImpl clientConfig) {
        if (clientConfig.isDiscoveryInUse()) {
            if (presult.getStatus().compareTo((Enum)AuthResult.SUCCESS) == 0) {
                clientConfig.setNextDiscoveryTime();
            } else if (System.currentTimeMillis() > clientConfig.getNextDiscoveryTime()) {
                clientConfig.handleDiscoveryEndpoint(clientConfig.getDiscoveryEndpointUrl());
            }
        }
    }

    boolean isConfigValid(ConvergedClientConfig config) {
        boolean valid = true;
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String tokenEndpointAuthMethod = config.getTokenEndpointAuthMethod();
        String authorizationEndpoint = config.getAuthorizationEndpointUrl();
        String jwksUri = config.getJwkEndpointUrl();
        if (clientId == null || clientId.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONFIG_PARAM", (Object[])new Object[]{"clientId", clientId});
            valid = false;
        }
        if (!"private_key_jwt".equals(tokenEndpointAuthMethod) && (clientSecret == null || clientSecret.isEmpty())) {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONFIG_PARAM", (Object[])new Object[]{"clientSecret", ""});
            valid = false;
        }
        if (authorizationEndpoint == null || authorizationEndpoint.length() == 0 || !authorizationEndpoint.toLowerCase().startsWith("http")) {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONFIG_PARAM", (Object[])new Object[]{"authorizationEndpoint", authorizationEndpoint});
            valid = false;
        }
        return valid;
    }

    TAISubjectUtils getTAISubjectUtils(AuthorizationCodeAuthenticator authzCodeAuthenticator) {
        return new TAISubjectUtils(authzCodeAuthenticator);
    }

    public boolean postLogout(HttpServletRequest arg0, HttpServletResponse arg1) {
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        configIdManager = new ObscuredConfigIdManager();
        issuedBetaMessage = false;
    }
}

