/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.LifecycleInterceptorWrapper;
import com.ibm.ejs.container.interceptors.InterceptorMetaData;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.JCDIHelper;
import com.ibm.ws.javaee.dd.ejb.EnterpriseBean;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.metadata.ejb.EJBInterceptorBinding;
import com.ibm.ws.metadata.ejb.EJBMDOrchestrator;
import com.ibm.ws.metadata.ejb.InterceptorMetaDataHelper;
import com.ibm.ws.metadata.ejb.InterceptorMethodKind;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.SessionBean;
import jakarta.interceptor.ExcludeClassInterceptors;
import jakarta.interceptor.ExcludeDefaultInterceptors;
import jakarta.interceptor.Interceptors;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterceptorMetaDataFactory {
    private static final TraceComponent tc = Tr.register(InterceptorMetaDataFactory.class, (String)"EJB3Interceptors", (String)"com.ibm.ejs.container.container");
    private final BeanMetaData ivBmd;
    private final Class<?> ivEjbClass;
    private final J2EEName ivJ2EEName;
    private final String ivEjbName;
    private final ClassLoader ivClassLoader;
    private EJBModuleMetaDataImpl ivEJBModuleMetaDataImpl;
    private final ArrayList<String> ivClassInterceptorNames = new ArrayList();
    private ArrayList<String> ivClassInterceptorOrder;
    private final ArrayList<String> ivDefaultInterceptorNames = new ArrayList();
    private Class<?> ivJCDIFirstInterceptorClass;
    private Class<?> ivJCDILastInterceptorClass;
    private final HashMap<String, Class<?>> ivInterceptorNameToClassMap = new HashMap();
    private List<EJBInterceptorBinding> ivInterceptorBinding;
    private EJBInterceptorBinding ivModuleInterceptorBinding;
    private EJBInterceptorBinding ivClassInterceptorBinding;
    private boolean ivExcludeDefaultFromClassLevel;
    private final ArrayList<Class<?>> ivInterceptorClasses = new ArrayList();
    private final Map<Class<?>, Map<InterceptorMethodKind, List<InterceptorProxy>>> ivInterceptorProxyMaps = new HashMap();
    private Map<InterceptorMethodKind, List<InterceptorProxy>> ivBeanInterceptorProxyMap;
    private Method[] ivBeanLifecycleMethods;
    private Map<Method, ArrayList<EJBMethodInfoImpl>> ivEJBMethodInfoMap;
    private final HashMap<String, EJBInterceptorBinding> ivStyle3InterceptorBindingMap = new HashMap();
    private final HashMap<String, EJBInterceptorBinding> ivStyle4InterceptorBindingMap = new HashMap();
    boolean ivHasComponentInterface;
    boolean ivMDB;
    boolean ivSLSB;
    boolean ivSFSB;
    boolean ivMB;
    private boolean ivMetadataComplete;

    public static InterceptorMetaData createInterceptorMetaData(EJBMDOrchestrator ejbMDOrchestrator, BeanMetaData bmd, Map<Method, ArrayList<EJBMethodInfoImpl>> methodInfoMap) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInterceptorMetaData", (Object[])new Object[0]);
        }
        EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)bmd.getModuleMetaData();
        InterceptorMetaDataFactory factory = new InterceptorMetaDataFactory(mmd, bmd);
        factory.ivEJBMethodInfoMap = methodInfoMap;
        if (factory.ivInterceptorBinding != null) {
            factory.validateInterceptorBindings();
        }
        factory.setExcludeDefaultInterceptors();
        factory.addDefaultInterceptors();
        factory.addClassLevelInterceptors();
        factory.ivClassInterceptorOrder = factory.orderClassLevelInterceptors();
        factory.addJCDIInterceptors();
        factory.processBeanInterceptors();
        factory.updateEJBMethodInfoInterceptorProxies();
        InterceptorProxy[] postConstructProxies = factory.getInterceptorProxies(InterceptorMethodKind.POST_CONSTRUCT, factory.ivClassInterceptorOrder);
        InterceptorProxy[] preDestroyProxies = factory.getInterceptorProxies(InterceptorMethodKind.PRE_DESTROY, factory.ivClassInterceptorOrder);
        InterceptorProxy[] prePassivateProxies = factory.getInterceptorProxies(InterceptorMethodKind.PRE_PASSIVATE, factory.ivClassInterceptorOrder);
        InterceptorProxy[] postActivateProxies = factory.getInterceptorProxies(InterceptorMethodKind.POST_ACTIVATE, factory.ivClassInterceptorOrder);
        InterceptorProxy[] aroundConstructProxies = factory.getInterceptorProxies(InterceptorMethodKind.AROUND_CONSTRUCT, factory.ivClassInterceptorOrder);
        InterceptorMetaData imd = null;
        if (!factory.ivBeanInterceptorProxyMap.isEmpty() || !factory.ivInterceptorClasses.isEmpty()) {
            Class[] classes = factory.ivInterceptorClasses.toArray(new Class[0]);
            ManagedObjectFactory[] managedObjectFactories = null;
            for (int i = 0; i < classes.length; ++i) {
                ManagedObjectFactory managedObjectFactory = ejbMDOrchestrator.getInterceptorManagedObjectFactory(bmd, classes[i]);
                if (managedObjectFactory == null) continue;
                if (managedObjectFactories == null) {
                    managedObjectFactories = new ManagedObjectFactory[classes.length];
                }
                managedObjectFactories[i] = managedObjectFactory;
            }
            imd = new InterceptorMetaData(classes, managedObjectFactories, aroundConstructProxies, postConstructProxies, postActivateProxies, prePassivateProxies, preDestroyProxies, factory.ivBeanLifecycleMethods);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createInterceptorMetaData returning: " + imd));
        }
        return imd;
    }

    private void validateInterceptorBindings() throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateInterceptorBindings", (Object[])new Object[0]);
        }
        ArrayList<Method> interceptableMethods = new ArrayList<Method>(this.ivEJBMethodInfoMap.keySet());
        if (this.ivBmd.timedMethodInfos != null) {
            for (EJBMethodInfoImpl info : this.ivBmd.timedMethodInfos) {
                interceptableMethods.add(info.getMethod());
            }
        }
        for (EJBInterceptorBinding binding : this.ivInterceptorBinding) {
            String methodName;
            String ejbName = binding.getEJBName();
            EJBInterceptorBinding.BindingStyle bindingStyle = binding.getBindingStyle();
            if (ejbName.equals("*")) {
                if (this.ivModuleInterceptorBinding == null) {
                    this.ivModuleInterceptorBinding = binding;
                    continue;
                }
                J2EEName j2eeName = this.ivEJBModuleMetaDataImpl.getJ2EEName();
                String message = "The " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application has more than one style 1 interceptor-binding in the deployment deployment descriptor. Only one style 1 interceptor-binding is allowed";
                Tr.error((TraceComponent)tc, (String)"DUPLICATE_STYLE_1_INTERCEPTOR_BINDING_CNTR0245E", (Object[])new Object[]{j2eeName.getModule(), j2eeName.getApplication()});
                throw new EJBConfigurationException(message);
            }
            if (!ejbName.equals(this.ivEjbName)) continue;
            if (bindingStyle == EJBInterceptorBinding.BindingStyle.STYLE2) {
                if (this.ivClassInterceptorBinding == null) {
                    this.ivClassInterceptorBinding = binding;
                    continue;
                }
                EJBInterceptorBinding binding1 = this.ivClassInterceptorBinding;
                this.ivClassInterceptorBinding = this.validateAndMergeStyle2Bindings(binding1, binding);
                continue;
            }
            if (bindingStyle == EJBInterceptorBinding.BindingStyle.STYLE3) {
                methodName = binding.getMethodName();
                EJBInterceptorBinding oldBinding = this.ivStyle3InterceptorBindingMap.put(methodName, binding);
                if (oldBinding != null) {
                    EJBInterceptorBinding merged = this.validateAndMergeStyle3Or4Bindings(methodName, null, oldBinding, binding);
                    this.ivStyle3InterceptorBindingMap.put(methodName, merged);
                    continue;
                }
                boolean notFound = true;
                for (Method m : interceptableMethods) {
                    if (!m.getName().equals(methodName)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"method not found for interceptor binding", (Object[])new Object[0]);
                    binding.dump();
                }
                String j2eeName = this.ivJ2EEName.toString();
                Tr.error((TraceComponent)tc, (String)"BUSINESS_METHOD_NOT_FOUND_FOR_INTERCEPTOR_BINDING_CNTR0244E", (Object[])new Object[]{methodName, j2eeName, "3"});
                String message = "The " + methodName + " method name is not found  in one of the business interfaces of the " + j2eeName + " enterprise bean. A style 3 interceptor-binding element requires the method to be a business method of the enterprise bean";
                throw new EJBConfigurationException(message);
            }
            if (bindingStyle != EJBInterceptorBinding.BindingStyle.STYLE4) continue;
            methodName = binding.getMethodName();
            List<String> methodParms = binding.getMethodParms();
            String signature = InterceptorMetaDataFactory.methodSignature(methodName, methodParms);
            EJBInterceptorBinding oldBinding = this.ivStyle4InterceptorBindingMap.put(signature = InterceptorMetaDataFactory.normalizeSignature(signature.trim()), binding);
            if (oldBinding != null) {
                EJBInterceptorBinding merged = this.validateAndMergeStyle3Or4Bindings(methodName, signature, oldBinding, binding);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("replaced style 4 for method signature: " + signature), (Object[])new Object[0]);
                }
                this.ivStyle4InterceptorBindingMap.put(signature, merged);
                continue;
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("added style 4 for method signature: " + signature), (Object[])new Object[0]);
            }
            boolean notFound = true;
            for (Method m : interceptableMethods) {
                String methodSignature;
                if (!m.getName().equals(methodName) || !signature.equals(methodSignature = MethodAttribUtils.methodSignature(m))) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"method not found for interceptor binding", (Object[])new Object[0]);
                binding.dump();
            }
            String j2eeName = this.ivJ2EEName.toString();
            Tr.error((TraceComponent)tc, (String)"BUSINESS_METHOD_NOT_FOUND_FOR_INTERCEPTOR_BINDING_CNTR0244E", (Object[])new Object[]{methodName, j2eeName, "4"});
            String message = "The " + methodName + " method name is not found  in one of the business interfaces of the " + j2eeName + " enterprise bean. A style 4 interceptor-binding element requires the method to be a business method of the enterprise bean";
            throw new EJBConfigurationException(message);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateInterceptorBindings");
        }
    }

    public static String methodSignature(String methodName, List<String> parmList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"methodSignature", (Object[])new Object[]{methodName});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append(":");
        boolean appendComma = false;
        for (String parm : parmList) {
            if (appendComma) {
                sb.append(",");
            } else {
                appendComma = true;
            }
            sb.append(parm);
        }
        String signature = sb.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"methodSignature", (Object)signature);
        }
        return signature;
    }

    public static final String normalizeSignature(String deplDescriptorSignature) {
        StringBuilder theSignature = new StringBuilder(deplDescriptorSignature);
        int scanIndex = 0;
        while (scanIndex < theSignature.length()) {
            if (theSignature.charAt(scanIndex) == ' ') {
                char next = theSignature.charAt(scanIndex + 1);
                if (next == ' ' | next == '[' | next == ']') {
                    theSignature.deleteCharAt(scanIndex);
                    continue;
                }
                ++scanIndex;
                continue;
            }
            ++scanIndex;
        }
        return theSignature.toString();
    }

    private EJBInterceptorBinding validateAndMergeStyle2Bindings(EJBInterceptorBinding binding1, EJBInterceptorBinding binding2) throws EJBConfigurationException {
        ArrayList<String> interceptorNames = binding1.ivInterceptorClassNames;
        if (!binding2.ivInterceptorClassNames.isEmpty()) {
            interceptorNames.addAll(binding2.ivInterceptorClassNames);
        }
        ArrayList<String> interceptorOrder = binding1.ivInterceptorOrder;
        if (!binding2.ivInterceptorOrder.isEmpty()) {
            interceptorOrder.addAll(binding2.ivInterceptorOrder);
        }
        Boolean excludeDefault = binding1.ivExcludeDefaultLevelInterceptors;
        if (binding2.ivExcludeDefaultLevelInterceptors != null) {
            excludeDefault = binding2.ivExcludeDefaultLevelInterceptors;
        }
        EJBInterceptorBinding mergedBinding = new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder);
        if (excludeDefault != null) {
            mergedBinding.setExcludeDefaultInterceptors(excludeDefault);
        }
        return mergedBinding;
    }

    private EJBInterceptorBinding validateAndMergeStyle3Or4Bindings(String methodName, String signature, EJBInterceptorBinding binding1, EJBInterceptorBinding binding2) throws EJBConfigurationException {
        ArrayList<String> interceptorNames = binding1.ivInterceptorClassNames;
        if (!binding2.ivInterceptorClassNames.isEmpty()) {
            interceptorNames.addAll(binding2.ivInterceptorClassNames);
        }
        ArrayList<String> interceptorOrder = binding1.ivInterceptorOrder;
        if (!binding2.ivInterceptorOrder.isEmpty()) {
            interceptorOrder.addAll(binding2.ivInterceptorOrder);
        }
        Boolean excludeDefault = binding1.ivExcludeDefaultLevelInterceptors;
        if (binding2.ivExcludeDefaultLevelInterceptors != null) {
            excludeDefault = binding2.ivExcludeDefaultLevelInterceptors;
        }
        Boolean excludeClass = binding1.ivExcludeClassLevelInterceptors;
        if (binding2.ivExcludeClassLevelInterceptors != null) {
            excludeClass = binding2.ivExcludeClassLevelInterceptors;
        }
        EJBInterceptorBinding mergedBinding = signature == null ? new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder, methodName, null) : new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder, methodName, binding1.ivMethodParms);
        if (excludeClass != null) {
            mergedBinding.setExcludeClassLevelInterceptors(excludeClass);
        }
        if (excludeDefault != null) {
            mergedBinding.setExcludeDefaultInterceptors(excludeDefault);
        }
        return mergedBinding;
    }

    private InterceptorMetaDataFactory(EJBModuleMetaDataImpl mmd, BeanMetaData bmd) throws EJBConfigurationException {
        this.ivBmd = bmd;
        this.ivMetadataComplete = bmd.metadataComplete;
        this.ivEjbClass = bmd.enterpriseBeanClass;
        this.ivJ2EEName = bmd.getJ2EEName();
        this.ivEjbName = bmd.enterpriseBeanName;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("InterceptorMetaDataFactory for J2EEName = " + this.ivJ2EEName), (Object[])new Object[0]);
        }
        this.ivClassLoader = bmd.classLoader;
        this.ivEJBModuleMetaDataImpl = mmd;
        this.ivHasComponentInterface = false;
        this.ivMDB = false;
        this.ivSLSB = false;
        this.ivSFSB = false;
        this.ivMB = false;
        if (bmd.type == 7) {
            this.ivMDB = true;
            this.ivHasComponentInterface = MessageDrivenBean.class.isAssignableFrom(this.ivEjbClass);
        } else if (bmd.type == 3) {
            this.ivSLSB = true;
            this.ivHasComponentInterface = SessionBean.class.isAssignableFrom(this.ivEjbClass);
        } else if (bmd.type == 4) {
            this.ivSFSB = true;
            this.ivHasComponentInterface = SessionBean.class.isAssignableFrom(this.ivEjbClass);
            if (bmd.container.isTransactionStatefulLifecycleMethods()) {
                this.ivBeanLifecycleMethods = new Method[4];
            }
        } else if (bmd.type == 2) {
            this.ivHasComponentInterface = false;
            this.ivBeanLifecycleMethods = new Method[4];
        } else if (bmd.type == 8) {
            this.ivMB = true;
        } else {
            throw new IllegalArgumentException("unsupported bean type: " + bmd.type);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ivHasComponentInterface = " + this.ivHasComponentInterface + " for bmd.enterpriseBeanClass = " + this.ivEjbClass.getName()), (Object[])new Object[0]);
        }
        if (this.ivEJBModuleMetaDataImpl.ivInterceptorBindingMap != null) {
            List<EJBInterceptorBinding> list = this.ivEJBModuleMetaDataImpl.getEJBInterceptorBindings("*");
            if (list != null && list.size() > 0) {
                if (list.size() == 1) {
                    this.ivModuleInterceptorBinding = list.get(0);
                } else {
                    J2EEName j2eeName = this.ivEJBModuleMetaDataImpl.getJ2EEName();
                    String message = "The " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application has more than one style 1 interceptor-binding in the deployment deployment descriptor. Only one style 1 interceptor-binding is allowed";
                    Tr.error((TraceComponent)tc, (String)"DUPLICATE_STYLE_1_INTERCEPTOR_BINDING_CNTR0245E", (Object[])new Object[]{j2eeName.getModule(), j2eeName.getApplication()});
                    throw new EJBConfigurationException(message);
                }
            }
            this.ivInterceptorBinding = this.ivEJBModuleMetaDataImpl.getEJBInterceptorBindings(this.ivEjbName);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("InterceptorMetaDataFactory for EJBName = " + this.ivEjbName + ", metadata-complete = " + this.ivMetadataComplete));
        }
    }

    private InterceptorMetaDataFactory() {
        throw new UnsupportedOperationException();
    }

    private void setExcludeDefaultInterceptors() {
        EJBInterceptorBinding binding = this.ivClassInterceptorBinding;
        boolean useAnnotation = false;
        if (binding == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else {
            Boolean exclude = binding.ivExcludeDefaultLevelInterceptors;
            if (exclude == null) {
                useAnnotation = !this.ivMetadataComplete;
            } else {
                this.ivExcludeDefaultFromClassLevel = exclude == Boolean.TRUE;
            }
        }
        if (useAnnotation) {
            ExcludeDefaultInterceptors a = this.ivEjbClass.getAnnotation(ExcludeDefaultInterceptors.class);
            this.ivExcludeDefaultFromClassLevel = a != null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setExcludeDefaultInterceptors: " + this.ivExcludeDefaultFromClassLevel), (Object[])new Object[0]);
        }
    }

    private void addDefaultInterceptors() throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDefaultInterceptorNames", (Object[])new Object[0]);
        }
        AbstractList names = new LinkedList<String>();
        if (this.ivModuleInterceptorBinding != null) {
            if (!this.ivModuleInterceptorBinding.ivInterceptorClassNames.isEmpty()) {
                names = this.ivModuleInterceptorBinding.ivInterceptorClassNames;
            } else if (!this.ivModuleInterceptorBinding.ivInterceptorOrder.isEmpty()) {
                names = this.ivModuleInterceptorBinding.ivInterceptorOrder;
            }
        }
        if (names.size() > 0) {
            this.updateNamesToClassMap(names);
            this.ivDefaultInterceptorNames.addAll(names);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addDefaultInterceptorNames: " + this.ivDefaultInterceptorNames));
        }
    }

    private void addClassLevelInterceptors() throws EJBConfigurationException {
        Interceptors cli;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addClassLevelInterceptors for EJB name: " + this.ivEjbName), (Object[])new Object[0]);
        }
        if (!this.ivMetadataComplete && (cli = this.ivEjbClass.getAnnotation(Interceptors.class)) != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processing @Interceptor annotation for EJB name", (Object[])new Object[0]);
            }
            List<String> names = this.addLoadedInterceptorClasses(cli.value());
            this.ivClassInterceptorNames.addAll(names);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(names + " were annotated with @Interceptor annotation at class level"), (Object[])new Object[0]);
            }
        }
        if (this.ivClassInterceptorBinding != null) {
            ArrayList<String> classInterceptorNames = this.ivClassInterceptorBinding.ivInterceptorClassNames;
            ArrayList<String> interceptorOrder = this.ivClassInterceptorBinding.ivInterceptorOrder;
            if (!classInterceptorNames.isEmpty()) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updating class level list with InterceptorBinding list: " + classInterceptorNames), (Object[])new Object[0]);
                }
                this.updateNamesToClassMap(classInterceptorNames);
                this.ivClassInterceptorNames.addAll(classInterceptorNames);
            } else if (!interceptorOrder.isEmpty()) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updating class level list with InterceptorBinding order list: " + interceptorOrder), (Object[])new Object[0]);
                }
                HashSet<String> set = new HashSet<String>(interceptorOrder);
                set.removeAll(this.ivDefaultInterceptorNames);
                set.removeAll(this.ivClassInterceptorNames);
                if (!set.isEmpty()) {
                    this.updateNamesToClassMap(set);
                    this.ivClassInterceptorNames.addAll(set);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addClassLevelInterceptors returning: " + this.ivClassInterceptorNames + " for EJB name: " + this.ivEjbName));
        }
    }

    private void addJCDIInterceptors() {
        JCDIHelper jcdiHelper = this.ivEJBModuleMetaDataImpl.ivJCDIHelper;
        if (jcdiHelper != null && !this.ivBmd.isManagedBean()) {
            J2EEName j2eeName = this.ivEJBModuleMetaDataImpl.ivJ2EEName;
            this.ivJCDIFirstInterceptorClass = jcdiHelper.getFirstEJBInterceptor(j2eeName, this.ivEjbClass);
            if (this.ivJCDIFirstInterceptorClass != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addJCDIInterceptor : " + this.ivJCDIFirstInterceptorClass.getName()), (Object[])new Object[0]);
                }
                this.ivInterceptorNameToClassMap.put(this.ivJCDIFirstInterceptorClass.getName(), this.ivJCDIFirstInterceptorClass);
            }
            this.ivJCDILastInterceptorClass = jcdiHelper.getEJBInterceptor(j2eeName, this.ivEjbClass);
            if (this.ivJCDILastInterceptorClass != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addJCDIInterceptor : " + this.ivJCDILastInterceptorClass.getName()), (Object[])new Object[0]);
                }
                this.ivInterceptorNameToClassMap.put(this.ivJCDILastInterceptorClass.getName(), this.ivJCDILastInterceptorClass);
            }
        }
    }

    private void updateNamesToClassMap(Collection<String> classInterceptorNames) throws EJBConfigurationException {
        String classNameToLoad = null;
        try {
            for (String name : classInterceptorNames) {
                Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                if (interceptorClass != null) continue;
                classNameToLoad = name;
                interceptorClass = this.ivClassLoader.loadClass(name);
                this.ivInterceptorNameToClassMap.put(name, interceptorClass);
            }
        }
        catch (ClassNotFoundException ex) {
            Tr.error((TraceComponent)tc, (String)"BEANCLASS_NOT_FOUND_CNTR0075E", (Object[])new Object[]{classNameToLoad});
            EJBConfigurationException cex = new EJBConfigurationException(classNameToLoad + " could not be found or loaded", ex);
            throw cex;
        }
    }

    private List<String> addLoadedInterceptorClasses(Class<?>[] classes) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> klass : classes) {
            String className = klass.getName();
            this.ivInterceptorNameToClassMap.put(className, klass);
            names.add(className);
        }
        return names;
    }

    private ArrayList<String> addMethodLevelInterceptors(Method method, EJBInterceptorBinding methodBinding) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addMethodLevelInterceptors method: " + method.getName()), (Object[])new Object[0]);
        }
        ArrayList<String> interceptorNames = new ArrayList<String>();
        if (!this.ivMetadataComplete) {
            Interceptors methodLevelInterceptors = method.getAnnotation(Interceptors.class);
            String methodName = method.getName();
            if (methodLevelInterceptors != null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processing @Interceptor annotation for method: " + methodName + ", EJB name: " + this.ivEjbName), (Object[])new Object[0]);
                }
                List<String> names = this.addLoadedInterceptorClasses(methodLevelInterceptors.value());
                interceptorNames.addAll(names);
            }
        }
        if (methodBinding != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing interceptor binding for method: " + method), (Object[])new Object[0]);
            }
            ArrayList<String> names = methodBinding.ivInterceptorClassNames;
            this.updateNamesToClassMap(names);
            interceptorNames.addAll(names);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addMethodLevelInterceptors: " + interceptorNames));
        }
        return interceptorNames;
    }

    private void updateEJBMethodInfoInterceptorProxies() throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateEJBMethodInfoInterceptorProxies: " + this.ivEjbName), (Object[])new Object[0]);
        }
        for (Map.Entry<Method, ArrayList<EJBMethodInfoImpl>> entry : this.ivEJBMethodInfoMap.entrySet()) {
            InterceptorProxy[] proxies = this.getAroundInterceptorProxies(InterceptorMethodKind.AROUND_INVOKE, entry.getKey());
            if (proxies == null) continue;
            for (EJBMethodInfoImpl info : entry.getValue()) {
                info.setAroundInterceptorProxies(proxies);
            }
        }
        if (this.ivBmd.timedMethodInfos != null) {
            for (EJBMethodInfoImpl info : this.ivBmd.timedMethodInfos) {
                InterceptorProxy[] proxies = this.getAroundInterceptorProxies(InterceptorMethodKind.AROUND_TIMEOUT, info.getMethod());
                if (proxies == null) continue;
                info.setAroundInterceptorProxies(proxies);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateEJBMethodInfoInterceptorProxies: " + this.ivJ2EEName));
        }
    }

    private InterceptorProxy[] getAroundInterceptorProxies(InterceptorMethodKind kind, Method m) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAroundInterceptorProxies: " + (Object)((Object)kind) + ", " + m), (Object[])new Object[0]);
        }
        ArrayList<String> orderedList = this.orderMethodLevelInterceptors(m);
        InterceptorProxy[] proxies = this.getInterceptorProxies(kind, orderedList);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAroundInterceptorProxies");
        }
        return proxies;
    }

    private boolean isDefaultInterceptorsExcluded(Method m, EJBInterceptorBinding binding) {
        boolean exclude;
        if (this.ivExcludeDefaultFromClassLevel) {
            exclude = true;
        } else if (binding != null && binding.ivExcludeDefaultLevelInterceptors != null) {
            exclude = binding.ivExcludeDefaultLevelInterceptors;
        } else {
            boolean bl = exclude = !this.ivMetadataComplete && m.getAnnotation(ExcludeDefaultInterceptors.class) != null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isDefaultInterceptorsExcluded for " + m.getDeclaringClass() + "." + m.getName() + " returning: " + exclude), (Object[])new Object[0]);
        }
        return exclude;
    }

    private boolean isClassInterceptorsExcluded(Method m, EJBInterceptorBinding binding) {
        boolean exclude;
        if (binding != null && binding.ivExcludeClassLevelInterceptors != null) {
            exclude = binding.ivExcludeClassLevelInterceptors;
        } else {
            boolean bl = exclude = !this.ivMetadataComplete && m.getAnnotation(ExcludeClassInterceptors.class) != null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isClassInterceptorsExcluded for " + m.getDeclaringClass() + "." + m.getName() + " returning: " + exclude), (Object[])new Object[0]);
        }
        return exclude;
    }

    private void processBeanInterceptors() throws EJBConfigurationException {
        this.ivBeanInterceptorProxyMap = this.createInterceptorProxyMap(this.ivEjbClass, -1);
        if (this.ivBeanLifecycleMethods != null) {
            block0: for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
                List<InterceptorProxy> proxyList;
                int mid = kind.getMethodID();
                if (mid == -1 || (proxyList = this.ivBeanInterceptorProxyMap.get((Object)kind)) == null) continue;
                for (InterceptorProxy proxy : proxyList) {
                    Method m = proxy.ivInterceptorMethod;
                    if (m.getDeclaringClass() != this.ivEjbClass) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found bean " + LifecycleInterceptorWrapper.TRACE_NAMES[mid] + " method: " + m), (Object[])new Object[0]);
                    }
                    this.ivBeanLifecycleMethods[mid] = m;
                    continue block0;
                }
            }
        }
    }

    private InterceptorProxy[] getInterceptorProxies(InterceptorMethodKind kind, List<String> orderedList) throws EJBConfigurationException {
        Object[] proxies;
        List<InterceptorProxy> kindProxyList;
        List<InterceptorProxy> kindProxyList2;
        Map<InterceptorMethodKind, List<InterceptorProxy>> proxyMap;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInterceptorProxies: " + (Object)((Object)kind) + ", " + orderedList), (Object[])new Object[0]);
        }
        ArrayList<InterceptorProxy> proxyList = new ArrayList<InterceptorProxy>();
        for (String name : orderedList) {
            List<InterceptorProxy> kindProxyList3;
            Class<?> klass = this.ivInterceptorNameToClassMap.get(name);
            Map<InterceptorMethodKind, List<InterceptorProxy>> proxyMap2 = this.ivInterceptorProxyMaps.get(klass);
            if (proxyMap2 == null) {
                int index = this.ivInterceptorClasses.size();
                this.ivInterceptorClasses.add(klass);
                proxyMap2 = this.createInterceptorProxyMap(klass, index);
                this.ivInterceptorProxyMaps.put(klass, proxyMap2);
            }
            if ((kindProxyList3 = proxyMap2.get((Object)kind)) == null) continue;
            proxyList.addAll(kindProxyList3);
        }
        if (this.ivJCDIFirstInterceptorClass != null) {
            proxyMap = this.ivInterceptorProxyMaps.get(this.ivJCDIFirstInterceptorClass);
            if (proxyMap == null) {
                int index = this.ivInterceptorClasses.size();
                this.ivInterceptorClasses.add(this.ivJCDIFirstInterceptorClass);
                proxyMap = this.createInterceptorProxyMap(this.ivJCDIFirstInterceptorClass, index);
                this.ivInterceptorProxyMaps.put(this.ivJCDIFirstInterceptorClass, proxyMap);
            }
            if ((kindProxyList2 = proxyMap.get((Object)kind)) != null) {
                proxyList.addAll(0, kindProxyList2);
            }
        }
        if (this.ivJCDILastInterceptorClass != null) {
            proxyMap = this.ivInterceptorProxyMaps.get(this.ivJCDILastInterceptorClass);
            if (proxyMap == null) {
                int index = this.ivInterceptorClasses.size();
                this.ivInterceptorClasses.add(this.ivJCDILastInterceptorClass);
                proxyMap = this.createInterceptorProxyMap(this.ivJCDILastInterceptorClass, index);
                this.ivInterceptorProxyMaps.put(this.ivJCDILastInterceptorClass, proxyMap);
            }
            if ((kindProxyList2 = proxyMap.get((Object)kind)) != null) {
                proxyList.addAll(kindProxyList2);
            }
        }
        if ((kindProxyList = this.ivBeanInterceptorProxyMap.get((Object)kind)) != null) {
            proxyList.addAll(kindProxyList);
        }
        if (proxyList.isEmpty()) {
            proxies = null;
        } else {
            proxies = new InterceptorProxy[proxyList.size()];
            proxyList.toArray(proxies);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInterceptorProxies: " + Arrays.toString(proxies)));
        }
        return proxies;
    }

    private Map<InterceptorMethodKind, List<InterceptorProxy>> createInterceptorProxyMap(Class<?> interceptorOrEjbClass, int index) throws EJBConfigurationException {
        boolean ejbClass;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createInterceptorProxyMap: " + interceptorOrEjbClass.getName() + ", " + index), (Object[])new Object[0]);
        }
        LinkedList<Class<?>> supers = InterceptorMetaDataHelper.getLIFOSuperClassesList(interceptorOrEjbClass);
        EnumMap<InterceptorMethodKind, List<Method>> enumMap = null;
        boolean bl = ejbClass = index < 0;
        if (ejbClass) {
            EnterpriseBean bean;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing EJB class, ivHasComponentInterface = " + this.ivHasComponentInterface), (Object[])new Object[0]);
            }
            if ((bean = this.ivBmd.wccm.enterpriseBean) != null) {
                enumMap = InterceptorMetaDataHelper.getEJBInterceptorMethods(this.ivEjbClass, bean, supers, this.ivBmd.j2eeName);
            }
        } else {
            IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> interceptorsMap = this.ivEJBModuleMetaDataImpl.ivInterceptorsMap;
            if (interceptorsMap != null) {
                enumMap = interceptorsMap.get(interceptorOrEjbClass);
            }
        }
        HashMap<InterceptorMethodKind, List<InterceptorProxy>> proxyMap = new HashMap<InterceptorMethodKind, List<InterceptorProxy>>();
        for (Class clazz : supers) {
            Method[] methods;
            EnumMap<InterceptorMethodKind, InterceptorProxy> proxies = new EnumMap<InterceptorMethodKind, InterceptorProxy>(InterceptorMethodKind.class);
            if (enumMap != null) {
                for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
                    List<Method> methodList = enumMap.get((Object)kind);
                    if (methodList == null) continue;
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (kind.isLifecycle() && ejbClass && kind.isEJBCallbackMethodValidationRequired(this)) {
                            this.validateEJBCallbackMethod(kind, m, false);
                        }
                        if (m.getDeclaringClass() != clazz) continue;
                        if (proxies.containsKey((Object)kind)) {
                            String className = clazz.getName();
                            Object[] data = new Object[]{className, kind.getXMLElementName()};
                            Tr.error((TraceComponent)tc, (String)"DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", (Object[])data);
                            throw new EJBConfigurationException("Only one " + kind.getXMLElementName() + " interceptor method is allowed in class " + className);
                        }
                        this.addInterceptorProxy(kind, m, index, proxies, proxyMap);
                    }
                }
            }
            if (this.ivMetadataComplete) continue;
            for (Method m : methods = clazz.getDeclaredMethods()) {
                for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
                    InterceptorProxy proxy;
                    Class<? extends Annotation> annotationClass = kind.getAnnotationClass();
                    if (annotationClass != null && m.isAnnotationPresent(annotationClass)) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (kind.isLifecycle()) {
                            if (ejbClass && kind.isEJBCallbackMethodValidationRequired(this)) {
                                this.validateEJBCallbackMethod(kind, m, true);
                            }
                            InterceptorMetaDataHelper.validateLifeCycleSignature(kind, annotationClass.getSimpleName(), m, ejbClass, this.ivBmd.j2eeName);
                        } else {
                            InterceptorMetaDataHelper.validateAroundSignature(kind, m, this.ivBmd.j2eeName);
                        }
                        proxy = (InterceptorProxy)proxies.get((Object)kind);
                        if (proxy == null) {
                            this.addInterceptorProxy(kind, m, index, proxies, proxyMap);
                            continue;
                        }
                        if (m.equals(proxy.ivInterceptorMethod)) continue;
                        String className = clazz.getName();
                        Object[] data = new Object[]{className, kind.getXMLElementName()};
                        Tr.error((TraceComponent)tc, (String)"DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", (Object[])data);
                        throw new EJBConfigurationException("Only one " + kind.getXMLElementName() + " interceptor method is allowed in class " + className);
                    }
                    if (!kind.isLifecycle() || !ejbClass || !kind.isNonAnnotatedEJBCallbackMethodValidationRequired(this) || !m.getName().equals(kind.getLifecycleCallbackMethodName()) || m.getParameterTypes().length != 0 || m.getReturnType() != Void.TYPE) continue;
                    proxy = (InterceptorProxy)proxies.get((Object)kind);
                    if (proxy == null) {
                        this.addInterceptorProxy(kind, m, index, proxies, proxyMap);
                        continue;
                    }
                    if (m.equals(proxy.ivInterceptorMethod)) continue;
                    String className = clazz.getName();
                    Object[] data = new Object[]{className, kind.getXMLElementName()};
                    Tr.error((TraceComponent)tc, (String)"DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", (Object[])data);
                    throw new EJBConfigurationException("Only one post-construct interceptor method is allowed for class " + className + ". Both " + proxy.ivInterceptorMethod.getName() + " and " + m.getName() + " are configured as post-construct methods.");
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInterceptorProxyMap");
        }
        return proxyMap;
    }

    private void addInterceptorProxy(InterceptorMethodKind kind, Method m, int index, Map<InterceptorMethodKind, InterceptorProxy> classProxies, Map<InterceptorMethodKind, List<InterceptorProxy>> proxyMap) {
        InterceptorProxy proxy = new InterceptorProxy(m, index);
        classProxies.put(kind, proxy);
        List<InterceptorProxy> proxyList = proxyMap.get((Object)kind);
        if (proxyList == null) {
            proxyList = new ArrayList<InterceptorProxy>();
            proxyMap.put(kind, proxyList);
        }
        proxyList.add(proxy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding " + (Object)((Object)kind) + ": " + proxy), (Object[])new Object[0]);
        }
    }

    private void validateEJBCallbackMethod(InterceptorMethodKind actualKind, Method m, boolean annotation) throws EJBConfigurationException {
        String methodName = m.getName();
        InterceptorMethodKind requiredKind = this.mapEjbCallbackName(methodName);
        if (requiredKind != null && actualKind != requiredKind) {
            String ejbClassName = this.ivEjbClass.getName();
            String required = this.mapInterceptorMethodKind(requiredKind, true, annotation);
            String actual = this.mapInterceptorMethodKind(actualKind, false, annotation);
            StringBuilder sb = new StringBuilder();
            if (this.ivMDB) {
                sb.append("CNTR0243E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the jakarta.ejb.MessageDriven interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error((TraceComponent)tc, (String)"INVALID_MDB_CALLBACK_METHOD_CNTR0243E", (Object[])new Object[]{ejbClassName, methodName, required, actual});
            } else if (this.ivSLSB) {
                sb.append("CNTR0241E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the jakarta.ejb.SessionBean interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error((TraceComponent)tc, (String)"INVALID_SLSB_CALLBACK_METHOD_CNTR0241E", (Object[])new Object[]{ejbClassName, methodName, required, actual});
            } else if (this.ivSFSB) {
                sb.append("CNTR0242E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the jakarta.ejb.SessionBean interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error((TraceComponent)tc, (String)"INVALID_SFSB_CALLBACK_METHOD_CNTR0242E", (Object[])new Object[]{ejbClassName, methodName, required, actual});
            }
            throw new EJBConfigurationException(sb.toString());
        }
    }

    private InterceptorMethodKind mapEjbCallbackName(String methodName) {
        for (InterceptorMethodKind kind : InterceptorMethodKind.values()) {
            if (!kind.isLifecycle() || !methodName.equals(kind.getLifecycleCallbackMethodName())) continue;
            return kind;
        }
        return null;
    }

    private String mapInterceptorMethodKind(InterceptorMethodKind kind, boolean honorSFSBMapping, boolean annotation) {
        if (kind.isLifecycle()) {
            if (kind == InterceptorMethodKind.POST_CONSTRUCT && this.ivSFSB && honorSFSBMapping) {
                if (annotation) {
                    return "@Init";
                }
                return "init-method";
            }
            if (annotation) {
                return kind.getAnnotationClass().getSimpleName();
            }
            return kind.getXMLElementName();
        }
        return "";
    }

    private EJBInterceptorBinding findInterceptorBindingForMethod(Method method) {
        EJBInterceptorBinding binding;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findInterceptorBindingForMethod: " + method.toString()), (Object[])new Object[0]);
        }
        String methodSignature = MethodAttribUtils.methodSignature(method);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lookup style 4 for method signature: " + methodSignature), (Object[])new Object[0]);
        }
        if ((binding = this.ivStyle4InterceptorBindingMap.get(methodSignature)) == null) {
            String methodName = method.getName();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("lookup style 3 for method: " + methodName), (Object[])new Object[0]);
            }
            binding = this.ivStyle3InterceptorBindingMap.get(methodName);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            if (binding != null) {
                Tr.exit((TraceComponent)tc, (String)"findInterceptorBindingForMethod found: ");
                binding.dump();
            } else {
                Tr.exit((TraceComponent)tc, (String)"findInterceptorBindingForMethod, interceptor-binding not found");
            }
        }
        return binding;
    }

    private ArrayList<String> orderClassLevelInterceptors() throws EJBConfigurationException {
        ArrayList<String> order;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"orderClassLevelInterceptors", (Object[])new Object[0]);
        }
        ArrayList<String> orderedList = new ArrayList<String>();
        if (!this.ivExcludeDefaultFromClassLevel && this.ivDefaultInterceptorNames.size() > 0) {
            orderedList.addAll(this.ivDefaultInterceptorNames);
        }
        if (this.ivClassInterceptorNames.size() > 0) {
            orderedList.addAll(this.ivClassInterceptorNames);
        }
        if (this.ivClassInterceptorBinding != null && !(order = this.ivClassInterceptorBinding.ivInterceptorOrder).isEmpty()) {
            ArrayList<String> interceptorOrder = new ArrayList<String>(order);
            if (interceptorOrder.containsAll(orderedList)) {
                orderedList = interceptorOrder;
            } else {
                ArrayList<String> missingList;
                if (interceptorOrder.size() < orderedList.size()) {
                    orderedList.removeAll(interceptorOrder);
                    missingList = orderedList;
                } else {
                    interceptorOrder.removeAll(orderedList);
                    missingList = interceptorOrder;
                }
                String ejbName = this.ivJ2EEName.toString();
                Object[] data = new Object[]{ejbName, order, missingList};
                Tr.warning((TraceComponent)tc, (String)"PARTIAL_CLASS_INTERCEPTOR_ORDER_CNTR0227E", (Object[])data);
                throw new EJBConfigurationException(order + " is not a total ordering of class-level interceptors for EJB " + ejbName + ". It is missing interceptor names: " + missingList);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("orderClassLevelInterceptors: " + orderedList));
        }
        return orderedList;
    }

    private ArrayList<String> orderMethodLevelInterceptors(Method m) throws EJBConfigurationException {
        ArrayList<String> orderedList = new ArrayList<String>();
        EJBInterceptorBinding binding = this.findInterceptorBindingForMethod(m);
        boolean excludeClassInterceptors = this.isClassInterceptorsExcluded(m, binding);
        boolean excludeDefaultInterceptors = this.isDefaultInterceptorsExcluded(m, binding);
        ArrayList<String> interceptors = this.addMethodLevelInterceptors(m, binding);
        if (!excludeClassInterceptors && excludeDefaultInterceptors == this.ivExcludeDefaultFromClassLevel) {
            orderedList.addAll(this.ivClassInterceptorOrder);
        } else {
            if (!excludeDefaultInterceptors) {
                orderedList.addAll(this.ivDefaultInterceptorNames);
            }
            if (!excludeClassInterceptors) {
                orderedList.addAll(this.ivClassInterceptorNames);
            }
        }
        orderedList.addAll(interceptors);
        if (binding != null && !binding.ivInterceptorOrder.isEmpty()) {
            ArrayList<String> order = binding.ivInterceptorOrder;
            this.updateNamesToClassMap(order);
            ArrayList<String> interceptorOrder = new ArrayList<String>(order);
            if (interceptorOrder.containsAll(orderedList)) {
                orderedList = interceptorOrder;
            } else {
                ArrayList<String> missingList;
                if (interceptorOrder.size() < orderedList.size()) {
                    orderedList.removeAll(interceptorOrder);
                    missingList = orderedList;
                } else {
                    interceptorOrder.removeAll(orderedList);
                    missingList = interceptorOrder;
                }
                String ejbName = this.ivJ2EEName.toString();
                String methodName = m.getName();
                Object[] data = new Object[]{ejbName, methodName, order, missingList};
                Tr.warning((TraceComponent)tc, (String)"PARTIAL_METHOD_INTERCEPTOR_ORDER_CNTR0228E", (Object[])data);
                throw new EJBConfigurationException(order + " is not a total ordering of method-level interceptors for method " + methodName + " of EJB " + ejbName + ". It is missing interceptor names: " + missingList);
            }
        }
        return orderedList;
    }
}

