/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.jbatch.rest.internal.resources.RequestException;
import com.ibm.ws.jbatch.rest.internal.resources.RequestHandler;
import com.ibm.ws.jbatch.rest.internal.resources.RequestRouter;
import com.ibm.ws.jbatch.rest.utils.BatchJSONHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchRuntime;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions/{jobexecutionid}/stepexecutions", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/stepexecutions/{stepexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions/{jobexecutionid}/stepexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v1/stepexecutions/{stepexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions/{jobexecutionid}/stepexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v2/stepexecutions/{stepexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions/{jobexecutionid}/stepexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v3/stepexecutions/{stepexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions/{jobexecutionid}/stepexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v4/stepexecutions/{stepexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}/stepexecutions/{stepname}", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class StepExecutions
implements RESTHandler {
    private WSJobRepository jobRepository;
    private RequestRouter requestRouter = new RequestRouter().addHandler(new StepExecutionsHandler("/batch/jobexecutions/*/stepexecutions")).addHandler(new StepExecutionByStepNameHandler("/batch/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionHandler("/batch/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/jobinstances/*/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/jobinstances/*/jobexecnum/*/stepexecutions/*")).addHandler(new StepExecutionsHandler("/batch/v1/jobexecutions/*/stepexecutions")).addHandler(new StepExecutionByStepNameHandler("/batch/v1/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionHandler("/batch/v1/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v1/jobinstances/*/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v1/jobinstances/*/jobexecnum/*/stepexecutions/*")).addHandler(new StepExecutionsHandler("/batch/v2/jobexecutions/*/stepexecutions")).addHandler(new StepExecutionByStepNameHandler("/batch/v2/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionHandler("/batch/v2/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v2/jobinstances/*/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v2/jobinstances/*/jobexecnum/*/stepexecutions/*")).addHandler(new StepExecutionsHandler("/batch/v3/jobexecutions/*/stepexecutions")).addHandler(new StepExecutionByStepNameHandler("/batch/v3/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionHandler("/batch/v3/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v3/jobinstances/*/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v3/jobinstances/*/jobexecnum/*/stepexecutions/*")).addHandler(new StepExecutionsHandler("/batch/v4/jobexecutions/*/stepexecutions")).addHandler(new StepExecutionByStepNameHandler("/batch/v4/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionHandler("/batch/v4/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v4/jobinstances/*/jobexecutions/*/stepexecutions/*")).addHandler(new StepExecutionByJobExecNumberAndStepNameHandler("/batch/v4/jobinstances/*/jobexecnum/*/stepexecutions/*"));
    static final long serialVersionUID = -5041415705613983935L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    protected void unsetWSJobRepository(WSJobRepository ref) {
        if (this.jobRepository == ref) {
            this.jobRepository = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        try {
            BatchRuntime.getJobOperator();
            this.requestRouter.routeRequest(request, response);
        }
        catch (JobSecurityException jobSecurityException) {
            void jse;
            FFDCFilter.processException((Throwable)jobSecurityException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"140", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(401, jse.getMessage());
        }
        catch (Exception jse) {
            void e;
            FFDCFilter.processException((Throwable)jse, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"142", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, e.getMessage());
        }
    }

    public void getStepExecutionsDataByStepName(RESTRequest request, RESTResponse response, long jobExecutionId, String stepName) throws IOException {
        ArrayList<WSStepThreadExecutionAggregate> stepExecAggregateList = new ArrayList<WSStepThreadExecutionAggregate>();
        try {
            stepExecAggregateList.add(this.jobRepository.getStepExecutionAggregateFromJobExecution(jobExecutionId, stepName));
            response.setContentType("application/json; charset=UTF-8");
            BatchJSONHelper.writeStepExecutionsList(stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            FFDCFilter.processException((Throwable)noSuchJobExecutionException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"224", (Object)this, (Object[])new Object[]{request, response, jobExecutionId, stepName});
            response.sendError(400, "Job Execution Id " + jobExecutionId + " with Step Name " + stepName + " not found.");
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"226", (Object)this, (Object[])new Object[]{request, response, jobExecutionId, stepName});
            response.sendError(400, "Job Execution Id " + jobExecutionId + " with Step Name " + stepName + " not found.");
        }
    }

    public void getStepExecution(RESTRequest request, RESTResponse response, long stepExecutionId) throws IOException {
        ArrayList<WSStepThreadExecutionAggregate> stepExecAggregateList = new ArrayList<WSStepThreadExecutionAggregate>();
        try {
            stepExecAggregateList.add(this.jobRepository.getStepExecutionAggregate(stepExecutionId));
            response.setContentType("application/json; charset=UTF-8");
            BatchJSONHelper.writeStepExecutionsList(stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"255", (Object)this, (Object[])new Object[]{request, response, stepExecutionId});
            response.sendError(400, "Step execution " + stepExecutionId + " not found.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getJobExecutionId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobexecutionid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"270", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job execution id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    public void getStepExecutionsData(RESTRequest request, RESTResponse response, long jobExecutionId) throws IOException {
        try {
            List stepExecAggregateList = this.jobRepository.getStepExecutionAggregatesFromJobExecution(jobExecutionId);
            response.setContentType("application/json; charset=UTF-8");
            BatchJSONHelper.writeStepExecutionsList(stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException stepExecAggregateList) {
            FFDCFilter.processException((Throwable)stepExecAggregateList, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"299", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(400, "Job execution " + jobExecutionId + " not found.");
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"301", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(400, "Job execution " + jobExecutionId + " not found.");
        }
    }

    public void getStepExecutionDataByJobExecNumAndStepName(RESTRequest request, RESTResponse response, long jobInstanceId, short jobExecNum, String stepName) throws IOException {
        ArrayList<WSStepThreadExecutionAggregate> stepExecAggregateList = new ArrayList<WSStepThreadExecutionAggregate>();
        try {
            stepExecAggregateList.add(this.jobRepository.getStepExecutionAggregateFromJobExecutionNumberAndStepName(jobInstanceId, jobExecNum, stepName));
            response.setContentType("application/json; charset=UTF-8");
            BatchJSONHelper.writeStepExecutionsList(stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            FFDCFilter.processException((Throwable)noSuchJobExecutionException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"332", (Object)this, (Object[])new Object[]{request, response, jobInstanceId, jobExecNum, stepName});
            response.sendError(400, "Job Instance Id " + jobInstanceId + " with Execution Sequence Number " + jobExecNum + " and Step Name " + stepName + " not found.");
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"334", (Object)this, (Object[])new Object[]{request, response, jobInstanceId, jobExecNum, stepName});
            response.sendError(400, "Job Instance Id " + jobInstanceId + " with Execution Sequence Number " + jobExecNum + " and Step Name " + stepName + " not found.");
        }
    }

    protected String getStepName(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("stepname");
        if (s == null || s.trim().length() == 0) {
            throw new RequestException(400, "The step id is null or empty");
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    protected long getStepExecutionId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("stepexecutionid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"365", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The step execution id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected short getJobExecutionNum(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobexecutionnumber");
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"383", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job execution number (" + s + ") must be a Short integer", (Exception)nfe);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getJobInstanceId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobinstanceid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", (String)"401", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job instance id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions", StepExecutions.class, (String)"wsbatch", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StepExecutionsHandler
    extends RequestHandler {
        static final long serialVersionUID = 8762356178935134761L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StepExecutionsHandler(String path) {
            super(path);
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            StepExecutions.this.getStepExecutionsData(request, response, StepExecutions.this.getJobExecutionId(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions$StepExecutionsHandler", StepExecutionsHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StepExecutionByStepNameHandler
    extends RequestHandler {
        static final long serialVersionUID = -8305105832746539109L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StepExecutionByStepNameHandler(String path) {
            super(path);
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            StepExecutions.this.getStepExecutionsDataByStepName(request, response, StepExecutions.this.getJobExecutionId(request), StepExecutions.this.getStepName(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions$StepExecutionByStepNameHandler", StepExecutionByStepNameHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StepExecutionHandler
    extends RequestHandler {
        static final long serialVersionUID = 5920325778048341422L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StepExecutionHandler(String path) {
            super(path);
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            StepExecutions.this.getStepExecution(request, response, StepExecutions.this.getStepExecutionId(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions$StepExecutionHandler", StepExecutionHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StepExecutionByJobExecNumberAndStepNameHandler
    extends RequestHandler {
        static final long serialVersionUID = -5401130237337636439L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StepExecutionByJobExecNumberAndStepNameHandler(String path) {
            super(path);
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            StepExecutions.this.getStepExecutionDataByJobExecNumAndStepName(request, response, StepExecutions.this.getJobInstanceId(request), StepExecutions.this.getJobExecutionNum(request), StepExecutions.this.getStepName(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.StepExecutions$StepExecutionByJobExecNumberAndStepNameHandler", StepExecutionByJobExecNumberAndStepNameHandler.class, (String)"wsbatch", null);
        }
    }
}

