/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.utils;

import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSPartitionStepAggregate;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.WSTopLevelStepExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.joblog.JobExecutionLog;
import com.ibm.ws.jbatch.joblog.JobInstanceLog;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.jbatch.rest.utils.BatchDateFormat;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.jbatch.rest.utils.WSPurgeResponse;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BatchJSONHelper {
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String MEDIA_TYPE_APPLICATION_JSON = "application/json; charset=UTF-8";
    private static final JsonBuilderFactory builderFactory;
    private static final JsonReaderFactory readerFactory;
    private static final JsonWriterFactory prettyWriterFactory;
    static final long serialVersionUID = 3062975397506794923L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static JsonObject readJsonObject(InputStream inputStream) {
        JsonReader jsonReader = readerFactory.createReader(inputStream);
        JsonObject jsonObject = jsonReader.readObject();
        jsonReader.close();
        return jsonObject;
    }

    public static void writeJsonObject(JsonObject jsonObject, OutputStream outputStream) {
        BatchJSONHelper.writeJsonStructure((JsonStructure)jsonObject, outputStream);
    }

    public static void writeJsonStructure(JsonStructure jsonStructure, OutputStream outputStream) {
        JsonWriter jsonWriter = BatchJSONHelper.createPrettyJsonWriter(outputStream);
        jsonWriter.write(jsonStructure);
        jsonWriter.close();
    }

    public static JsonObject createJsonObject() {
        return builderFactory.createObjectBuilder().build();
    }

    public static void writeJobInstances(List<WSJobInstance> jobInstances, String urlRoot, OutputStream outputStream) throws IOException {
        JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
        for (WSJobInstance jobInstance : jobInstances) {
            JsonObjectBuilder json = BatchJSONHelper.toJsonObjectBuilderWithLinks(jobInstance, new ArrayList<WSJobExecution>(jobInstance.getJobExecutions()), urlRoot);
            jsonArrayBuilder.add(json);
        }
        BatchJSONHelper.writeJsonStructure((JsonStructure)jsonArrayBuilder.build(), outputStream);
    }

    public static void writeJobInstance(WSJobInstance jobInstance, String urlRoot, OutputStream outputStream) throws IOException {
        BatchJSONHelper.writeJobInstance(jobInstance, new ArrayList<WSJobExecution>(), urlRoot, outputStream);
    }

    public static void writeJobInstance(WSJobInstance jobInstance, List<WSJobExecution> jobExecList, String urlRoot, OutputStream outputStream) throws IOException {
        JsonObject jsonObject = BatchJSONHelper.toJsonObjectBuilderWithLinks(jobInstance, jobExecList, urlRoot).build();
        BatchJSONHelper.writeJsonStructure((JsonStructure)jsonObject, outputStream);
    }

    public static void writeJobExecution(WSJobExecution jobExecution, List<WSStepThreadExecutionAggregate> stepExecs, String urlRoot, OutputStream outputStream) throws IOException {
        BatchJSONHelper.writeJsonStructure((JsonStructure)BatchJSONHelper.toJsonObjectBuilderWithLinks(jobExecution, stepExecs, urlRoot).build(), outputStream);
    }

    public static void writeJobExecutionLogLinks(JobExecutionLog jobExecutionLog, String urlRoot, OutputStream outputStream) throws IOException {
        BatchJSONHelper.writeJsonStructure((JsonStructure)BatchJSONHelper.convertJobExecutionLogLinksToJsonArray(Arrays.asList(jobExecutionLog), urlRoot).build(), outputStream);
    }

    public static void writeStepExecutionsList(List<WSStepThreadExecutionAggregate> stepExecAggregateList, String urlRoot, OutputStream outputStream) throws IOException {
        JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
        JsonArrayBuilder partitionBuilder = builderFactory.createArrayBuilder();
        JsonObjectBuilder topLevelObject = null;
        JsonObjectBuilder stepObjectLinks = null;
        if (!stepExecAggregateList.isEmpty()) {
            for (WSStepThreadExecutionAggregate stepExecAggregate : stepExecAggregateList) {
                topLevelObject = BatchJSONHelper.convertStepExecutionToJsonObjectInBasicFormatNoLink(stepExecAggregate.getTopLevelStepExecution(), urlRoot);
                stepObjectLinks = BatchJSONHelper.buildStepExecutionLinks(stepExecAggregate.getTopLevelStepExecution().getJobExecutionId(), stepExecAggregate.getTopLevelStepExecution().getJobInstanceId(), urlRoot);
                if (stepExecAggregate.getPartitionAggregate() != null) {
                    for (WSPartitionStepAggregate partitionStepAggregate : stepExecAggregate.getPartitionAggregate()) {
                        partitionBuilder.add(BatchJSONHelper.convertStepExecutionPartitionToJsonObject(partitionStepAggregate, urlRoot, partitionStepAggregate.getPartitionStepThread().getPartitionNumber()));
                    }
                } else {
                    for (WSPartitionStepThreadExecution partitionStepExec : stepExecAggregate.getPartitionLevelStepExecutions()) {
                        partitionBuilder.add(BatchJSONHelper.convertStepExecutionPartitionToJsonObject((StepExecution)partitionStepExec, urlRoot, partitionStepExec.getPartitionNumber()));
                    }
                }
                topLevelObject.add("partitions", partitionBuilder);
                arrayBuilder.add(topLevelObject);
            }
            arrayBuilder.add(stepObjectLinks);
        }
        BatchJSONHelper.writeJsonStructure((JsonStructure)arrayBuilder.build(), outputStream);
    }

    public static void writeJobExecutionList(List<WSJobExecution> jobExecutionList, Map<Long, List<WSStepThreadExecutionAggregate>> jobExecStepExecListMap, String urlRoot, OutputStream outputStream) throws IOException {
        BatchJSONHelper.writeJsonStructure((JsonStructure)BatchJSONHelper.toJsonArrayBuilderWithLinks(jobExecutionList, jobExecStepExecListMap, urlRoot).build(), outputStream);
    }

    public static void writeJobDefinitions(Set<String> jobNames, OutputStream outputStream) throws IOException {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
        for (String jobName : jobNames) {
            jsonArrayBuilder.add(jobName);
        }
        jsonObjBuilder.add("jobdefinitions", jsonArrayBuilder);
        BatchJSONHelper.writeJsonStructure((JsonStructure)jsonObjBuilder.build(), outputStream);
    }

    public static void writeJobInstanceLogLinks(JobInstanceLog jobInstanceLog, String urlRoot, OutputStream outputStream) throws IOException {
        JsonArrayBuilder links = BatchJSONHelper.convertJobExecutionLogLinksToJsonArray(jobInstanceLog.getJobExecutionLogs(), urlRoot);
        links.add(builderFactory.createObjectBuilder().add("rel", "joblog text").add("href", urlRoot + "jobinstances/" + jobInstanceLog.getJobInstance().getInstanceId() + "/joblogs?type=text")).add(builderFactory.createObjectBuilder().add("rel", "joblog zip").add("href", urlRoot + "jobinstances/" + jobInstanceLog.getJobInstance().getInstanceId() + "/joblogs?type=zip"));
        BatchJSONHelper.writeJsonStructure((JsonStructure)links.build(), outputStream);
    }

    public static JsonObjectBuilder toJsonObjectBuilder(WSPurgeResponse purgeResponse) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("instanceId", purgeResponse.getInstanceId()).add("purgeStatus", purgeResponse.getPurgeStatus().toString()).add("message", purgeResponse.getMessage());
        return jsonObjBuilder;
    }

    public static JsonObjectBuilder toJsonObjectBuilder(WSJobInstance jobInstance) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("jobName", StringUtils.firstNonNull(jobInstance.getJobName(), "")).add("instanceId", jobInstance.getInstanceId()).add("appName", StringUtils.firstNonNull(jobInstance.getAmcName(), "")).add("submitter", StringUtils.firstNonNull(jobInstance.getSubmitter(), "")).add("batchStatus", jobInstance.getBatchStatus() != null ? jobInstance.getBatchStatus().name() : "").add("jobXMLName", StringUtils.firstNonNull(jobInstance.getJobXMLName(), "")).add("instanceState", jobInstance.getInstanceState() != null ? jobInstance.getInstanceState().name() : "").add("lastUpdatedTime", BatchJSONHelper.formatDate(jobInstance.getLastUpdatedTime()));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder toJsonObjectBuilderWithLinks(WSJobInstance jobInstance, List<WSJobExecution> jobExecList, String urlRoot) {
        JsonObjectBuilder jsonObjBuilder = BatchJSONHelper.toJsonObjectBuilder(jobInstance);
        if (jobExecList != null && !jobExecList.isEmpty()) {
            String jesJobName = null;
            String jesJobID = null;
            Properties jobParams = jobExecList.get(0).getJobParameters();
            if (jobParams != null) {
                jesJobName = jobParams.getProperty("com.ibm.ws.batch.submitter.jobName");
                jesJobID = jobParams.getProperty("com.ibm.ws.batch.submitter.jobId");
            }
            if (jesJobName != null) {
                jsonObjBuilder.add("JESJobName", jesJobName);
            }
            if (jesJobID != null) {
                jsonObjBuilder.add("JESJobId", jesJobID);
            }
        }
        JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder().add(builderFactory.createObjectBuilder().add("rel", "self").add("href", urlRoot + "jobinstances/" + jobInstance.getInstanceId())).add(builderFactory.createObjectBuilder().add("rel", "job logs").add("href", urlRoot + "jobinstances/" + jobInstance.getInstanceId() + "/joblogs"));
        for (WSJobExecution jobExec : jobExecList != null ? jobExecList : new ArrayList()) {
            jsonArrayBuilder.add(builderFactory.createObjectBuilder().add("rel", "job execution").add("href", urlRoot + "jobinstances/" + jobInstance.getInstanceId() + "/jobexecutions/" + jobExec.getExecutionNumberForThisInstance()));
        }
        jsonObjBuilder.add("_links", jsonArrayBuilder);
        return jsonObjBuilder;
    }

    public static JsonObjectBuilder toJsonObjectBuilder(WSJobExecution jobExecution, List<WSStepThreadExecutionAggregate> stepExecs) {
        JsonObjectBuilder jsonObjBuilder = BatchJSONHelper.toJsonObjectBuilderInBasicFormat(jobExecution);
        JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
        for (WSStepThreadExecutionAggregate stepExec : stepExecs) {
            arrayBuilder.add(BatchJSONHelper.convertStepExecutionSummaryToJsonObject((StepExecution)stepExec.getTopLevelStepExecution(), jobExecution.getExecutionId()));
        }
        jsonObjBuilder.add("stepExecutions", arrayBuilder);
        return jsonObjBuilder;
    }

    public static JsonObjectBuilder toJsonObjectBuilderInBasicFormat(WSJobExecution jobExecution) {
        return BatchJSONHelper.buildExecutionJson(jobExecution, null);
    }

    private static JsonObjectBuilder toJsonObjectBuilderInBasicFormat(WSJobExecution jobExecution, String version) {
        return BatchJSONHelper.buildExecutionJson(jobExecution, version);
    }

    private static JsonObjectBuilder buildExecutionJson(WSJobExecution jobExecution, String version) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("jobName", jobExecution.getJobName()).add("executionId", jobExecution.getExecutionId()).add("instanceId", jobExecution.getInstanceId()).add("batchStatus", jobExecution.getBatchStatus().name()).add("exitStatus", StringUtils.firstNonNull(jobExecution.getExitStatus(), "")).add("createTime", BatchJSONHelper.formatDate(jobExecution.getCreateTime())).add("endTime", BatchJSONHelper.formatDate(jobExecution.getEndTime())).add("lastUpdatedTime", BatchJSONHelper.formatDate(jobExecution.getLastUpdatedTime())).add("startTime", BatchJSONHelper.formatDate(jobExecution.getStartTime())).add("jobParameters", (JsonValue)BatchJSONHelper.convertPropertiesToJsonObject(jobExecution.getJobParameters()));
        if (version == null) {
            jsonObjBuilder.add("restUrl", StringUtils.trimSuffix(jobExecution.getRestUrl(), "/"));
        } else {
            jsonObjBuilder.add("restUrl", StringUtils.trimSuffix(jobExecution.getRestUrl(), "/") + "/" + version);
        }
        jsonObjBuilder.add("serverId", jobExecution.getServerId()).add("logpath", StringUtils.firstNonNull(jobExecution.getLogpath(), ""));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder toJsonObjectBuilderWithLinks(WSJobExecution jobExecution, List<WSStepThreadExecutionAggregate> stepExecs, String urlRoot) {
        JsonObjectBuilder jsonObjBuilder = BatchJSONHelper.toJsonObjectBuilderInBasicFormat(jobExecution, BatchRequestUtil.getUrlVersion(urlRoot));
        JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
        for (WSStepThreadExecutionAggregate stepExec : stepExecs) {
            arrayBuilder.add(BatchJSONHelper.convertStepExecutionSummaryToJsonObjectWithLink((StepExecution)stepExec.getTopLevelStepExecution(), jobExecution.getExecutionId(), urlRoot));
        }
        jsonObjBuilder.add("stepExecutions", arrayBuilder);
        jsonObjBuilder.add("_links", BatchJSONHelper.buildJobExecutionLinksArray(jobExecution, urlRoot));
        return jsonObjBuilder;
    }

    protected static JsonArrayBuilder buildJobExecutionLinksArray(WSJobExecution jobExecution, String urlRoot) {
        return builderFactory.createArrayBuilder().add(builderFactory.createObjectBuilder().add("rel", "self").add("href", urlRoot + "jobexecutions/" + jobExecution.getExecutionId())).add(builderFactory.createObjectBuilder().add("rel", "job instance").add("href", urlRoot + "jobinstances/" + jobExecution.getInstanceId())).add(builderFactory.createObjectBuilder().add("rel", "step executions").add("href", urlRoot + "jobexecutions/" + jobExecution.getExecutionId() + "/stepexecutions")).add(builderFactory.createObjectBuilder().add("rel", "job logs").add("href", BatchRequestUtil.buildJoblogsUrl((JobExecution)jobExecution, urlRoot))).add(builderFactory.createObjectBuilder().add("rel", "stop url").add("href", BatchRequestUtil.buildStopUrl((JobExecution)jobExecution, urlRoot)));
    }

    protected static JsonObjectBuilder buildStepExecutionLinks(long jobExecutionId, long jobInstanceId, String urlRoot) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("_links", builderFactory.createArrayBuilder().add(builderFactory.createObjectBuilder().add("rel", "job execution").add("href", urlRoot + "jobexecutions/" + jobExecutionId)).add(builderFactory.createObjectBuilder().add("rel", "job instance").add("href", urlRoot + "jobinstances/" + jobInstanceId)));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder convertStepExecutionSummaryToJsonObjectWithLink(StepExecution stepExecution, Long jobExecutionId, String urlRoot) {
        JsonObjectBuilder jsonObjBuilder = BatchJSONHelper.convertStepExecutionSummaryToJsonObject(stepExecution, jobExecutionId);
        jsonObjBuilder.add("stepExecution", urlRoot + "jobexecutions/" + jobExecutionId + "/stepexecutions/" + stepExecution.getStepName());
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder convertStepExecutionSummaryToJsonObject(StepExecution stepExecution, Long jobExecutionId) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("stepExecutionId", stepExecution.getStepExecutionId()).add("stepName", stepExecution.getStepName()).add("batchStatus", stepExecution.getBatchStatus() == null ? "" : stepExecution.getBatchStatus().name()).add("exitStatus", StringUtils.firstNonNull(stepExecution.getExitStatus(), ""));
        return jsonObjBuilder;
    }

    protected static JsonArrayBuilder toJsonArrayBuilderWithLinks(List<WSJobExecution> jobExecutionList, Map<Long, List<WSStepThreadExecutionAggregate>> jobExecStepExecListMap, String urlRoot) {
        JsonArrayBuilder retMe = builderFactory.createArrayBuilder();
        for (WSJobExecution jobExecution : jobExecutionList) {
            retMe.add(BatchJSONHelper.toJsonObjectBuilderWithLinks(jobExecution, jobExecStepExecListMap.get(jobExecution.getExecutionId()), urlRoot));
        }
        return retMe;
    }

    public static JsonObjectBuilder convertStepExecutionToJsonObjectInBasicFormatNoLink(WSTopLevelStepExecution stepExecution, String urlRoot) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("stepExecutionId", stepExecution.getStepExecutionId()).add("stepName", stepExecution.getStepName()).add("executionId", stepExecution.getJobExecutionId()).add("instanceId", stepExecution.getJobInstanceId()).add("batchStatus", stepExecution.getBatchStatus().name()).add("startTime", BatchJSONHelper.formatDate(stepExecution.getStartTime())).add("endTime", BatchJSONHelper.formatDate(stepExecution.getEndTime())).add("exitStatus", StringUtils.firstNonNull(stepExecution.getExitStatus(), "")).add("metrics", BatchJSONHelper.convertStepMetricsToJsonObject(stepExecution.getMetrics()));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder convertStepExecutionPartitionToJsonObject(WSPartitionStepAggregate partitionAggregate, String urlRoot, int partNumber) {
        WSPartitionStepThreadExecution stepExecution = partitionAggregate.getPartitionStepThread();
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        String serverId = partitionAggregate.getRemotablePartition() == null ? "" : partitionAggregate.getRemotablePartition().getServerId();
        String restUrl = partitionAggregate.getRemotablePartition() == null ? "" : partitionAggregate.getRemotablePartition().getRestUrl();
        jsonObjBuilder.add("partitionNumber", partNumber).add("batchStatus", stepExecution.getBatchStatus().name()).add("startTime", BatchJSONHelper.formatDate(stepExecution.getStartTime())).add("endTime", BatchJSONHelper.formatDate(stepExecution.getEndTime())).add("exitStatus", StringUtils.firstNonNull(stepExecution.getExitStatus(), "")).add("restUrl", restUrl).add("serverId", serverId).add("metrics", BatchJSONHelper.convertStepMetricsToJsonObject(stepExecution.getMetrics()));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder convertStepExecutionPartitionToJsonObject(StepExecution stepExecution, String urlRoot, int partNumber) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("partitionNumber", partNumber).add("batchStatus", stepExecution.getBatchStatus().name()).add("startTime", BatchJSONHelper.formatDate(stepExecution.getStartTime())).add("endTime", BatchJSONHelper.formatDate(stepExecution.getEndTime())).add("exitStatus", StringUtils.firstNonNull(stepExecution.getExitStatus(), "")).add("metrics", BatchJSONHelper.convertStepMetricsToJsonObject(stepExecution.getMetrics()));
        return jsonObjBuilder;
    }

    protected static JsonObjectBuilder convertStepMetricsToJsonObject(Metric[] metrics) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        for (Metric metric : metrics) {
            String name = metric.getType().toString();
            String value = Long.valueOf(metric.getValue()).toString();
            jsonObjBuilder.add(name, value);
        }
        return jsonObjBuilder;
    }

    private static String formatDate(Date d) {
        return d != null ? BatchDateFormat.get().format(d) : "";
    }

    protected static JsonWriter createPrettyJsonWriter(OutputStream outputStream) {
        return prettyWriterFactory.createWriter(outputStream);
    }

    protected static Properties convertJsonObjectToProperties(JsonObject jsonObject) {
        Properties retMe = new Properties();
        if (jsonObject != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                retMe.setProperty((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
            }
        }
        return retMe;
    }

    protected static JsonObject convertPropertiesToJsonObject(Properties props) {
        JsonObjectBuilder builder = builderFactory.createObjectBuilder();
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                builder.add(key, props.getProperty(key));
            }
        }
        return builder.build();
    }

    protected static JsonArrayBuilder convertJobExecutionLogLinksToJsonArray(List<JobExecutionLog> jobExecutionLogs, String urlRoot) throws IOException {
        JsonArrayBuilder retMe = builderFactory.createArrayBuilder();
        String urlVersion = BatchRequestUtil.getUrlVersion(urlRoot);
        for (JobExecutionLog jobExecutionLog : jobExecutionLogs) {
            retMe.add(builderFactory.createObjectBuilder().add("rel", "joblog text").add("href", ((WSJobExecution)jobExecutionLog.getJobExecution()).getRestUrl() + "/" + urlVersion + "jobexecutions/" + jobExecutionLog.getExecutionId() + "/joblogs?type=text"));
            retMe.add(builderFactory.createObjectBuilder().add("rel", "joblog zip").add("href", ((WSJobExecution)jobExecutionLog.getJobExecution()).getRestUrl() + "/" + urlVersion + "jobexecutions/" + jobExecutionLog.getExecutionId() + "/joblogs?type=zip"));
            for (String relativePath : jobExecutionLog.getRelativePaths()) {
                relativePath = StringUtils.normalizePath(relativePath);
                retMe.add(builderFactory.createObjectBuilder().add("rel", "joblog part text").add("href", ((WSJobExecution)jobExecutionLog.getJobExecution()).getRestUrl() + "/" + urlVersion + "jobexecutions/" + jobExecutionLog.getExecutionId() + "/joblogs?part=" + relativePath + "&type=text"));
                retMe.add(builderFactory.createObjectBuilder().add("rel", "joblog part zip").add("href", ((WSJobExecution)jobExecutionLog.getJobExecution()).getRestUrl() + "/" + urlVersion + "jobexecutions/" + jobExecutionLog.getExecutionId() + "/joblogs?part=" + relativePath + "&type=zip"));
            }
        }
        return retMe;
    }

    public static Properties mergeProperties(Properties ... properties) {
        Properties retMe = new Properties();
        for (Properties props : properties != null ? properties : new Properties[]{}) {
            if (props == null) continue;
            retMe.putAll((Map<?, ?>)props);
        }
        return retMe;
    }

    public static JsonObjectBuilder convertPartitionToJsonObjectBuilderForEvent(int partitionNumber, BatchStatus batchStatus, String exitStatus, String stepName, long topLevelInstanceId, long topLevelExecutionId, long topLevelStepExecutionId) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("partitionNumber", partitionNumber).add("batchStatus", batchStatus.name()).add("exitStatus", StringUtils.firstNonNull(exitStatus, "")).add("stepName", stepName).add("executionId", topLevelExecutionId).add("instanceId", topLevelInstanceId).add("stepExecutionId", topLevelStepExecutionId);
        return jsonObjBuilder;
    }

    public static JsonObjectBuilder convertCheckpointToJsonObjectBuilderForEvent(String stepName, long jobInstanceId, long jobExecutionId, long stepExecutionId) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("stepName", stepName).add("executionId", jobExecutionId).add("instanceId", jobInstanceId).add("stepExecutionId", stepExecutionId);
        return jsonObjBuilder;
    }

    public static JsonObjectBuilder convertSplitFlowToJsonObjectBuilderForEvent(String splitName, String flowName, long jobInstanceId, long jobExecutionId) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("splitName", splitName).add("flowName", flowName).add("executionId", jobExecutionId).add("instanceId", jobInstanceId);
        return jsonObjBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public static JsonObjectBuilder convertJobLogToJsonObjectBuilderForEvent(long jobInstanceId, long jobExecutionId, String appName, int partNumber, Integer partitionNumber, String stepName, String splitName, String flowName, boolean finalLog, String logContent) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        jsonObjBuilder.add("executionId", jobExecutionId).add("instanceId", jobInstanceId).add("appName", appName).add("partNumber", partNumber).add("finalLog", finalLog);
        if (partitionNumber != null) {
            jsonObjBuilder.add("partitionNumber", partitionNumber.intValue()).add("stepName", stepName);
        }
        if (splitName != null) {
            jsonObjBuilder.add("splitName", splitName).add("flowName", flowName);
        }
        JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(logContent));
        String line = null;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                arrayBuilder.add(line);
            }
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.rest.utils.BatchJSONHelper", (String)"871", null, (Object[])new Object[]{jobInstanceId, jobExecutionId, appName, partNumber, partitionNumber, stepName, splitName, flowName, finalLog, logContent});
            throw new IllegalStateException((Throwable)e);
        }
        jsonObjBuilder.add("contents", arrayBuilder);
        return jsonObjBuilder;
    }

    public static void buildAndWritePurgeJsonObject(ArrayList<WSPurgeResponse> responseList, OutputStream outputStream) {
        JsonObjectBuilder jsonObjBuilder = builderFactory.createObjectBuilder();
        JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
        for (int i = 0; i < responseList.size(); ++i) {
            WSPurgeResponse purgeResponse = responseList.get(i);
            jsonObjBuilder.add("instanceId", purgeResponse.getInstanceId());
            jsonObjBuilder.add("purgeStatus", purgeResponse.getPurgeStatus().name());
            jsonObjBuilder.add("message", purgeResponse.getMessage());
            jsonObjBuilder.add("redirectUrl", purgeResponse.getRedirectURL() != null ? purgeResponse.getRedirectURL() : "");
            jsonArrayBuilder.add(jsonObjBuilder);
        }
        BatchJSONHelper.writeJsonStructure((JsonStructure)jsonArrayBuilder.build(), outputStream);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.utils.BatchJSONHelper", BatchJSONHelper.class, (String)"wsbatch", null);
        builderFactory = Json.createBuilderFactory(null);
        readerFactory = Json.createReaderFactory(null);
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>(1);
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        prettyWriterFactory = Json.createWriterFactory(writerConfig);
    }
}

