/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connectionpool.monitor;

import com.ibm.websphere.jca.pmi.JCAPMIHelper;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtExceptionExit;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.connectionpool.monitor.ConnectionPoolStats;
import com.ibm.ws.connectionpool.monitor.LegacyMonitor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import java.util.HashMap;

@Monitor(group={"ConnectionPool"})
public class ConnectionPoolMonitor
extends StatisticActions {
    @PublishedMetric
    public MeterCollection<ConnectionPoolStats> connectionPoolCountByName = new MeterCollection("ConnectionPool", (Object)this);
    private static final TraceComponent tc = Tr.register(ConnectionPoolMonitor.class, (String)"ConnectionPoolMonitor");
    private final ThreadLocal<Long> tlocalforwtTime = new ThreadLocal();
    private final ThreadLocal<Long> tlocalforiuTime = new ThreadLocal();
    private final ThreadLocal<Integer> tlocalforiumconThread = new ThreadLocal();
    private final ThreadLocal<Boolean> tlocalfpsize = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return false;
        }
    };
    private static HashMap<String, ConnectionPoolStats> CPStatsMap = new HashMap();
    private static final String template = "/com/ibm/ws/connectionpool/monitor/xml/j2cModule.xml";
    private StatsGroup grp;
    private final HashMap<String, LegacyMonitor> legacyPMIMap = new HashMap();

    public ConnectionPoolMonitor() {
        try {
            if (StatsFactory.isPMIEnabled()) {
                this.grp = StatsFactory.createStatsGroup((String)"ConnectionPool", (String)template, null, (StatisticActions)this);
            }
        }
        catch (StatsFactoryException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ConnectionPool Module is not registered with PMI", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"ConnectionPoolMonitor");
        }
    }

    public synchronized ConnectionPoolStats initializeConnectionPoolStats(String dsName) {
        ConnectionPoolStats cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(dsName);
        if (cStats == null) {
            cStats = new ConnectionPoolStats();
            this.connectionPoolCountByName.put(dsName, (Object)cStats);
            if (StatsFactory.isPMIEnabled()) {
                this.legacyPMIMap.put(dsName, new LegacyMonitor(dsName, this.grp));
                CPStatsMap.put(dsName, cStats);
            }
            return cStats;
        }
        return cStats;
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.FreePool", method="createManagedConnectionWithMCWrapper")
    public void incCreateCount(@This Object fpObject) {
        try {
            ConnectionPoolStats cStats;
            String JNDIName;
            JCAPMIHelper fpobj = (JCAPMIHelper)fpObject;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"incCreateCount", (Object[])new Object[0]);
            }
            if ((JNDIName = fpobj.getJNDIName()) == null) {
                JNDIName = fpobj.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incCreateCount");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
                cStats = this.initializeConnectionPoolStats(JNDIName);
                cStats.updateMaxConnectionsLimit(fpobj.getMaximumConnectionValue());
            }
            cStats.incCreateCount();
            cStats.incManagedConnectionCount();
            cStats.incFreeConnectionCount();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incCreateCount");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeAtExceptionExit
    @ProbeSite(clazz="com.ibm.ejs.j2c.MCWrapper", method="destroy")
    public void incDestroyCount(@This Object ob) {
        try {
            ConnectionPoolStats cStats;
            JCAPMIHelper mObject;
            String JNDIName;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"incDestroyCount", (Object[])new Object[0]);
            }
            if ((JNDIName = (mObject = (JCAPMIHelper)ob).getJNDIName()) == null) {
                JNDIName = mObject.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided so J2C returns us a null.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incDestroyCount");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incDestroyCount");
                }
                return;
            }
            cStats.incDestroyCount();
            cStats.decManagedConnectionCount();
            cStats.decFreeConnectionCount();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incDestroyCount");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.MCWrapper", method="incrementHandleCount")
    public void incConnectionHandleCount(@This Object ob) {
        try {
            ConnectionPoolStats cStats;
            JCAPMIHelper mObject;
            String JNDIName;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"incConnectionHandleCount", (Object[])new Object[0]);
            }
            if ((JNDIName = (mObject = (JCAPMIHelper)ob).getJNDIName()) == null) {
                JNDIName = mObject.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incConnectionHandleCount");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
                cStats = this.initializeConnectionPoolStats(JNDIName);
            }
            cStats.incConnectionHandleCount();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incConnectionHandleCount");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.MCWrapper", method="decrementHandleCount")
    public void decConnectionHandleCount(@This Object ob) {
        try {
            ConnectionPoolStats cStats;
            JCAPMIHelper mObject;
            String JNDIName;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"decConnectionHandleCount", (Object[])new Object[0]);
            }
            if ((JNDIName = (mObject = (JCAPMIHelper)ob).getJNDIName()) == null) {
                JNDIName = mObject.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"decConnectionHandleCount");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"decConnectionHandleCount");
                }
                return;
            }
            cStats.decConnectionHandleCount();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"decConnectionHandleCount");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ejs.j2c.FreePool", method="queueRequest")
    public void waitTimeEntry() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"waitTimeEntry", (Object[])new Object[0]);
        }
        this.tlocalforwtTime.set(System.currentTimeMillis());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitTimeEntry");
        }
    }

    @ProbeAtReturn
    @ProbeAtExceptionExit
    @ProbeSite(clazz="com.ibm.ejs.j2c.FreePool", method="queueRequest")
    public void waitTimeExit(@This Object wtobj) {
        ConnectionPoolStats cStats;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"waitTimeExit", (Object[])new Object[0]);
        }
        long elapsed = System.currentTimeMillis() - this.tlocalforwtTime.get();
        JCAPMIHelper mObject = (JCAPMIHelper)wtobj;
        String JNDIName = mObject.getJNDIName();
        if (JNDIName == null) {
            JNDIName = mObject.getUniqueId();
        }
        if (JNDIName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"waitTimeExit");
            }
            return;
        }
        if (JNDIName.contains(":")) {
            JNDIName = JNDIName.replace(":", "-");
        }
        if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
            cStats = this.initializeConnectionPoolStats(JNDIName);
        }
        cStats.updateWaitTime(elapsed);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitTimeExit");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ejs.j2c.MCWrapper", method="isNotAlreadyFreeActive")
    public void incFreePoolSize(@This Object ob) {
        try {
            ConnectionPoolStats cStats;
            JCAPMIHelper mObject;
            String JNDIName;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"incFreePoolSize", (Object[])new Object[0]);
            }
            if ((JNDIName = (mObject = (JCAPMIHelper)ob).getJNDIName()) == null) {
                JNDIName = mObject.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incFreePoolSize");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Do not create new ConnectionPooLStas  at this point if w dnt get ConnectionPoolStats as we are sure that by this time CStats should be created", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"incFreePoolSize");
                }
                return;
            }
            Long iuTime = this.tlocalforiuTime.get();
            if (iuTime != null) {
                long elapsed = System.currentTimeMillis() - this.tlocalforiuTime.get();
                cStats.updateInUseTime(elapsed);
                if (this.tlocalforiumconThread.get() < 2) {
                    this.tlocalforiuTime.set(null);
                } else {
                    this.tlocalforiumconThread.set(this.tlocalforiumconThread.get() - 1);
                }
            }
            cStats.incFreeConnectionCount();
            this.tlocalfpsize.set(true);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"incFreePoolSize");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.MCWrapper", method="markInUse")
    public void decFreePoolSize(@This Object McObj) {
        try {
            JCAPMIHelper mcwrapperobj;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"decFreePoolSize", (Object[])new Object[0]);
            }
            if (!(mcwrapperobj = (JCAPMIHelper)McObj).getParkedValue()) {
                Long iuTime;
                String JNDIName = mcwrapperobj.getJNDIName();
                if (JNDIName == null) {
                    JNDIName = mcwrapperobj.getUniqueId();
                }
                if (JNDIName == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"decFreePoolSize");
                    }
                    return;
                }
                if (JNDIName.contains(":")) {
                    JNDIName = JNDIName.replace(":", "-");
                }
                if ((iuTime = this.tlocalforiuTime.get()) == null) {
                    this.tlocalforiuTime.set(System.currentTimeMillis());
                    this.tlocalforiumconThread.set(1);
                } else {
                    this.tlocalforiumconThread.set(this.tlocalforiumconThread.get() + 1);
                }
                ConnectionPoolStats cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName);
                if (cStats == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"decFreePoolSize");
                    }
                    return;
                }
                cStats.decFreeConnectionCount();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"decFreePoolSize");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.PoolManager", method="vetoableChange")
    public void updatePMIMaxConnectionsIfNeeded(@This Object fpObject) {
        try {
            ConnectionPoolStats cStats;
            String JNDIName;
            JCAPMIHelper fpobj = (JCAPMIHelper)fpObject;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updatePMIMaxConnectionsIfNeeded", (Object[])new Object[0]);
            }
            if ((JNDIName = fpobj.getJNDIName()) == null) {
                JNDIName = fpobj.getUniqueId();
            }
            if (JNDIName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updatePMIMaxConnectionsIfNeeded");
                }
                return;
            }
            if (JNDIName.contains(":")) {
                JNDIName = JNDIName.replace(":", "-");
            }
            if ((cStats = (ConnectionPoolStats)this.connectionPoolCountByName.get(JNDIName)) != null) {
                int maxConnections = fpobj.getMaximumConnectionValue();
                long currentPMIMaxConnections = cStats.getMaxConnectionsLimit();
                if (currentPMIMaxConnections != (long)maxConnections) {
                    cStats.updateMaxConnectionsLimit(maxConnections);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Did not update pmi maximum connections", (Object[])new Object[0]);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updatePMIMaxConnectionsIfNeeded");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ejs.j2c.PoolManager", method="serverShutDown")
    public void removeDataSource(@This Object obj) {
        JCAPMIHelper fpObj = (JCAPMIHelper)obj;
        String JNDIName = fpObj.getJNDIName();
        if (JNDIName == null) {
            JNDIName = fpObj.getUniqueId();
        }
        if (JNDIName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JNDI Name returned is null this will only come when DS is created but no JNDI name is provided.We Should not handle this case", (Object[])new Object[0]);
            }
            return;
        }
        if (JNDIName.contains(":")) {
            JNDIName = JNDIName.replace(":", "-");
        }
        this.connectionPoolCountByName.remove(JNDIName);
        if (StatsFactory.isPMIEnabled()) {
            this.legacyPMIMap.remove(fpObj.getUniqueId()).removeSInstance();
        }
    }

    static ConnectionPoolStats getConnectionPoolOB(String dsName) {
        return CPStatsMap.get(dsName);
    }
}

