/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.metatype;

import com.ibm.websphere.metatype.MetaTypeFactory;
import com.ibm.websphere.metatype.ObjectClassDefinitionProperties;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.Utils;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeAd;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

@Trivial
public class MetatypeOcd
implements Comparator<MetatypeAd> {
    private String id;
    private String ibmAlias;
    private String ibmChildAlias;
    private String ibmParentPid;
    private String ibmExtendsAlias;
    private String ibmExtends;
    private String name;
    private String description;
    private List<MetatypeAd> metatypeAds = new LinkedList<MetatypeAd>();
    private Metatype parent;
    private final MetaTypeFactory metaTypeProviderFactory;

    public MetatypeOcd(MetaTypeFactory mtpService) {
        this.metaTypeProviderFactory = mtpService;
    }

    @Override
    public int compare(MetatypeAd ad1, MetatypeAd ad2) {
        return ad1.getID().toLowerCase().compareTo(ad2.getID().toLowerCase());
    }

    public void sort(boolean sortByGroup) {
        if (sortByGroup && this.parent != null) {
            HashMap<String, LinkedList<MetatypeAd>> adsByGroup = new HashMap<String, LinkedList<MetatypeAd>>();
            for (MetatypeAd metatypeAd : this.metatypeAds) {
                LinkedList<MetatypeAd> list;
                String group = metatypeAd.getIbmUigroup();
                if (group == null) {
                    group = "(default)";
                }
                if ((list = (LinkedList<MetatypeAd>)adsByGroup.get(group)) == null) {
                    list = new LinkedList<MetatypeAd>();
                    adsByGroup.put(group, list);
                }
                list.add(metatypeAd);
            }
            for (Map.Entry entry : adsByGroup.entrySet()) {
                Collections.sort((List)entry.getValue(), this);
            }
            this.metatypeAds.clear();
            List<String> orderedGroupNames = this.parent.getIbmuiGroupOrder();
            if (orderedGroupNames != null && !orderedGroupNames.isEmpty()) {
                for (String groupName : orderedGroupNames) {
                    List group = (List)adsByGroup.remove(groupName);
                    if (group == null) continue;
                    this.metatypeAds.addAll(group);
                }
            } else {
                this.metatypeAds.addAll((Collection)adsByGroup.remove("(default)"));
                for (List adGroup : adsByGroup.values()) {
                    this.metatypeAds.addAll(adGroup);
                }
            }
        } else {
            Collections.sort(this.metatypeAds, this);
        }
    }

    public void setParentMetatype(Metatype parent) {
        this.parent = parent;
    }

    @XmlAttribute(name="id")
    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(name="alias", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setAlias(String ibmAlias) {
        this.ibmAlias = ibmAlias;
    }

    @XmlAttribute(name="childAlias", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setChildAlias(String ibmChildAlias) {
        this.ibmChildAlias = ibmChildAlias;
    }

    @XmlAttribute(name="parentPid", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setParentPID(String ibmParentPid) {
        this.ibmParentPid = ibmParentPid;
    }

    @XmlAttribute(name="extendsAlias", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setExtendsAlias(String ibmExtendsAlias) {
        this.ibmExtendsAlias = ibmExtendsAlias;
    }

    @XmlAttribute(name="extends", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setExtends(String ibmExtends) {
        this.ibmExtends = ibmExtends;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="AD")
    public void setMetatypeAds(List<MetatypeAd> metatypeAds) {
        this.metatypeAds = metatypeAds;
    }

    public void addInternalMetatypeAd(String id, String value) {
        MetatypeAd ad = new MetatypeAd(this.metaTypeProviderFactory);
        ad.setId(id);
        ad.setType("String");
        ad.setDefault(value);
        ad.setFinal(true);
        ad.setName("internal");
        ad.setDescription("internal use only");
        this.addMetatypeAd(ad);
    }

    public boolean addMetatypeAd(MetatypeAd metatypeAd) {
        if (this.metatypeAds == null) {
            this.metatypeAds = new LinkedList<MetatypeAd>();
        }
        for (MetatypeAd ad : this.metatypeAds) {
            if (!ad.getID().equals(metatypeAd.getID())) continue;
            return false;
        }
        this.metatypeAds.add(metatypeAd);
        return true;
    }

    public String getId() {
        return this.id;
    }

    public ObjectClassDefinition getObjectClassDefinition() {
        ObjectClassDefinitionProperties props = new ObjectClassDefinitionProperties(this.id);
        props.setAlias(this.ibmAlias);
        props.setChildalias(this.ibmChildAlias);
        props.setParentPID(this.ibmParentPid);
        props.setExtendsAlias(this.ibmExtendsAlias);
        props.setExtends(this.ibmExtends);
        props.setName(this.name);
        props.setDescription(this.description);
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        for (MetatypeAd ad : this.getMetatypeAds()) {
            attributes.add(ad.getAttributeDefinition());
        }
        return this.metaTypeProviderFactory.createObjectClassDefinition(props, attributes, Collections.emptyList());
    }

    public List<MetatypeAd> getMetatypeAds() {
        return this.metatypeAds;
    }

    public MetatypeAd getMetatypeAdByID(String id) {
        for (MetatypeAd ad : this.metatypeAds) {
            if (!ad.getID().equals(id)) continue;
            return ad;
        }
        return null;
    }

    public String toString() {
        return "MetatypeOcd{id='" + this.id + "'}";
    }

    public String toMetatypeString(int padSpaces) {
        String buffer = Utils.getSpaceBufferString(padSpaces);
        StringBuilder sb = new StringBuilder(buffer).append("<OCD ");
        sb.append("id=\"").append(this.id).append("\" ");
        if (this.ibmAlias != null) {
            sb.append("ibm:alias=\"").append(this.ibmAlias).append("\" ");
        }
        if (this.ibmChildAlias != null) {
            sb.append("ibm:childAlias=\"").append(this.ibmChildAlias).append("\" ");
        }
        if (this.ibmParentPid != null) {
            sb.append("ibm:parentPid=\"").append(this.ibmParentPid).append("\" ");
        }
        if (this.ibmExtendsAlias != null) {
            sb.append("ibm:extendsAlias=\"").append(this.ibmExtendsAlias).append("\" ");
        }
        if (this.ibmExtends != null) {
            sb.append("ibm:extends=\"").append(this.ibmExtends).append("\" ");
        }
        if (this.name != null) {
            sb.append("name=\"").append(this.name).append("\" ");
        }
        if (this.description != null) {
            sb.append("description=\"").append(this.description).append("\" ");
        }
        sb.append(">" + Utils.NEW_LINE);
        for (MetatypeAd ad : this.metatypeAds) {
            if (ad == null) continue;
            sb.append(ad.toMetatypeString(padSpaces + 1) + Utils.NEW_LINE);
        }
        sb.append(buffer).append("</OCD>");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChildAlias() {
        return this.ibmChildAlias;
    }

    public String getExtendsAlias() {
        return this.ibmExtendsAlias;
    }

    public String getAlias() {
        return this.ibmAlias;
    }
}

