/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.failover.ReplicatableImpl;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.servlets.LstNotificationType;
import com.ibm.ws.sip.container.timer.AppSessionTimerListener;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.timer.ExpirationTimer;
import com.ibm.ws.sip.container.timer.ServletTimerImpl;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class SipApplicationSessionImpl
extends ReplicatableImpl
implements SipApplicationSession {
    static final long serialVersionUID = 7746526996100284291L;
    private static final int NO_EXPIRATION = -1;
    private static final transient LogMgr c_logger = Log.get(SipApplicationSessionImpl.class);
    private long m_expires = 180000L;
    private transient AppSessionTimerListener m_expiresTimer;
    private long m_lastAccessedTime;
    private long m_creationTime;
    private transient List<TransactionUserWrapper> m_transactionUsers = null;
    private Vector<Integer> m_timersIds;
    private LinkedHashSet<String> m_attributes;
    private transient SipAppDesc m_appDescriptor;
    private String _applicationName;
    private int m_nextTimerId = 1;
    private boolean m_isValid = true;
    private boolean m_applicationIsAlive = false;
    public static final String ENCODED_APP_SESSION_ID = "ibmappid";
    private transient boolean m_duringInvalidate = false;
    private transient int m_extractedAppSessionSeqCounter = -1;
    private boolean m_invalidateWhenReady = false;
    private String m_sessionKeyBaseKey = null;
    private Object _synchronizer;
    private Object _serviceSynchronizer;

    SipApplicationSessionImpl() {
    }

    SipApplicationSessionImpl(String sessionID) {
        this.m_lastAccessedTime = this.m_creationTime = System.currentTimeMillis();
        String srvrid = sessionID.substring(0, sessionID.indexOf("_"));
        this.setSharedId(sessionID);
        this.setServerID(srvrid);
        PerformanceMgr.getInstance().incrementNotReplicatedSipAppSessionsCounter();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "SipApplicationSessionImpl", "New ApplicationSession id = " + this.getId());
        }
    }

    public void addToApplicationSessionsTable() {
        SessionRepository.getInstance().put(this);
    }

    public void createSipAppTimer(long delay, ExpirationTimer expTimer) {
        this.m_expiresTimer = new AppSessionTimerListener(this, expTimer);
        if (expTimer == null) {
            this.m_expiresTimer.schedule(false, delay);
        }
    }

    @Override
    public long getCreationTime() {
        this.checkIsSessionValid();
        return this.m_creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.m_lastAccessedTime;
    }

    public void setLastAccessedTime() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "setLastAccessedTime");
        }
        this.m_lastAccessedTime = System.currentTimeMillis();
        this.store();
    }

    public synchronized int getNextTimerId() {
        return this.m_nextTimerId++;
    }

    public void setExpirationFromTU(long expirationTime) {
        this.m_expires = expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExpires(int deltaMinutes) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setExpires", "deltaMinutes = " + deltaMinutes);
            }
            this.checkIsSessionValid();
            if (deltaMinutes < 1) {
                if (this.m_expiresTimer != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "setExpires", "cancel the existing epiration timer - session will not expired" + this);
                    }
                    this.m_expiresTimer.cancel();
                    this.m_expires = -1L;
                    this.m_expiresTimer = null;
                    deltaMinutes = Integer.MAX_VALUE;
                }
            } else {
                long deltaMilis = deltaMinutes * 1000 * 60;
                long expires = System.currentTimeMillis() + deltaMilis;
                if (this.m_expiresTimer == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer buffer = new StringBuffer(96);
                        buffer.append("AppSessionId: ");
                        buffer.append(this.getId());
                        buffer.append(" Prev m_expires was = ");
                        buffer.append(this.m_expires);
                        buffer.append(" Timer was set by application for = ");
                        buffer.append(deltaMinutes);
                        buffer.append(" minutes...");
                        c_logger.traceDebug(this, "setExpires", buffer.toString());
                    }
                    this.m_expires = expires;
                    this.createSipAppTimer(deltaMilis, null);
                } else {
                    boolean reschedule = expires < this.m_expires;
                    this.m_expires = expires;
                    if (reschedule) {
                        this.m_expiresTimer.rescheduleAppSessionTimer();
                    }
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "setExpires", deltaMinutes);
            }
            this.store();
            return deltaMinutes;
        }
    }

    private void destroyAllTimers() {
        if (this.m_timersIds == null || this.m_timersIds.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "destroyAllTimers", "No timers were found for SipApplicationSession Id = " + this.getId());
            }
            return;
        }
        Vector timersClone = (Vector)this.m_timersIds.clone();
        for (int i = 0; i < timersClone.size(); ++i) {
            Integer timerId = (Integer)timersClone.get(i);
            ServletTimerImpl timer = (ServletTimerImpl)SessionRepository.getInstance().getTimer(this.getId(), timerId);
            if (timer == null) continue;
            timer.cancel();
        }
        if (this.m_timersIds.size() != 0 && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "destroyAllTimers", "SipApplicationSession Timer queue wasn't fully cleaned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllSessions() {
        LinkedList<String> tuIdList;
        ArrayList<TUKey> tuKeyList;
        block18: {
            TransactionUserWrapper[] transactionUsers;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "destroyAllSessions");
            }
            if (this.m_transactionUsers == null) {
                return;
            }
            List<TransactionUserWrapper> list = this.m_transactionUsers;
            synchronized (list) {
                transactionUsers = this.copyTransactionUsers();
                this.m_transactionUsers.clear();
            }
            if (transactionUsers == null) {
                return;
            }
            int nTransactionUsers = transactionUsers.length;
            tuKeyList = new ArrayList<TUKey>(nTransactionUsers);
            tuIdList = new LinkedList<String>();
            try {
                for (int iTransactionUsers = 0; iTransactionUsers < nTransactionUsers; ++iTransactionUsers) {
                    TransactionUserWrapper tu = transactionUsers[iTransactionUsers];
                    if (tu.isWaitingForPendingMessage()) {
                        if (!c_logger.isTraceDebugEnabled()) continue;
                        c_logger.traceDebug(this, "destroyAllSessions", "Session belongs to an Encode URI/Key base targeting message that wasn't processed, skipping invalidation till we process the message.");
                        continue;
                    }
                    if (tu.isTransactionUserInvalidated()) {
                        tuIdList.add(tu.getId());
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "destroyAllSessions", "TranscationUser did not have tuImpl object, will be removed accroding to id, id=" + tu.getId());
                        }
                    } else {
                        TUKey key = tu.resetTempTUKeyValues();
                        if (nTransactionUsers > 1) {
                            tuKeyList.add(key.clone());
                        } else {
                            tuKeyList.add(key);
                        }
                    }
                    tu.invalidateTU(false, true);
                    tu.applicationSessionIvalidated(this);
                }
            }
            catch (CloneNotSupportedException e2) {
                if (!c_logger.isErrorEnabled()) break block18;
                c_logger.error("error.exception", "Create", null, (Throwable)e2);
            }
        }
        for (TUKey key : tuKeyList) {
            SessionRepository.getInstance().removeTuWrapper(key, true);
        }
        for (String id : tuIdList) {
            SessionRepository.getInstance().removeTuWrapper(id);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "destroyAllSessions");
        }
    }

    private TransactionUserWrapper[] copyTransactionUsers() {
        if (this.m_transactionUsers == null) {
            return null;
        }
        int nTransactionUsers = this.m_transactionUsers.size();
        if (nTransactionUsers == 0) {
            return null;
        }
        TransactionUserWrapper[] transactionUsers = new TransactionUserWrapper[nTransactionUsers];
        for (int iTransactionUsers = 0; iTransactionUsers < nTransactionUsers; ++iTransactionUsers) {
            TransactionUserWrapper tu;
            transactionUsers[iTransactionUsers] = tu = this.m_transactionUsers.get(iTransactionUsers);
        }
        return transactionUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            block20: {
                block19: {
                    block18: {
                        PerformanceMgr perfMgr;
                        if (this.m_duringInvalidate) {
                            this.checkIsSessionValid();
                            return;
                        }
                        this.m_duringInvalidate = true;
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "invalidate", "AppSessionId: " + this.getId());
                        }
                        if (this.m_expiresTimer != null) {
                            this.m_expiresTimer.cancel();
                        }
                        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
                            perfMgr.sipAppSessionDestroyed(this.m_appDescriptor.getApplicationName(), this.m_appDescriptor.getAppIndexForPmi());
                            perfMgr.decrementNotReplicatedSipAppSessionsCounter();
                        }
                        this.m_applicationIsAlive = false;
                        try {
                            this.sendAppSessionNotification(LstNotificationType.APPLICATION_DESTROYED);
                        }
                        catch (Throwable t) {
                            if (!c_logger.isErrorEnabled()) break block18;
                            c_logger.error("invalidate", "Destroy", "Exception while calling application", t);
                        }
                    }
                    try {
                        this.destroyAllTimers();
                    }
                    catch (Throwable t) {
                        if (!c_logger.isErrorEnabled()) break block19;
                        c_logger.error("invalidate", "Destroy", "Exception while removing timers", t);
                    }
                }
                try {
                    this.destroyAllSessions();
                }
                catch (Throwable t) {
                    if (!c_logger.isErrorEnabled()) break block20;
                    c_logger.error("invalidate", "Destroy", "Exception while invalidating sessions", t);
                }
            }
            if (this.m_sessionKeyBaseKey != null) {
                SessionRepository.getInstance().removeKeyBaseAppSession(this.m_sessionKeyBaseKey);
            }
            this.removeFromStorage();
            this.m_attributes = null;
            this.m_isValid = false;
            if (SipContainer.getInstance().isInQuiesce()) {
                List<SipApplicationSessionImpl> totalAppSessions = SessionRepository.getInstance().getAllAppSessions();
                if (totalAppSessions.isEmpty() && c_logger.isInfoEnabled()) {
                    c_logger.info("info.sip.container.quiesce.ended", null);
                }
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer b = new StringBuffer(64);
                    b.append("Sip Application Session Invalidated, Id: ");
                    b.append(this.getId());
                    b.append(" , ");
                    b.append(this);
                    c_logger.traceDebug(this, "invalidate", b.toString());
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "invalidate", "AppSessionId: " + this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttributesFromStorage() {
        LinkedHashSet<String> attr = this.m_attributes;
        if (attr == null || attr.isEmpty()) {
            return;
        }
        LinkedHashSet<String> linkedHashSet = attr;
        synchronized (linkedHashSet) {
            Object[] attrArr = attr.toArray();
            for (int i = 0; i < attrArr.length; ++i) {
                String name = (String)attrArr[i];
                this.removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IBMSipSession> getSessions() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            this.checkIsSessionValid();
            List<IBMSipSession> allSessions = this.getAllSIPSessions();
            return allSessions.iterator();
        }
    }

    protected List<IBMSipSession> getAllSIPSessions() {
        return this.getAllSIPSessions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IBMSipSession> getAllSIPSessions(boolean create) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (this.m_transactionUsers == null || this.m_transactionUsers.size() == 0) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getAllSIPSessions", "no SIP session found. return empty list.");
                }
                return Collections.EMPTY_LIST;
            }
            int size = this.m_transactionUsers.size();
            ArrayList<IBMSipSession> result = new ArrayList<IBMSipSession>(size);
            List<TransactionUserWrapper> list = this.m_transactionUsers;
            synchronized (list) {
                TransactionUserWrapper tu = null;
                for (int i = 0; i < size; ++i) {
                    tu = this.m_transactionUsers.get(i);
                    result.addAll(tu.getAllSipSessions(create));
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAllSIPSessions", "found SIP sessions. count:" + result.size());
            }
            return result;
        }
    }

    @Override
    public Iterator<IBMSipSession> getSessions(String protocol) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry("SipApplicationSessionImpl", "getSessions(" + protocol);
        }
        this.checkIsSessionValid();
        if (protocol.equalsIgnoreCase("SIP")) {
            return this.getAllSIPSessions().iterator();
        }
        if (protocol.equalsIgnoreCase("HTTP")) {
            return Collections.EMPTY_MAP.keySet().iterator();
        }
        SipAppDesc sipAppDesc = this.getAppDescriptor();
        if (sipAppDesc != null && !sipAppDesc.isJSR289Application()) {
            return Collections.EMPTY_MAP.keySet().iterator();
        }
        throw new IllegalArgumentException("Unsupported protocol type " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SipSession getSipSession(String id) {
        this.checkIsSessionValid();
        if (id == null) {
            throw new NullPointerException("The SipSession ID is null");
        }
        IBMSipSession result = null;
        if (this.m_transactionUsers == null || this.m_transactionUsers.size() == 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAllSIPSessions", "no SIP session found.");
            }
            new NullPointerException("No Session found for ID = " + id);
        } else {
            int size = this.m_transactionUsers.size();
            List<TransactionUserWrapper> list = this.m_transactionUsers;
            synchronized (list) {
                TransactionUserWrapper tu = null;
                List<IBMSipSession> allSessions = null;
                for (int i = 0; i < size && result == null; ++i) {
                    tu = this.m_transactionUsers.get(i);
                    allSessions = tu.getAllSipSessions();
                    if (allSessions == null || allSessions.size() == 0) continue;
                    for (IBMSipSession session : allSessions) {
                        if (!session.getId().equals(id)) continue;
                        result = session;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void encodeURI(URI uri) {
        this.checkIsSessionValid();
        if (!uri.isSipURI()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "encodeURI", "Can not encode URI, Not a SIP URI " + uri);
            }
            throw new IllegalArgumentException("Not a SIP a URI, Can not encode session information");
        }
        ((SipURI)uri).setParameter(ENCODED_APP_SESSION_ID, this.getId());
        this.setDirty();
        this.store();
    }

    @Override
    public Object getAttribute(String name) {
        this.checkIsSessionValid();
        LinkedHashSet<String> attr = this.m_attributes;
        if (attr == null) {
            return null;
        }
        if (!attr.contains(name)) {
            return null;
        }
        return SessionRepository.getInstance().getSASAttr(this, name);
    }

    @Override
    public Iterator getAttributeNames() {
        this.checkIsSessionValid();
        LinkedHashSet<String> attr = this.m_attributes;
        if (attr == null) {
            return Collections.EMPTY_MAP.keySet().iterator();
        }
        return attr.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, Object attribute) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "setAttribute", (Object)name);
            }
            this.checkIsSessionValid();
            if (attribute == null || name == null) {
                throw new NullPointerException("SipApplicationSession#setAttribute: attribute name or value cannot be null");
            }
            if (this.m_appDescriptor.isDistributed() && !(attribute instanceof Serializable)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setAttribute", "Attribute must implement Serializable ... attrName = " + name + this);
                }
                throw new IllegalArgumentException("Attribute not Serializable: Attribute name=" + name + ", Attribute=" + attribute);
            }
            Object prevValue = null;
            LinkedHashSet<String> attr = this.m_attributes;
            if (attr == null) {
                if (attr == null && !this.m_duringInvalidate) {
                    this.m_attributes = attr = new LinkedHashSet();
                } else if (this.m_duringInvalidate) {
                    throw new IllegalStateException("Invalid Session: " + this);
                }
            }
            attr.add(name);
            this.setDirty();
            prevValue = SessionRepository.getInstance().putSASAttr(this, name, attribute);
            if (prevValue != null) {
                this.sendAttributeNotification(name, LstNotificationType.APP_ATTRIBUTE_REPLACED);
            } else {
                this.sendAttributeNotification(name, LstNotificationType.APP_ATTRIBUTE_ADDED);
            }
            EventsDispatcher.AppSessionAttributeBounding(this, name, this.m_appDescriptor, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends EventListener> void sendEvent(Collection<T> listeners, Object evt, LstNotificationType attrNotifyType) {
        Iterator<T> iter = listeners.iterator();
        ContextEstablisher contextEstablisher = this.m_appDescriptor.getContextEstablisher();
        ClassLoader currentThreaClassLoader = null;
        try {
            if (contextEstablisher != null) {
                currentThreaClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                contextEstablisher.establishContext();
            }
            block11: while (iter.hasNext()) {
                switch (attrNotifyType) {
                    case APP_ATTRIBUTE_ADDED: {
                        ((SipApplicationSessionAttributeListener)iter.next()).attributeAdded((SipApplicationSessionBindingEvent)evt);
                        continue block11;
                    }
                    case APP_ATTRIBUTE_REPLACED: {
                        ((SipApplicationSessionAttributeListener)iter.next()).attributeReplaced((SipApplicationSessionBindingEvent)evt);
                        continue block11;
                    }
                    case APP_ATTRIBUTE_REMOVED: {
                        ((SipApplicationSessionAttributeListener)iter.next()).attributeRemoved((SipApplicationSessionBindingEvent)evt);
                        continue block11;
                    }
                    case APPLICATION_CREATED: {
                        ((SipApplicationSessionListener)iter.next()).sessionCreated((SipApplicationSessionEvent)evt);
                        continue block11;
                    }
                    case APPLICATION_DESTROYED: {
                        ((SipApplicationSessionListener)iter.next()).sessionDestroyed((SipApplicationSessionEvent)evt);
                        continue block11;
                    }
                    case APPLICATION_EXPIRED: {
                        ((SipApplicationSessionListener)iter.next()).sessionExpired((SipApplicationSessionEvent)evt);
                        continue block11;
                    }
                }
            }
        }
        finally {
            if (contextEstablisher != null) {
                contextEstablisher.removeContext(currentThreaClassLoader);
            }
        }
    }

    public void sendAttributeNotification(String attrName, LstNotificationType attrNotifyType) {
        StringBuffer buff;
        if (c_logger.isTraceEntryExitEnabled()) {
            buff = new StringBuffer(attrName);
            buff.append((Object)attrNotifyType);
            c_logger.traceEntryExit((Object)this, "sendAttributeAddedNotify", buff.toString());
        }
        if (null == this.m_appDescriptor) {
            if (c_logger.isTraceDebugEnabled()) {
                buff = new StringBuffer(100);
                buff.append("Unable to send Attribute Added notification, ");
                buff.append("sessionAppId = ");
                buff.append(this.getId());
                buff.append(" No Application Descriptor");
                c_logger.traceDebug(this, "sendAttributeRemovedNotify", buff.toString());
            }
            return;
        }
        Collection<SipApplicationSessionAttributeListener> listeners = this.m_appDescriptor.getAppSessionAttributesListeners();
        if (!listeners.isEmpty()) {
            SipApplicationSessionBindingEvent evt = new SipApplicationSessionBindingEvent(this, attrName);
            this.sendEvent(listeners, evt, attrNotifyType);
        }
    }

    public void sendAppSessionNotification(LstNotificationType type) {
        if (null == this.m_appDescriptor) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer(100);
                buff.append("Unable to send sendAppSessionNotification ");
                buff.append("sessionAppId = ");
                buff.append("Notification type = ");
                buff.append((Object)type);
                buff.append(this.getId());
                buff.append(" No Application Descriptor");
                c_logger.traceDebug(this, "sendApplicationSessionCreatedNotification", buff.toString());
            }
            return;
        }
        Collection<SipApplicationSessionListener> listeners = this.m_appDescriptor.getAppSessionListeners();
        if (!listeners.isEmpty()) {
            SipApplicationSessionEvent evt = new SipApplicationSessionEvent(this);
            this.sendEvent(listeners, evt, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            LinkedHashSet<String> attrMap;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "removeAttribute", (Object)name);
            }
            if (this.m_appDescriptor != null && this.m_appDescriptor.isJSR289Application()) {
                this.checkIsSessionValid();
            }
            if ((attrMap = this.m_attributes) == null || !attrMap.remove(name)) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "removeAttribute", name + " wasn't found. request ignored. " + this);
                }
                return;
            }
            EventsDispatcher.AppSessionAttributeBounding(this, name, this.m_appDescriptor, false);
            Object attr = SessionRepository.getInstance().removeAttribute(this, name);
            if (attr == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit((Object)this, "removeAttribute", name + " not removed, not found in SessionRepository " + this);
                }
                return;
            }
            this.sendAttributeNotification(name, LstNotificationType.APP_ATTRIBUTE_REMOVED);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeAttribute", name + " calling to unbound, if attribute is a listener. " + attr);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "removeAttribute", name);
            }
        }
    }

    public SipAppDesc getAppDescriptor() {
        return this.m_appDescriptor;
    }

    public void addSipSession(SipSession session) {
        this.setLastAccessedTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransctionUser(TransactionUserWrapper tu) {
        if (this.m_transactionUsers == null) {
            this.m_transactionUsers = new ArrayList<TransactionUserWrapper>(2);
        }
        List<TransactionUserWrapper> list = this.m_transactionUsers;
        synchronized (list) {
            this.m_transactionUsers.add(tu);
        }
        String sessionKey = tu.getSessionKeyBaseKey();
        if (sessionKey != null) {
            if (this.m_sessionKeyBaseKey != null && !this.m_sessionKeyBaseKey.equals(sessionKey)) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("Multiple session key based key old key = '" + this.m_sessionKeyBaseKey + "' new key = '" + sessionKey + "'. new value ignored");
                }
            } else {
                this.m_sessionKeyBaseKey = sessionKey;
                tu.setSessionKeyBase(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionUser(TransactionUserWrapper tu) {
        if (this.m_transactionUsers == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipApplicationSessionImp.removeTransactionUser: trying to remove nonexisting TU: " + tu);
            }
            return;
        }
        List<TransactionUserWrapper> list = this.m_transactionUsers;
        synchronized (list) {
            this.m_transactionUsers.remove(tu);
        }
    }

    public void setSipApp(SipAppDesc desc, boolean setExpiration) {
        this._applicationName = desc.getApplicationName().toString();
        if (desc.isJSR289Application()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setSipApp", "this is 289 app - m_invalidateWhenReady is true");
            }
            this.m_invalidateWhenReady = true;
        }
        boolean isSASJustNowCreated = this.m_appDescriptor == null;
        this.m_appDescriptor = desc;
        this.notifyPerfMgrOnNewSAS();
        if (isSASJustNowCreated) {
            this.sendAppSessionNotification(LstNotificationType.APPLICATION_CREATED);
        }
        if (setExpiration) {
            int sessionTimeout = this.m_appDescriptor.getAppSessionTTL();
            if (sessionTimeout < 1) {
                this.m_expires = -1L;
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("SipApplicationId = [");
                    buff.append(this.getId());
                    buff.append("]");
                    buff.append("WARNING: According to sip.xml settings, this ApplicationSession will never expire. The session must be explicitly invalidated when dialog finished, or else it will stay in memory forever!");
                    c_logger.traceDebug(this, "setSipApp", buff.toString());
                }
            } else {
                this.setExpires(sessionTimeout);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("SipApplicationId = [");
            buff.append(this.getId());
            buff.append("]");
            buff.append("isDistributed = [");
            buff.append(desc.isDistributed());
            buff.append("]");
            c_logger.traceDebug(this, "setSipApp", buff.toString());
        }
        this.store();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "setSipApp");
        }
    }

    public void notifyPerfMgrOnNewSAS() {
        if (null == this.m_appDescriptor) {
            return;
        }
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.sipAppSessionCreated(this.m_appDescriptor.getApplicationName(), this.m_appDescriptor.getAppIndexForPmi());
        }
    }

    public long getExpires() {
        return this.m_expires;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTimers() {
        ArrayList<BaseTimer> timersCollection = null;
        Object object = this.getSynchronizer();
        synchronized (object) {
            this.checkIsSessionValid();
            if (this.m_timersIds == null) {
                return Collections.EMPTY_LIST;
            }
            int size = this.m_timersIds.size();
            timersCollection = new ArrayList<BaseTimer>();
            for (int i = 0; i < size; ++i) {
                Integer timerId = this.m_timersIds.get(i);
                BaseTimer currentTimer = SessionRepository.getInstance().getTimer(this.getId(), timerId);
                if (currentTimer != null) {
                    timersCollection.add(currentTimer);
                    continue;
                }
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "getTimers", " check flow. Timer value was missing in repository.");
            }
        }
        return timersCollection;
    }

    public static SipApplicationSessionImpl getAppSession(String id) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)"SipApplicationSessionImpl", "getAppSession", (Object)id);
        }
        SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)SessionRepository.getInstance().getAppSession(id);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit("SipApplicationSessionImpl", "getAppSession: " + appSession);
        }
        return appSession;
    }

    private void checkIsSessionValid() throws IllegalStateException {
        if (!this.m_isValid) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkIsSessionValid", "Session is invalid, Operation not allowed,  " + this);
            }
            throw new IllegalStateException("Invalid Session: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(ServletTimerImpl timer) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "addTimer", (Object)timer);
            }
            if (this.m_timersIds == null) {
                this.m_timersIds = new Vector(2);
            }
            this.m_timersIds.addElement(timer.getTimerId());
            this.setDirty();
            SessionRepository.getInstance().put(this, timer);
            this.store();
            timer.store();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "addTimer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(ServletTimerImpl timer) {
        Object object = this.getSynchronizer();
        synchronized (object) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)null, "removeTimer", (Object)timer);
            }
            if (this.m_timersIds == null || this.m_timersIds.isEmpty()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "removeTimer", " empty timer list. check flow.");
                }
                return;
            }
            SessionRepository.getInstance().removeTimer(this.getId(), timer);
            this.m_timersIds.removeElement(timer.getTimerId());
            this.store();
            if (this.getInvalidateWhenReady() && this.isReadyToInvalidate()) {
                this.readyToInvalidate();
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(null, "removeTimer", timer);
            }
        }
    }

    public String getApplicationId() {
        return this._applicationName;
    }

    public boolean isApplicationAlive() {
        return this.m_applicationIsAlive;
    }

    public void notifyOnActivationOrPassivation(boolean activation) {
        if (null != this.m_appDescriptor) {
            if (activation) {
                EventsDispatcher.AppSessionActivated(this);
            } else {
                EventsDispatcher.AppSessionWillPassivate(this);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Unable to send Application Session");
            if (activation) {
                buff.append(" activation");
            } else {
                buff.append(" passivation");
            }
            buff.append(" notification, SIP app descriptor not available");
            buff.append("sessionId = ");
            buff.append(this.getId());
            c_logger.traceDebug(this, "sendSessionActivateNotification", buff.toString());
        }
    }

    @Override
    public void store() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "store");
        }
        SessionRepository.getInstance().put(this);
    }

    @Override
    public String getId() {
        return this.getSharedId();
    }

    public String toString() {
        StringBuffer myInformation = new StringBuffer();
        myInformation.append("Id = ");
        myInformation.append(this.getSharedId());
        myInformation.append(" Info = ");
        myInformation.append(super.toString());
        return myInformation.toString();
    }

    @Override
    public void removeFromStorage() {
        this.removeAttributesFromStorage();
        SessionRepository.getInstance().remove(this);
    }

    @Override
    public long getExpirationTime() throws IllegalStateException {
        this.checkIsSessionValid();
        if (this.m_expires == -1L) {
            return 0L;
        }
        return this.m_expires;
    }

    @Override
    public String getApplicationName() {
        if (this.m_appDescriptor == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getApplicationName", "m_appDescriptor was null");
            }
            return null;
        }
        return this.m_appDescriptor.getApplicationName();
    }

    @Override
    public ServletTimer getTimer(String id) {
        this.checkIsSessionValid();
        try {
            int timerId = Integer.parseInt(id);
            return (ServletTimerImpl)SessionRepository.getInstance().getTimer(this.getId(), timerId);
        }
        catch (NumberFormatException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getTimer", "Error - id is not numeric " + id);
            }
            return null;
        }
    }

    @Override
    public URL encodeURL(URL url) throws IllegalStateException {
        this.checkIsSessionValid();
        return null;
    }

    public boolean isDuringInvalidate() {
        return this.m_duringInvalidate;
    }

    public int extractAppSessionCounter() {
        if (this.m_extractedAppSessionSeqCounter < 0) {
            this.m_extractedAppSessionSeqCounter = SipApplicationSessionImpl.extractAppSessionCounter(this.getSharedId());
        }
        return this.m_extractedAppSessionSeqCounter;
    }

    public static int extractAppSessionCounter(String AppSessionId) {
        StringTokenizer tokenizer = new StringTokenizer(AppSessionId, "_");
        tokenizer.nextToken();
        String appCounterAsString = tokenizer.nextToken();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)"SipApplicationSessionImpl", "extractAppSessionCounter", "found App session counter:" + appCounterAsString);
        }
        int result = Integer.parseInt(appCounterAsString);
        return result;
    }

    public Object getSynchronizer() {
        return this._synchronizer;
    }

    public void setSynchronizer(Object synchronizer) {
        this._synchronizer = synchronizer;
    }

    public Object getServiceSynchronizer() {
        return this._serviceSynchronizer;
    }

    public void setServiceSynchronizer(Object serviceSynchronizer) {
        this._serviceSynchronizer = serviceSynchronizer;
    }

    @Override
    public Object getSession(String id, SipApplicationSession.Protocol protocol) throws NullPointerException, IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{id, protocol};
            c_logger.traceEntry((Object)this, " getSession", params);
        }
        SipSession sipSession = this.getSipSession(id);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSession", "Requested SIP session found = " + sipSession);
        }
        return sipSession;
    }

    @Override
    public boolean getInvalidateWhenReady() throws IllegalStateException {
        this.checkIsSessionValid();
        return this.m_invalidateWhenReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadyToInvalidate() throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, " isReadyToInvalidate", (Object)this.getId());
        }
        Object object = this.getSynchronizer();
        synchronized (object) {
            this.checkIsSessionValid();
            boolean isRedyToInvalidate = true;
            if (this.m_transactionUsers != null) {
                for (TransactionUserWrapper transactionUserWrapper : this.m_transactionUsers) {
                    if (transactionUserWrapper.isReadyToInvalidate()) continue;
                    isRedyToInvalidate = false;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "isReadyToInvalidate", "SipSession is not ready yet = " + transactionUserWrapper.getId());
                    }
                    break;
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "isReadyToInvalidate", "Empty sessions list, sip applications can be invalidated.");
            }
            if (isRedyToInvalidate && this.m_timersIds != null && !this.m_timersIds.isEmpty()) {
                isRedyToInvalidate = false;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "isReadyToInvalidate", "There are still active timers associated with this APplicationSession");
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, " isReadyToInvalidate", this.getId() + " result: " + isRedyToInvalidate);
            }
            return isRedyToInvalidate;
        }
    }

    @Override
    public void setInvalidateWhenReady(boolean invalidateWhenReady) throws IllegalStateException {
        this.checkIsSessionValid();
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this.getId(), invalidateWhenReady};
            c_logger.traceEntry((Object)this, " setInvalidateWhenReady", params);
        }
        this.m_invalidateWhenReady = invalidateWhenReady;
    }

    public void readyToInvalidate() {
        if (this.isValid()) {
            if (this.getInvalidateWhenReady()) {
                this.sendSessionReadyToInvalidateEvt();
                if (this.getInvalidateWhenReady()) {
                    try {
                        this.invalidate();
                    }
                    catch (IllegalStateException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "readyToInvalidate", "SipApplication session was already invalidated");
                        }
                    }
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "readyToInvalidate", "getInvalidateWhenReady() is false - invalidate later");
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "readyToInvalidate", "getInvalidateWhenReady() is false - invalidate later");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "readyToInvalidate", "AppSession has already been invalidated. Just ignore.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessionReadyToInvalidateEvt() {
        SipAppDesc desc = this.getAppDescriptor();
        if (null != desc) {
            Iterator<SipApplicationSessionListener> iter = desc.getAppSessionListeners().iterator();
            if (!iter.hasNext()) {
                return;
            }
            SipApplicationSessionEvent evt = new SipApplicationSessionEvent(this);
            ContextEstablisher contextEstablisher = desc.getContextEstablisher();
            ClassLoader currentThreadClassLoader = null;
            try {
                if (contextEstablisher != null) {
                    currentThreadClassLoader = contextEstablisher.getThreadCurrentClassLoader();
                    contextEstablisher.establishContext();
                }
                while (iter.hasNext()) {
                    try {
                        iter.next().sessionReadyToInvalidate(evt);
                    }
                    catch (Exception e2) {
                        if (!c_logger.isTraceDebugEnabled()) continue;
                        c_logger.traceDebug(this, "sendSessionReadyToInvalidateEvt", "Exception  = " + e2.getMessage());
                    }
                }
            }
            finally {
                if (contextEstablisher != null) {
                    contextEstablisher.removeContext(currentThreadClassLoader);
                }
            }
        }
    }

    public boolean isContainsAttr(String attrName) {
        return this.m_attributes.contains(attrName);
    }

    public String getSessionKeyBaseTargetingKey() {
        return this.m_sessionKeyBaseKey;
    }

    public void setSessionKeyBaseTargeting(String skbt) {
        if (this.m_sessionKeyBaseKey != null && !this.m_sessionKeyBaseKey.equals(skbt) && c_logger.isErrorEnabled()) {
            c_logger.error("Multiple session key based key old key = '" + this.m_sessionKeyBaseKey + "' new key = '" + skbt + "'. new value ignored");
        }
        this.m_sessionKeyBaseKey = skbt;
    }

    @Override
    public Iterator getSessions(String protocol, boolean create) {
        if (protocol.equalsIgnoreCase("SIP")) {
            if (create) {
                return this.getAllSIPSessions(true).iterator();
            }
            return this.getAllSIPSessions(false).iterator();
        }
        if (protocol.equalsIgnoreCase("HTTP")) {
            return Collections.EMPTY_MAP.keySet().iterator();
        }
        SipAppDesc sipAppDesc = this.getAppDescriptor();
        if (sipAppDesc != null && !sipAppDesc.isJSR289Application()) {
            return Collections.EMPTY_MAP.keySet().iterator();
        }
        throw new IllegalArgumentException("Unsupported protocol type " + protocol);
    }
}

