/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.container.service.annotations.FragmentAnnotations;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.container.service.config.ServletConfiguratorHelper;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.webbnd.WebBnd;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.was.SipAppAnnotationsInfo;
import com.ibm.ws.sip.container.was.extension.SipServletConfigFactoryImpl;
import com.ibm.ws.webcontainer.osgi.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.sip.annotation.SipApplicationKey;
import javax.servlet.sip.annotation.SipListener;

public class SipServletConfiguratorHelper
implements ServletConfiguratorHelper {
    private static final LogMgr c_logger = Log.get(SipServletConfiguratorHelper.class);
    private final ServletConfigurator configurator;
    private SipAppDesc _appDesc = null;

    public SipServletConfiguratorHelper(ServletConfigurator configurator) {
        this.configurator = configurator;
    }

    public void configureInit() throws UnableToAdaptException {
    }

    public void configureFromWebApp(WebApp webApp) throws UnableToAdaptException {
        if (webApp != null) {
            WebModuleInfo moduleInfo = (WebModuleInfo)this.configurator.getFromModuleCache(WebModuleInfo.class);
            if (webApp instanceof SipAppDesc) {
                this._appDesc = (SipAppDesc)webApp;
            }
            if (this._appDesc != null) {
                this._appDesc.setWebAppName(moduleInfo.getName());
                SipAppDescManager.getInstance().addNewApp(this._appDesc);
            }
        }
    }

    public void configureFromWebFragment(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
    }

    public void configureFromAnnotations(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Configuring from annotations");
        }
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        FragmentAnnotations fragmentAnnotations = webAnnotations.getFragmentAnnotations(webFragmentItem);
        if (webAnnotations != null && fragmentAnnotations != null) {
            SipAppDesc newApp;
            WebModuleInfo moduleInfo = (WebModuleInfo)this.configurator.getFromModuleCache(WebModuleInfo.class);
            SipAppAnnotationsInfo sipInfo = new SipAppAnnotationsInfo(moduleInfo.getName(), webAnnotations, fragmentAnnotations);
            this._appDesc = newApp = sipInfo.createSipAppDesc();
        }
    }

    private void processSipApplicationKeyAnnotations(WebAnnotations webAnnotations, FragmentAnnotations fragmentAnnotations) throws UnableToAdaptException {
        Set appKeys = fragmentAnnotations.selectAnnotatedClasses(SipApplicationKey.class);
        System.out.println("SipApplicationKeys: " + appKeys);
    }

    private void processSipListenerAnnotations(WebAnnotations webAnnotations, FragmentAnnotations fragmentAnnotations) throws UnableToAdaptException {
        Set listeners = fragmentAnnotations.selectAnnotatedClasses(SipListener.class);
        System.out.println("SipListeners: " + listeners);
    }

    public void configureDefaults() throws UnableToAdaptException {
    }

    public void finish() throws UnableToAdaptException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("finishing servlet Config");
        }
        if (this._appDesc == null) {
            return;
        }
        WebAppConfiguration config = (WebAppConfiguration)this.configurator.getFromModuleCache(WebAppConfig.class);
        Map<String, Condition> servletsPatterns = this._appDesc.getServletsPatterns();
        boolean appHasServletMappingRules = servletsPatterns != null && servletsPatterns.size() > 0;
        boolean appHasMainServlet = this._appDesc.hasMainServlet();
        if (appHasMainServlet) {
            SipServletDesc servletDesc = this._appDesc.getSipServlet(this._appDesc.getMainSipletName());
            if (servletDesc != null) {
                this._appDesc.setMainServlet(servletDesc);
            } else {
                if (c_logger.isErrorEnabled()) {
                    Object[] objectArray = new Object[]{this._appDesc.getMainSipletName()};
                    c_logger.error("error.no.main.serv", (String)null, objectArray);
                }
                throw new UnableToAdaptException("The application defined a main servlet that does not exist: " + this._appDesc.getMainSipletName());
            }
        }
        if (appHasMainServlet && appHasServletMappingRules) {
            if (c_logger.isErrorEnabled()) {
                Object[] params = new Object[]{this._appDesc};
                c_logger.error("cant.both.main.serv.mapping", (String)null, params);
            }
            throw new UnableToAdaptException("The application incorrectly defines both a main servlet " + this._appDesc.getMainSipletName() + " and servlets mapping rules.");
        }
        if (appHasServletMappingRules) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Application [" + this._appDesc.getAppName() + "] has mapping rules and doesn't have a main servlet");
            }
            for (Map.Entry entry : servletsPatterns.entrySet()) {
                String servletName = (String)entry.getKey();
                SipServletDesc siplet = this._appDesc.getSipServlet(servletName);
                if (siplet != null) {
                    siplet.setTriggeringCondition((Condition)entry.getValue());
                    continue;
                }
                if (c_logger.isErrorEnabled()) {
                    Object[] args = new Object[]{this._appDesc, servletName};
                    c_logger.error("error.mapping.to.nonexisting.siplet", "Create", args);
                }
                throw new UnableToAdaptException("Mapping for nonexisting siplet: " + servletName + ", Application: " + this._appDesc);
            }
        } else if (!appHasMainServlet) {
            List<SipServletDesc> siplets = this._appDesc.getSipServlets();
            if (this._appDesc.isJSR289Application() && this._appDesc.getMainSiplet() == null && siplets.size() == 1) {
                this._appDesc.setMainSipletName(siplets.iterator().next().getName());
                this._appDesc.setMainServlet(siplets.iterator().next());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Main servlet for application [" + this._appDesc.getAppName() + "] defined to be  [" + this._appDesc.getMainSiplet() + "]");
                }
            } else if (siplets.size() > 1) {
                if (c_logger.isErrorEnabled()) {
                    Object[] objectArray = new Object[]{this._appDesc};
                    c_logger.error("must.define.main.serv", (String)null, objectArray);
                }
                throw new UnableToAdaptException("The application doesn't define a main servlet but has more than one siplet");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Main servlet for application [" + this._appDesc.getAppName() + "] is defined to be  [" + this._appDesc.getMainSiplet() + "]. No mapping rules.");
        }
        for (SipServletDesc sipServletDesc : this._appDesc.getSipServlets()) {
            String servletId = "SIP" + this.configurator.generateUniqueId();
            IServletConfig cfg = config.getServletInfo(sipServletDesc.getName());
            if (cfg == null) {
                cfg = new com.ibm.ws.webcontainer.servlet.ServletConfig(servletId, (WebAppConfig)config);
            }
            IServletConfig servletConfig = SipServletConfigFactoryImpl.getInstance().createSipServletConfig((ServletConfig)cfg);
            ((com.ibm.ws.webcontainer.servlet.ServletConfig)cfg).setName(sipServletDesc.getName());
            servletConfig.setAddedToLoadOnStartup(sipServletDesc.isServletLoadOnStartup());
            servletConfig.setServletName(sipServletDesc.getName());
            servletConfig.setMetaData((WebComponentMetaData)new WebComponentMetaDataImpl(config.getMetaData()));
            servletConfig.setClassName(sipServletDesc.getClassName());
            servletConfig.setLoadOnStartup(sipServletDesc.getServletLoadOnStartup());
            servletConfig.setInitParams(sipServletDesc.getInitParams());
            config.addServletInfo(sipServletDesc.getName(), servletConfig);
            List mappings = config.getServletMappings(sipServletDesc.getName());
            String servMapping = "/" + sipServletDesc.getName();
            if (mappings != null && mappings.contains(servMapping)) continue;
            config.addServletMapping(sipServletDesc.getName(), servMapping);
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug("mapping: " + servMapping + " -> " + sipServletDesc.getName());
        }
        config.setContextParams((HashMap)this._appDesc.getAppContextParams());
        SipAppDescManager.getInstance().addNewApp(this._appDesc);
    }

    public void configureWebBnd(WebBnd webBnd) throws UnableToAdaptException {
    }

    public void configureWebExt(WebExt webExt) throws UnableToAdaptException {
    }
}

