/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import jakarta.resource.ResourceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    static final long serialVersionUID = -7562688864531804215L;

    public static Number convert(Number value, Class<?> type) {
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            value = value.intValue();
        } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            value = value.longValue();
        } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            value = value.shortValue();
        } else if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            value = value.byteValue();
        } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            value = value.doubleValue();
        } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            value = Float.valueOf(value.floatValue());
        }
        return value;
    }

    public static Object convert(String str, Class<?> type) throws Exception {
        Constable value = Integer.TYPE.equals(type) || Integer.class.equals(type) ? Integer.valueOf(Integer.parseInt(str)) : (Boolean.TYPE.equals(type) || Boolean.class.equals(type) ? Boolean.valueOf(Boolean.parseBoolean(str)) : (Long.TYPE.equals(type) || Long.class.equals(type) ? Long.valueOf(Long.parseLong(str)) : (Short.TYPE.equals(type) || Short.class.equals(type) ? Short.valueOf(Short.parseShort(str)) : (Byte.TYPE.equals(type) || Byte.class.equals(type) ? Byte.valueOf(Byte.parseByte(str)) : (Double.TYPE.equals(type) || Double.class.equals(type) ? Double.valueOf(Double.parseDouble(str)) : (Float.TYPE.equals(type) || Float.class.equals(type) ? (Constable)Float.valueOf(Float.parseFloat(str)) : (Constable)(Character.TYPE.equals(type) || Character.class.equals(type) ? Character.valueOf(str.charAt(0)) : type.getConstructor(String.class).newInstance(str))))))));
        return value;
    }

    @Trivial
    public static final String getMessage(String key, Object ... params) {
        return TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)key, (Object[])params, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    private static final OnErrorUtil.OnError ignoreWarnOrFail() {
        String value = null;
        BundleContext bundleContext = priv.getBundleContext(FrameworkUtil.getBundle(VariableRegistry.class));
        ServiceReference ref = priv.getServiceReference(bundleContext, VariableRegistry.class);
        VariableRegistry variableRegistry = (VariableRegistry)priv.getService(bundleContext, ref);
        try {
            String key = "${onError}";
            value = variableRegistry.resolveString(key);
            if (!key.equals(value)) {
                OnErrorUtil.OnError onError = OnErrorUtil.OnError.valueOf((String)value.trim().toUpperCase());
                return onError;
            }
        }
        catch (Exception key) {
            FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.jca.internal.Utils", (String)"132", null, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void x;
                Tr.debug((TraceComponent)tc, (String)("onError: " + value), (Object[])new Object[]{x});
            }
        }
        finally {
            bundleContext.ungetService(ref);
        }
        return OnErrorUtil.getDefaultOnError();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T ignoreWarnOrFail(TraceComponent tc, Throwable throwable, Class<T> exceptionClassToRaise, String msgKey, Object ... objs) {
        switch (Utils.ignoreWarnOrFail()) {
            case IGNORE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ignoring error: " + msgKey), (Object[])objs);
                }
                return null;
            }
            case WARN: {
                Tr.warning((TraceComponent)tc, (String)msgKey, (Object[])objs);
                return null;
            }
            case FAIL: {
                try {
                    if (throwable != null && exceptionClassToRaise.isInstance(throwable)) {
                        return (T)((Throwable)exceptionClassToRaise.cast(throwable));
                    }
                    String message = msgKey == null ? throwable.getMessage() : TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)msgKey, (Object[])objs, null);
                    Constructor<T> con = exceptionClassToRaise.getConstructor(String.class);
                    return (T)((Throwable)exceptionClassToRaise.cast(((Throwable)con.newInstance(message)).initCause(throwable)));
                }
                catch (RuntimeException message) {
                    void e;
                    FFDCFilter.processException((Throwable)message, (String)"com.ibm.ws.jca.internal.Utils", (String)"176", null, (Object[])new Object[]{tc, throwable, exceptionClassToRaise, msgKey, objs});
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.internal.Utils", (String)"178", null, (Object[])new Object[]{tc, throwable, exceptionClassToRaise, msgKey, objs});
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Trivial
    public static final String toString(Throwable x) {
        StringWriter sw = new StringWriter();
        x.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static final Object deserialize(byte[] bytes) throws Exception {
        Object o;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object[])new Object[0]);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream oin = new ObjectInputStream(bis);
            o = oin.readObject();
            oin.close();
        }
        catch (IOException bis) {
            void e;
            FFDCFilter.processException((Throwable)bis, (String)"com.ibm.ws.jca.internal.Utils", (String)"216", null, (Object[])new Object[]{bytes});
            FFDCFilter.processException((Throwable)e, (String)Utils.class.getName(), (String)"305");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deserialize", (Object)new Object[]{Utils.toString(bytes), e});
            }
            throw e;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserialize", o == null ? null : o.getClass());
        }
        return o;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static byte[] serObjByte(Object pk) throws IOException {
        byte[] b;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serObjByte", (Object[])new Object[]{pk == null ? null : pk.getClass()});
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(pk);
            out.flush();
            out.close();
            b = bos.toByteArray();
        }
        catch (IOException bos) {
            void e;
            FFDCFilter.processException((Throwable)bos, (String)"com.ibm.ws.jca.internal.Utils", (String)"246", null, (Object[])new Object[]{pk});
            FFDCFilter.processException((Throwable)e, (String)Utils.class.getName(), (String)"336");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serObjByte", (Object)new Object[]{"Unable to serialize: " + pk, e});
            }
            throw e;
        }
        catch (Error e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.internal.Utils", (String)"251", null, (Object[])new Object[]{pk});
            FFDCFilter.processException((Throwable)e, (String)Utils.class.getName(), (String)"342");
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serObjByte", (Object)new Object[]{"Unable to serialize: " + pk, e});
            }
            throw e;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serObjByte");
        }
        return b;
    }

    private static final String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
            sb.append(Integer.toHexString(b / 16)).append(Integer.toHexString(b % 16)).append(' ');
        }
        return new String(sb);
    }

    public static void checkAccessibility(String resourceName, String adapterName, String embeddedApp, String accessingApp, boolean isEndpoint) throws ResourceException {
        if (embeddedApp != null && !embeddedApp.equals(accessingApp)) {
            String msg = null;
            msg = isEndpoint ? (accessingApp != null ? TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)"J2CA8810.embedded.activation.failed", (Object[])new Object[]{resourceName, adapterName, embeddedApp, accessingApp}, (String)"J2CA8810.embedded.activation.failed") : TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)"J2CA8812.embedded.activation.failed", (Object[])new Object[]{resourceName, adapterName, embeddedApp}, (String)"J2CA8812.embedded.activation.failed")) : (accessingApp != null ? TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)"J2CA8809.embedded.lookup.failed", (Object[])new Object[]{resourceName, adapterName, embeddedApp, accessingApp}, (String)"J2CA8809.embedded.lookup.failed") : TraceNLS.getFormattedMessage(Utils.class, (String)tc.getResourceBundleName(), (String)"J2CA8811.embedded.lookup.failed", (Object[])new Object[]{resourceName, adapterName, embeddedApp}, (String)"J2CA8811.embedded.lookup.failed"));
            throw new ResourceException(msg);
        }
    }
}

