/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.PersistentStoreException;
import com.ibm.websphere.concurrent.persistent.ResultNotSerializableException;
import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.concurrent.persistent.TaskStatus;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.ejb.TimerStatus;
import com.ibm.ws.concurrent.persistent.ejb.TimerTrigger;
import com.ibm.ws.concurrent.persistent.internal.InvokerTask;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.concurrent.persistent.internal.Utils;
import com.ibm.ws.concurrent.persistent.serializable.TaskFailure;
import com.ibm.ws.concurrent.persistent.serializable.TaskSkipped;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.concurrent.persistent.TaskRecord;
import com.ibm.wsspi.concurrent.persistent.TaskStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.AbortedException;
import javax.enterprise.concurrent.SkippedException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TaskStatusImpl<T>
implements TaskStatus<T>,
TimerStatus<T> {
    private static final TraceComponent tc = Tr.register(TaskStatusImpl.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
    private final String classLoaderIdentifier;
    private final long id;
    private final short miscBinaryFlags;
    private final String name;
    private final long nextExecutionTime;
    private final PersistentExecutorImpl persistentExecutor;
    private final byte[] resultBytes;
    private final short state;
    private final byte[] triggerBytes;
    static final long serialVersionUID = 7168212620930512348L;

    public TaskStatusImpl(TaskRecord task, PersistentExecutorImpl persistentExecutor) {
        this.classLoaderIdentifier = task.getIdentifierOfClassLoader();
        this.id = task.getId();
        this.miscBinaryFlags = task.getMiscBinaryFlags();
        this.name = task.getName();
        this.nextExecutionTime = task.getNextExecutionTime();
        this.resultBytes = task.getResult();
        this.state = task.getState();
        this.triggerBytes = task.hasTrigger() ? task.getTrigger() : null;
        this.persistentExecutor = persistentExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        long[] runningTaskState;
        PersistentExecutorImpl.TransactionController tranController = this.persistentExecutor.new PersistentExecutorImpl.TransactionController();
        boolean result = false;
        boolean removed = false;
        TaskStore taskStore = this.persistentExecutor.taskStore;
        try {
            tranController.preInvoke();
            result = (this.miscBinaryFlags & TaskRecord.Flags.AUTO_PURGE_ALWAYS.bit) == 0 ? taskStore.cancel(this.id) : (removed = taskStore.remove(this.id, null, false));
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.TaskStatusImpl", (String)"125", (Object)this, (Object[])new Object[]{mayInterruptIfRunning});
            tranController.setFailure(x);
        }
        finally {
            PersistentStoreException x = tranController.postInvoke(PersistentStoreException.class);
            if (x != null) {
                throw x;
            }
        }
        if (removed && (runningTaskState = InvokerTask.runningTaskState.get()) != null && runningTaskState[0] == this.id) {
            runningTaskState[1] = 1L;
        }
        return result;
    }

    @Override
    public int compareTo(Delayed delayed) {
        int result;
        if (delayed instanceof TaskStatusImpl) {
            long otherNextExecTime = ((TaskStatusImpl)delayed).nextExecutionTime;
            result = this == delayed || this.nextExecutionTime == otherNextExecTime ? 0 : (this.nextExecutionTime - otherNextExecTime < 0L ? -1 : 1);
        } else {
            long diff = this.nextExecutionTime - new Date().getTime() - delayed.getDelay(TimeUnit.MILLISECONDS);
            result = diff < -100L ? -1 : (diff > 100L ? 1 : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TaskStatusImpl) {
            TaskStatusImpl other = (TaskStatusImpl)obj;
            return this.id == other.id && this.state == other.state && this.nextExecutionTime == other.nextExecutionTime && this.persistentExecutor == other.persistentExecutor && Arrays.equals(this.resultBytes, other.resultBytes);
        }
        return false;
    }

    @Override
    Throwable exceptionNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get() throws ExecutionException {
        if ((this.state & TaskState.ENDED.bit) == 0) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1551.result.unavailable.until.ended", (Object[])new Object[]{"get"}));
        }
        return this.getResult();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        if ((this.state & TaskState.ENDED.bit) == 0) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1551.result.unavailable.until.ended", (Object[])new Object[0]));
        }
        return this.getResult();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        if ((this.miscBinaryFlags & TaskRecord.Flags.ONE_SHOT_TASK.bit) == 0 && (this.state & TaskState.ENDED.bit) == 0) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1552.delay.unavailable", (Object[])new Object[0]));
        }
        return unit.convert(this.nextExecutionTime - new Date().getTime(), TimeUnit.MILLISECONDS);
    }

    private final String getIdAndName() {
        StringBuilder sb = new StringBuilder().append(this.id);
        if (!" ".equals(this.name)) {
            sb.append(" (").append(this.name).append(')');
        }
        return sb.toString();
    }

    @Override
    @Trivial
    public Date getNextExecutionTime() {
        Date time;
        Date date = time = (this.state & TaskState.ENDED.bit) == 0 ? new Date(this.nextExecutionTime) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)Utils.appendDate(new StringBuilder("getNextExecutionTime "), time == null ? null : Long.valueOf(time.getTime())).toString(), (Object[])new Object[0]);
        }
        return time;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public T getResult() throws ExecutionException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getResult", (Object[])new Object[0]);
        }
        Exception failure = null;
        Object instance = null;
        if ((this.state & TaskState.UNATTEMPTED.bit) == 0) {
            if ((this.state & TaskState.CANCELED.bit) != 0) {
                failure = new CancellationException();
            } else if ((this.state & TaskState.SKIPPED.bit) != 0 && (this.state & TaskState.SKIPRUN_FAILED.bit) == 0) {
                failure = new SkippedException();
            } else if (this.resultBytes != null) {
                try {
                    ClassLoader loader = this.classLoaderIdentifier == null ? null : this.persistentExecutor.classloaderIdSvc.getClassLoader(this.classLoaderIdentifier);
                    Object result = this.persistentExecutor.deserialize(this.resultBytes, loader);
                    if (result instanceof TaskFailure) {
                        TaskFailure taskFailure = (TaskFailure)result;
                        switch (taskFailure.getReason()) {
                            case 1: {
                                failure = new AbortedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1555.retry.limit.reached", (Object[])new Object[]{this.getIdAndName(), taskFailure.getParameter(0)}), taskFailure.getCause());
                                break;
                            }
                            case 2: {
                                failure = new ResultNotSerializableException(taskFailure.getParameter(0));
                                failure.initCause(taskFailure.getCause());
                                break;
                            }
                            default: {
                                failure = new ExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1554.general.task.failure", (Object[])new Object[]{this.getIdAndName()}), taskFailure.getCause());
                                break;
                            }
                        }
                    } else if (result instanceof TaskSkipped) {
                        failure = new SkippedException(((TaskSkipped)result).getCause());
                    } else {
                        Object newInstance;
                        instance = newInstance = result;
                    }
                }
                catch (ClassNotFoundException loader) {
                    void x;
                    FFDCFilter.processException((Throwable)loader, (String)"com.ibm.ws.concurrent.persistent.internal.TaskStatusImpl", (String)"299", (Object)this, (Object[])new Object[0]);
                    failure = new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1553.result.inaccessible", (Object[])new Object[]{this.persistentExecutor.name, this.getIdAndName()}), (Throwable)x);
                }
                catch (IOException x) {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.persistent.internal.TaskStatusImpl", (String)"301", (Object)this, (Object[])new Object[0]);
                    failure = new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1553.result.inaccessible", (Object[])new Object[]{this.persistentExecutor.name, this.getIdAndName()}), x);
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getResult", (Object)(failure == null ? instance : failure));
        }
        if (failure == null) {
            return (T)instance;
        }
        if (failure instanceof ExecutionException) {
            throw (ExecutionException)failure;
        }
        throw (RuntimeException)failure;
    }

    @Override
    public long getTaskId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.name;
    }

    @Override
    public TimerTrigger getTimer() throws ClassNotFoundException, IOException {
        if (this.triggerBytes == null) {
            return null;
        }
        return (TimerTrigger)this.persistentExecutor.deserialize(this.triggerBytes, InvokerTask.priv.getSystemClassLoader());
    }

    public int hashCode() {
        return (int)(this.id % Integer.MAX_VALUE);
    }

    @Override
    public boolean hasResult() {
        return (this.state & TaskState.UNATTEMPTED.bit) == 0;
    }

    @Override
    public boolean isCancelled() {
        if ((this.state & TaskState.ENDED.bit) == 0) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1550.status.unavailable.until.ended", (Object[])new Object[]{"isCancelled"}));
        }
        return (this.state & TaskState.CANCELED.bit) != 0;
    }

    @Override
    public boolean isDone() {
        if ((this.state & TaskState.ENDED.bit) == 0) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1550.status.unavailable.until.ended", (Object[])new Object[]{"isDone"}));
        }
        return true;
    }

    @Override
    T resultNow() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder output = new StringBuilder(100).append("TaskStatus[").append(this.id).append("]@").append(Integer.toHexString(System.identityHashCode(this)));
        if (this.name != null && this.name.length() > 0) {
            output.append(' ').append(this.name);
        }
        Utils.appendState(output.append(' '), this.state);
        Utils.appendDate(output.append(' '), this.nextExecutionTime);
        return output.toString();
    }
}

