/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.bridge;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.ws.BatchInternalDispatcher;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobOperator;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.rest.bridge.AppModuleContextService;
import com.ibm.ws.jbatch.rest.bridge.BatchContainerAppNotFoundException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={BatchInternalDispatcher.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class BatchInternalDispatcherImpl
implements BatchInternalDispatcher {
    private WSJobOperator wsJobOperator;
    private WSJobRepository jobRepository;
    private AppModuleContextService appModuleContextService;
    private J2EENameFactory j2eeNameFactory;
    private BatchLocationService batchLocationService;
    private static final String MANAGEDTASK_IDENTITY_NAME = "jakarta.enterprise.concurrent.IDENTITY_NAME";
    private static final String ENDPOINT_EXECUTION_WAIT = "com.ibm.ws.jbatch.internal.test.endpoint.execution.wait";
    private static boolean triggerEndpointExecutionWait;
    static final long serialVersionUID = -3615762984180646994L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setWSJobOperator(WSJobOperator ref) {
        this.wsJobOperator = ref;
    }

    @Reference
    protected void setAppModuleContextService(AppModuleContextService appModuleContextService) {
        this.appModuleContextService = appModuleContextService;
    }

    @Reference
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        this.j2eeNameFactory = j2eeNameFactory;
    }

    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        this.batchLocationService = batchLocationService;
    }

    protected J2EEName createJ2EEName(String j2eeName) {
        return this.j2eeNameFactory.create(j2eeName.getBytes(StandardCharsets.UTF_8));
    }

    public Future<?> start(WSJobInstance jobInstance, Properties jobParameters, long executionId) throws JobStartException, JobSecurityException {
        if (triggerEndpointExecutionWait) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.jbatch.rest.bridge.BatchInternalDispatcherImpl", (String)"173", (Object)this, (Object[])new Object[]{jobInstance, jobParameters, executionId});
            }
        }
        J2EEName j2eeName = this.createJ2EEName(jobInstance.getAmcName());
        WSJobOperator proxy = this.createProxyForAppContext(j2eeName, this.wsJobOperator, WSJobOperator.class);
        return (Future)proxy.start(jobInstance, jobParameters, executionId).getValue();
    }

    public void markInstanceExecutionFailed(long instanceId, long executionId) {
        this.jobRepository.updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus(instanceId, executionId, InstanceState.FAILED, BatchStatus.FAILED);
    }

    public WSJobExecution getJobExecution(long executionId) {
        return this.jobRepository.getJobExecution(executionId);
    }

    public WSJobInstance getJobInstance(long instanceId) {
        return this.jobRepository.getJobInstance(instanceId);
    }

    public Future<?> restartInstance(long instanceId, Properties restartParameters, long executionId) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        J2EEName j2eeName = this.createJ2EEName(this.jobRepository.getJobInstance(instanceId).getAmcName());
        WSJobOperator proxy = this.createProxyForAppContext(j2eeName, this.wsJobOperator, WSJobOperator.class);
        return (Future)proxy.restartInstance(instanceId, restartParameters, executionId).getValue();
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException, BatchJobNotLocalException {
        this.batchLocationService.assertIsLocalJobExecution(executionId);
        J2EEName j2eeName = this.createJ2EEName(this.jobRepository.getBatchAppNameFromExecution(executionId));
        WSJobOperator proxy = this.createProxyForAppContext(j2eeName, this.wsJobOperator, WSJobOperator.class);
        proxy.stop(executionId);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T createProxyForAppContext(J2EEName j2eeName, T instance, Class<T> intf) {
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put(MANAGEDTASK_IDENTITY_NAME, "batch.request.app.proxy");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", "batch.runtime");
        try {
            return this.appModuleContextService.createContextualProxy(execProps, j2eeName, instance, intf);
        }
        catch (IllegalStateException illegalStateException) {
            void ise;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.jbatch.rest.bridge.BatchInternalDispatcherImpl", (String)"271", (Object)this, (Object[])new Object[]{j2eeName, instance, intf});
            throw new BatchContainerAppNotFoundException(j2eeName.toString(), "Failed to load the application context for application " + j2eeName.toString() + ". Verify the application is installed.", (Throwable)ise);
        }
        catch (Exception ise) {
            void e;
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.jbatch.rest.bridge.BatchInternalDispatcherImpl", (String)"275", (Object)this, (Object[])new Object[]{j2eeName, instance, intf});
            throw new BatchContainerRuntimeException("Failed to load the application context for application " + j2eeName.toString() + ". Verify the application is installed.", (Throwable)e);
        }
    }

    public Future<?> startPartition(PartitionPlanConfig partitionPlanConfig, Step step, PartitionReplyQueue partitionReplyQueue) {
        J2EEName j2eeName = this.createJ2EEName(this.jobRepository.getBatchAppNameFromExecution(partitionPlanConfig.getTopLevelExecutionId()));
        WSJobOperator proxy = this.createProxyForAppContext(j2eeName, this.wsJobOperator, WSJobOperator.class);
        return proxy.startPartition(partitionPlanConfig, step, partitionReplyQueue);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.bridge.BatchInternalDispatcherImpl", BatchInternalDispatcherImpl.class, (String)"wsbatch", null);
        triggerEndpointExecutionWait = false;
        triggerEndpointExecutionWait = Boolean.getBoolean(ENDPOINT_EXECUTION_WAIT);
    }
}

