/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.tx.remote.DistributableTransaction;
import com.ibm.tx.remote.Vote;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATParticipantState;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.ProtocolServiceWrapper;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WSATUtil;
import com.ibm.ws.wsat.service.WebClient;
import com.ibm.ws.wsat.tm.impl.ParticipantFactoryService;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import jakarta.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProtocolImpl {
    private static final TraceComponent TC = Tr.register(ProtocolImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final ProtocolImpl INSTANCE = new ProtocolImpl();
    private static final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private EndpointReferenceType coordinatorEndpoint;
    private EndpointReferenceType participantEndpoint;
    private static String recoveryId;
    static final long serialVersionUID = -2136197608200222284L;

    public static ProtocolImpl getInstance() {
        if (recoveryId == null) {
            recoveryId = tranService.getRecoveryId();
        }
        return INSTANCE;
    }

    public synchronized void setCoordinatorEndpoint(EndpointReferenceType epr) {
        this.coordinatorEndpoint = epr;
        this.notifyAll();
    }

    public synchronized void setParticipantEndpoint(EndpointReferenceType epr) {
        this.participantEndpoint = epr;
        this.notifyAll();
    }

    public synchronized EndpointReferenceType getCoordinatorEndpoint(String globalId) throws WSATException {
        while (this.coordinatorEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.coordinatorEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"95", (Object)this, (Object[])new Object[]{globalId});
            }
        }
        return this.getEndpoint(this.coordinatorEndpoint, globalId);
    }

    public synchronized EndpointReferenceType getParticipantEndpoint(String globalId) throws WSATException {
        while (this.participantEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.participantEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"108", (Object)this, (Object[])new Object[]{globalId});
            }
        }
        return this.getEndpoint(this.participantEndpoint, globalId);
    }

    private EndpointReferenceType getEndpoint(EndpointReferenceType epr, String ctxId) {
        EndpointReferenceType eprCopy = EndpointReferenceUtils.duplicate((EndpointReferenceType)epr);
        ReferenceParametersType refs = new ReferenceParametersType();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)ctxId));
        String recoveryId = tranService.getRecoveryId();
        if (recoveryId != null && !recoveryId.isEmpty()) {
            refs.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)recoveryId));
        }
        eprCopy.setReferenceParameters(refs);
        return eprCopy;
    }

    @FFDCIgnore(value={WSATException.class})
    public void prepare(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"prepare: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectParticipant(wrapper, WSATParticipantState.PREPARE);
            return;
        }
        String globalId = wrapper.getTxID();
        WSATTransaction tran = WSATTransaction.getTran(globalId);
        if (tran != null) {
            try {
                Vote vote = tran.prepare();
                WSATParticipantState resp = vote == Vote.VoteCommit ? WSATParticipantState.PREPARED : (vote == Vote.VoteReadOnly ? WSATParticipantState.READONLY : WSATParticipantState.ABORTED);
                this.participantResponse(tran, globalId, wrapper.getResponseEpr(), resp);
            }
            catch (WSATException e) {
                this.participantResponse(tran, globalId, wrapper.getResponseEpr(), WSATParticipantState.ROLLBACK);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rerouteToCorrectParticipant(ProtocolServiceWrapper wrapper, WSATParticipantState messageType) throws WSATException {
        String newAddr;
        String globalId;
        block13: {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"REROUTE {0} originally sent to {1}", (Object[])new Object[]{messageType, wrapper.getWsatProperties().get(Names.WSA_TO_QNAME.getLocalPart())});
            }
            globalId = wrapper.getTxID();
            newAddr = null;
            try {
                newAddr = tranService.getAddress(wrapper.getRecoveryID());
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"178", (Object)this, (Object[])new Object[]{wrapper, messageType});
                if (!TC.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)TC, (String)"Can't get address for {0} {1}", (Object[])new Object[]{wrapper.getRecoveryID(), e});
            }
        }
        if (newAddr == null) {
            return;
        }
        String toAddr = WSATUtil.createRedirectAddr(wrapper.getWsatProperties().get(Names.WSA_TO_QNAME.getLocalPart()), newAddr);
        EndpointReferenceType toEpr = WSATUtil.createEpr(toAddr);
        ReferenceParametersType refs = toEpr.getReferenceParameters();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)globalId));
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)wrapper.getRecoveryID()));
        toEpr.setReferenceParameters(refs);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"{0} needs to go to\n{1}", (Object[])new Object[]{messageType, DebugUtils.printEPR(toEpr)});
        }
        String partId = null;
        for (Object obj : wrapper.getResponseEpr().getReferenceParameters().getAny()) {
            try {
                Element name = (Element)obj;
                if (!Constants.WS_WSAT_PART_REF.getLocalPart().equals(name.getLocalName()) || !Constants.WS_WSAT_PART_REF.getNamespaceURI().equals(name.getNamespaceURI())) continue;
                partId = name.getFirstChild().getNodeValue();
            }
            catch (Throwable name) {
                FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"208", (Object)this, (Object[])new Object[]{wrapper, messageType});
            }
        }
        WSATCoordinator coord = new WSATCoordinator(globalId, wrapper.getResponseEpr());
        WSATParticipant part = new WSATParticipant(globalId, partId, toEpr);
        WebClient webClient = WebClient.getWebClient(part, coord);
        webClient.setMisrouting(false);
        switch (messageType) {
            case PREPARE: {
                webClient.prepare();
                break;
            }
            case COMMIT: {
                webClient.commit();
                break;
            }
            case ROLLBACK: {
                webClient.rollback();
            }
        }
    }

    public void commit(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"commit: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectParticipant(wrapper, WSATParticipantState.COMMIT);
            return;
        }
        String globalId = wrapper.getTxID();
        WSATTransaction tran = WSATTransaction.getTran(globalId);
        DistributableTransaction t = null;
        if (tran != null) {
            tran.commit();
        } else {
            t = tranService.getRemoteTranMgr().getTransactionForID(globalId);
        }
        if (t != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Participant is probably still in replay. Coordinator can retry later: {0}", (Object[])new Object[]{t});
            }
        } else {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"No sign of this subordinate. Assume it committed", (Object[])new Object[0]);
            }
            this.participantResponse(tran, globalId, wrapper.getResponseEpr(), WSATParticipantState.COMMITTED);
        }
    }

    @FFDCIgnore(value={WSATException.class})
    public void rollback(ProtocolServiceWrapper wrapper) throws WSATException {
        WSATTransaction tran;
        String globalId;
        block5: {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"rollback: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
            }
            if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
                this.rerouteToCorrectParticipant(wrapper, WSATParticipantState.ROLLBACK);
                return;
            }
            globalId = wrapper.getTxID();
            tran = WSATTransaction.getTran(globalId);
            if (tran != null) {
                try {
                    tran.rollback();
                }
                catch (WSATException e) {
                    if (!TC.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)TC, (String)"Transaction is probably gone already: {0}", (Object[])new Object[]{e});
                }
            }
        }
        this.participantResponse(tran, globalId, wrapper.getResponseEpr(), WSATParticipantState.ABORTED);
    }

    private void coordinatorResponse(ProtocolServiceWrapper wrapper, WSATParticipantState response) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"From EPR address: {0}", (Object[])new Object[]{wrapper.getResponseEpr().getAddress().getValue()});
            Tr.debug((TraceComponent)TC, (String)"Coordinator Endpoint: {0}", (Object[])new Object[]{this.coordinatorEndpoint.getAddress().getValue()});
            Tr.debug((TraceComponent)TC, (String)"From EPR address: {0}", (Object[])new Object[]{this.participantEndpoint.getAddress().getValue()});
        }
        WSATParticipant part = new WSATParticipant(wrapper.getTxID(), wrapper.getPartID(), wrapper.getResponseEpr());
        WSATCoordinator coord = new WSATCoordinator(wrapper.getTxID(), this.coordinatorEndpoint);
        coord.setParticipant(part);
        part.setCoordinator(coord);
        WebClient client = WebClient.getWebClient(part, coord);
        client.rollback();
    }

    private void participantResponse(WSATTransaction tran, String globalId, EndpointReferenceType fromEpr, WSATParticipantState response) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"EPR:\n{0}", (Object[])new Object[]{DebugUtils.printEPR(fromEpr)});
        }
        WSATCoordinator coord = null;
        if (tran != null) {
            coord = tran.getCoordinator();
        } else if (fromEpr != null) {
            coord = new WSATCoordinator(globalId, fromEpr);
        }
        if (coord != null) {
            WebClient client = WebClient.getWebClient(coord, coord.getParticipant());
            if (response == WSATParticipantState.PREPARED) {
                client.prepared();
            } else if (response == WSATParticipantState.COMMITTED) {
                client.committed();
            } else if (response == WSATParticipantState.READONLY) {
                client.readOnly();
            } else {
                client.aborted();
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Unable to find response coordinator", (Object[])new Object[0]);
        }
    }

    public void prepared(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"prepared: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectCoordinator(wrapper, WSATParticipantState.PREPARED);
        } else {
            WSATParticipant participant = this.findParticipant(wrapper.getTxID(), wrapper.getPartID());
            if (participant != null) {
                participant.setResponse(WSATParticipantState.PREPARED);
            } else {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Unsolicited PREPARED received: {0}/{1}/{2}. Replaying completion", (Object[])new Object[]{wrapper.getTxID(), wrapper.getPartID(), wrapper.getResponseEpr().getAddress().getValue()});
                }
                ParticipantFactoryService.putRecoveryAddress(wrapper.getTxID(), wrapper.getPartID(), wrapper.getResponseEpr());
                if (!tranService.replayCompletion(wrapper.getTxID()) && TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Couldn't find tran. Need to send rollback", (Object[])new Object[0]);
                    this.coordinatorResponse(wrapper, WSATParticipantState.ROLLBACK);
                }
            }
        }
    }

    public void readOnly(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"readOnly: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectCoordinator(wrapper, WSATParticipantState.READONLY);
        } else {
            WSATParticipant participant = this.findParticipant(wrapper.getTxID(), wrapper.getPartID());
            if (participant != null) {
                participant.setResponse(WSATParticipantState.READONLY);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rerouteToCorrectCoordinator(ProtocolServiceWrapper wrapper, WSATParticipantState messageType) throws WSATException {
        String newAddr;
        String globalId;
        block10: {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"REROUTE {0} originally sent to {1}", (Object[])new Object[]{messageType, wrapper.getWsatProperties().get(Names.WSA_TO_QNAME.getLocalPart())});
            }
            globalId = wrapper.getTxID();
            newAddr = null;
            try {
                newAddr = tranService.getAddress(wrapper.getRecoveryID());
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsat.service.impl.ProtocolImpl", (String)"411", (Object)this, (Object[])new Object[]{wrapper, messageType});
                if (!TC.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)TC, (String)"Can't get address for {0} {1}", (Object[])new Object[]{wrapper.getRecoveryID(), e});
            }
        }
        if (newAddr == null) {
            return;
        }
        String toAddr = WSATUtil.createRedirectAddr(wrapper.getWsatProperties().get(Names.WSA_TO_QNAME.getLocalPart()), newAddr);
        EndpointReferenceType toEpr = WSATUtil.createEpr(toAddr);
        ReferenceParametersType refs = toEpr.getReferenceParameters();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)globalId));
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_PART_REF, String.class, (Object)wrapper.getPartID()));
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)wrapper.getRecoveryID()));
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"REROUTE {0} needs to go to\n{1}", (Object[])new Object[]{messageType, DebugUtils.printEPR(toEpr)});
        }
        WSATCoordinator coord = new WSATCoordinator(globalId, toEpr);
        WebClient webClient = WebClient.getWebClient(coord, null);
        webClient.setMisrouting(false);
        switch (messageType) {
            case PREPARED: {
                webClient.prepared();
                break;
            }
            case COMMITTED: {
                webClient.committed();
                break;
            }
            case READONLY: {
                webClient.readOnly();
                break;
            }
            default: {
                webClient.aborted();
            }
        }
    }

    public void aborted(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"aborted: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectCoordinator(wrapper, WSATParticipantState.ABORTED);
        } else {
            WSATParticipant participant = this.findParticipant(wrapper.getTxID(), wrapper.getPartID());
            if (participant != null) {
                participant.setResponse(WSATParticipantState.ABORTED);
            }
        }
    }

    public void committed(ProtocolServiceWrapper wrapper) throws WSATException {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"committed: recoveryId={0}, incoming={1}", (Object[])new Object[]{recoveryId, wrapper.getRecoveryID()});
        }
        if (recoveryId != null && wrapper.getRecoveryID() != null && !recoveryId.equals(wrapper.getRecoveryID())) {
            this.rerouteToCorrectCoordinator(wrapper, WSATParticipantState.COMMITTED);
        } else {
            WSATParticipant participant = this.findParticipant(wrapper.getTxID(), wrapper.getPartID());
            if (participant != null) {
                participant.setResponse(WSATParticipantState.COMMITTED);
            }
        }
    }

    private WSATParticipant findParticipant(String globalId, String partId) {
        WSATParticipant participant = null;
        WSATCoordinatorTran wsatTran = WSATTransaction.getCoordTran(globalId);
        if (wsatTran != null) {
            participant = wsatTran.getParticipant(partId);
            if (participant == null && TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Unable to find participant for transaction: {0}/{1}", (Object[])new Object[]{globalId, partId});
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Unable to find transaction: {0}", (Object[])new Object[]{globalId});
        }
        return participant;
    }
}

