/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.WSSecurityPolicyException;
import com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyCallerInterceptor;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.PolicyUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.processor.UsernameTokenProcessor;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UsernameTokenInterceptor
extends org.apache.cxf.ws.security.wss4j.UsernameTokenInterceptor {
    protected static final TraceComponent tc = Tr.register(UsernameTokenInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final long serialVersionUID = -5509043952347295870L;

    public UsernameTokenInterceptor() {
        this.addBefore(WSSecurityLibertyCallerInterceptor.class.getName());
    }

    protected WSSecurityEngineResult validateToken(Element tokenElement, final SoapMessage message) throws WSSecurityException, Base64DecodingException {
        boolean bspCompliant = this.isWsiBSPCompliant(message);
        boolean allowNoPassword = this.isAllowNoPassword((AssertionInfoMap)message.get(AssertionInfoMap.class));
        UsernameTokenProcessor p = new UsernameTokenProcessor();
        Object nt = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" validateToken" + tokenElement.toString()), (Object[])new Object[0]);
        }
        RequestData data = new RequestData(){
            static final long serialVersionUID = -6118596239391109734L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public CallbackHandler getCallbackHandler() {
                return UsernameTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                Object validator = message.getContextualProperty("ws-security.ut.validator");
                if (validator == null) {
                    return super.getValidator(qName);
                }
                return (Validator)validator;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor$1", 1.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
            }
        };
        ReplayCache nonceCache = WSS4JUtils.getReplayCache((SoapMessage)message, (String)"ws-security.enable.nonce.cache", (String)"ws-security.nonce.cache.instance");
        data.setNonceReplayCache(nonceCache);
        data.setAllowUsernameTokenNoPassword(allowNoPassword);
        data.setWssConfig(WSSConfig.getNewInstance());
        if (!bspCompliant) {
            data.setDisableBSPEnforcement(true);
        }
        data.setMsgContext((Object)message);
        this.translateSettingsFromMsgContext(data, message);
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        data.setWsDocInfo(wsDocInfo);
        List results = p.handleToken(tokenElement, data);
        this.checkTokens(message, results);
        return (WSSecurityEngineResult)results.get(0);
    }

    private boolean isAllowNoPassword(AssertionInfoMap aim) throws WSSecurityException {
        Collection ais = PolicyUtils.getAllAssertionsByLocalname((AssertionInfoMap)aim, (String)"UsernameToken");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                UsernameToken policy = (UsernameToken)ai.getAssertion();
                if (policy.getPasswordType() != UsernameToken.PasswordType.NoPassword) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private CallbackHandler getCallback(@Sensitive SoapMessage message) {
        Object o = Utils.getSecurityPropertyValue("security.callback-handler", message);
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"147", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception while getCallback handler :" + e), (Object[])new Object[0]);
                }
                handler = null;
            }
        }
        return handler;
    }

    protected WSSecUsernameToken addUsernameToken(@Sensitive SoapMessage message, Document doc, @Sensitive UsernameToken token) {
        WSSConfig wssConfig;
        String userName = null;
        Object o = Utils.getSecurityPropertyValue("security.username", message);
        if (o != null) {
            userName = (String)o;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add usernameToken" + userName), (Object[])new Object[0]);
        }
        if ((wssConfig = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName())) == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        if (!StringUtils.isEmpty((String)userName)) {
            boolean isNoPassword = UsernameToken.PasswordType.NoPassword.equals((Object)token.getPasswordType());
            boolean isPasswordHashed = UsernameToken.PasswordType.HashPassword.equals((Object)token.getPasswordType());
            if (isNoPassword) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(doc);
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                if (token.isCreated() && !isPasswordHashed) {
                    utBuilder.addCreated();
                }
                if (token.isNonce() && !isPasswordHashed) {
                    utBuilder.addNonce();
                }
                return utBuilder;
            }
            o = Utils.getSecurityPropertyValue("security.password", message);
            String password = null;
            if (o != null) {
                password = (String)o;
            }
            if (StringUtils.isEmpty(password)) {
                password = this.getPassword(userName, (AbstractToken)token, 2, message);
            }
            if (!StringUtils.isEmpty((String)password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(doc);
                if (isPasswordHashed) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addUsernameToken, " + userName), (Object[])new Object[0]);
                }
                if (token.isCreated() && !isPasswordHashed) {
                    utBuilder.addCreated();
                }
                if (token.isNonce() && !isPasswordHashed) {
                    utBuilder.addNonce();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addUsernameToken returns, " + utBuilder), (Object[])new Object[0]);
                }
                return utBuilder;
            }
            this.policyNotAsserted((AbstractToken)token, "No username available", message);
        } else {
            this.policyNotAsserted((AbstractToken)token, "No username available", message);
        }
        return null;
    }

    public boolean checkTokens(@Sensitive SoapMessage message, List<WSSecurityEngineResult> utResults) throws WSSecurityException {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ais in checkTokens is '" + ais + "'"), (Object[])new Object[0]);
        }
        UsernameToken usernameTokenPolicy = null;
        Object[] aiArray = ais.toArray();
        AssertionInfo ai = null;
        if (aiArray.length > 0) {
            ai = (AssertionInfo)aiArray[0];
            usernameTokenPolicy = (UsernameToken)ai.getAssertion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ai in checkTokens is '" + ai + "'"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("usernameTokenPolicy is '" + usernameTokenPolicy + "'"), (Object[])new Object[0]);
        }
        boolean bOk = true;
        LinkedHashSet<String> msgs = new LinkedHashSet<String>();
        for (WSSecurityEngineResult result : utResults) {
            String strErr;
            boolean isNoPassword;
            boolean isPasswordHashed;
            org.apache.wss4j.dom.message.token.UsernameToken usernameToken = (org.apache.wss4j.dom.message.token.UsernameToken)result.get((Object)"username-token");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("usernameToken is '" + usernameToken + "'"), (Object[])new Object[0]);
            }
            if ((isPasswordHashed = UsernameToken.PasswordType.HashPassword.equals((Object)usernameTokenPolicy.getPasswordType())) != usernameToken.isHashed()) {
                String strErr2 = "Password hashing policy not enforced";
                msgs.add(strErr2);
                bOk = false;
            }
            if ((isNoPassword = UsernameToken.PasswordType.NoPassword.equals((Object)usernameTokenPolicy.getPasswordType())) && usernameToken.getPassword() != null) {
                strErr = "Username Token NoPassword policy not enforced";
                msgs.add(strErr);
                bOk = false;
            }
            if (usernameTokenPolicy.isCreated() && (usernameToken.getCreated() == null || usernameToken.isHashed())) {
                strErr = "Username Token Created policy not enforced";
                msgs.add(strErr);
                bOk = false;
            }
            if (!usernameTokenPolicy.isNonce() || usernameToken.getNonce() != null && !usernameToken.isHashed()) continue;
            strErr = "Username Token Nonce policy not enforced";
            msgs.add(strErr);
            bOk = false;
        }
        if (!bOk) {
            WSSecurityPolicyException wsse = new WSSecurityPolicyException(((Object)msgs).toString());
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)wsse);
        }
        return true;
    }

    void translateSettingsFromMsgContext(RequestData reqData, @Sensitive SoapMessage message) {
        WSSConfig wssConfig = reqData.getWssConfig();
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
            reqData.setWssConfig(wssConfig);
        }
        Object mc = reqData.getMsgContext();
        reqData.setUtTTL(this.decodeTimeToLive(reqData, message, false));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unt TTL '" + reqData.getUtTTL() + "'"), (Object[])new Object[0]);
        }
        reqData.setUtFutureTTL(this.decodeFutureTimeToLive(reqData, message, false));
        reqData.setWssConfig(wssConfig);
    }

    /*
     * WARNING - void declaration
     */
    public int decodeTimeToLive(RequestData reqData, @Sensitive SoapMessage message, boolean timestamp) {
        String tag = "ws-security.timestamp.timeToLive";
        if (!timestamp) {
            tag = "ws-security.usernametoken.timeToLive";
        }
        String ttl = (String)message.getContextualProperty(tag);
        int ttlI = 0;
        if (ttl != null) {
            try {
                ttlI = Integer.parseInt(ttl);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[3];
                objectArray[0] = reqData;
                objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                objectArray[2] = timestamp;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"339", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("ttl string is malformat '" + ttl + "'" + e.getMessage()), (Object[])new Object[0]);
                }
                ttlI = timestamp ? reqData.getTimeStampTTL() : reqData.getUtTTL();
            }
        }
        if (ttlI <= 0) {
            ttlI = timestamp ? reqData.getTimeStampTTL() : reqData.getUtTTL();
        }
        return ttlI;
    }

    /*
     * WARNING - void declaration
     */
    protected int decodeFutureTimeToLive(RequestData reqData, @Sensitive SoapMessage message, boolean timestamp) {
        String tag = "ws-security.timestamp.futureTimeToLive";
        if (!timestamp) {
            tag = "ws-security.usernametoken.futureTimeToLive";
        }
        String ttl = (String)message.getContextualProperty(tag);
        int defaultFutureTimeToLive = 60;
        if (ttl != null) {
            try {
                int ttlI = Integer.parseInt(ttl);
                if (ttlI < 0) {
                    return defaultFutureTimeToLive;
                }
                return ttlI;
            }
            catch (NumberFormatException ttlI) {
                Object[] objectArray = new Object[3];
                objectArray[0] = reqData;
                objectArray[1] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                objectArray[2] = timestamp;
                FFDCFilter.processException((Throwable)ttlI, (String)"com.ibm.ws.wssecurity.cxf.interceptor.UsernameTokenInterceptor", (String)"374", (Object)((Object)this), (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("future ttl string is malformat '" + ttl + "'" + e.getMessage()), (Object[])new Object[0]);
                }
                return defaultFutureTimeToLive;
            }
        }
        return defaultFutureTimeToLive;
    }
}

