/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.ws.wssecurity.cxf.interceptor.WSSecurityLibertyPluginInterceptor;
import com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecurityConfiguration
implements ConfigurationListener {
    private static final TraceComponent tc = Tr.register(WSSecurityConfiguration.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    protected volatile ConfigurationAdmin configAdmin;
    private volatile SecurityService securityService;
    static final String KEY_ID = "id";
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_PASSWORD = "password";
    static final String CFG_KEY_PASSWORD_VALUE = "value";
    static final String CFG_KEY_CALLBACK = "callback";
    static final String CFG_KEY_NAME = "name";
    static final String CFG_KEY_PROVIDER = "provider";
    static final String CFG_KEY_ENTRY = "entry";
    static final String CFG_KEY_ENTRY_KEY = "key";
    static final String CFG_KEY_ENTRY_VALUE = "value";
    static final String[] SPECIAL_CFG_KEYS = new String[]{"component.name", "component.id", "config.source", "config.id", "id", "service.vendor", "service.factoryPid", "service.pid"};
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    static final String KEY_samlToken = "samlToken";
    static final String KEY_wantAssertionsSigned = "wantAssertionsSigned";
    static final String KEY_clockSkew = "clockSkew";
    static final String KEY_requiredSubjectConfirmationMethod = "requiredSubjectConfirmationMethod";
    static final String KEY_timeToLive = "timeToLive";
    static final String KEY_audienceRestrictions = "audienceRestrictions";
    static Map<String, String> subjectConfirmationMethods = new HashMap<String, String>();
    private volatile String cfgCallback;
    private volatile Map<String, Object> defaultConfigMap = Collections.synchronizedMap(new HashMap());
    private volatile Map<String, Object> properties;
    private final Set<String> pids = new HashSet<String>();
    private volatile Map<String, Object> samlTokenConfigMap = null;
    private volatile Map<String, Object> defaultSamlTokenConfigMap = null;
    static final long serialVersionUID = 7435720178429061485L;

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        if (this.configAdmin == configAdmin) {
            this.configAdmin = null;
        }
    }

    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected void unsetSecurityService(SecurityService securityService) {
        if (this.securityService == securityService) {
            this.securityService = null;
        }
    }

    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedtSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetSslSupport service.pid:" + ref.getProperty("service.pid")), (Object[])new Object[0]);
        }
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        this.properties = properties;
        this.internalModify();
        UsernameTokenValidator.setSecurityService(this.securityService);
    }

    protected void modified(ComponentContext cc, Map<String, Object> newProperties) {
        this.properties = newProperties;
        this.internalModify();
    }

    protected void deactivate(ComponentContext cc) {
        this.keyStoreServiceRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        UsernameTokenValidator.setSecurityService(null);
        WSSecurityLibertyPluginInterceptor.setBindingsConfiguration(null);
        WSSecurityLibertyPluginInterceptor.setSamlTokenConfiguration(null);
        this.cfgCallback = null;
        this.defaultConfigMap.clear();
        if (this.defaultSamlTokenConfigMap == null) {
            this.defaultSamlTokenConfigMap = this.processDefaultSamlToken();
        }
        this.samlTokenConfigMap = this.defaultSamlTokenConfigMap;
    }

    private synchronized void internalModify() {
        this.cfgCallback = null;
        this.defaultConfigMap.clear();
        this.setAndValidateProperties();
        WSSecurityLibertyPluginInterceptor.setBindingsConfiguration(this.defaultConfigMap);
        try {
            this.processSamlToken();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"206", (Object)this, (Object[])new Object[0]);
        }
        WSSecurityLibertyPluginInterceptor.setSamlTokenConfiguration(this.samlTokenConfigMap);
    }

    /*
     * WARNING - void declaration
     */
    void processSamlToken() {
        block5: {
            String samlToken = (String)this.properties.get(KEY_samlToken);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"samlToken pid:", (Object[])new Object[]{samlToken});
            }
            if (samlToken == null || samlToken.isEmpty()) {
                if (this.defaultSamlTokenConfigMap == null) {
                    this.defaultSamlTokenConfigMap = this.processDefaultSamlToken();
                }
                this.samlTokenConfigMap = this.defaultSamlTokenConfigMap;
                return;
            }
            try {
                Map<String, Object> samlTokenConfigMap = this.processSamlToken(samlToken);
                this.samlTokenConfigMap = Collections.unmodifiableMap(samlTokenConfigMap);
            }
            catch (Exception samlTokenConfigMap) {
                void e;
                FFDCFilter.processException((Throwable)samlTokenConfigMap, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"232", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Failed to initialize saml token configuration data: ", (Object[])new Object[]{samlToken, e});
            }
        }
    }

    Map<String, Object> processDefaultSamlToken() {
        HashMap<String, Object> samlTokenConfigMap = new HashMap<String, Object>();
        samlTokenConfigMap.put(KEY_wantAssertionsSigned, true);
        samlTokenConfigMap.put(KEY_clockSkew, 300L);
        String shortMethod = "bearer";
        samlTokenConfigMap.put(KEY_requiredSubjectConfirmationMethod, subjectConfirmationMethods.get(shortMethod));
        samlTokenConfigMap.put(KEY_timeToLive, 1800L);
        samlTokenConfigMap.put(KEY_audienceRestrictions, null);
        return Collections.unmodifiableMap(samlTokenConfigMap);
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Object> processSamlToken(String samlToken) throws Exception {
        HashMap<String, Object> samlTokenConfigMap = new HashMap<String, Object>();
        Configuration config = null;
        try {
            config = this.configAdmin.getConfiguration(samlToken);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"263", (Object)this, (Object[])new Object[]{samlToken});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid saml websso trust engine configuration", (Object[])new Object[]{samlToken});
            }
            return samlTokenConfigMap;
        }
        Dictionary samlTokenProps = config.getProperties();
        samlTokenConfigMap.put(KEY_wantAssertionsSigned, samlTokenProps.get(KEY_wantAssertionsSigned));
        samlTokenConfigMap.put(KEY_clockSkew, (Long)samlTokenProps.get(KEY_clockSkew) / 1000L);
        String shortMethod = this.trim((String)samlTokenProps.get(KEY_requiredSubjectConfirmationMethod));
        if (!"bearer".equalsIgnoreCase(shortMethod)) {
            shortMethod = "bearer";
        }
        samlTokenConfigMap.put(KEY_requiredSubjectConfirmationMethod, subjectConfirmationMethods.get(shortMethod));
        samlTokenConfigMap.put(KEY_timeToLive, (Long)samlTokenProps.get(KEY_timeToLive) / 1000L);
        String[] audienceRestrictions = this.trim((String[])samlTokenProps.get(KEY_audienceRestrictions));
        if (audienceRestrictions != null) {
            int iI;
            for (iI = 0; iI < audienceRestrictions.length; ++iI) {
                try {
                    audienceRestrictions[iI] = URLDecoder.decode(audienceRestrictions[iI], "UTF-8");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("audienceRestriction[" + iI + "] = " + audienceRestrictions[iI]), (Object[])new Object[0]);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    void e;
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"291", (Object)this, (Object[])new Object[]{samlToken});
                    throw new Exception((Throwable)e);
                }
            }
            if (iI == 0) {
                audienceRestrictions = null;
            }
        }
        samlTokenConfigMap.put(KEY_audienceRestrictions, audienceRestrictions);
        return samlTokenConfigMap;
    }

    /*
     * WARNING - void declaration
     */
    private void setAndValidateProperties() {
        this.pids.clear();
        String id = (String)this.properties.get(KEY_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Default config id = ", (Object[])new Object[]{id});
        }
        Set<Map.Entry<String, Object>> entrySet = this.properties.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object encProp;
            Object sigProp;
            String key;
            int n;
            String entry_key = entry.getKey();
            if ("signatureProperties".equals(entry_key)) {
                try {
                    String sigPropsConfigPid = (String)entry.getValue();
                    this.pids.add(sigPropsConfigPid);
                    Map<String, Object> signaturePropertyMap = this.convertToMap(sigPropsConfigPid);
                    if (signaturePropertyMap != null && !signaturePropertyMap.isEmpty()) {
                        String[] stringArray = SPECIAL_CFG_KEYS;
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            key = stringArray[n];
                            signaturePropertyMap.remove(key);
                        }
                        if (this.newConfigSpecified(signaturePropertyMap)) {
                            signaturePropertyMap.remove("org.apache.ws.security.crypto.provider");
                            signaturePropertyMap.putIfAbsent("org.apache.wss4j.crypto.provider", "org.apache.wss4j.common.crypto.Merlin");
                            this.defaultConfigMap.put("security.signature.properties", signaturePropertyMap);
                        } else {
                            this.defaultConfigMap.put("ws-security.signature.properties", signaturePropertyMap);
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        sigProp = signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.type") != null ? signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.type") : signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.type");
                        Tr.debug((TraceComponent)tc, (String)"signature configuration type = ", (Object[])new Object[]{sigProp});
                        sigProp = signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.alias") != null ? signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.alias") : signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.alias");
                        Tr.debug((TraceComponent)tc, (String)"signature configuration alias = ", (Object[])new Object[]{sigProp});
                        sigProp = signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.file") != null ? signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.file") : signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.file");
                        Tr.debug((TraceComponent)tc, (String)"signature configuration ks file = ", (Object[])new Object[]{sigProp});
                        sigProp = signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.password") != null ? signaturePropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.password") : signaturePropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.password");
                        Tr.debug((TraceComponent)tc, (String)"signature configuration password = ", (Object[])new Object[]{sigProp});
                        sigProp = signaturePropertyMap.get("org.apache.wss4j.crypto.provider") != null ? signaturePropertyMap.get("org.apache.wss4j.crypto.provider") : signaturePropertyMap.get("org.apache.ws.security.crypto.provider");
                        Tr.debug((TraceComponent)tc, (String)"signature configuration provider = ", (Object[])new Object[]{sigProp});
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Empty ws-security provider signature configuration ", (Object[])new Object[]{sigPropsConfigPid});
                }
                catch (IOException sigPropsConfigPid) {
                    void e;
                    FFDCFilter.processException((Throwable)sigPropsConfigPid, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"362", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid ws-security provider signature configuration: " + e), (Object[])new Object[0]);
                }
                continue;
            }
            if ("encryptionProperties".equals(entry_key)) {
                try {
                    String encPropsConfigPid = (String)entry.getValue();
                    this.pids.add(encPropsConfigPid);
                    Map<String, Object> encryptionPropertyMap = this.convertToMap(encPropsConfigPid);
                    if (encryptionPropertyMap != null && !encryptionPropertyMap.isEmpty()) {
                        sigProp = SPECIAL_CFG_KEYS;
                        int n3 = ((String[])sigProp).length;
                        for (n = 0; n < n3; ++n) {
                            key = sigProp[n];
                            encryptionPropertyMap.remove(key);
                        }
                        if (this.newConfigSpecified(encryptionPropertyMap)) {
                            encryptionPropertyMap.remove("org.apache.ws.security.crypto.provider");
                            encryptionPropertyMap.putIfAbsent("org.apache.wss4j.crypto.provider", "org.apache.wss4j.common.crypto.Merlin");
                            this.defaultConfigMap.put("security.encryption.properties", encryptionPropertyMap);
                        } else {
                            this.defaultConfigMap.put("ws-security.encryption.properties", encryptionPropertyMap);
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        encProp = encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.type") != null ? encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.type") : encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.type");
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration type = ", (Object[])new Object[]{encProp});
                        encProp = encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.alias") != null ? encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.alias") : encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.alias");
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration alias = ", (Object[])new Object[]{encProp});
                        encProp = encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.file") != null ? encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.file") : encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.file");
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration ks file = ", (Object[])new Object[]{encProp});
                        encProp = encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.password") != null ? encryptionPropertyMap.get("org.apache.wss4j.crypto.merlin.keystore.password") : encryptionPropertyMap.get("org.apache.ws.security.crypto.merlin.keystore.password");
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration password = ", (Object[])new Object[]{encProp});
                        encProp = encryptionPropertyMap.get("org.apache.wss4j.crypto.provider") != null ? encryptionPropertyMap.get("org.apache.wss4j.crypto.provider") : encryptionPropertyMap.get("org.apache.ws.security.crypto.provider");
                        Tr.debug((TraceComponent)tc, (String)"encryption configuration provider = ", (Object[])new Object[]{encProp});
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Empty ws-security provider encryption configuration ", (Object[])new Object[]{encPropsConfigPid});
                }
                catch (IOException encPropsConfigPid) {
                    void e;
                    FFDCFilter.processException((Throwable)encPropsConfigPid, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"409", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid ws-security provider encryption configuration: " + e), (Object[])new Object[0]);
                }
                continue;
            }
            if ("callerToken".equals(entry_key)) {
                try {
                    String[] callerConfig = (String[])entry.getValue();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        for (int len = callerConfig.length; len > 0; --len) {
                            Tr.debug((TraceComponent)tc, (String)"caller configuration  = ", (Object[])new Object[]{callerConfig[len - 1]});
                        }
                    }
                    this.pids.add(callerConfig[0]);
                    Map<String, Object> callerConfigMap = this.convertToMap(callerConfig[0]);
                    if (callerConfigMap != null && !callerConfigMap.isEmpty()) {
                        String callerName;
                        encProp = SPECIAL_CFG_KEYS;
                        int n4 = ((String[])encProp).length;
                        for (n = 0; n < n4; ++n) {
                            key = encProp[n];
                            callerConfigMap.remove(key);
                        }
                        if (callerConfigMap.get(CFG_KEY_NAME) == null || (callerName = (String)callerConfigMap.get(CFG_KEY_NAME)).isEmpty()) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"caller configuration name = ", (Object[])new Object[]{callerName});
                        }
                        if (!("UsernameToken".equalsIgnoreCase(callerName) || "X509Token".equalsIgnoreCase(callerName) || "SamlToken".equalsIgnoreCase(callerName))) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("UsernameToken").append(", ").append("X509Token").append(KEY_samlToken);
                            Tr.error((TraceComponent)tc, (String)"UNKNOWN_CALLER_TOKEN_NAME", (Object[])new Object[]{callerName, sb.toString()});
                        }
                        this.defaultConfigMap.put("callerConfig", callerConfigMap);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Empty ws-security provider caller configuration ", (Object[])new Object[0]);
                }
                catch (IOException callerConfig) {
                    void ioe;
                    FFDCFilter.processException((Throwable)callerConfig, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"457", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid ws-security provider caller configuration: " + ioe), (Object[])new Object[0]);
                }
                continue;
            }
            if (entry_key.startsWith(".") || entry_key.startsWith("config.") || entry_key.startsWith("service.") || entry_key.equals(KEY_ID) || entry_key.startsWith("osgi.ds.")) continue;
            Object entry_value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ws-security provider configuration entry key = ", (Object[])new Object[]{entry_key});
                Tr.debug((TraceComponent)tc, (String)"ws-security provider configuration entry value = ", (Object[])new Object[]{entry_value});
            }
            if (entry_value == null) continue;
            if ("ws-security.cache.config.file".equals(entry_key) || "security.cache.config.file".equals(entry_key)) {
                String cache_file = (String)entry.getValue();
                if (cache_file != null && !cache_file.isEmpty()) {
                    File f = new File(cache_file = cache_file.replace('\\', '/'));
                    if (f.exists()) {
                        StringBuffer sb = new StringBuffer("file:///");
                        sb.append(cache_file);
                        this.defaultConfigMap.put(entry_key, sb.toString());
                    } else {
                        this.defaultConfigMap.put(entry_key, cache_file);
                    }
                }
            } else {
                this.defaultConfigMap.put(entry_key, entry_value);
            }
            if (!"ws-security.callback-handler".equals(entry_key)) continue;
            this.cfgCallback = (String)entry_value;
        }
        if (this.defaultConfigMap.isEmpty()) {
            Tr.info((TraceComponent)tc, (String)"WSSECURITY_NO_CONFIG_DEFINED_PROV", (Object[])new Object[0]);
        }
    }

    private boolean newConfigSpecified(Map<String, Object> propertyMap) {
        Set<String> keys = propertyMap.keySet();
        for (String key : keys) {
            if (!key.contains("org.apache.wss4j.crypto")) continue;
            return true;
        }
        return false;
    }

    String getCallback() {
        return this.cfgCallback;
    }

    Map<String, Object> getDefaultConfiguration() {
        return this.defaultConfigMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> convertToMap(String pid) throws IOException {
        HashMap<String, Object> map;
        block5: {
            map = new HashMap<String, Object>();
            try {
                Configuration config;
                Dictionary dictionary;
                Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null && configs.length != 0 && (dictionary = (config = this.configAdmin.getConfiguration(pid)).getProperties()) != null) {
                    Enumeration keys = dictionary.keys();
                    while (keys.hasMoreElements()) {
                        String strKey = (String)keys.nextElement();
                        map.put(strKey, dictionary.get(strKey));
                    }
                    return map;
                }
            }
            catch (InvalidSyntaxException configs) {
                void e;
                FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.wssecurity.internal.WSSecurityConfiguration", (String)"563", (Object)this, (Object[])new Object[]{pid});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Syntax error accesssing configuration for pid " + pid + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No configuration for pid " + pid), (Object[])new Object[0]);
        }
        return map;
    }

    public synchronized void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && this.pids.contains(event.getPid())) {
            this.internalModify();
        }
    }

    String[] trim(String[] originals) {
        if (originals == null || originals.length == 0) {
            return null;
        }
        String[] tmpResults = new String[originals.length];
        int iCnt = 0;
        for (int iI = 0; iI < originals.length; ++iI) {
            String original = this.trim(originals[iI]);
            if (original == null) continue;
            tmpResults[iCnt++] = original;
        }
        if (iCnt == 0) {
            return null;
        }
        String[] results = new String[iCnt];
        System.arraycopy(tmpResults, 0, results, 0, iCnt);
        return results;
    }

    String trim(String original) {
        if (original == null) {
            return null;
        }
        String result = original.trim();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        subjectConfirmationMethods.put("bearer", "urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subjectConfirmationMethods.put("sender-vouches", "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        subjectConfirmationMethods.put("holder-of-key", "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
    }
}

