/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.util.Optional;
import java.util.logging.Level;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.ValueMember;

final class FVDValueDescriptor
extends ValueDescriptor {
    final FullValueDescription fvd;
    final String repid;

    FVDValueDescriptor(FullValueDescription fvd, Class<?> clazz, TypeRepository rep, String repid, ValueDescriptor super_desc) {
        super(clazz, rep);
        this.repid = repid;
        this.fvd = fvd;
        this.init();
        this._super_descriptor = super_desc;
    }

    @Override
    public void init() {
        super.init();
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
            VerboseLogging.MARSHAL_LOG.finer("Computing field descriptors for " + this.fvd.name + " version " + this.fvd.version);
        }
        ValueMember[] members = this.fvd.members;
        FieldDescriptor[] new_fields = new FieldDescriptor[members.length];
        for (int i = 0; i < members.length; ++i) {
            FieldDescriptor fd;
            ValueMember vm = members[i];
            new_fields[i] = fd = this.findField(vm);
            if (!VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) continue;
            VerboseLogging.MARSHAL_LOG.finer(String.format("\t%s -> %s", FVDValueDescriptor.describe(vm), FVDValueDescriptor.describe(fd)));
        }
        this._fields = new_fields;
    }

    private static String describe(FieldDescriptor fd) {
        return fd == null ? null : String.format("FieldDescriptor[%s in %s]", fd.java_name, Optional.of(fd.declaringClass).map(Class::getName).orElse(""));
    }

    private static String describe(ValueMember vm) {
        return vm == null ? null : String.format("ValueMember[name=\"%s\", id=\"%s\"]", vm.name, vm.id);
    }

    private FieldDescriptor findField(ValueMember valueMember) {
        for (Class c = this.type; c != null; c = c.getSuperclass()) {
            TypeDescriptor td = this.repo.getDescriptor(c);
            if (!(td instanceof ValueDescriptor)) continue;
            ValueDescriptor vd = (ValueDescriptor)td;
            FieldDescriptor[] fds = vd._fields;
            if (fds == null) continue;
            for (FieldDescriptor fd : fds) {
                if (!fd.getIDLName().equals(valueMember.name)) continue;
                return fd;
            }
        }
        String repId = valueMember.id;
        return null;
    }

    @Override
    protected String genRepId() {
        return this.repid;
    }

    @Override
    FullValueDescription getFullValueDescription() {
        return this.fvd;
    }

    @Override
    protected final TypeCode genTypeCode() {
        return this.fvd.type;
    }

    @Override
    public boolean isCustomMarshalled() {
        return this.fvd.is_custom;
    }
}

