/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.LTPAValidationKeysInfo;
import com.ibm.ws.security.token.ltpa.internal.LTPAToken2;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAToken2Factory
implements TokenFactory {
    private static final TraceComponent tc = Tr.register(LTPAToken2Factory.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private long expirationInMinutes;
    private byte[] primarySharedKey;
    private LTPAPublicKey primaryPublicKey;
    private LTPAPrivateKey primaryPrivateKey;
    private List<LTPAValidationKeysInfo> validationKeys;
    private long expDiffAllowed;
    static final long serialVersionUID = -6791362626438004002L;

    public void initialize(@Sensitive Map tokenFactoryMap) {
        this.expirationInMinutes = (Long)tokenFactoryMap.get("expiration");
        this.primarySharedKey = (byte[])tokenFactoryMap.get("primary_ltpa_shared_key");
        this.primaryPublicKey = (LTPAPublicKey)tokenFactoryMap.get("primary_ltpa_public_key");
        this.primaryPrivateKey = (LTPAPrivateKey)tokenFactoryMap.get("primary_ltpa_private_key");
        this.expDiffAllowed = (Long)tokenFactoryMap.get("expirationDifferenceAllowed");
        this.validationKeys = (List)tokenFactoryMap.get("ltpa_validation_keys");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of validationKeys: " + this.validationKeys.size()), (Object[])new Object[0]);
        }
    }

    public Token createToken(Map tokenData) throws TokenCreationFailedException {
        String userUniqueId = this.getUniqueId(tokenData);
        return new LTPAToken2(userUniqueId, this.expirationInMinutes, this.primarySharedKey, this.primaryPrivateKey, this.primaryPublicKey);
    }

    private String getUniqueId(Map tokenData) throws TokenCreationFailedException {
        String userUniqueId = (String)tokenData.get("unique_id");
        if (userUniqueId == null || userUniqueId.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_INVALID_UNIQUE_ID", (Object[])new Object[0]);
            String formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_INVALID_UNIQUE_ID", (Object[])new Object[0]);
            throw new TokenCreationFailedException(formattedMessage);
        }
        return userUniqueId;
    }

    public Token validateTokenBytes(byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        return this.validateTokenBytes(tokenBytes, null);
    }

    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    public Token validateTokenBytes(byte[] tokenBytes, String ... removeAttributes) throws InvalidTokenException, TokenExpiredException {
        LTPAToken2 validatedToken;
        block23: {
            validatedToken = null;
            if (this.primarySharedKey != null && this.primaryPrivateKey != null && this.primaryPublicKey != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"validateTokenBytes with primary keys", (Object[])new Object[0]);
                }
                try {
                    validatedToken = new LTPAToken2(tokenBytes, this.primarySharedKey, this.primaryPrivateKey, this.primaryPublicKey, this.expDiffAllowed, removeAttributes);
                    if (validatedToken != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"validateTokenBytes with primary keys (success)", (Object[])new Object[0]);
                        }
                        return validatedToken;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof TokenExpiredException)) break block23;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validateTokenBytes (expired)");
                    }
                    throw (TokenExpiredException)e;
                }
            }
        }
        if (this.validationKeys != null) {
            Throwable lastException = null;
            Iterator<LTPAValidationKeysInfo> validationKeysIterator = this.validationKeys.iterator();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("go through " + this.validationKeys.size() + " validationKeys"), (Object[])new Object[0]);
            }
            while (validationKeysIterator.hasNext()) {
                LTPAValidationKeysInfo ltpaKeyInfo = validationKeysIterator.next();
                byte[] sharedKeyForValidation = ltpaKeyInfo.getSecretKey();
                LTPAPrivateKey ltpaPrivateKeyForValidation = ltpaKeyInfo.getLTPAPrivateKey();
                LTPAPublicKey ltpaPublicKeyForValidation = ltpaKeyInfo.getLTPAPublicKey();
                if (ltpaKeyInfo.isValidUntilDateExpired()) {
                    validationKeysIterator.remove();
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("validateTokenBytes with validationKeys: " + ltpaKeyInfo), (Object[])new Object[0]);
                }
                if (sharedKeyForValidation == null || ltpaPrivateKeyForValidation == null || ltpaPublicKeyForValidation == null) continue;
                try {
                    validatedToken = new LTPAToken2(tokenBytes, sharedKeyForValidation, ltpaPrivateKeyForValidation, ltpaPublicKeyForValidation, this.expDiffAllowed, removeAttributes);
                    if (validatedToken == null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"validateTokenBytes with validationKeys (success)", (Object[])new Object[0]);
                    }
                    return validatedToken;
                }
                catch (Exception e) {
                    if (e instanceof TokenExpiredException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"validateTokenBytes (expired)");
                        }
                        throw (TokenExpiredException)e;
                    }
                    lastException = e;
                    Tr.debug((TraceComponent)tc, (String)"Exception validating LTPAToken using validation keys.", (Object[])new Object[]{e.getMessage()});
                }
            }
            if (lastException != null && lastException instanceof InvalidTokenException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"validateTokenBytes (invalid token)");
                }
                throw (InvalidTokenException)lastException;
            }
            if (lastException != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("validateTokenBytes (" + lastException.getClass().getName() + ")"));
                }
                throw new InvalidTokenException(lastException.getMessage(), lastException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateTokenBytes (unknown error)");
            }
            throw new InvalidTokenException("Error validating LTPA token.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateTokenBytes (no keys)");
        }
        throw new InvalidTokenException("Token factory not properly initialized.");
    }
}

