/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PeerLeaseData {
    private static final TraceComponent tc = Tr.register(PeerLeaseData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final String _recoveryIdentity;
    private final long _leaseTime;
    private final int _leaseTimeout;
    static final long serialVersionUID = 6465566093042642773L;

    @ManualTrace
    public PeerLeaseData(String recoveryIdentity, long leaseTime, int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PeerLeaseData", (Object[])new Object[]{recoveryIdentity, Utils.traceTime((long)leaseTime), leaseTimeout});
        }
        this._recoveryIdentity = recoveryIdentity;
        this._leaseTime = leaseTime;
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PeerLeaseData");
        }
    }

    @Trivial
    public String getRecoveryIdentity() {
        return this._recoveryIdentity;
    }

    @Trivial
    public long getLeaseTime() {
        return this._leaseTime;
    }

    @Trivial
    public boolean isExpired() {
        long curTime = System.currentTimeMillis();
        if (curTime - this._leaseTime > (long)(this._leaseTimeout * 1000)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Lease for " + this._recoveryIdentity + " expired at " + Utils.traceTime((long)(this._leaseTime + (long)this._leaseTimeout))), (Object[])new Object[0]);
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Lease for " + this._recoveryIdentity + " has not expired. " + (curTime + (long)this._leaseTimeout - this._leaseTime) / 1000L + " seconds left."), (Object[])new Object[0]);
        }
        return false;
    }
}

