/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.ContextBeginnerEnder;
import com.ibm.ws.cdi.liberty.JndiHelperComponentMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextBeginnerEnderImpl
implements ContextBeginnerEnder {
    private static final TraceComponent tc = Tr.register(ContextBeginnerEnderImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private ClassLoader newTheadContextClassLoader = null;
    private ClassLoader oldTheadContextClassLoader = null;
    private JndiHelperComponentMetaData cmd = null;
    private boolean began = false;
    private String cmdLogStringSuffix = "";
    private String tcclLogStringSuffix = "";
    static final long serialVersionUID = 8426615962677129174L;

    public ContextBeginnerEnder extractTCCL(Application application) {
        this.tcclLogStringSuffix = application.getName();
        this.newTheadContextClassLoader = application.getTCCL();
        return this;
    }

    public ContextBeginnerEnder extractComponentMetaData(Application application) throws CDIException {
        if (application.getModuleArchives().size() > 0 && application.getApplicationMetaData() != null) {
            CDIArchive archive = (CDIArchive)application.getModuleArchives().iterator().next();
            this.extractComponentMetaData(archive);
            this.cmdLogStringSuffix = this.cmdLogStringSuffix + " as a stand in for the whole application";
        }
        return this;
    }

    public ContextBeginnerEnder extractComponentMetaData(CDIArchive archive) throws CDIException {
        if (archive.getApplication() == null) {
            return this;
        }
        CDIArchive moduleArchive = null;
        moduleArchive = archive.isModule() ? archive : (CDIArchive)archive.getApplication().getModuleArchives().iterator().next();
        MetaData metaData = moduleArchive.getMetaData();
        ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
        this.cmd = new JndiHelperComponentMetaData(moduleMetaData);
        this.cmdLogStringSuffix = archive.equals(moduleArchive) ? moduleArchive.getName() : moduleArchive.getName() + " as a stand in for " + archive.getName();
        return this;
    }

    public ContextBeginnerEnder beginContext() {
        if (this.began) {
            throw new IllegalStateException("beginContext cannot be called twice");
        }
        this.began = true;
        if (this.cmd != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginContext", (Object[])new Object[]{"setting component medata data using archive: " + this.cmdLogStringSuffix});
            }
            ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            accessor.beginContext((ComponentMetaData)this.cmd);
        }
        if (this.newTheadContextClassLoader != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginContext", (Object[])new Object[]{"setting tccl with classloader for app: " + this.tcclLogStringSuffix});
            }
            this.oldTheadContextClassLoader = CDIUtils.getAndSetLoader((ClassLoader)this.newTheadContextClassLoader);
        }
        return this;
    }

    public void close() {
        if (!this.began) {
            throw new IllegalStateException("close invoked without beginContext");
        }
        if (this.cmd != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginContext", (Object[])new Object[]{"unsetting component medata data for archive: " + this.cmdLogStringSuffix});
            }
            ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            accessor.endContext();
            this.cmd = null;
        }
        if (this.oldTheadContextClassLoader != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginContext", (Object[])new Object[]{"unsetting tccl classloader for app: " + this.tcclLogStringSuffix});
            }
            CDIUtils.getAndSetLoader((ClassLoader)this.oldTheadContextClassLoader);
            this.oldTheadContextClassLoader = null;
        }
    }
}

