/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20EndpointServlet;
import com.ibm.ws.security.openidconnect.web.OidcEndpointServices;
import io.openliberty.security.common.http.SupportedHttpMethodHandler;
import io.openliberty.security.openidconnect.web.OidcSupportedHttpMethodHandler;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcEndpointServlet
extends OAuth20EndpointServlet {
    private static TraceComponent tc = Tr.register(OidcEndpointServlet.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private transient OidcEndpointServices oidcEndpointServices = null;
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient ServiceReference<OidcEndpointServices> oidcEndPointServicesRef = null;
    private static final long serialVersionUID = 1L;

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.oidcEndPointServicesRef = this.bundleContext.getServiceReference(OidcEndpointServices.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.GET)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.POST)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.HEAD)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.DELETE)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isValidHttpMethodForRequest(request, response, SupportedHttpMethodHandler.HttpMethod.PUT)) {
            return;
        }
        this.handleRequest(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OidcSupportedHttpMethodHandler optionsRequestHandler = this.getOidcSupportedHttpMethodHandler(request, response);
        optionsRequestHandler.sendUnsupportedMethodResponse();
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OidcSupportedHttpMethodHandler optionsRequestHandler = this.getOidcSupportedHttpMethodHandler(request, response);
        optionsRequestHandler.sendHttpOptionsResponse();
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getOidcEndpointServices();
        this.oidcEndpointServices.handleOidcRequest(request, response, this.servletContext);
    }

    OidcSupportedHttpMethodHandler getOidcSupportedHttpMethodHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        return new OidcSupportedHttpMethodHandler(request, response, this.getOidcEndpointServices());
    }

    private OidcEndpointServices getOidcEndpointServices() throws ServletException {
        if (this.oidcEndPointServicesRef == null) {
            throw new ServletException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_OSGI_ENDPOINT_SERVICE_ERROR", null, (String)"CWWKS1616E: A configuration error has occurred. No OpenID Connect endpoint service is available. Ensure that you have the openidConnectServer-1.0 feature configured."));
        }
        this.oidcEndpointServices = (OidcEndpointServices)((Object)this.bundleContext.getService(this.oidcEndPointServicesRef));
        return this.oidcEndpointServices;
    }

    private boolean isValidHttpMethodForRequest(HttpServletRequest request, HttpServletResponse response, SupportedHttpMethodHandler.HttpMethod requestMethod) throws IOException, ServletException {
        OidcSupportedHttpMethodHandler optionsRequestHandler = this.getOidcSupportedHttpMethodHandler(request, response);
        if (!optionsRequestHandler.isValidHttpMethodForRequest(requestMethod)) {
            optionsRequestHandler.sendUnsupportedMethodResponse();
            return false;
        }
        return true;
    }
}

