/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.LikeOperator;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.selector.impl.SimpleTestImpl;
import java.util.ArrayList;
import java.util.List;

public final class ConjunctionImpl
implements Conjunction {
    public SimpleTest[] simpleTests;
    public Selector residual;
    public boolean alwaysTrue;
    private List tmpSimpleTests = new ArrayList();
    private List tmpResidual = new ArrayList();

    public ConjunctionImpl(SimpleTest simple) {
        this.tmpSimpleTests.add(simple);
    }

    public ConjunctionImpl(Selector resid) {
        this.tmpResidual.add(resid);
    }

    public ConjunctionImpl() {
        this.alwaysTrue = true;
    }

    public boolean and(SimpleTest newTest) {
        for (int i = 0; i < this.tmpSimpleTests.size(); ++i) {
            SimpleTest cand = (SimpleTest)this.tmpSimpleTests.get(i);
            if (!cand.getIdentifier().getName().equals(newTest.getIdentifier().getName())) continue;
            if (cand.getIdentifier().isExtended()) {
                if (cand.getIdentifier().getStep() != newTest.getIdentifier().getStep()) continue;
                return cand.combine(newTest);
            }
            return cand.combine(newTest);
        }
        this.tmpSimpleTests.add(newTest);
        this.alwaysTrue = false;
        return true;
    }

    public void and(Selector newResid) {
        this.tmpResidual.add(newResid);
        this.alwaysTrue = false;
    }

    public boolean organize() {
        if (this.tmpResidual.size() > 0) {
            List[] equatedIds = this.findEquatedIdentifiers();
            while (equatedIds != null && this.tmpResidual.size() > 0) {
                if ((equatedIds = this.reduceResidual(equatedIds)) == null || equatedIds.length != 0) continue;
                return false;
            }
        }
        int i = 0;
        while (i < this.tmpSimpleTests.size()) {
            if (((SimpleTestImpl)this.tmpSimpleTests.get(i)).shedSubtests(this.tmpResidual)) {
                ++i;
                continue;
            }
            this.tmpSimpleTests.remove(i);
        }
        for (i = 0; i < this.tmpSimpleTests.size() - 1; ++i) {
            for (int j = i + 1; j < this.tmpSimpleTests.size(); ++j) {
                SimpleTest iTest = (SimpleTest)this.tmpSimpleTests.get(i);
                SimpleTest jTest = (SimpleTest)this.tmpSimpleTests.get(j);
                OrdinalPosition iPos = (OrdinalPosition)iTest.getIdentifier().getOrdinalPosition();
                OrdinalPosition jPos = (OrdinalPosition)jTest.getIdentifier().getOrdinalPosition();
                if (jPos.compareTo(iPos) < 0) {
                    this.tmpSimpleTests.set(j, iTest);
                    this.tmpSimpleTests.set(i, jTest);
                    continue;
                }
                if (jTest.getIdentifier().getOrdinalPosition() != iTest.getIdentifier().getOrdinalPosition()) continue;
                throw new IllegalStateException();
            }
        }
        this.simpleTests = this.tmpSimpleTests.toArray(new SimpleTest[0]);
        this.tmpSimpleTests = null;
        for (i = 0; i < this.tmpResidual.size(); ++i) {
            this.residual = this.residual == null ? (Selector)this.tmpResidual.get(i) : new OperatorImpl(46, this.residual, (Selector)this.tmpResidual.get(i));
        }
        this.tmpResidual = null;
        this.alwaysTrue = this.simpleTests.length == 0 && this.residual == null;
        return true;
    }

    private List[] findEquatedIdentifiers() {
        List[] ans = null;
        for (int i = 0; i < this.tmpSimpleTests.size(); ++i) {
            SimpleTest cand = (SimpleTest)this.tmpSimpleTests.get(i);
            if (cand.getKind() == 4) {
                if (ans == null) {
                    ans = new List[]{new ArrayList(), new ArrayList()};
                }
                ans[0].add(cand.getIdentifier().getName());
                ans[1].add(null);
                continue;
            }
            Object candValue = cand.getValue();
            if (candValue == null) continue;
            if (ans == null) {
                ans = new List[]{new ArrayList(), new ArrayList()};
            }
            ans[0].add(cand.getIdentifier().getName());
            ans[1].add(candValue);
        }
        return ans;
    }

    private List[] reduceResidual(List[] equatedIds) {
        List[] ans = null;
        int i = 0;
        while (i < this.tmpResidual.size()) {
            Operator oper = ConjunctionImpl.substitute((Operator)this.tmpResidual.get(i), equatedIds);
            if (oper.getNumIds() > 0 && !Matching.isSimple((Selector)oper)) {
                this.tmpResidual.set(i++, oper);
                continue;
            }
            if (oper.getNumIds() == 1) {
                Selector trans = Matching.getTransformer().DNF((Selector)oper);
                if (trans instanceof Operator && ((Operator)trans).getOp() == 47) {
                    this.tmpResidual.set(i++, oper);
                    continue;
                }
                SimpleTestImpl newTest = new SimpleTestImpl(trans);
                if (!this.and(newTest)) {
                    return new List[0];
                }
                this.tmpResidual.remove(i);
                if (newTest.getKind() == 4) {
                    if (ans == null) {
                        ans = new List[]{new ArrayList(), new ArrayList()};
                    }
                    ans[0].add(newTest.getIdentifier().getName());
                    ans[1].add(null);
                    continue;
                }
                Object newTestValue = newTest.getValue();
                if (newTestValue == null) continue;
                if (ans == null) {
                    ans = new List[]{new ArrayList(), new ArrayList()};
                }
                ans[0].add(newTest.getIdentifier().getName());
                ans[1].add(newTestValue);
                continue;
            }
            Boolean theEval = (Boolean)Matching.getEvaluator().eval((Selector)oper);
            if (theEval == null || !theEval.booleanValue()) {
                return new List[0];
            }
            this.tmpResidual.remove(i);
        }
        return ans;
    }

    private static Operator substitute(Operator oper, List[] equatedIds) {
        Selector op2;
        Selector op1 = oper.getOperands()[0];
        Selector selector = op2 = oper.getOperands().length == 1 ? null : oper.getOperands()[1];
        if (op1 instanceof Identifier) {
            op1 = ConjunctionImpl.substitute((Identifier)op1, equatedIds);
        } else if (op1 instanceof Operator) {
            op1 = ConjunctionImpl.substitute((Operator)op1, equatedIds);
        }
        if (op1 == null) {
            return null;
        }
        if (op2 != null) {
            if (op2 instanceof Identifier) {
                op2 = ConjunctionImpl.substitute((Identifier)op2, equatedIds);
            } else if (op2 instanceof Operator) {
                op2 = ConjunctionImpl.substitute((Operator)op2, equatedIds);
            }
            if (op2 == null) {
                return null;
            }
        }
        if (op1 == oper.getOperands()[0] && (op2 == null || op2 == oper.getOperands()[1])) {
            return oper;
        }
        if (oper instanceof LikeOperator) {
            LikeOperatorImpl loper = (LikeOperatorImpl)oper;
            return new LikeOperatorImpl(loper.getOp(), op1, loper.getInternalPattern(), loper.getPattern(), loper.isEscaped(), loper.getEscape());
        }
        return op2 == null ? new OperatorImpl(oper.getOp(), op1) : new OperatorImpl(oper.getOp(), op1, op2);
    }

    private static Selector substitute(Identifier id, List[] equatedIds) {
        for (int i = 0; i < equatedIds[0].size(); ++i) {
            if (!id.getName().equals(equatedIds[0].get(i))) continue;
            return new LiteralImpl(equatedIds[1].get(i));
        }
        return id;
    }

    public String toString() {
        if (this.simpleTests == null) {
            return "unknown";
        }
        if (this.alwaysTrue) {
            return "true";
        }
        StringBuffer ans = new StringBuffer();
        String delim = "";
        for (int i = 0; i < this.simpleTests.length; ++i) {
            ans.append(delim).append(this.simpleTests[i]);
            delim = " AND ";
        }
        if (this.residual != null) {
            ans.append(delim).append(this.residual);
        }
        return ans.toString();
    }

    public SimpleTest[] getSimpleTests() {
        return this.simpleTests;
    }

    public Selector getResidual() {
        return this.residual;
    }
}

