/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAccept;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlBrowseEnd;
import com.ibm.ws.sib.mfp.control.ControlBrowseGet;
import com.ibm.ws.sib.mfp.control.ControlBrowseStatus;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCompleted;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDecisionExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlReject;
import com.ibm.ws.sib.mfp.control.ControlRequest;
import com.ibm.ws.sib.mfp.control.ControlRequestAck;
import com.ibm.ws.sib.mfp.control.ControlRequestHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAck;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAckAck;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AOBrowserSession;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.JSRemoteConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.destination.RemotePtoPSupport;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AOStartedFlushItem;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class AnycastOutputHandler
implements ControlHandler {
    private static TraceComponent tc = SibTr.register(AnycastOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final String destName;
    private final SIBUuid12 destUuid;
    private final DestinationHandler destinationHandler;
    private JSConsumerManager pubSubConsumerDispatcher;
    private final boolean isPubSub;
    private final ItemStream containerItemStream;
    private final MessageProcessor mp;
    private final AsyncUpdateThread msUpdateThread;
    private final AsyncUpdateThread persistLockThread;
    private final Hashtable<AOBrowserSessionKey, AOBrowserSession> browserSessionTable;
    public final long dmeVersion;
    private final Hashtable<String, StreamInfo> streamTable;
    private boolean cardinalityOne;
    private final Object cardinalityOneLock;
    private boolean closed;
    private boolean startedCloseAndFlush;
    private volatile boolean finishedCloseAndFlush;
    private boolean redriveDeletionThread;
    private final long controlItemLockID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastOutputHandler(String destName, SIBUuid12 destUuid, boolean receiveExclusive, DestinationHandler destinationHandler, ConsumerDispatcher cd, SIMPItemStream containerItemStream, MessageProcessor mp, AsyncUpdateThread msUpdateThread, AsyncUpdateThread persistLockThread, long dmeVersion, boolean restartFromStaleBackup) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)new Object[]{destName, destUuid, receiveExclusive, destinationHandler, cd, containerItemStream, mp, msUpdateThread, persistLockThread, dmeVersion, restartFromStaleBackup});
        }
        this.destName = destName;
        this.destUuid = destUuid;
        this.cardinalityOneLock = new Object();
        this.setCardinalityOne(receiveExclusive);
        this.destinationHandler = destinationHandler;
        this.pubSubConsumerDispatcher = cd;
        this.isPubSub = this.pubSubConsumerDispatcher != null;
        this.containerItemStream = containerItemStream;
        this.mp = mp;
        this.controlItemLockID = mp.getMessageStore().getUniqueLockID(1);
        this.msUpdateThread = msUpdateThread;
        this.persistLockThread = persistLockThread;
        this.dmeVersion = dmeVersion;
        this.browserSessionTable = new Hashtable();
        this.streamTable = new Hashtable();
        ArrayList<AOStream> toFlushStream = new ArrayList<AOStream>();
        boolean redoInitialization = false;
        ArrayList<SIBUuid8> clashingRemoteMEIdList = new ArrayList<SIBUuid8>();
        try {
            Hashtable<String, StreamInfo> hashtable = this.streamTable;
            synchronized (hashtable) {
                StreamInfo sinfo;
                AbstractItem abitem;
                NonLockingCursor cursor;
                do {
                    redoInitialization = false;
                    this.streamTable.clear();
                    cursor = containerItemStream.newNonLockingItemStreamCursor(null);
                    while ((abitem = cursor.next()) != null) {
                        if (!(abitem instanceof AOProtocolItemStream)) continue;
                        AOProtocolItemStream itemStream = (AOProtocolItemStream)abitem;
                        SIBUuid8 remoteMEId = itemStream.getRemoteMEId();
                        String streamKey = SIMPUtils.getRemoteGetKey(remoteMEId, itemStream.getGatheringTargetDestUuid());
                        SIBUuid12 streamId = itemStream.getStreamId();
                        StreamInfo sinfo2 = this.streamTable.get(streamKey);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler retrieved: " + sinfo2 + ", using key: " + streamKey + ", streamId: " + streamId + ", AOProtocolItemStream: " + (Object)((Object)itemStream)));
                        }
                        if (sinfo2 != null) {
                            if (sinfo2.streamId.equals((Object)streamId)) {
                                if (sinfo2.itemStream == null) {
                                    sinfo2.itemStream = itemStream;
                                    continue;
                                }
                                if (clashingRemoteMEIdList.contains(remoteMEId)) {
                                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:441:1.89.4.1"}, null));
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:448:1.89.4.1", (Object)this);
                                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:456:1.89.4.1"});
                                    throw e;
                                }
                                clashingRemoteMEIdList.add(remoteMEId);
                                this.cleanupPersistentStreams(containerItemStream, remoteMEId);
                                redoInitialization = true;
                                break;
                            }
                            if (clashingRemoteMEIdList.contains(remoteMEId)) {
                                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:485:1.89.4.1"}, null));
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:491:1.89.4.1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:499:1.89.4.1"});
                                throw e;
                            }
                            clashingRemoteMEIdList.add(remoteMEId);
                            this.cleanupPersistentStreams(containerItemStream, remoteMEId);
                            redoInitialization = true;
                            break;
                        }
                        sinfo2 = new StreamInfo(streamKey, streamId, null, itemStream);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler AOProtocolItemStream put: " + sinfo2 + ", using key: " + streamKey));
                        }
                        this.streamTable.put(streamKey, sinfo2);
                    }
                    cursor.finished();
                } while (redoInitialization);
                cursor = containerItemStream.newNonLockingItemCursor(null);
                while ((abitem = cursor.next()) != null) {
                    if (!(abitem instanceof AOStartedFlushItem)) continue;
                    AOStartedFlushItem item = (AOStartedFlushItem)abitem;
                    String streamKey = item.getStreamKey();
                    SIBUuid12 streamId = item.getStreamId();
                    sinfo = this.streamTable.get(streamKey);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler retrieved: " + sinfo + ", using key: " + streamKey + ", streamId: " + streamId + ", AOStartedFlushItem: " + (Object)((Object)item)));
                    }
                    if (sinfo != null) {
                        SIErrorException e;
                        if (sinfo.streamId.equals((Object)streamId)) {
                            if (sinfo.item == null) {
                                sinfo.item = item;
                                continue;
                            }
                            e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:557:1.89.4.1"}, null));
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:564:1.89.4.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:572:1.89.4.1"});
                            throw e;
                        }
                        e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:586:1.89.4.1"}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:593:1.89.4.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:599:1.89.4.1"});
                        throw e;
                    }
                    sinfo = new StreamInfo(streamKey, streamId, null, null);
                    sinfo.item = item;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler AOStartedFlushItem put: " + sinfo + ", using key: " + streamKey));
                    }
                    this.streamTable.put(streamKey, sinfo);
                }
                cursor.finished();
                boolean toStartFlushAllStreams = false;
                if (this.getCardinalityOne()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler prepare to counting non-flushed streams, table size: " + this.streamTable.size()));
                    }
                    if (this.streamTable.size() > 1) {
                        int tempCount = 0;
                        Enumeration<StreamInfo> vEnum = this.streamTable.elements();
                        while (vEnum.hasMoreElements()) {
                            sinfo = vEnum.nextElement();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler counting non-flushed streams: " + sinfo));
                            }
                            if (sinfo.item != null) continue;
                            ++tempCount;
                        }
                        if (tempCount > 1) {
                            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:651:1.89.4.1"}, null));
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:658:1.89.4.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:665:1.89.4.1"});
                            toStartFlushAllStreams = true;
                        }
                    }
                }
                Enumeration<StreamInfo> vEnum = this.streamTable.elements();
                ArrayList<AOValue> valueTicks = new ArrayList<AOValue>();
                while (vEnum.hasMoreElements()) {
                    JSConsumerManager streamConsumerManager;
                    boolean aliasNotFound;
                    boolean startedFlush;
                    block49: {
                        AOValue tick;
                        sinfo = vEnum.nextElement();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("AnycastOutputHandler initialising stream: " + sinfo));
                        }
                        boolean bl = startedFlush = sinfo.item != null;
                        if (sinfo.itemStream == null) {
                            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:692:1.89.4.1"}, null));
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:699:1.89.4.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:706:1.89.4.1"});
                            throw e;
                        }
                        valueTicks.clear();
                        cursor = sinfo.itemStream.newNonLockingItemCursor(null);
                        while ((tick = (AOValue)cursor.next()) != null) {
                            valueTicks.add(tick);
                        }
                        cursor.finished();
                        aliasNotFound = false;
                        streamConsumerManager = null;
                        if (!this.isPubSub) {
                            DestinationHandler dest = destinationHandler;
                            SIBUuid12 gatheringTargetUuid = sinfo.itemStream.getGatheringTargetDestUuid();
                            try {
                                if (gatheringTargetUuid != null) {
                                    ((RemotePtoPSupport)((BaseDestinationHandler)destinationHandler).getPtoPRealization().getRemoteSupport()).reconstituteIMELinks(valueTicks);
                                    if (!gatheringTargetUuid.equals((Object)destinationHandler.getUuid())) {
                                        dest = mp.getDestinationManager().getAliasDestination(gatheringTargetUuid, destinationHandler, false);
                                    }
                                    streamConsumerManager = (JSConsumerManager)dest.chooseConsumerManager(gatheringTargetUuid, null, null);
                                    break block49;
                                }
                                streamConsumerManager = (JSConsumerManager)dest.getLocalPtoPConsumerManager();
                            }
                            catch (SIException e) {
                                SibTr.warning((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:764:1.89.4.1"});
                                streamConsumerManager = (JSConsumerManager)dest.chooseConsumerManager(gatheringTargetUuid, null, null);
                                aliasNotFound = true;
                            }
                        } else {
                            streamConsumerManager = this.pubSubConsumerDispatcher;
                        }
                    }
                    if (restartFromStaleBackup) {
                        this.deleteAndUnlockPersistentStream(sinfo, valueTicks);
                        this.sendFlushed(sinfo.itemStream.getRemoteMEId(), sinfo.itemStream.getGatheringTargetDestUuid(), sinfo.streamId);
                        continue;
                    }
                    if (startedFlush && valueTicks.size() == 0) {
                        String key = SIMPUtils.getRemoteGetKey(sinfo.itemStream.getRemoteMEId(), sinfo.itemStream.getGatheringTargetDestUuid());
                        RemovePersistentStream update = new RemovePersistentStream(key, sinfo.streamId, sinfo.itemStream, sinfo.item);
                        msUpdateThread.enqueueWork(update);
                        continue;
                    }
                    sinfo.stream = new AOStream(sinfo.itemStream.getRemoteMEId(), sinfo.itemStream.getGatheringTargetDestUuid(), sinfo.streamId, sinfo.itemStream, this, msUpdateThread, false, valueTicks, startedFlush, mp, this.dmeVersion, streamConsumerManager);
                    if (aliasNotFound || toStartFlushAllStreams) {
                        toFlushStream.add(sinfo.stream);
                    } else if (this.getCardinalityOne() && !startedFlush && !toStartFlushAllStreams) {
                        try {
                            JSRemoteConsumerPoint aock = new JSRemoteConsumerPoint();
                            ConsumableKey ck = (ConsumableKey)streamConsumerManager.attachConsumerPoint(aock, null, new SIBUuid12(), false, false, null);
                            aock.init(sinfo.stream, "", new ConsumableKey[]{ck}, 0L, mp.getAlarmManager(), null);
                            sinfo.stream.setConsumerKey(aock);
                        }
                        catch (Exception e) {
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                            toFlushStream.add(sinfo.stream);
                        }
                    }
                    sinfo.stream.start();
                }
                if (restartFromStaleBackup) {
                    this.streamTable.clear();
                    SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETE_CWSIP0451", (Object)new Object[]{mp.getMessagingEngineName(), destName});
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:880:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)e);
            }
            throw e;
        }
        if (toFlushStream != null) {
            for (int i = 0; i < toFlushStream.size(); ++i) {
                AOStream stream = (AOStream)toFlushStream.get(i);
                stream.processRequestFlush();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)this);
        }
    }

    private void cleanupPersistentStreams(ItemStream containerItemStream, SIBUuid8 clashingRemoteMeId) throws Exception {
        AbstractItem abitem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupPersistentStreams", (Object)new Object[]{containerItemStream, clashingRemoteMeId});
        }
        NonLockingCursor cursor = containerItemStream.newNonLockingItemStreamCursor(null);
        while ((abitem = cursor.next()) != null) {
            if (!(abitem instanceof AOProtocolItemStream)) continue;
            AOProtocolItemStream protocolItemStream = (AOProtocolItemStream)abitem;
            SIBUuid8 remoteMEId = protocolItemStream.getRemoteMEId();
            SIBUuid12 streamId = protocolItemStream.getStreamId();
            SIBUuid12 gatheringTargetDestUuid = protocolItemStream.getGatheringTargetDestUuid();
            if (!remoteMEId.equals((Object)clashingRemoteMeId)) continue;
            NonLockingCursor protocolCursor = protocolItemStream.newNonLockingItemCursor(null);
            if (protocolCursor.next() == null) {
                String key = SIMPUtils.getRemoteGetKey(remoteMEId, gatheringTargetDestUuid);
                RemovePersistentStream update = new RemovePersistentStream(key, streamId, protocolItemStream, null);
                this.msUpdateThread.enqueueWork(update);
                this.msUpdateThread.waitTillAllUpdatesExecuted();
            }
            protocolCursor.finished();
        }
        cursor.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupPersistentStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        Enumeration<StreamInfo> streams = null;
        Object object = this;
        synchronized (object) {
            Hashtable<String, StreamInfo> hashtable = this.streamTable;
            synchronized (hashtable) {
                this.closed = true;
                this.closeBrowserSessionsInternal();
                streams = this.streamTable.elements();
            }
        }
        while (streams.hasMoreElements()) {
            StreamInfo sinfo = streams.nextElement();
            if (sinfo.stream == null) continue;
            sinfo.stream.close();
        }
        object = this.streamTable;
        synchronized (object) {
            this.streamTable.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndFlush(boolean redriveDeletionThread) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAndFlush", (Object)redriveDeletionThread);
        }
        Hashtable streamTableClone = null;
        AnycastOutputHandler anycastOutputHandler = this;
        synchronized (anycastOutputHandler) {
            Hashtable<String, StreamInfo> hashtable = this.streamTable;
            synchronized (hashtable) {
                if (!this.startedCloseAndFlush) {
                    this.startedCloseAndFlush = true;
                    this.redriveDeletionThread = redriveDeletionThread;
                    this.closeBrowserSessionsInternal();
                    if (this.streamTable.size() == 0) {
                        this.finishedCloseAndFlush = true;
                        this.streamTable.notifyAll();
                    } else {
                        streamTableClone = (Hashtable)this.streamTable.clone();
                    }
                }
            }
        }
        if (streamTableClone != null) {
            Enumeration e = streamTableClone.elements();
            while (e.hasMoreElements()) {
                StreamInfo sinfo = (StreamInfo)e.nextElement();
                if (sinfo.stream == null) continue;
                sinfo.stream.processRequestFlush();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAndFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanup(boolean flushStreams, boolean redriveDeletionThread) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanup", (Object)new Object[]{flushStreams, redriveDeletionThread});
        }
        boolean retvalue = false;
        Hashtable<String, StreamInfo> hashtable = this.streamTable;
        synchronized (hashtable) {
            if (this.finishedCloseAndFlush) {
                retvalue = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"cleanup", (Object)retvalue);
                }
                return retvalue;
            }
        }
        if (!flushStreams) {
            this.close();
            retvalue = true;
        } else {
            this.closeAndFlush(redriveDeletionThread);
            hashtable = this.streamTable;
            synchronized (hashtable) {
                retvalue = this.finishedCloseAndFlush;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanup", (Object)retvalue);
        }
        return retvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCloseAndFlushCompleted() {
        Hashtable<String, StreamInfo> hashtable = this.streamTable;
        synchronized (hashtable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isCloseAndFlushCompleted");
                SibTr.exit((TraceComponent)tc, (String)"isCloseAndFlushCompleted", (Object)this.finishedCloseAndFlush);
            }
            return this.finishedCloseAndFlush;
        }
    }

    public void closeBrowserSessionsInternal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeBrowserSessionsInternal");
        }
        Enumeration<AOBrowserSession> e = this.browserSessionTable.elements();
        while (e.hasMoreElements()) {
            AOBrowserSession session = e.nextElement();
            session.close();
        }
        this.browserSessionTable.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeBrowserSessionsInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getCardinalityOne() {
        Object object = this.cardinalityOneLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getCardinalityOne");
                SibTr.exit((TraceComponent)tc, (String)"getCardinalityOne", (Object)this.cardinalityOne);
            }
            return this.cardinalityOne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCardinalityOne(boolean value) {
        Object object = this.cardinalityOneLock;
        synchronized (object) {
            this.cardinalityOne = value;
        }
    }

    public final boolean isMEReachable(SIBUuid8 rme) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMEReachable", (Object)rme);
        }
        MPIO msgTran = this.mp.getMPIO();
        boolean reachable = msgTran.isMEReachable(rme);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMEReachable", (Object)reachable);
        }
        return reachable;
    }

    public final AsyncUpdateThread getAsyncUpdateThread() {
        return this.msUpdateThread;
    }

    public final AsyncUpdateThread getPersistLockThread() {
        return this.persistLockThread;
    }

    public final AOStream getAOStream(String streamKey, SIBUuid12 streamId) {
        StreamInfo streamInfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOStream", (Object)new Object[]{streamKey, streamId});
        }
        if ((streamInfo = this.getStreamInfo(streamKey, streamId)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAOStream", (Object)streamInfo.stream);
            }
            return streamInfo.stream;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOStream", null);
        }
        return null;
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, msg});
        }
        SIBUuid8 remoteMEId = msg.getGuaranteedSourceMessagingEngineUUID();
        SIBUuid12 gatheringTargetDestUuid = msg.getGuaranteedGatheringTargetUUID();
        ControlMessageType type = msg.getControlMessageType();
        if (type == ControlMessageType.BROWSEGET) {
            ControlBrowseGet cmsg = (ControlBrowseGet)msg;
            long browseId = cmsg.getBrowseID();
            String selectorString = cmsg.getFilter();
            String discriminator = cmsg.getControlDiscriminator();
            SelectorDomain domain = SelectorDomain.getSelectorDomain((int)cmsg.getSelectorDomain());
            SelectionCriteria criteria = this.mp.getSelectionCriteriaFactory().createSelectionCriteria(discriminator, selectorString, domain);
            long seqNum = cmsg.getSequenceNumber();
            this.handleControlBrowseGet(remoteMEId, gatheringTargetDestUuid, browseId, criteria, seqNum);
        } else if (type == ControlMessageType.BROWSESTATUS) {
            ControlBrowseStatus cmsg = (ControlBrowseStatus)msg;
            long browseId = cmsg.getBrowseID();
            int status = cmsg.getStatus();
            this.handleControlBrowseStatus(remoteMEId, gatheringTargetDestUuid, browseId, status);
        } else if (type == ControlMessageType.CREATESTREAM) {
            ControlCreateStream cmsg = (ControlCreateStream)msg;
            long requestId = cmsg.getRequestID();
            SIBUuid12 parent = null;
            if (msg.getGuaranteedProtocolType() == ProtocolType.DURABLEOUTPUT) {
                parent = msg.getGuaranteedTargetDestinationDefinitionUUID();
            }
            this.handleControlCreateStream(remoteMEId, gatheringTargetDestUuid, requestId, parent);
        } else {
            SIBUuid12 streamId = msg.getGuaranteedStreamUUID();
            String streamKey = SIMPUtils.getRemoteGetKey(remoteMEId, gatheringTargetDestUuid);
            StreamInfo streamInfo = this.getStreamInfo(streamKey, streamId);
            if (streamInfo == null) {
                this.sendFlushed(remoteMEId, gatheringTargetDestUuid, streamId);
            } else if (streamInfo.stream != null) {
                if (type == ControlMessageType.ACCEPT) {
                    ControlAccept cmsg = (ControlAccept)msg;
                    long[] ticks = cmsg.getTick();
                    streamInfo.stream.processAccept(ticks);
                } else if (type == ControlMessageType.REJECT) {
                    ControlReject cmsg = (ControlReject)msg;
                    long[] startTicks = cmsg.getStartTick();
                    long[] endTicks = cmsg.getEndTick();
                    long[] unlockCounts = cmsg.getRMEUnlockCount();
                    boolean recovery = cmsg.getRecovery();
                    streamInfo.stream.processReject(startTicks, endTicks, unlockCounts, recovery);
                } else if (type == ControlMessageType.COMPLETED) {
                    ControlCompleted cmsg = (ControlCompleted)msg;
                    long[] startTicks = cmsg.getStartTick();
                    long[] endTicks = cmsg.getEndTick();
                    streamInfo.stream.processCompleted(startTicks, endTicks);
                } else if (type == ControlMessageType.REQUEST) {
                    ControlRequest cmsg = (ControlRequest)msg;
                    String[] discriminators = cmsg.getControlDisciminator();
                    String[] filters = cmsg.getFilter();
                    int[] selectorDomains = cmsg.getSelectorDomain();
                    long[] getTicks = cmsg.getGetTick();
                    long[] rejectStartTicks = cmsg.getRejectStartTick();
                    long[] timeouts = cmsg.getTimeout();
                    streamInfo.stream.processRequest(discriminators, selectorDomains, filters, rejectStartTicks, getTicks, timeouts);
                } else if (type == ControlMessageType.HIGHESTGENERATEDTICK) {
                    ControlHighestGeneratedTick cmsg = (ControlHighestGeneratedTick)msg;
                    long requestId = cmsg.getRequestID();
                    long tick = cmsg.getTick();
                    streamInfo.stream.processHighestGeneratedTick(requestId, tick);
                } else if (type == ControlMessageType.AREYOUFLUSHED) {
                    ControlAreYouFlushed cmsg = (ControlAreYouFlushed)msg;
                    long requestId = cmsg.getRequestID();
                    streamInfo.stream.processAreYouFlushed(requestId, null);
                } else if (type == ControlMessageType.REQUESTFLUSH) {
                    streamInfo.stream.processRequestFlush();
                } else if (type == ControlMessageType.RESETREQUESTACKACK) {
                    ControlResetRequestAckAck cmsg = (ControlResetRequestAckAck)msg;
                    long dmeVersion = cmsg.getDMEVersion();
                    if (this.dmeVersion == dmeVersion) {
                        streamInfo.stream.processResetRequestAckAck();
                    }
                } else if (type != ControlMessageType.REQUESTCARDINALITYINFO) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1303:1.89.4.1"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlMessage", (String)"1:1310:1.89.4.1", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1316:1.89.4.1"});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleControlBrowseGet(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, long browseId, SelectionCriteria criteria, long seqNum) {
        boolean closed;
        AOBrowserSession session;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlBrowseGet", (Object)new Object[]{remoteME, gatheringTargetDestUuid, browseId, criteria, seqNum});
        }
        AOBrowserSessionKey key = new AOBrowserSessionKey(remoteME, gatheringTargetDestUuid, browseId);
        AnycastOutputHandler anycastOutputHandler = this;
        synchronized (anycastOutputHandler) {
            if (this.startedCloseAndFlush) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseGet");
                }
                return;
            }
            session = this.browserSessionTable.get(key);
        }
        if (session == null) {
            if (seqNum == 0L) {
                try {
                    JSConsumerManager streamConsumerDispatcher = null;
                    if (!this.isPubSub) {
                        try {
                            DestinationHandler dest = this.destinationHandler;
                            if (gatheringTargetDestUuid != null) {
                                dest = this.mp.getDestinationManager().getDestination(gatheringTargetDestUuid, true);
                            }
                            streamConsumerDispatcher = (JSConsumerManager)dest.chooseConsumerManager(gatheringTargetDestUuid, null, null);
                        }
                        catch (SIException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1388:1.89.4.1", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1394:1.89.4.1"});
                            throw e;
                        }
                    } else {
                        streamConsumerDispatcher = this.pubSubConsumerDispatcher;
                    }
                    BrowseCursor browseCursor = streamConsumerDispatcher.getBrowseCursor(criteria);
                    session = new AOBrowserSession(this, browseCursor, remoteME, gatheringTargetDestUuid, browseId, this.mp.getAlarmManager());
                    key = session.getKey();
                    AOBrowserSession existing = this.browserSessionTable.put(key, session);
                    if (existing != null) {
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1422:1.89.4.1"}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1429:1.89.4.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1436:1.89.4.1"});
                        existing.close();
                    }
                }
                catch (SISelectorSyntaxException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1188:1.77", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                    this.sendBrowseEnd(remoteME, gatheringTargetDestUuid, browseId, 3);
                    session = null;
                }
                catch (SIException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1454:1.89.4.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
                    this.sendBrowseEnd(remoteME, gatheringTargetDestUuid, browseId, 1);
                    session = null;
                }
            } else {
                this.sendBrowseEnd(remoteME, gatheringTargetDestUuid, browseId, 2);
            }
        }
        if (session != null && (closed = session.next(seqNum))) {
            this.browserSessionTable.remove(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseGet");
        }
    }

    private final void handleControlBrowseStatus(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, long browseId, int status) {
        AOBrowserSessionKey key;
        AOBrowserSession session;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlBrowseStatus", (Object)new Object[]{remoteME, gatheringTargetDestUuid, browseId, status});
        }
        if ((session = this.browserSessionTable.get(key = new AOBrowserSessionKey(remoteME, gatheringTargetDestUuid, browseId))) != null) {
            if (status == 1) {
                session.close();
                this.browserSessionTable.remove(key);
            } else if (status == 0) {
                session.keepAlive();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseStatus");
        }
    }

    public final void removeBrowserSession(AOBrowserSessionKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowserSession", (Object)key);
        }
        this.browserSessionTable.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowserSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleControlCreateStream(SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, long requestId, SIBUuid12 parentDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlCreateStream", (Object)new Object[]{remoteMEId, gatheringTargetDestUuid, requestId, parentDest});
        }
        StreamInfo sinfo = null;
        boolean sendControlCardinality = false;
        boolean createStreamSuccess = true;
        Hashtable<String, StreamInfo> hashtable = this.streamTable;
        synchronized (hashtable) {
            if (!this.startedCloseAndFlush) {
                String streamTableKey = SIMPUtils.getRemoteGetKey(remoteMEId, gatheringTargetDestUuid);
                sinfo = this.streamTable.get(streamTableKey);
                if (sinfo == null) {
                    JSRemoteConsumerPoint aock = null;
                    ConsumableKey ck = null;
                    JSConsumerManager streamConsumerDispatcher = null;
                    if (!this.isPubSub) {
                        try {
                            DestinationHandler dest = this.destinationHandler;
                            if (gatheringTargetDestUuid != null) {
                                dest = this.mp.getDestinationManager().getDestinationByUuid(gatheringTargetDestUuid, true);
                            }
                            streamConsumerDispatcher = (JSConsumerManager)dest.chooseConsumerManager(gatheringTargetDestUuid, null, null);
                        }
                        catch (SIException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlCreateStream", (String)"1:1593:1.89.4.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            createStreamSuccess = false;
                        }
                    } else {
                        streamConsumerDispatcher = this.pubSubConsumerDispatcher;
                    }
                    if (createStreamSuccess) {
                        if (this.getCardinalityOne()) {
                            try {
                                aock = new JSRemoteConsumerPoint();
                                ck = (ConsumableKey)streamConsumerDispatcher.attachConsumerPoint(aock, null, new SIBUuid12(), false, false, null);
                            }
                            catch (Exception e) {
                                sendControlCardinality = true;
                                SibTr.exception((TraceComponent)tc, (Exception)e);
                            }
                        }
                        if (!sendControlCardinality) {
                            SIBUuid12 streamId = this.generateUniqueStreamName();
                            StreamInfo sinfo2 = new StreamInfo(streamTableKey, streamId, null, null);
                            this.streamTable.put(streamTableKey, sinfo2);
                            try {
                                CreatePersistentStream update = new CreatePersistentStream(remoteMEId, gatheringTargetDestUuid, streamId, requestId, aock, ck, parentDest, this.destinationHandler, streamConsumerDispatcher);
                                this.msUpdateThread.enqueueWork(update);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlCreateStream", (String)"1:1646:1.89.4.1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)e);
                                this.streamTable.remove(streamTableKey);
                                createStreamSuccess = false;
                                try {
                                    if (ck != null) {
                                        ck.detach();
                                    }
                                }
                                catch (Exception e2) {
                                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlCreateStream", (String)"1:1665:1.89.4.1", (Object)this);
                                    SibTr.exception((TraceComponent)tc, (Exception)e2);
                                }
                            }
                        }
                    }
                }
            } else {
                createStreamSuccess = false;
            }
        }
        if (sinfo != null && sinfo.stream != null) {
            sinfo.stream.processAreYouFlushed(requestId, parentDest);
        }
        if (sendControlCardinality && createStreamSuccess) {
            this.sendCardinalityInfo(remoteMEId, gatheringTargetDestUuid, requestId, 1, parentDest);
        }
        if (!createStreamSuccess) {
            this.sendCardinalityInfo(remoteMEId, gatheringTargetDestUuid, requestId, 0, parentDest);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlCreateStream");
        }
    }

    private final StreamInfo getStreamInfo(String streamKey, SIBUuid12 streamId) {
        StreamInfo sinfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamInfo", (Object)new Object[]{streamKey, streamId});
        }
        if ((sinfo = this.streamTable.get(streamKey)) != null && sinfo.streamId.equals((Object)streamId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getStreamInfo", (Object)sinfo);
            }
            return sinfo;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamInfo", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamIsFlushed(AOStream stream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"streamIsFlushed", (Object)stream);
        }
        Hashtable<String, StreamInfo> hashtable = this.streamTable;
        synchronized (hashtable) {
            String key = SIMPUtils.getRemoteGetKey(stream.getRemoteMEUuid(), stream.getGatheringTargetDestUuid());
            StreamInfo sinfo = this.streamTable.get(key);
            if (sinfo != null && sinfo.streamId.equals((Object)stream.streamId)) {
                RemovePersistentStream update = null;
                StreamInfo streamInfo = sinfo;
                synchronized (streamInfo) {
                    update = new RemovePersistentStream(key, sinfo.streamId, sinfo.itemStream, sinfo.item);
                }
                this.doEnqueueWork(update);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamIsFlushed");
        }
    }

    private final void initializeControlMessage(ControlMessage msg, SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{msg, remoteMEId, streamId});
        }
        msg.setPriority(11);
        msg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        SIMPUtils.setGuaranteedDeliveryProperties(msg, this.mp.getMessagingEngineUuid(), remoteMEId, streamId, gatheringTargetDestUuid, this.destUuid, ProtocolType.ANYCASTINPUT, GDConfig.PROTOCOL_VERSION);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    public final void sendBrowseData(JsMessage msg, SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid8 remoteMEId, long browseId, long seqNum) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseData", (Object)new Object[]{msg, remoteME, gatheringTargetDestUuid, remoteMEId, browseId, seqNum});
        }
        try {
            JsMessage jsMsg = msg.getReceived();
            jsMsg.clearGuaranteedRemoteGet();
            SIMPUtils.setGuaranteedDeliveryProperties(jsMsg, this.mp.getMessagingEngineUuid(), remoteMEId, null, gatheringTargetDestUuid, this.destUuid, ProtocolType.ANYCASTINPUT, GDConfig.PROTOCOL_VERSION);
            jsMsg.setGuaranteedRemoteBrowseID(browseId);
            jsMsg.setGuaranteedRemoteBrowseSequenceNumber(seqNum);
            this.sendToMe(remoteME, 1, (int)jsMsg.getPriority(), jsMsg);
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendBrowseData", (String)"1:2189:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseData");
        }
    }

    public final void sendBrowseEnd(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, long browseId, int errorCode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseEnd", (Object)new Object[]{remoteME, gatheringTargetDestUuid, browseId, errorCode});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlBrowseEnd msg = cmf.createNewControlBrowseEnd();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, null);
            msg.setBrowseID(browseId);
            msg.setExceptionCode(errorCode);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendBrowseEnd", (String)"1:2222:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseEnd");
        }
    }

    public final void sendRequestHighestGeneratedTick(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long requestId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestHighestGeneratedTick", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, requestId});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlRequestHighestGeneratedTick msg = cmf.createNewControlRequestHighestGeneratedTick();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            msg.setRequestID(requestId);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendRequestHighestGeneratedTick", (String)"1:2254:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestHighestGeneratedTick");
        }
    }

    public final void sendRemoteGetData(SIMPMessage msg, SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long prevTick, long startTick, long tick, long waitTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRemoteGetData", (Object)new Object[]{msg, remoteMEId, gatheringTargetDestUuid, streamId, prevTick, startTick, tick, waitTime});
        }
        JsMessage jsMsg = null;
        try {
            jsMsg = msg.getMessage().getReceived();
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendRemoteGetData", (String)"1:2296:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRemoteGetData", (Object)"MessageCopyFailedException");
            }
            throw new SIErrorException((Throwable)e);
        }
        jsMsg.clearGuaranteedRemoteBrowse();
        SIMPUtils.setGuaranteedDeliveryProperties(jsMsg, this.mp.getMessagingEngineUuid(), remoteMEId, streamId, gatheringTargetDestUuid, this.destUuid, ProtocolType.ANYCASTINPUT, GDConfig.PROTOCOL_VERSION);
        jsMsg.setRedeliveredCount(msg.guessRedeliveredCount());
        jsMsg.setGuaranteedRemoteGetPrevTick(prevTick);
        jsMsg.setGuaranteedRemoteGetStartTick(startTick);
        jsMsg.setGuaranteedRemoteGetValueTick(tick);
        jsMsg.setGuaranteedRemoteGetWaitTime(waitTime);
        jsMsg.setMessageWaitTime(msg.updateStatisticsMessageWaitTime());
        this.sendToMe(remoteMEId, 1, (int)jsMsg.getPriority(), jsMsg);
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_MESSAGE_SENT_CWSJU0031", new Object[]{this.getDestName(), this.mp.getMessagingEngineUuid(), remoteMEId, gatheringTargetDestUuid}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRemoteGetData");
        }
    }

    public final void sendCompleted(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, List tickRangeList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, tickRangeList});
        }
        long[] startTicks = new long[tickRangeList.size()];
        long[] endTicks = new long[tickRangeList.size()];
        for (int i = 0; i < startTicks.length; ++i) {
            TickRange r = (TickRange)tickRangeList.get(i);
            startTicks[i] = r.startstamp;
            endTicks[i] = r.endstamp;
        }
        this.sendCompletedInternal(remoteME, gatheringTargetDestUuid, streamId, startTicks, endTicks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public final void sendCompleted(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, TickRange r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, r});
        }
        long[] startTicks = new long[1];
        long[] endTicks = new long[1];
        startTicks[0] = r.startstamp;
        endTicks[0] = r.endstamp;
        this.sendCompletedInternal(remoteME, gatheringTargetDestUuid, streamId, startTicks, endTicks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public final void sendCompletedInternal(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long[] startTicks, long[] endTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompletedInternal", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, Arrays.toString(startTicks), Arrays.toString(endTicks)});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlCompleted msg = cmf.createNewControlCompleted();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            msg.setStartTick(startTicks);
            msg.setEndTick(endTicks);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendCompletedInternal", (String)"1:2415:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompletedInternal");
        }
    }

    public final void sendDecisionExpected(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, List valueTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDecisionExpected", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, valueTicks});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlDecisionExpected msg = cmf.createNewControlDecisionExpected();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            long[] ticks = new long[valueTicks.size()];
            for (int i = 0; i < ticks.length; ++i) {
                AOValue value = (AOValue)valueTicks.get(i);
                ticks[i] = value.getTick();
            }
            msg.setTick(ticks);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendDecisionExpected", (String)"1:2462:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDecisionExpected");
        }
    }

    public final void sendFlushed(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushed", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlFlushed msg = cmf.createNewControlFlushed();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendFlushed", (String)"1:2493:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushed");
        }
    }

    public final void sendCardinalityInfo(SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, long requestId, int value, SIBUuid12 parentDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCardinalityInfo", (Object)new Object[]{remoteMEId, gatheringTargetDestUuid, requestId, value, parentDest});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlCardinalityInfo msg = cmf.createNewControlCardinalityInfo();
            this.initializeControlMessage((ControlMessage)msg, remoteMEId, gatheringTargetDestUuid, null);
            msg.setRequestID(requestId);
            msg.setCardinality(value);
            if (parentDest != null) {
                msg.setGuaranteedProtocolType(ProtocolType.DURABLEINPUT);
            }
            this.sendToMe(remoteMEId, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendCardinalityInfo", (String)"1:2532:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCardinalityInfo");
        }
    }

    public final void sendNotFlushed(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long requestId, long completedPrefix, long duplicatePrefix, SIBUuid12 parentDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushed", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, requestId, completedPrefix, duplicatePrefix, parentDest});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlNotFlushed msg = cmf.createNewControlNotFlushed();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            msg.setRequestID(requestId);
            int[] junk = new int[]{0};
            msg.setCompletedPrefixPriority(junk);
            msg.setCompletedPrefixQOS(junk);
            msg.setDuplicatePrefixPriority(junk);
            msg.setDuplicatePrefixQOS(junk);
            long[] cp = new long[]{completedPrefix};
            msg.setCompletedPrefixTicks(cp);
            long[] dp = new long[]{duplicatePrefix};
            msg.setDuplicatePrefixTicks(dp);
            if (parentDest != null) {
                msg.setGuaranteedProtocolType(ProtocolType.DURABLEINPUT);
            }
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendNotFlushed", (String)"1:2584:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushed");
        }
    }

    public final void sendRequestAck(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long dmeVersion, long[] ticks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestAck", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, dmeVersion, Arrays.toString(ticks)});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlRequestAck msg = cmf.createNewControlRequestAck();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            msg.setDMEVersion(dmeVersion);
            msg.setTick(ticks);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendRequestAck", (String)"1:2618:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestAck");
        }
    }

    public final void sendResetRequestAck(SIBUuid8 remoteME, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long dmeVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetRequestAck", (Object)new Object[]{remoteME, gatheringTargetDestUuid, streamId, dmeVersion});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlResetRequestAck msg = cmf.createNewControlResetRequestAck();
            this.initializeControlMessage((ControlMessage)msg, remoteME, gatheringTargetDestUuid, streamId);
            msg.setDMEVersion(dmeVersion);
            this.sendToMe(remoteME, 1, 11, (ControlMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendResetRequestAck", (String)"1:2650:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetRequestAck");
        }
    }

    public final AOValue persistLockAndTick(TransactionCommon t, AOStream stream, long tick, SIMPMessage msg, int storagePolicy, long waitTime, long prevTick) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistLockAndTick", (Object)new Object[]{t, stream, tick, msg, storagePolicy, waitTime, prevTick});
        }
        AOValue retvalue = null;
        try {
            Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction(t);
            msg.persistLock(msTran);
            long plockId = msg.getLockID();
            retvalue = new AOValue(tick, msg, msg.getID(), storagePolicy, plockId, waitTime, prevTick);
            stream.itemStream.addItem(retvalue, msTran);
        }
        catch (Exception e) {
            retvalue = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"persistLockAndTick", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistLockAndTick", (Object)retvalue);
        }
        return retvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanupTicks(StreamInfo sinfo, TransactionCommon t, ArrayList valueTicks) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupTicks", (Object)new Object[]{sinfo, t, valueTicks});
        }
        try {
            int length = valueTicks.size();
            for (int i = 0; i < length; ++i) {
                AOValue storedTick = (AOValue)valueTicks.get(i);
                ConsumerDispatcher cd = null;
                if (storedTick.getSourceMEUuid() == null || storedTick.getSourceMEUuid().equals((Object)this.getMessageProcessor().getMessagingEngineUuid())) {
                    cd = (ConsumerDispatcher)this.destinationHandler.getLocalPtoPConsumerManager();
                } else {
                    AnycastInputHandler aih = this.destinationHandler.getAnycastInputHandler(storedTick.getSourceMEUuid(), null, true);
                    cd = aih.getRCD();
                }
                SIMPMessage msg = null;
                AOValue aOValue = storedTick;
                synchronized (aOValue) {
                    msg = cd.getMessageByValue(storedTick);
                    if (msg == null) {
                        storedTick.setToBeFlushed();
                    }
                }
                Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction(t);
                if (msg != null && msg.getLockID() == storedTick.getPLockId()) {
                    msg.unlockMsg(storedTick.getPLockId(), msTran, true);
                }
                storedTick.lockItemIfAvailable(this.controlItemLockID);
                storedTick.remove(msTran, this.controlItemLockID);
            }
        }
        catch (MessageStoreException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cleanupTicks", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupTicks");
        }
    }

    public final Item writeStartedFlush(TransactionCommon t, AOStream stream) throws Exception {
        String key;
        StreamInfo sinfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeStartedFlush");
        }
        if ((sinfo = this.streamTable.get(key = SIMPUtils.getRemoteGetKey(stream.getRemoteMEUuid(), stream.getGatheringTargetDestUuid()))) != null && sinfo.streamId.equals((Object)stream.streamId)) {
            AOStartedFlushItem item = new AOStartedFlushItem(key, stream.streamId);
            Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction(t);
            this.containerItemStream.addItem((Item)item, msTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeStartedFlush", (Object)((Object)item));
            }
            return item;
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2810:1.89.4.1"}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.writeStartedFlush", (String)"1:2817:1.89.4.1", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2822:1.89.4.1"});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeStartedFlush", (Object)((Object)e));
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writtenStartedFlush(AOStream stream, Item startedFlushItem) {
        String key;
        StreamInfo sinfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writtenStartedFlush");
        }
        if ((sinfo = this.streamTable.get(key = SIMPUtils.getRemoteGetKey(stream.getRemoteMEUuid(), stream.getGatheringTargetDestUuid()))) != null && sinfo.streamId.equals((Object)stream.streamId)) {
            StreamInfo streamInfo = sinfo;
            synchronized (streamInfo) {
                sinfo.item = (AOStartedFlushItem)startedFlushItem;
            }
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2858:1.89.4.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.writtenStartedFlush", (String)"1:2865:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2872:1.89.4.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush");
        }
    }

    public final long generateUniqueValue() throws SIResourceException {
        return this.mp.nextTick();
    }

    private final SIBUuid12 generateUniqueStreamName() {
        return new SIBUuid12();
    }

    public final LocalTransaction getLocalTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalTransaction");
        }
        SIMPTransactionManager txManager = this.mp.getTXManager();
        LocalTransaction tran = txManager.createLocalTransaction(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalTransaction", (Object)tran);
        }
        return tran;
    }

    public final MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this.mp);
        }
        return this.mp;
    }

    public final ConsumerDispatcher getPubSubConsumerDispatcher() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubConsumerDispatcher");
            SibTr.exit((TraceComponent)tc, (String)"getPubSubConsumerDispatcher", (Object)this.pubSubConsumerDispatcher);
        }
        return (ConsumerDispatcher)this.pubSubConsumerDispatcher;
    }

    public final SelectionCriteria createSelectionCriteria(String discriminator, String selector, SelectorDomain domain) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSelectionCriteria", (Object)new Object[]{discriminator, selector, domain});
            SibTr.exit((TraceComponent)tc, (String)"createSelectionCriteria");
        }
        return this.mp.getSelectionCriteriaFactory().createSelectionCriteria(discriminator, selector, domain);
    }

    private final void doEnqueueWork(AsyncUpdate asyncUpdate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)asyncUpdate);
        }
        try {
            this.msUpdateThread.enqueueWork(asyncUpdate);
        }
        catch (ClosedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.doEnqueueWork", (String)"1:2955:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork");
        }
    }

    public void sendToMe(SIBUuid8 rme, int srcId, int priority, JsMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{rme, srcId, priority, msg});
        }
        MPIO msgTran = this.mp.getMPIO();
        msgTran.sendToMe(rme, priority, (AbstractMessage)msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public void sendToMe(SIBUuid8 rme, int srcId, int priority, ControlMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{rme, srcId, priority, msg});
        }
        MPIO msgTran = this.mp.getMPIO();
        msgTran.sendToMe(rme, priority, (AbstractMessage)msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public int getCountOfBrowseSessions() {
        return this.browserSessionTable.size();
    }

    public SIMPItemStream getItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this.containerItemStream);
        }
        return (SIMPItemStream)this.containerItemStream;
    }

    public final String getDestName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestName", (Object)this.destName);
        }
        return this.destName;
    }

    public final SIBUuid12 getDestUUID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestUUID");
            SibTr.exit((TraceComponent)tc, (String)"getDestUUID", (Object)this.destName);
        }
        return this.destUuid;
    }

    public Iterator<ControlAdapter> getAOControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOControlAdapterIterator", (Object)new Object[0]);
        }
        ArrayList<ControlAdapter> aoStreams = new ArrayList<ControlAdapter>();
        Enumeration<StreamInfo> streamInfos = this.streamTable.elements();
        while (streamInfos.hasMoreElements()) {
            StreamInfo streamInfo = streamInfos.nextElement();
            if (streamInfo.stream == null) continue;
            aoStreams.add(streamInfo.stream.getControlAdapter());
        }
        Iterator<ControlAdapter> itr = aoStreams.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOControlAdapterIterator", itr);
        }
        return itr;
    }

    public final String convertSelectionCriteriasToString(String[] discriminators, int[] selectorDomains, String[] selectors) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)new Object[]{discriminators, selectorDomains, selectors});
        }
        String selectionCriteriasAsString = "";
        if (discriminators.length == 1) {
            boolean discEmpty = true;
            if (discriminators[0] != null && !discriminators[0].equals("")) {
                discEmpty = false;
            }
            if (discEmpty && (selectors[0] == null || selectors[0].equals(""))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)selectionCriteriasAsString);
                }
                return selectionCriteriasAsString;
            }
        }
        for (int i = 0; i < discriminators.length; ++i) {
            if (discriminators[i] == null) {
                discriminators[i] = "";
            }
            if (selectors[i] == null) {
                selectors[i] = "";
            }
            selectionCriteriasAsString = selectionCriteriasAsString + ":" + discriminators[i] + ":" + SelectorDomain.getSelectorDomain((int)selectorDomains[i]).toString() + ":" + selectors[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)selectionCriteriasAsString);
        }
        return selectionCriteriasAsString;
    }

    public Hashtable getBrowserSessions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowserSessions");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowserSessions", this.browserSessionTable);
        }
        return this.browserSessionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlushAtSource(SIBUuid8 remoteUuid, SIBUuid12 gatheringTargetDestUuid) {
        StreamInfo sinfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtSource", (Object)new Object[]{remoteUuid, gatheringTargetDestUuid});
        }
        boolean success = false;
        String key = SIMPUtils.getRemoteGetKey(remoteUuid, gatheringTargetDestUuid);
        Hashtable<String, StreamInfo> hashtable = this.streamTable;
        synchronized (hashtable) {
            sinfo = this.streamTable.get(key);
        }
        if (sinfo == null) {
            success = true;
        } else {
            if (sinfo.stream == null) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:3159:1.89.4.1"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.forceFlushAtSource", (String)"1:3165:1.89.4.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:3171:1.89.4.1"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
                }
                throw e;
            }
            try {
                AOValue tick;
                AOStream stream = sinfo.stream;
                stream.close();
                ArrayList<AOValue> valueTicks = new ArrayList<AOValue>();
                NonLockingCursor cursor = sinfo.itemStream.newNonLockingItemCursor(null);
                while ((tick = (AOValue)cursor.next()) != null) {
                    valueTicks.add(tick);
                }
                cursor.finished();
                this.deleteAndUnlockPersistentStream(sinfo, valueTicks);
                Hashtable<String, StreamInfo> hashtable2 = this.streamTable;
                synchronized (hashtable2) {
                    this.streamTable.remove(key);
                }
                success = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.forceFlushAtSource", (String)"1:3211:1.89.4.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:3217:1.89.4.1"});
                SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:3226:1.89.4.1"}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
                }
                throw e2;
            }
        }
        if (success) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETE_CWSIP0452", (Object)new Object[]{this.destName, this.mp.getMessagingEngineName(), key});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
        }
    }

    private void deleteAndUnlockPersistentStream(StreamInfo sinfo, ArrayList valueTicks) throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAndUnlockPersistentStream", (Object)new Object[]{sinfo, valueTicks});
        }
        LocalTransaction tran = this.getLocalTransaction();
        this.cleanupTicks(sinfo, (TransactionCommon)tran, valueTicks);
        Transaction msTran = this.mp.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
        sinfo.itemStream.lockItemIfAvailable(this.controlItemLockID);
        sinfo.itemStream.remove(msTran, this.controlItemLockID);
        if (sinfo.item != null) {
            sinfo.item.lockItemIfAvailable(this.controlItemLockID);
            sinfo.item.remove(msTran, this.controlItemLockID);
        }
        tran.commit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAndUnlockPersistentStream");
        }
    }

    public void notifyReceiveExclusiveChange(boolean newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveExclusiveChange", (Object)new Object[]{newValue});
        }
        this.setCardinalityOne(newValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChange");
        }
    }

    public DestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }

    class StreamInfo {
        final String streamKey;
        final SIBUuid12 streamId;
        AOStream stream;
        AOProtocolItemStream itemStream;
        AOStartedFlushItem item;

        StreamInfo(String streamKey, SIBUuid12 streamId, AOStream stream, AOProtocolItemStream itemStream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"StreamInfo", (Object)new Object[]{streamKey, streamId, stream, itemStream});
            }
            this.streamKey = streamKey;
            this.streamId = streamId;
            this.stream = stream;
            this.itemStream = itemStream;
            this.item = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"StreamInfo", (Object)this);
            }
        }

        public String toString() {
            String strRep = "Key: " + this.streamKey + ", Id: " + this.streamId + ", stream: " + this.stream + ", itemstream: " + (Object)((Object)this.itemStream) + ", item: " + (Object)((Object)this.item);
            return strRep;
        }
    }

    class RemovePersistentStream
    extends AsyncUpdateWithRetry {
        final String streamKey;
        final SIBUuid12 streamId;
        final ItemStream itemStream;
        final Item item;

        RemovePersistentStream(String streamKey, SIBUuid12 streamId, ItemStream itemStream, Item item) {
            super(4L, AnycastOutputHandler.this.msUpdateThread, AnycastOutputHandler.this.destName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"RemovePersistentStream", (Object)new Object[]{streamKey, streamId, itemStream, item});
            }
            this.streamKey = streamKey;
            this.streamId = streamId;
            this.itemStream = itemStream;
            this.item = item;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RemovePersistentStream", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)t);
            }
            Transaction msTran = AnycastOutputHandler.this.mp.resolveAndEnlistMsgStoreTransaction(t);
            if (this.item != null) {
                this.item.lockItemIfAvailable(AnycastOutputHandler.this.controlItemLockID);
                this.item.remove(msTran, AnycastOutputHandler.this.controlItemLockID);
            }
            this.itemStream.lockItemIfAvailable(AnycastOutputHandler.this.controlItemLockID);
            this.itemStream.remove(msTran, AnycastOutputHandler.this.controlItemLockID);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            Hashtable hashtable = AnycastOutputHandler.this.streamTable;
            synchronized (hashtable) {
                StreamInfo sinfo = (StreamInfo)AnycastOutputHandler.this.streamTable.get(this.streamKey);
                if (sinfo != null && sinfo.streamId.equals((Object)this.streamId)) {
                    AnycastOutputHandler.this.streamTable.remove(this.streamKey);
                    if (AnycastOutputHandler.this.startedCloseAndFlush && AnycastOutputHandler.this.streamTable.size() == 0) {
                        AnycastOutputHandler.this.finishedCloseAndFlush = true;
                        if (AnycastOutputHandler.this.redriveDeletionThread) {
                            AnycastOutputHandler.this.mp.getDestinationManager().startAsynchDeletion();
                        } else {
                            try {
                                LocalTransaction siTran = AnycastOutputHandler.this.getLocalTransaction();
                                ((SIMPItemStream)AnycastOutputHandler.this.containerItemStream).removeAll((Transaction)siTran);
                                siTran.commit();
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.RemovePersistentStream.committed", (String)"1:2115:1.89.4.1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)e);
                            }
                        }
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class CreatePersistentStream
    extends AsyncUpdateWithRetry {
        final SIBUuid8 remoteMEId;
        final SIBUuid12 gatheringTargetDestUuid;
        final SIBUuid12 streamId;
        final String streamKey;
        final long requestId;
        final AOProtocolItemStream itemStream;
        final JSRemoteConsumerPoint aock;
        final ConsumableKey ck;
        final JSConsumerManager cd;
        final SIBUuid12 parentDest;

        CreatePersistentStream(SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, long requestId, JSRemoteConsumerPoint aock, ConsumableKey ck, SIBUuid12 parentDest, DestinationHandler destinationHandler, JSConsumerManager cd) {
            super(4L, AnycastOutputHandler.this.msUpdateThread, AnycastOutputHandler.this.destName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreatePersistentStream", (Object)new Object[]{remoteMEId, gatheringTargetDestUuid, streamId, requestId, aock, ck, parentDest, destinationHandler, cd});
            }
            this.remoteMEId = remoteMEId;
            this.gatheringTargetDestUuid = gatheringTargetDestUuid;
            this.streamId = streamId;
            this.streamKey = SIMPUtils.getRemoteGetKey(remoteMEId, gatheringTargetDestUuid);
            this.requestId = requestId;
            this.itemStream = new AOProtocolItemStream(remoteMEId, gatheringTargetDestUuid, streamId, destinationHandler);
            this.aock = aock;
            this.ck = ck;
            this.cd = cd;
            this.parentDest = parentDest;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreatePersistentStream", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute");
            }
            Transaction msTran = AnycastOutputHandler.this.mp.resolveAndEnlistMsgStoreTransaction(t);
            AnycastOutputHandler.this.containerItemStream.addItemStream((ItemStream)this.itemStream, msTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rolledback(Throwable e) {
            boolean isRetrying;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)e);
            }
            if (!(isRetrying = this.rolledbackRetry(e))) {
                Hashtable hashtable = AnycastOutputHandler.this.streamTable;
                synchronized (hashtable) {
                    AnycastOutputHandler.this.streamTable.remove(this.streamKey);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            try {
                boolean startFlushing;
                AOStream stream = new AOStream(this.remoteMEId, this.gatheringTargetDestUuid, this.streamId, this.itemStream, AnycastOutputHandler.this, AnycastOutputHandler.this.msUpdateThread, true, null, false, AnycastOutputHandler.this.mp, AnycastOutputHandler.this.dmeVersion, this.cd);
                StreamInfo sinfo = new StreamInfo(this.streamKey, this.streamId, stream, this.itemStream);
                if (this.aock != null) {
                    this.aock.init(stream, "", new ConsumableKey[]{this.ck}, 0L, AnycastOutputHandler.this.mp.getAlarmManager(), null);
                    stream.setConsumerKey(this.aock);
                }
                Hashtable hashtable = AnycastOutputHandler.this.streamTable;
                synchronized (hashtable) {
                    if (AnycastOutputHandler.this.closed) {
                        stream.close();
                        stream = null;
                        if (this.ck != null) {
                            this.ck.detach();
                        }
                    } else {
                        StreamInfo sinfo2 = AnycastOutputHandler.this.streamTable.put(this.streamKey, sinfo);
                        if (sinfo2.stream != null) {
                            AnycastOutputHandler.this.streamTable.put(this.streamKey, sinfo);
                            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.CreatePersistentStream", "1:1924:1.89.4.1"}, null));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.CreatePersistentStream", "1:1930:1.89.4.1"});
                            throw e;
                        }
                    }
                    startFlushing = AnycastOutputHandler.this.startedCloseAndFlush;
                }
                if (stream != null) {
                    stream.start();
                    if (startFlushing) {
                        stream.processRequestFlush();
                    } else {
                        stream.processAreYouFlushed(this.requestId, this.parentDest);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.CreatePersistentStream.committed", (String)"1:1949:1.89.4.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                try {
                    if (this.ck != null) {
                        this.ck.detach();
                    }
                    RemovePersistentStream update = new RemovePersistentStream(this.streamKey, this.streamId, this.itemStream, null);
                    AnycastOutputHandler.this.msUpdateThread.enqueueWork(update);
                }
                catch (ClosedException closedException) {
                    // empty catch block
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    public static abstract class AsyncUpdateWithRetry
    extends AsyncUpdate {
        private int repetitionCount;
        private final long repetitionThreshold;
        private final AsyncUpdateThread msUpdateThread;
        private final String destName;

        public AsyncUpdateWithRetry(long repetitionThreshold, AsyncUpdateThread msUpdateThread, String destName) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AsyncUpdateWithRetry", (Object)new Object[]{repetitionThreshold, msUpdateThread, destName});
            }
            this.repetitionThreshold = repetitionThreshold;
            this.msUpdateThread = msUpdateThread;
            this.repetitionCount = 1;
            this.destName = destName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AsyncUpdateWithRetry", (Object)this);
            }
        }

        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)e);
            }
            this.rolledbackRetry(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        public boolean rolledbackRetry(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledbackRetry", (Object)new Object[]{this, e});
            }
            boolean retvalue = true;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1748:1.89.4.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Throwable)e);
            ++this.repetitionCount;
            if (this.repetitionThreshold != -1L && (long)this.repetitionCount > this.repetitionThreshold) {
                retvalue = false;
                Exception e2 = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0457", new Object[]{this.destName, this.repetitionThreshold}, null));
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1765:1.89.4.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e2);
            } else {
                try {
                    this.msUpdateThread.enqueueWork(this);
                }
                catch (ClosedException e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1777:1.89.4.1", (Object)this);
                    retvalue = false;
                    Exception e3 = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0457", new Object[]{this.destName, this.repetitionCount - 1}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)e3);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledbackRetry");
            }
            return retvalue;
        }
    }
}

