/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageEventListeners;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MQLinkQueuedMessage;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessageItem
extends Item
implements SIMPMessage,
TransactionCallback {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(MessageItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ControlAdapter controlAdapter;
    private int producerSeed = 0;
    private int maintainPersistence = -1;
    private boolean streamIsGuess = false;
    private int fanOut;
    private Reliability msgReliability;
    private int msgPriority = -2;
    private SIBUuid12 guaranteedStreamUuid;
    private long currentMEArrivalTimeStamp;
    private long messageWaitTime = -1L;
    private long preMEArrivalWaitTime = 0L;
    private boolean arrivalTimeStored = true;
    private String debugName;
    private String _busName;
    private String messageControlClassification = null;
    private boolean retrievedMessageControlClassification = false;
    private boolean failedInitInRestore = false;
    private boolean registerEvents = false;
    private SIMPItemStream itemstream;
    private MessageEventListener PRE_COMMIT_ADD;
    private MessageEventListener PRE_COMMIT_REMOVE;
    private MessageEventListener REFERENCES_DROPPED_TO_ZERO;
    private MessageEventListener PRE_PREPARE_TRANSACTION;
    private MessageEventListener POST_COMMITTED_TRANSACTION;
    private MessageEventListener EXPIRY_NOTIFICATION;
    private MessageEventListener COD_CALLBACK;
    private final MessageEventListeners postCommitAddListeners = new MessageEventListeners(2, 2);
    private final MessageEventListeners postCommitRemoveListeners = new MessageEventListeners(3, 5);
    private final MessageEventListeners postRollbackAddListeners = new MessageEventListeners(4, 2);
    private final MessageEventListeners postRollbackRemoveListeners = new MessageEventListeners(5, 5);
    private final MessageEventListeners preUnlockedListeners = new MessageEventListeners(12, 2);
    private final MessageEventListeners unlockedListeners = new MessageEventListeners(6, 4);
    private JsMessage msg;
    private SoftReference<JsMessage> softReferenceMsg;
    private boolean transacted = false;
    private int maxStorageStrategy = 4;
    private boolean requiresNewId = false;
    private boolean storeAtSendTime = false;
    private boolean fromRemoteME = false;
    private boolean fromRemoteBus = false;
    private SIBUuid12 producerConnectionUuid = null;
    private MessageProcessorSearchResults searchResults;
    private long latestWaitTimeUpdate;
    private Byte _reportCOD;
    private boolean _reportCODSet = false;
    private boolean guaranteedStreamUuidSet = false;
    private boolean reavailable = false;
    private boolean forcePut = false;
    private int redirectCount = 0;
    private boolean redeliveryCountReached = false;
    private boolean preferLocal = true;
    private boolean restoringJsMessageOnly = false;
    private boolean hiddenMessage;
    private long hiddenExpiryTime = 0L;
    private SIBUuid8 localisingMEUuid;
    private long rmeUnlockCount = 0L;
    private long uncommittedRMEUnlockCount;
    private final Object messageSyncUpdateLock = new Object();

    public MessageItem() {
    }

    public MessageItem(JsMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MessageItem", (Object)msg);
        }
        this.msg = msg;
        this.setOriginatingBus(msg.getBus());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MessageItem", (Object)this);
        }
    }

    public MessageItem(JsMessage msg, long waitTime) {
        this(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MessageItem", (Object)new Object[]{msg, waitTime});
        }
        this.messageWaitTime = waitTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MessageItem", (Object)this);
        }
    }

    @Override
    public JsMessage getMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessage");
        }
        JsMessage localMsg = this.getJSMessage(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessage", (Object)localMsg);
        }
        return localMsg;
    }

    @Override
    public JsMessage getMessageIfAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageIfAvailable");
        }
        boolean throwExceptionIfNotAvailable = false;
        JsMessage localMsg = this.getJSMessage(throwExceptionIfNotAvailable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageIfAvailable", (Object)localMsg);
        }
        return localMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsMessage getJSMessage(boolean throwExceptionIfNotAvailable) {
        JsMessage localMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJSMessage", (Object)throwExceptionIfNotAvailable);
        }
        if ((localMsg = this.msg) == null) {
            if (this.softReferenceMsg != null) {
                localMsg = this.softReferenceMsg.get();
            }
            if (localMsg == null) {
                MessageItem messageItem = this;
                synchronized (messageItem) {
                    this.restoreJsMessageFromMsgstore(throwExceptionIfNotAvailable);
                    localMsg = this.msg;
                    if (localMsg != null) {
                        this.softReferenceMsg = new SoftReference<JsMessage>(this.msg);
                        this.msg = null;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJSMessage", (Object)localMsg);
        }
        return localMsg;
    }

    public int getStorageStrategy() {
        Reliability rel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStorageStrategy");
        }
        int storageStrategy = (rel = this.getReliability()) == Reliability.BEST_EFFORT_NONPERSISTENT ? 1 : (this.maintainPersistence != 0 && rel == Reliability.RELIABLE_PERSISTENT ? 3 : (this.maintainPersistence != 0 && rel == Reliability.ASSURED_PERSISTENT ? 4 : 2));
        int n = storageStrategy = storageStrategy < this.maxStorageStrategy ? storageStrategy : this.maxStorageStrategy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStorageStrategy", (Object)storageStrategy);
        }
        return storageStrategy;
    }

    public void restore(List<DataSlice> dataSlices) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restore", dataSlices);
        }
        this.restoreInternal(dataSlices, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restore");
        }
    }

    protected void restoreIfMsgAvailable(List<DataSlice> dataSlices) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreIfMsgAvailable", dataSlices);
        }
        this.restoreInternal(dataSlices, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreIfMsgAvailable");
        }
    }

    public void restoreInternal(List<DataSlice> dataSlices, boolean throwExceptionIfMsgNotAvailable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreInternal", (Object)new Object[]{dataSlices, throwExceptionIfMsgNotAvailable});
        }
        try {
            JsMessageFactory jmf = JsMessageFactory.getInstance();
            ArrayList<DataSlice> arraylistDataSlices = new ArrayList<DataSlice>(dataSlices);
            this.msg = jmf.restoreJsMessage(arraylistDataSlices, (Object)this.getOwningMessageStore());
            if (this.msg != null) {
                this.msg.setRedeliveredCount(this.guessRedeliveredCount());
            }
            this.itemstream = (SIMPItemStream)this.getItemStream();
            if (!this.restoringJsMessageOnly) {
                this.initialiseNonPersistent(true);
            }
        }
        catch (Exception e) {
            if (e instanceof NotInMessageStore && !throwExceptionIfMsgNotAvailable) {
                this.msg = null;
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.restoreInternal", (String)"1:677:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (e instanceof MessageRestoreFailedException) {
                SIMPItemStream stream = (SIMPItemStream)this.getItemStream();
                BaseDestinationHandler destHandler = this.getDestinationHandler(false, stream);
                destHandler.setCorrupt(true);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreInternal", (Object)e);
            }
            throw new MessageStoreRuntimeException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreInternal");
        }
    }

    BaseDestinationHandler getDestinationHandler(boolean registerForEvents, SIMPItemStream itemstream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationHandler", (Object)new Object[]{registerForEvents, itemstream});
        }
        BaseDestinationHandler destinationHandler = null;
        if (itemstream instanceof PubSubMessageItemStream) {
            PubSubMessageItemStream mis = (PubSubMessageItemStream)itemstream;
            destinationHandler = mis.getDestinationHandler();
        } else {
            MessageEventListener listener;
            PtoPMessageItemStream localisation = (PtoPMessageItemStream)itemstream;
            destinationHandler = localisation.getDestinationHandler();
            if (registerForEvents && (listener = (MessageEventListener)((Object)localisation.getOutputHandler())) != null) {
                listener.registerForEvents(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationHandler", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public void initialiseNonPersistent(boolean registerForEvents) throws SevereMessageStoreException {
        BaseDestinationHandler destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialiseNonPersistent");
        }
        if ((destinationHandler = this.getDestinationHandler(registerForEvents, this.itemstream)) != null) {
            SIBUuid8 srcME;
            JsMessage localMsg = this.getJSMessage(true);
            destinationHandler.registerForEvents(this);
            if (localMsg.getReportCOD() != null) {
                this.registerMessageEventListener(11, destinationHandler);
            }
            this.debugName = destinationHandler.getName();
            String originalBus = localMsg.getBus();
            this.setOriginatingBus(originalBus);
            MessageProcessor mp = destinationHandler.getMessageProcessor();
            if (originalBus != null && !originalBus.equals(mp.getMessagingEngineBus())) {
                this.fromRemoteBus = true;
            }
            if ((srcME = localMsg.getGuaranteedSourceMessagingEngineUUID()) != null && !mp.getMessagingEngineUuid().equals((Object)srcME)) {
                this.fromRemoteME = true;
            }
            this.failedInitInRestore = false;
        } else {
            this.failedInitInRestore = true;
        }
        if (this.isRemoving()) {
            this.itemstream.setCurrentTransaction(this, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialiseNonPersistent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSlice> getPersistentData() throws PersistentDataEncodingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentData");
        }
        if (!this.arrivalTimeStored) {
            this.msg.setCurrentMEArrivalTimestamp(this.currentMEArrivalTimeStamp);
            this.arrivalTimeStored = true;
        }
        if (this.producerConnectionUuid != null) {
            this.msg.setConnectionUuid(this.producerConnectionUuid);
        }
        List data = null;
        try {
            Object object = this.messageSyncUpdateLock;
            synchronized (object) {
                data = this.msg.flatten((Object)this.getOwningMessageStore());
            }
        }
        catch (MessageEncodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.getPersistentData", (String)"1:861:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"MESSAGE_CORRUPT_ERROR_CWSIP0262", (Object)new Object[]{SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e));
            }
            throw new PersistentDataEncodingException(nls.getFormattedMessage("MESSAGE_CORRUPT_ERROR_CWSIP0262", new Object[]{e}, null), (Throwable)e);
        }
        catch (MessageStoreException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e));
            }
            throw new PersistentDataEncodingException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentData");
        }
        return data;
    }

    public int getInMemoryDataSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInMemoryDataSize");
        }
        JsMessage localMsg = this.getJSMessage(true);
        int msgSize = localMsg.getInMemorySize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInMemoryDataSize", (Object)msgSize);
        }
        return msgSize;
    }

    @Override
    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReliability");
        }
        if (this.msgReliability == null) {
            JsMessage localMsg = this.getJSMessage(true);
            this.msgReliability = localMsg.getReliability();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReliability", (Object)this.msgReliability);
        }
        return this.msgReliability;
    }

    public void setReliability(Reliability reliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReliability", (Object)reliability);
        }
        JsMessage localMsg = this.getJSMessage(true);
        this.msgReliability = reliability;
        localMsg.setReliability(this.msgReliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReliability");
        }
    }

    public long getExpiryStartTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExpiryStartTime");
        }
        long startTime = this.getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExpiryStartTime", (Object)startTime);
        }
        return startTime;
    }

    public long getMaximumTimeInStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        JsMessage localMsg = this.getJSMessage(true);
        long timeToLive = localMsg.getTimeToLive();
        long maxTime = -2L;
        if (timeToLive > 0L) {
            maxTime = timeToLive - this.getAggregateWaitTime();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)maxTime);
        }
        return maxTime;
    }

    @Override
    public long calculateWaitTimeUpdate(long timeNow) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"calculateWaitTimeUpdate");
        }
        long calculatedWaitTime = timeNow - this.getCurrentMEArrivalTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"calculateWaitTimeUpdate", (Object)calculatedWaitTime);
        }
        return calculatedWaitTime;
    }

    public boolean canExpireSilently() {
        JsMessage localMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"canExpireSilently");
        }
        if ((localMsg = this.getJSMessage(true)).getReportExpiry() != null || TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"canExpireSilently", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"canExpireSilently");
        }
        return super.canExpireSilently();
    }

    public void eventExpiryNotification(Transaction transaction) throws SevereMessageStoreException {
        super.eventExpiryNotification(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventExpiryNotification", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && this.getJSMessage(true).isApiMessage()) {
            String apiMsgId = null;
            if (this.getJSMessage(true) instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)this.getJSMessage(true)).getApiMessageId();
            } else if (this.getJSMessage(true).getApiMessageIdAsBytes() != null) {
                apiMsgId = this.getJSMessage(true).getApiMessageIdAsBytes().toString();
            }
            SibTr.debug((Object)this, (TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXPIRED_CWSJU0011", new Object[]{apiMsgId, this.getJSMessage(true).getSystemMessageId(), this.debugName}, null));
        }
        if (this.EXPIRY_NOTIFICATION != null) {
            try {
                if (this.getJSMessage(true).getReportExpiry() != null) {
                    this.EXPIRY_NOTIFICATION.messageEventOccurred(10, this, (TransactionCommon)transaction);
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventExpiryNotification", (String)"1:1096:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventExpiryNotification", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventExpiryNotification");
        }
    }

    public void handleInvalidDeliveryDelayable(MessageStoreConstants.MaximumAllowedDeliveryDelayAction action) throws MessageStoreException, SIException {
        String methodName = "handleInvalidDeliveryDelayable";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable", (Object)action);
        }
        try {
            JsMessage jsMessage = this.getJSMessage(true);
            String apiMsgId = null;
            if (jsMessage instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)jsMessage).getApiMessageId();
            } else if (jsMessage.getApiMessageIdAsBytes() != null) {
                apiMsgId = this.getJSMessage(true).getApiMessageIdAsBytes().toString();
            }
            SIMPItemStream itemstream = (SIMPItemStream)this.getItemStream();
            BaseDestinationHandler baseDestinationHandler = this.getDestinationHandler(false, itemstream);
            switch (action) {
                case exception: {
                    baseDestinationHandler.handleUndeliverableMessage(this, 906, new String[]{apiMsgId, jsMessage.getSystemMessageId(), baseDestinationHandler.getName(), baseDestinationHandler.getMessageProcessor().getMessagingEngineName()}, null);
                }
            }
            SibTr.warning((TraceComponent)tc, (String)"DELIVERY_DELAY_TIME_WARNING_CWSIP0580", (Object)new Object[]{apiMsgId, jsMessage.getSystemMessageId(), baseDestinationHandler.getName(), action.toString()});
        }
        catch (SIException | MessageStoreException exception) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable", (Object)exception);
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
        }
        this.dereferenceControlAdapter();
        try {
            this.postCommitRemoveListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostCommitRemove", (String)"1:1160:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostCommitRemove", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) throws SevereMessageStoreException {
        block21: {
            super.eventPostCommitAdd(transaction);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
            }
            if (this.failedInitInRestore) {
                this.initialiseNonPersistent(true);
                this.setRegisterForPostEvents(true);
            }
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                try {
                    if (this.getJSMessage(true).isApiMessage()) {
                        boolean foreignBus = false;
                        boolean link = false;
                        boolean mqlink = false;
                        String targetME = null;
                        if (this.debugName != null) {
                            SIBUuid8 meUUID;
                            SIMPItemStream itemstream = (SIMPItemStream)this.getItemStream();
                            BaseDestinationHandler destination = this.getDestinationHandler(false, itemstream);
                            targetME = itemstream instanceof PubSubMessageItemStream ? destination.getMessageProcessor().getMessagingEngineName() : ((meUUID = ((PtoPMessageItemStream)itemstream).getLocalizingMEUuid()).equals((Object)destination.getMessageProcessor().getMessagingEngineUuid()) ? destination.getMessageProcessor().getMessagingEngineName() : meUUID.toString());
                            foreignBus = destination.isForeignBus();
                            link = destination.isLink();
                            mqlink = destination.isMQLink();
                        }
                        String apiMsgId = null;
                        String correlationId = null;
                        if (this.getJSMessage(true) instanceof JsApiMessage) {
                            apiMsgId = ((JsApiMessage)this.getJSMessage(true)).getApiMessageId();
                            correlationId = ((JsApiMessage)this.getJSMessage(true)).getCorrelationId();
                        } else {
                            if (this.getJSMessage(true).getApiMessageIdAsBytes() != null) {
                                apiMsgId = new String(this.getJSMessage(true).getApiMessageIdAsBytes());
                            }
                            if (this.getJSMessage(true).getCorrelationIdAsBytes() != null) {
                                correlationId = new String(this.getJSMessage(true).getCorrelationIdAsBytes());
                            }
                        }
                        String msg = "PRODUCER_SEND_COMMIT_CWSJU0003";
                        if (foreignBus) {
                            msg = "PRODUCER_SEND_COMMIT_BUS_CWSJU0064";
                        } else if (mqlink) {
                            msg = "PRODUCER_SEND_COMMIT_MQLINK_CWSJU0066";
                        } else if (link) {
                            msg = "PRODUCER_SEND_COMMIT_LINK_CWSJU0065";
                        }
                        SibTr.debug((Object)this, (TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(msg, new Object[]{apiMsgId, this.getJSMessage(true).getSystemMessageId(), correlationId, this.debugName, targetME}, null));
                    }
                }
                catch (MessageStoreException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        if (!transaction.isAutoCommit()) {
            try {
                this.postCommitAddListeners.messageEventOccurred(this, transaction);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostCommitAdd", (String)"1:1313:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostCommitAdd", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
            this.setRegisterForPostEvents(true);
        }
        try {
            this.postRollbackAddListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostRollbackAdd", (String)"1:1360:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        this.resetEvents();
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            String apiMsgId = null;
            if (this.getJSMessage(true) instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)this.getJSMessage(true)).getApiMessageId();
            } else if (this.getJSMessage(true).getApiMessageIdAsBytes() != null) {
                apiMsgId = this.getJSMessage(true).getApiMessageIdAsBytes().toString();
            }
            PersistentTranId persistentTranId = transaction != null ? transaction.getPersistentTranId() : null;
            SibTr.debug((Object)this, (TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_ROLLBACK_CWSJU0010", new Object[]{apiMsgId, this.getJSMessage(true).getSystemMessageId(), this.debugName, persistentTranId}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
        }
        try {
            this.postRollbackRemoveListeners.messageEventOccurred(this, transaction);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostRollbackRemove", (String)"1:1455:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    private void resetEvents() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetEvents");
        }
        this.PRE_COMMIT_ADD = null;
        this.PRE_COMMIT_REMOVE = null;
        this.postCommitAddListeners.reset();
        this.postCommitRemoveListeners.reset();
        this.postRollbackAddListeners.reset();
        this.postRollbackRemoveListeners.reset();
        this.unlockedListeners.reset();
        this.preUnlockedListeners.reset();
        this.REFERENCES_DROPPED_TO_ZERO = null;
        this.PRE_PREPARE_TRANSACTION = null;
        this.POST_COMMITTED_TRANSACTION = null;
        this.EXPIRY_NOTIFICATION = null;
        this.COD_CALLBACK = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resetEvents");
        }
    }

    @Override
    public void eventUnlocked() throws SevereMessageStoreException {
        super.eventUnlocked();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventUnlocked");
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
        }
        this.reavailable = true;
        try {
            this.unlockedListeners.messageEventOccurred(this, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventUnlocked", (String)"1:1568:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventUnlocked", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        this.reavailable = false;
        this.rmeUnlockCount += this.uncommittedRMEUnlockCount;
        this.uncommittedRMEUnlockCount = 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    @Override
    public void eventLocked() {
    }

    public void itemReferencesDroppedToZero() {
        super.itemReferencesDroppedToZero();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemReferencesDroppedToZero");
        }
        if (this.failedInitInRestore) {
            try {
                this.initialiseNonPersistent(true);
            }
            catch (SevereMessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.itemReferencesDroppedToZero", (String)"1:1617:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (this.REFERENCES_DROPPED_TO_ZERO != null) {
            try {
                this.REFERENCES_DROPPED_TO_ZERO.messageEventOccurred(7, this, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.itemReferencesDroppedToZero", (String)"1:1644:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemReferencesDroppedToZero");
        }
    }

    @Override
    public SIBUuid12 getProducerConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducerConnectionUuid");
        }
        if (this.producerConnectionUuid == null) {
            JsMessage localMsg = this.getJSMessage(true);
            this.producerConnectionUuid = localMsg.getConnectionUuid();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducerConnectionUuid", (Object)this.producerConnectionUuid);
        }
        return this.producerConnectionUuid;
    }

    public void setProducerConnectionUuid(SIBUuid12 producerConnectionUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProducerConnectionUuid", (Object)producerConnectionUuid);
        }
        this.producerConnectionUuid = producerConnectionUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProducerConnectionUuid");
        }
    }

    public void setProducerSeed(int producerSeed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProducerSeed", (Object)producerSeed);
        }
        this.producerSeed = producerSeed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProducerSeed");
        }
    }

    public void setForcePut(boolean _forcePut) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setForcePut", (Object)_forcePut);
        }
        this.forcePut = _forcePut;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForcePut");
        }
    }

    public boolean isForcePut() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isForcePut");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isForcePut", (Object)this.forcePut);
        }
        return this.forcePut;
    }

    @Override
    public String toString() {
        try {
            String sysId = "null";
            String apiId = "null";
            if (this.msg != null) {
                sysId = this.msg.getSystemMessageId();
                if (this.msg instanceof JsApiMessage) {
                    apiId = ((JsApiMessage)this.msg).getApiMessageId();
                } else if (this.msg.getApiMessageIdAsBytes() != null) {
                    apiId = new String(this.msg.getApiMessageIdAsBytes());
                }
            }
            long msId = -1L;
            try {
                if (this.isInStore()) {
                    msId = this.getID();
                }
            }
            catch (MessageStoreException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            String text = null;
            if (this.msg instanceof JsJmsTextMessage) {
                try {
                    text = "'" + ((JsJmsTextMessage)this.msg).getText() + "'";
                    if (text != null && text.length() > 30) {
                        text = text.substring(0, 30) + "..'";
                    }
                }
                catch (UnsupportedEncodingException e) {
                    text = "Unsupported message encoding";
                }
            } else {
                text = String.valueOf(this.msg);
            }
            return "MessageItem@" + Integer.toHexString(this.hashCode()) + "[" + sysId + "," + apiId + "," + msId + "," + text + "]";
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    @Override
    public boolean isTransacted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTransacted");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTransacted", (Object)this.transacted);
        }
        return this.transacted;
    }

    @Override
    public int getProducerSeed() {
        return this.producerSeed;
    }

    public void setMaxStorageStrategy(int requestedMaxStrategy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaxStorageStrategy", (Object)requestedMaxStrategy);
        }
        this.maxStorageStrategy = requestedMaxStrategy;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMaxStorageStrategy");
        }
    }

    @Override
    public int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        if (this.msgPriority == -2) {
            JsMessage localMsg = this.getJSMessage(true);
            this.msgPriority = localMsg.getPriority();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)this.msgPriority);
        }
        return this.msgPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeliveryDelay() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay");
        }
        long deliveryDelay = 0L;
        try {
            long l = deliveryDelay = this.getJSMessage(true).getDeliveryDelay().longValue();
            return l;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay", (Object)deliveryDelay);
            }
        }
    }

    public void setPriority(int newPriority) {
        JsMessage localMsg = this.getJSMessage(true);
        this.msgPriority = newPriority;
        localMsg.setPriority(newPriority);
    }

    @Override
    public void registerMessageEventListener(int event, MessageEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerMessageEventListener", (Object)new Object[]{event, listener});
        }
        boolean error = false;
        switch (event) {
            case 2: {
                this.postCommitAddListeners.add(listener);
                break;
            }
            case 3: {
                this.postCommitRemoveListeners.add(listener);
                break;
            }
            case 4: {
                this.postRollbackAddListeners.add(listener);
                break;
            }
            case 5: {
                this.postRollbackRemoveListeners.add(listener);
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD == null) {
                    this.PRE_COMMIT_ADD = listener;
                    break;
                }
                error = true;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE == null) {
                    this.PRE_COMMIT_REMOVE = listener;
                    break;
                }
                error = true;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO == null) {
                    this.REFERENCES_DROPPED_TO_ZERO = listener;
                    break;
                }
                error = true;
                break;
            }
            case 6: {
                this.unlockedListeners.add(listener);
                break;
            }
            case 12: {
                this.preUnlockedListeners.add(listener);
                break;
            }
            case 8: {
                if (this.PRE_PREPARE_TRANSACTION == null) {
                    this.PRE_PREPARE_TRANSACTION = listener;
                    break;
                }
                error = true;
                break;
            }
            case 9: {
                if (this.POST_COMMITTED_TRANSACTION == null) {
                    this.POST_COMMITTED_TRANSACTION = listener;
                    break;
                }
                error = true;
                break;
            }
            case 10: {
                if (this.EXPIRY_NOTIFICATION == null) {
                    this.EXPIRY_NOTIFICATION = listener;
                    break;
                }
                error = true;
                break;
            }
            case 11: {
                if (this.COD_CALLBACK == null) {
                    this.COD_CALLBACK = listener;
                    break;
                }
                error = true;
            }
        }
        if (error) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", "1:1982:1.244.1.40", event}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", (String)"1:1988:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", "1:1995:1.244.1.40", event});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerMessageEventListener", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerMessageEventListener");
        }
    }

    @Override
    public void deregisterMessageEventListener(int event, MessageEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deregisterMessageEventListener", (Object)new Object[]{event, listener});
        }
        switch (event) {
            case 2: {
                this.postCommitAddListeners.remove(listener);
                break;
            }
            case 3: {
                this.postCommitRemoveListeners.remove(listener);
                break;
            }
            case 4: {
                this.postRollbackAddListeners.remove(listener);
                break;
            }
            case 5: {
                this.postRollbackRemoveListeners.remove(listener);
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD != listener) break;
                this.PRE_COMMIT_ADD = null;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE != listener) break;
                this.PRE_COMMIT_REMOVE = null;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO != listener) break;
                this.REFERENCES_DROPPED_TO_ZERO = null;
                break;
            }
            case 6: {
                this.unlockedListeners.remove(listener);
                break;
            }
            case 12: {
                this.preUnlockedListeners.remove(listener);
                break;
            }
            case 8: {
                if (this.PRE_PREPARE_TRANSACTION != listener) break;
                this.PRE_PREPARE_TRANSACTION = null;
                break;
            }
            case 9: {
                if (this.POST_COMMITTED_TRANSACTION != listener) break;
                this.POST_COMMITTED_TRANSACTION = null;
                break;
            }
            case 10: {
                if (this.EXPIRY_NOTIFICATION != listener) break;
                this.EXPIRY_NOTIFICATION = null;
                break;
            }
            case 11: {
                if (this.COD_CALLBACK != listener) break;
                this.COD_CALLBACK = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deregisterMessageEventListener");
        }
    }

    public void addPersistentRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addPersistentRef");
        }
        this.maintainPersistence = 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addPersistentRef");
        }
    }

    public void addNonPersistentRef() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addNonPersistentRef");
        }
        if (this.maintainPersistence == -1) {
            this.maintainPersistence = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addNonPersistentRef");
        }
    }

    public MessageProcessorSearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(MessageProcessorSearchResults searchResults) {
        this.searchResults = searchResults;
    }

    @Override
    public long getAggregateWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAggregateWaitTime");
        }
        if (this.messageWaitTime == -1L) {
            JsMessage localMsg = this.getJSMessage(true);
            this.preMEArrivalWaitTime = this.messageWaitTime = localMsg.getMessageWaitTime().longValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAggregateWaitTime", (Object)this.messageWaitTime);
        }
        return this.messageWaitTime;
    }

    @Override
    public long getLatestWaitTimeUpdate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLatestWaitTimeUpdate");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLatestWaitTimeUpdate", (Object)this.latestWaitTimeUpdate);
        }
        return this.latestWaitTimeUpdate;
    }

    public void beforeCompletion(TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            try {
                this.initialiseNonPersistent(true);
            }
            catch (SevereMessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.beforeCompletion", (String)"1:2209:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        try {
            if (this.PRE_PREPARE_TRANSACTION != null) {
                this.PRE_PREPARE_TRANSACTION.messageEventOccurred(8, this, transaction);
                this.PRE_PREPARE_TRANSACTION = null;
            } else if (this.COD_CALLBACK != null) {
                this.COD_CALLBACK.messageEventOccurred(11, this, transaction);
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.beforeCompletion", (String)"1:2243:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object)((Object)e));
            }
            throw new SIErrorException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public void afterCompletion(TransactionCommon transaction, boolean committed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object)transaction);
        }
        if (this.failedInitInRestore) {
            try {
                this.initialiseNonPersistent(true);
            }
            catch (SevereMessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.afterCompletion", (String)"1:2279:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (committed && this.POST_COMMITTED_TRANSACTION != null) {
            try {
                this.POST_COMMITTED_TRANSACTION.messageEventOccurred(9, this, transaction);
                this.POST_COMMITTED_TRANSACTION = null;
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.afterCompletion", (String)"1:2307:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object)((Object)e));
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        this.releaseJsMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion");
        }
    }

    @Override
    public void setStreamIsGuess(boolean streamIsGuess) {
        this.streamIsGuess = streamIsGuess;
    }

    @Override
    public boolean getStreamIsGuess() {
        return this.streamIsGuess;
    }

    public void setFanOut(int newFanOut) {
        this.fanOut = newFanOut;
    }

    public int getFanOut() {
        return this.fanOut;
    }

    @Override
    public boolean getRequiresNewId() {
        return this.requiresNewId;
    }

    @Override
    public void setRequiresNewId(boolean value) {
        this.requiresNewId = value;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        block17: {
            if (this.msg == null) {
                this.getJSMessage(true);
            }
            try {
                if (this.msg == null) break block17;
                writer.newLine();
                writer.taggedValue("JsMessage", (Object)this.msg.getClass().getName());
                writer.newLine();
                writer.taggedValue("systemMessageId", (Object)this.msg.getSystemMessageId());
                if (this.msg instanceof JsApiMessage) {
                    writer.newLine();
                    writer.taggedValue("APIMessageId", (Object)((JsApiMessage)this.msg).getApiMessageId());
                    writer.newLine();
                    writer.taggedValue("APICorrelId", (Object)((JsApiMessage)this.msg).getCorrelationId());
                } else {
                    if (this.msg.getApiMessageIdAsBytes() != null) {
                        writer.newLine();
                        writer.taggedValue("APIMessageId", (Object)new String(this.msg.getApiMessageIdAsBytes()));
                    }
                    if (this.msg.getCorrelationIdAsBytes() != null) {
                        writer.newLine();
                        writer.taggedValue("APICorrelId", (Object)new String(this.msg.getCorrelationIdAsBytes()));
                    }
                }
                writer.newLine();
                writer.taggedValue("putTime", (Object)new Date(this.msg.getTimestamp()));
                try {
                    ItemStream is = this.getItemStream();
                    if (is instanceof PtoPXmitMsgsItemStream) {
                        writer.newLine();
                        writer.startTag("xmitData");
                        writer.indent();
                        writer.newLine();
                        writer.taggedValue("startTick", this.msg.getGuaranteedValueStartTick());
                        writer.newLine();
                        writer.taggedValue("endTick", this.msg.getGuaranteedValueEndTick());
                        writer.newLine();
                        writer.taggedValue("priority", (Object)this.msg.getPriority());
                        writer.newLine();
                        writer.taggedValue("reliability", (Object)this.msg.getReliability());
                        writer.newLine();
                        writer.taggedValue("streamId", (Object)this.msg.getGuaranteedStreamUUID());
                        if (this.msg.getRoutingDestination() != null) {
                            writer.newLine();
                            writer.taggedValue("routingDestination", (Object)this.msg.getRoutingDestination());
                        }
                        writer.outdent();
                        writer.newLine();
                        writer.endTag("xmitData");
                    }
                }
                catch (SevereMessageStoreException is) {
                }
                catch (RuntimeException is) {
                    // empty catch block
                }
                String text = null;
                if (this.msg instanceof JsJmsTextMessage) {
                    try {
                        text = ((JsJmsTextMessage)this.msg).getText();
                        if (text != null && text.length() > 40) {
                            text = text.substring(0, 37) + "...";
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        text = "Unsupported message encoding";
                    }
                } else {
                    text = String.valueOf(this.msg);
                }
                writer.newLine();
                writer.taggedValue("data", (Object)text);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setStoreAtSendTime(boolean store) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStoreAtSendTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setStoreAtSendTime");
        }
        this.storeAtSendTime = store;
    }

    @Override
    public boolean isToBeStoredAtSendTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isToBeStoredAtSendTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isToBeStoredAtSendTime");
        }
        return this.storeAtSendTime;
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createControlAdapter");
        }
        BaseDestinationHandler dh = null;
        try {
            ItemStream is = this.getItemStream();
            if (is instanceof PubSubMessageItemStream) {
                dh = ((PubSubMessageItemStream)is).getDestinationHandler();
                this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)dh, is);
            } else if (is instanceof MQLinkMessageItemStream) {
                dh = ((MQLinkMessageItemStream)is).getDestinationHandler();
                this.controlAdapter = new MQLinkQueuedMessage((SIMPMessage)this, (DestinationHandler)dh, is);
            } else if (is instanceof PtoPMessageItemStream) {
                dh = ((PtoPMessageItemStream)is).getDestinationHandler();
                this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)dh, is);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown item stream type " + is));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.createControlAdapter", (String)"1:2585:1.244.1.40", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public boolean isFromRemoteME() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isFromRemoteME");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isFromRemoteME", (Object)this.fromRemoteME);
        }
        return this.fromRemoteME;
    }

    public void setFromRemoteME(boolean fromRemoteME) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFromRemoteME", (Object)fromRemoteME);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFromRemoteME");
        }
        this.fromRemoteME = fromRemoteME;
    }

    public boolean isFromRemoteBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isFromRemoteBus");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isFromRemoteBus", (Object)this.fromRemoteBus);
        }
        return this.fromRemoteBus;
    }

    public void setFromRemoteBus(boolean fromRemoteBus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFromRemoteBus", (Object)fromRemoteBus);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFromRemoteBus");
        }
        this.fromRemoteBus = fromRemoteBus;
    }

    @Override
    public void dereferenceControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    @Override
    public SIBUuid12 getGuaranteedStreamUuid() {
        if (!this.guaranteedStreamUuidSet) {
            JsMessage localMsg = this.getJSMessage(true);
            this.guaranteedStreamUuidSet = true;
            this.guaranteedStreamUuid = localMsg.getGuaranteedStreamUUID();
        }
        return this.guaranteedStreamUuid;
    }

    @Override
    public void setGuaranteedStreamUuid(SIBUuid12 uuid) {
        JsMessage localMsg = this.getJSMessage(true);
        this.guaranteedStreamUuid = uuid;
        this.guaranteedStreamUuidSet = true;
        localMsg.setGuaranteedStreamUUID(this.guaranteedStreamUuid);
    }

    @Override
    public Byte getReportCOD() {
        if (!this._reportCODSet) {
            JsMessage localMsg = this.getJSMessage(true);
            this._reportCODSet = true;
            this._reportCOD = localMsg.getReportCOD();
        }
        return this._reportCOD;
    }

    public long getCurrentMEArrivalTimestamp() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurrentMEArrivalTimestamp");
        }
        if (this.currentMEArrivalTimeStamp == 0L) {
            JsMessage localMsg = this.getJSMessage(true);
            this.currentMEArrivalTimeStamp = localMsg.getCurrentMEArrivalTimestamp();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCurrentMEArrivalTimestamp", (Object)this.currentMEArrivalTimeStamp);
        }
        return this.currentMEArrivalTimeStamp;
    }

    public void setCurrentMEArrivalTimestamp(long timeStamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCurrentMEArrivalTimestamp", (Object)timeStamp);
        }
        this.currentMEArrivalTimeStamp = timeStamp;
        this.arrivalTimeStored = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCurrentMEArrivalTimestamp");
        }
    }

    @Override
    public long updateStatisticsMessageWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateStatisticsMessageWaitTime");
        }
        long timeNow = System.currentTimeMillis();
        this.latestWaitTimeUpdate = this.calculateWaitTimeUpdate(timeNow);
        this.messageWaitTime = this.latestWaitTimeUpdate + this.getPreMEArrivalWaitTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateStatisticsMessageWaitTime", (Object)this.messageWaitTime);
        }
        return this.messageWaitTime;
    }

    public void setDebugName(String string) {
        this.debugName = string;
    }

    @Override
    public boolean isReavailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReavailable");
            SibTr.exit((TraceComponent)tc, (String)"isReavailable", (Object)this.reavailable);
        }
        return this.reavailable;
    }

    @Override
    public int guessRedeliveredCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"guessRedeliveredCount");
        }
        int count = 0;
        count = super.guessUnlockCount() + (int)this.rmeUnlockCount + (int)this.uncommittedRMEUnlockCount;
        try {
            count += super.getPersistedRedeliveredCount();
        }
        catch (MessageStoreException messageStoreException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessRedeliveredCount", (Object)count);
        }
        return count;
    }

    private void setOriginatingBus(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setOriginatingBus", (Object)busName);
        }
        this._busName = busName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setOriginatingBus");
        }
    }

    public String getOriginatingBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOriginatingBus");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOriginatingBus", (Object)this._busName);
        }
        return this._busName;
    }

    public boolean isPersistentDataImmutable() {
        return true;
    }

    public boolean isPersistentDataNeverUpdated() {
        return true;
    }

    public void forceCurrentMEArrivalTimeToJsMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forceCurrentMEArrivalTimeToJsMessage");
        }
        if (!this.arrivalTimeStored) {
            JsMessage localMsg = this.getJSMessage(true);
            localMsg.setCurrentMEArrivalTimestamp(this.currentMEArrivalTimeStamp);
            this.arrivalTimeStored = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forceCurrentMEArrivalTimeToJsMessage");
        }
    }

    public int getRedirectCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRedirectCount");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRedirectCount", (Object)this.redirectCount);
        }
        return this.redirectCount;
    }

    public void incrementRedirectCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementRedirectCount");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementRedirectCount", (Object)this.redirectCount);
        }
        ++this.redirectCount;
    }

    @Override
    public void unlockMsg(long lockID, Transaction transaction, boolean incrementUnlock) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockMsg", (Object)new Object[]{lockID, transaction, incrementUnlock});
        }
        if (this.failedInitInRestore) {
            this.initialiseNonPersistent(true);
        }
        if (incrementUnlock) {
            this.redeliveryCountReached = false;
            try {
                this.preUnlockedListeners.messageEventOccurred(this, transaction);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.unlockMsg", (String)"1:2955:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                this.redeliveryCountReached = false;
            }
        }
        if (!this.redeliveryCountReached) {
            this.unlock(lockID, transaction, incrementUnlock);
            SIMPItemStream itemStream = (SIMPItemStream)this.getItemStream();
            BaseDestinationHandler bdh = this.getDestinationHandler(false, itemStream);
            if (bdh.isRedeliveryCountPersisted() && bdh.getMessageProcessor().getMessageStore().isRedeliveryCountColumnAvailable()) {
                int rdl_count = this.guessRedeliveredCount();
                try {
                    this.persistRedeliveredCount(rdl_count);
                }
                catch (NotInMessageStore e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                if (this.msg != null) {
                    this.msg.setRedeliveredCount(rdl_count);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockMsg");
        }
    }

    public void persistRedeliveredCount(int redeliveredCount) throws SevereMessageStoreException {
        super.persistRedeliveredCount(redeliveredCount);
    }

    @Override
    public void setRedeliveryCountReached() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRedeliveryCountReached");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRedeliveryCountReached");
        }
        this.redeliveryCountReached = true;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseJsMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"releaseJsMessage");
        }
        if (this.getReliability().compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0 && this.isPersistentRepresentationStable()) {
            MessageItem messageItem = this;
            synchronized (messageItem) {
                this.softReferenceMsg = new SoftReference<JsMessage>(this.msg);
                this.msg = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"releaseJsMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreJsMessageFromMsgstore(boolean throwExceptionIfNotAvailable) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreJsMessageFromMsgstore", (Object)throwExceptionIfNotAvailable);
            }
            this.restoringJsMessageOnly = true;
            try {
                this.restoreData(throwExceptionIfNotAvailable);
            }
            catch (MessageStoreException e) {
                if (e instanceof NotInMessageStore && !throwExceptionIfNotAvailable) {
                    this.msg = null;
                    break block9;
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.restoreJsMessageFromMsgstore", (String)"1:3079:1.244.1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"1:3086:1.244.1.40", SIMPUtils.getStackTrace(e)});
                SIMPErrorException errorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItem", "1:3094:1.244.1.40"}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreJsMessageFromMsgstore", (Object)((Object)e));
                }
                throw errorException;
            }
            finally {
                this.restoringJsMessageOnly = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreJsMessageFromMsgstore", (Object)this.msg);
        }
    }

    public void setPreferLocal(boolean preferLocal) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPreferLocal", (Object)preferLocal);
            SibTr.exit((TraceComponent)tc, (String)"setPreferLocal");
        }
        this.preferLocal = preferLocal;
    }

    public boolean preferLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"preferLocal");
            SibTr.exit((TraceComponent)tc, (String)"preferLocal", (Object)this.preferLocal);
        }
        return this.preferLocal;
    }

    @Override
    public void markHiddenMessage(boolean hiddenMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markHiddenMessage", (Object)hiddenMessage);
            SibTr.exit((TraceComponent)tc, (String)"markHiddenMessage");
        }
        this.hiddenMessage = hiddenMessage;
    }

    @Override
    public boolean isHidden() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isHidden");
            SibTr.exit((TraceComponent)tc, (String)"isHidden", (Object)this.hiddenMessage);
        }
        return this.hiddenMessage;
    }

    @Override
    public void setHiddenExpiryTime(long expiryTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setHiddenExpiryTime", (Object)expiryTime);
        }
        this.hiddenExpiryTime = expiryTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setHiddenExpiryTime");
        }
    }

    @Override
    public long getHiddenExpiryTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHiddenExpiryTime");
            SibTr.exit((TraceComponent)tc, (String)"getHiddenExpiryTime", (Object)this.hiddenExpiryTime);
        }
        return this.hiddenExpiryTime;
    }

    @Override
    public SIBUuid8 getLocalisingMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisingMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getLocalisingMEUuid", (Object)this.localisingMEUuid);
        }
        return this.localisingMEUuid;
    }

    @Override
    public void setLocalisingME(SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLocalisingME", (Object)messagingEngineUuid);
        }
        this.localisingMEUuid = messagingEngineUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLocalisingME");
        }
    }

    @Override
    public long getMessageWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageWaitTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageWaitTime", (Object)this.messageWaitTime);
        }
        return this.messageWaitTime;
    }

    private long getPreMEArrivalWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPreMEArrivalWaitTime");
        }
        if (this.messageWaitTime == -1L) {
            JsMessage localMsg = this.getJSMessage(true);
            this.preMEArrivalWaitTime = this.messageWaitTime = localMsg.getMessageWaitTime().longValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPreMEArrivalWaitTime", (Object)this.preMEArrivalWaitTime);
        }
        return this.preMEArrivalWaitTime;
    }

    @Override
    public boolean isRemoteGet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemote");
            SibTr.exit((TraceComponent)tc, (String)"isRemote", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public void setMessageControlClassification(String classification) {
        JsMessage localMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessageControlClassification", (Object)classification);
        }
        if ((localMsg = this.getJSMessage(true)).isApiMessage() && localMsg instanceof JsApiMessage) {
            ((JsApiMessage)localMsg).setMessageControlClassification(classification);
            this.messageControlClassification = classification;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageControlClassification");
        }
    }

    @Override
    public String getMessageControlClassification(boolean throwExceptionIfMessageNotAvailable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageControlClassification", (Object)throwExceptionIfMessageNotAvailable);
        }
        if (!this.retrievedMessageControlClassification) {
            JsMessage localMsg = this.getJSMessage(throwExceptionIfMessageNotAvailable);
            if (localMsg == null) {
                this.messageControlClassification = null;
            } else {
                if (localMsg.isApiMessage() && localMsg instanceof JsApiMessage) {
                    this.messageControlClassification = ((JsApiMessage)localMsg).getMessageControlClassification();
                }
                this.retrievedMessageControlClassification = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageControlClassification", (Object)this.messageControlClassification);
        }
        return this.messageControlClassification;
    }

    @Override
    public void setRMEUnlockCount(long rmeUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRMEUnlockCount", (Object)rmeUnlockCount);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRMEUnlockCount");
        }
        this.uncommittedRMEUnlockCount = rmeUnlockCount;
    }

    public Object getSynchUpdateLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSynchUpdateLock");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSynchUpdateLock", (Object)this.messageSyncUpdateLock);
        }
        return this.messageSyncUpdateLock;
    }

    public void setRegisterForPostEvents(boolean registerEvents) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRegisterForPostEvents", (Object)registerEvents);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRegisterForPostEvents");
        }
        this.registerEvents = registerEvents;
    }

    public boolean getRegisterForPostEvents() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRegisterForPostEvents");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRegisterForPostEvents", (Object)this.registerEvents);
        }
        return this.registerEvents;
    }
}

