/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Entry;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Cursor
extends Entry {
    private static final TraceComponent tc = SibTr.register(Cursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected Entry current = null;
    protected String name = "Cursor";
    protected boolean atTop = false;
    protected boolean atBottom = false;

    Cursor(String name, LinkedList parentList, boolean atTop) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Cursor", (Object)new Object[]{name, parentList, new Boolean(atTop)});
        }
        this.name = name;
        this.parentList = parentList;
        this.current = null;
        this.atTop = atTop;
        boolean bl = this.atBottom = !atTop;
        if (atTop) {
            Cursor nextCursor = parentList.firstTopCursor;
            if (nextCursor != null) {
                nextCursor.previous = this;
                this.next = nextCursor;
            }
            parentList.firstTopCursor = this;
        } else {
            Cursor nextCursor = parentList.firstBottomCursor;
            if (nextCursor != null) {
                nextCursor.previous = this;
                this.next = nextCursor;
            }
            parentList.firstBottomCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Cursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry next() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        this.checkEntryParent();
        Entry nextEntry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            nextEntry = this.getNextEntry();
            if (nextEntry == null) {
                if (this.current == this.parentList.last) {
                    this.moveToBottom();
                } else if (!this.atBottom) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"Cursor", "1:160:1.15"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.next", (String)"1:166:1.15", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)e));
                    }
                    throw e;
                }
            } else {
                this.moveCursor(nextEntry);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)nextEntry);
        }
        return nextEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry previous() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"previous");
        }
        this.checkEntryParent();
        Entry previousEntry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            previousEntry = this.getPreviousEntry();
            if (previousEntry == null) {
                if (this.current == this.parentList.first) {
                    this.moveToTop();
                } else if (!this.atTop) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:228:1.15"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.previous", (String)"1:234:1.15", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"previous", (Object)((Object)e));
                    }
                    throw e;
                }
            } else {
                this.moveCursor(previousEntry);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"previous", (Object)previousEntry);
        }
        return previousEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry getPreviousEntry() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreviousEntry");
        }
        this.checkEntryParent();
        Entry previousEntry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (this.atBottom) {
                previousEntry = this.parentList.last;
            } else if (!this.atTop) {
                previousEntry = this.current.getPrevious();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreviousEntry", (Object)previousEntry);
        }
        return previousEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry getNextEntry() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextEntry");
        }
        this.checkEntryParent();
        Entry nextEntry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (this.atTop) {
                nextEntry = this.parentList.first;
            } else if (!this.atBottom) {
                nextEntry = this.current.getNext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNextEntry", (Object)nextEntry);
        }
        return nextEntry;
    }

    public synchronized Entry current() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"current");
        }
        this.checkEntryParent();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"current", (Object)this.current);
        }
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToTop() {
        LinkedList list;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveToTop");
        }
        this.checkEntryParent();
        LinkedList linkedList = list = this.parentList;
        synchronized (linkedList) {
            this.forceRemove();
            this.parentList = list;
            this.atTop = true;
            this.next = list.firstTopCursor;
            if (this.next != null) {
                this.next.previous = this;
            }
            list.firstTopCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveToTop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToBottom() {
        LinkedList list;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveToBottom");
        }
        this.checkEntryParent();
        LinkedList linkedList = list = this.parentList;
        synchronized (linkedList) {
            this.forceRemove();
            this.parentList = list;
            this.atBottom = true;
            this.next = list.firstBottomCursor;
            if (this.next != null) {
                this.next.previous = this;
            }
            list.firstBottomCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveToBottom");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(Entry newEntry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveCursor", (Object)new Object[]{newEntry});
        }
        this.checkEntryParent();
        if (newEntry != this.current) {
            if (newEntry != null && newEntry.parentList == this.parentList) {
                LinkedList list;
                LinkedList linkedList = list = this.parentList;
                synchronized (linkedList) {
                    this.forceRemove();
                    this.next = newEntry.firstCursor;
                    if (this.next != null) {
                        this.next.previous = this;
                    }
                    newEntry.firstCursor = this;
                    this.previous = null;
                    this.parentList = list;
                    this.current = newEntry;
                }
            } else {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:457:1.15"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.moveCursor", (String)"1:463:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveCursor", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveCursor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(Cursor cursor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveCursor", (Object)new Object[]{cursor});
        }
        this.checkEntryParent();
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (cursor != null && cursor.parentList == this.parentList) {
                if (cursor.current != this.current) {
                    if (cursor.atTop) {
                        this.moveToTop();
                    } else if (cursor.atBottom) {
                        this.moveToBottom();
                    } else {
                        this.moveCursor(cursor.current);
                    }
                } else if (cursor.current == null) {
                    if (cursor.atTop && this.atBottom) {
                        this.moveToTop();
                    } else if (cursor.atBottom && this.atTop) {
                        this.moveToBottom();
                    }
                }
            } else {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:541:1.15"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.moveCursor", (String)"1:547:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveCursor", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveCursor");
        }
    }

    @Override
    Entry forceRemove() {
        Entry removedEntry = null;
        this.checkEntryParent();
        if (this.atTop) {
            if (this.parentList.firstTopCursor == this) {
                this.parentList.firstTopCursor = (Cursor)this.next;
            }
            this.atTop = false;
        } else if (this.atBottom) {
            if (this.parentList.firstBottomCursor == this) {
                this.parentList.firstBottomCursor = (Cursor)this.next;
            }
            this.atBottom = false;
        } else {
            if (this.current.firstCursor == this) {
                this.current.firstCursor = (Cursor)this.next;
            }
            this.current = null;
        }
        removedEntry = super.forceRemove();
        return removedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.checkEntryParent();
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            this.forceRemove();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    @Override
    synchronized void checkEntryParent() {
        super.checkEntryParent();
    }

    @Override
    public String toString() {
        return "Cursor(" + this.name + ")";
    }

    public synchronized boolean isAtBottom() {
        return this.atBottom;
    }
}

