/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NoClassNotFoundLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.NameBasedClassLoaderLock;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UnifiedClassLoader
extends LibertyLoader
implements SpringLoader {
    private static final TraceComponent tc;
    private final List<ClassLoader> followOnClassLoaders = new ArrayList<ClassLoader>();
    static final long serialVersionUID = 4255658571728280816L;

    @Override
    public boolean addTransformer(ClassFileTransformer cft) {
        boolean added = false;
        for (ClassLoader loader : this.followOnClassLoaders) {
            if (!(loader instanceof SpringLoader)) continue;
            added |= ((SpringLoader)((Object)loader)).addTransformer(cft);
        }
        return added;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        ClassLoader newParent = this.getThrowawayVersion(this.parent);
        ClassLoader[] newFollowOns = new ClassLoader[this.followOnClassLoaders.size()];
        for (int i = 0; i < newFollowOns.length; ++i) {
            newFollowOns[i] = this.getThrowawayVersion(this.followOnClassLoaders.get(i));
        }
        return new UnifiedClassLoader(newParent, newFollowOns);
    }

    private ClassLoader getThrowawayVersion(ClassLoader loader) {
        return loader instanceof SpringLoader ? ((SpringLoader)((Object)loader)).getThrowawayClassLoader() : loader;
    }

    public UnifiedClassLoader(ClassLoader parent, ClassLoader ... followOns) {
        super(parent);
        Collections.addAll(this.followOnClassLoaders, followOns);
    }

    @Override
    @Trivial
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return Delegation.loadClass(name, resolve, false, false, this);
    }

    @Override
    @Trivial
    protected Class<?> loadClass(String name, boolean resolve, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        return Delegation.loadClass(name, resolve, onlySearchSelf, returnNull, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    Class<?> loadClass0(String name, boolean resolve, boolean onlySearchSelf, boolean returnNull) throws ClassNotFoundException {
        NameBasedClassLoaderLock lock;
        if (this.parent == null) {
            return super.loadClass(name, resolve);
        }
        NameBasedClassLoaderLock nameBasedClassLoaderLock = lock = this.getClassLoadingLock(name);
        synchronized (nameBasedClassLoaderLock) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            if (!onlySearchSelf) {
                if (this.parent instanceof NoClassNotFoundLoader) {
                    result = ((NoClassNotFoundLoader)((Object)this.parent)).loadClassNoException(name);
                } else {
                    try {
                        result = this.parent.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (result != null) {
                    return result;
                }
            }
            return this.findClass(name, returnNull);
        }
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClass(String name, boolean returnNull) throws ClassNotFoundException {
        for (ClassLoader cl : this.followOnClassLoaders) {
            try {
                if (cl instanceof NoClassNotFoundLoader) {
                    Class<?> result = ((NoClassNotFoundLoader)((Object)cl)).loadClassNoException(name);
                    if (result == null) continue;
                    return result;
                }
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException swallowed) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("CNFE from followOnClassLoader " + cl), (Object[])new Object[]{swallowed});
            }
        }
        if (returnNull) {
            return null;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String arg0) {
        ClassLoader cl;
        URL result = null;
        Iterator<ClassLoader> iterator = this.followOnClassLoaders.iterator();
        while (iterator.hasNext() && (result = (cl = iterator.next()).getResource(arg0)) == null) {
        }
        return result;
    }

    @Override
    protected Enumeration<URL> findResources(String arg0) throws IOException {
        ArrayList<Enumeration<URL>> rawResult = new ArrayList<Enumeration<URL>>();
        for (ClassLoader cl : this.followOnClassLoaders) {
            Enumeration<URL> result = cl.getResources(arg0);
            if (result == null) continue;
            rawResult.add(result);
        }
        final Iterator allURLs = rawResult.iterator();
        return new Enumeration<URL>(){
            private Enumeration<URL> current;
            static final long serialVersionUID = -2427758562650295738L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean hasMoreElements() {
                while (this.current == null || !this.current.hasMoreElements()) {
                    if (!allURLs.hasNext()) {
                        return false;
                    }
                    this.current = (Enumeration)allURLs.next();
                }
                return true;
            }

            @Override
            public URL nextElement() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                return this.current.nextElement();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public Enumeration<URL> getResources(final String name) throws IOException {
        if (this.parent == null) {
            return super.getResources(name);
        }
        try {
            Enumeration<URL> eURL = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){
                static final long serialVersionUID = -9018728235301990753L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Enumeration<URL> run() throws Exception {
                    return UnifiedClassLoader.this.parent.getResources(name);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
            return new CompositeEnumeration(eURL).add(this.findResources(name));
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    synchronized void addFollowOnClassLoader(ClassLoader cl) {
        if (!this.followOnClassLoaders.contains(cl)) {
            this.followOnClassLoaders.add(cl);
        }
    }

    List<ClassLoader> getFollowOnClassLoaders() {
        return this.followOnClassLoaders;
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return null;
    }

    @Override
    public Bundle getBundle() {
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(UnifiedClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Delegation {
        static final long serialVersionUID = -1108756983988623262L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Delegation() {
        }

        @Trivial
        static Class<?> loadClass(String className, boolean resolve, boolean onlySearchSelf, boolean returnNull, UnifiedClassLoader loader) throws ClassNotFoundException {
            return loader.loadClass0(className, resolve, onlySearchSelf, returnNull);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.UnifiedClassLoader$Delegation", Delegation.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

