/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import io.openliberty.microprofile.metrics50.helper.Util;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(MetricRESTHandler.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected SharedMetricRegistries sharedMetricRegistry;
    protected Object responseFunction;
    protected Method handleRequestMethod;
    protected Object srMetricsRequestHandlerObj;
    static final long serialVersionUID = 4426824252314651654L;

    protected void createSRMetricRequestHandler() throws IllegalStateException {
        Class<?> clazz = Util.SR_METRICS_REQUEST_HANDLER_CLASS;
        if (clazz == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SmallRye Metric MetricsRequestHandler class was not resolved.", (Object[])new Object[0]);
            }
        } else {
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.srMetricsRequestHandlerObj = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics50.rest.MetricRESTHandler", (String)"67", (Object)this, (Object[])new Object[0]);
            }
            try {
                this.handleRequestMethod = this.srMetricsRequestHandlerObj.getClass().getMethod("handleRequest", String.class, String.class, Stream.class, Map.class, Util.SR_REST_RESPONDER_INTERFACE);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics50.rest.MetricRESTHandler", (String)"78", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, final RESTResponse response) throws IOException {
        Locale locale = null;
        String regName = "";
        String attName = "";
        String acceptHeader = null;
        String method = "";
        String requestPath = "";
        String accept = request.getHeader("Accept");
        Stream acceptHeaders = null;
        try {
            locale = request.getLocale();
            regName = request.getPathVariable("sub");
            attName = request.getPathVariable("attribute");
            acceptHeader = request.getHeader("Accept");
            method = request.getMethod();
            requestPath = request.getURI();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics50.rest.MetricRESTHandler", (String)"105", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"internal.error.CWMMC0006E", (Object[])new Object[]{e}));
        }
        if (acceptHeader != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(acceptHeader);
            acceptHeaders = tmp.stream();
        }
        ClassLoader baoClassLoader = Util.BUNDLE_ADD_ON_CLASSLOADER;
        if (this.srMetricsRequestHandlerObj == null || baoClassLoader == null || this.handleRequestMethod == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SmallRye RequestHandler was not created or class loader was not created", (Object[])new Object[0]);
            }
            response.sendError(500, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"internal.error.CWMMC0006E", (Object[])new Object[0]));
            return;
        }
        this.responseFunction = Proxy.newProxyInstance(baoClassLoader, new Class[]{Util.SR_REST_RESPONDER_INTERFACE}, new InvocationHandler(){
            static final long serialVersionUID = 6990765892781578120L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("respondWith")) {
                    int status = (Integer)args[0];
                    String message = (String)args[1];
                    Map headers = (Map)args[2];
                    headers.forEach((key, value) -> response.addResponseHeader(key, value));
                    response.setStatus(status);
                    response.getWriter().write(message);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics50.rest.MetricRESTHandler$1", 1.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
            }
        });
        try {
            this.handleRequestMethod.invoke(this.srMetricsRequestHandlerObj, requestPath, method, acceptHeaders == null ? null : acceptHeaders, request.getParameterMap(), this.responseFunction);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.metrics50.rest.MetricRESTHandler", (String)"152", (Object)this, (Object[])new Object[]{request, response});
        }
    }
}

