/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Path(value="/")
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class AsynchronousDispatcher
extends SynchronousDispatcher {
    private ContextualExecutorService executor;
    private int threadPoolSize = 100;
    private Map<String, Future<MockHttpResponse>> jobs;
    private Cache cache;
    private String basePath = "/asynch/jobs";
    private SecureRandomWrapper counter = new SecureRandomWrapper();
    private long maxWaitMilliSeconds = 300000L;
    private int maxCacheSize = 100;
    static final long serialVersionUID = -3538675154659545152L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AsynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        super(providerFactory);
    }

    public AsynchronousDispatcher(ResteasyProviderFactory providerFactory, ResourceMethodRegistry registry) {
        super(providerFactory, registry);
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        if (this.cache != null) {
            this.cache.setMaxSize(maxCacheSize);
        }
    }

    public void setMaxWaitMilliSeconds(long maxWaitMilliSeconds) {
        this.maxWaitMilliSeconds = maxWaitMilliSeconds;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = ContextualExecutors.wrap(executor, true);
    }

    public void start() {
        this.cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(this.cache);
        if (this.executor == null) {
            this.executor = ContextualExecutors.wrap(Executors.newFixedThreadPool(this.threadPoolSize), false);
        }
        this.registry.addSingletonResource((Object)this, this.basePath);
    }

    public void stop() {
        if (!this.executor.isManaged()) {
            this.executor.shutdown();
        }
    }

    @Path(value="{job-id}")
    @DELETE
    public void remove(@PathParam(value="job-id") String jobId) {
        this.jobs.remove(jobId);
    }

    @Path(value="{job-id}")
    @POST
    public Response readAndRemove(@QueryParam(value="wait") @DefaultValue(value="-1") long wait, @PathParam(value="job-id") String jobId) {
        return this.process(wait, jobId, true);
    }

    @Path(value="{job-id}")
    @GET
    public Response get(@QueryParam(value="wait") @DefaultValue(value="-1") long wait, @PathParam(value="job-id") String jobId) {
        return this.process(wait, jobId, false);
    }

    protected Response process(long wait, String jobId, boolean eatJob) {
        Future<MockHttpResponse> job = this.jobs.get(jobId);
        if (job == null) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        MockHttpResponse response = null;
        boolean nowait = false;
        if (wait <= 0L) {
            nowait = true;
        }
        if (nowait) {
            if (job.isDone()) {
                try {
                    response = job.get();
                }
                catch (Exception e) {
                    return Response.serverError().build();
                }
            }
        } else {
            if (wait > this.maxWaitMilliSeconds) {
                wait = this.maxWaitMilliSeconds;
            }
            try {
                response = job.get(wait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return Response.serverError().build();
            }
            catch (ExecutionException e) {
                return Response.serverError().build();
            }
            catch (TimeoutException e) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
        }
        if (response == null) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        Response.ResponseBuilder builder = Response.status((int)response.getStatus());
        builder.entity((Object)response.getOutput());
        for (String name : response.getOutputHeaders().keySet()) {
            List values = (List)response.getOutputHeaders().get((Object)name);
            for (Object value : values) {
                builder.header(name, value);
            }
        }
        if (eatJob) {
            this.jobs.remove(jobId);
        }
        return builder.build();
    }

    public boolean isAsynchrnousRequest(HttpRequest in) {
        MultivaluedMap queryParameters = in.getUri().getQueryParameters();
        return queryParameters.get((Object)"asynch") != null || queryParameters.get((Object)"oneway") != null;
    }

    public void invokeSuper(HttpRequest in, HttpResponse response, ResourceInvoker invoker) {
        super.invoke(in, response, invoker);
    }

    @Override
    public void invoke(HttpRequest in, HttpResponse response, ResourceInvoker invoker) {
        MultivaluedMap queryParameters = in.getUri().getQueryParameters();
        if (queryParameters.get((Object)"asynch") != null) {
            this.postJob(in, response, invoker);
        } else if (queryParameters.get((Object)"oneway") != null) {
            this.oneway(in, response, invoker);
        } else {
            super.invoke(in, response, invoker);
        }
    }

    public void postJob(HttpRequest request, HttpResponse response, final ResourceInvoker invoker) {
        MockHttpRequest in;
        try {
            in = MockHttpRequest.deepCopy(request);
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        Callable<MockHttpResponse> callable = new Callable<MockHttpResponse>(){
            static final long serialVersionUID = -5979941497299041487L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public MockHttpResponse call() throws Exception {
                MockHttpResponse theResponse = new MockHttpResponse();
                try {
                    AsynchronousDispatcher.this.pushContextObjects(in, theResponse);
                    AsynchronousDispatcher.this.invokeSuper(in, theResponse, invoker);
                }
                finally {
                    AsynchronousDispatcher.this.clearContextData();
                }
                return theResponse;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.AsynchronousDispatcher$1", 1.class, null, null);
            }
        };
        Future<MockHttpResponse> future = this.executor.submit(callable);
        String id = System.currentTimeMillis() + "-" + this.counter.nextInt();
        this.jobs.put(id, future);
        response.setStatus(202);
        URI uri = request.getUri().getBaseUriBuilder().path(this.basePath).path(id).build(new Object[0]);
        response.getOutputHeaders().add((Object)"Location", (Object)uri);
    }

    public void oneway(HttpRequest request, HttpResponse response, final ResourceInvoker invoker) {
        MockHttpRequest in;
        LogMessages.LOGGER.inOneWay();
        try {
            in = MockHttpRequest.deepCopy(request);
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        Runnable runnable = new Runnable(){
            static final long serialVersionUID = -4089693904060229803L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                LogMessages.LOGGER.runningJob();
                MockHttpResponse theResponse = new MockHttpResponse();
                try {
                    AsynchronousDispatcher.this.pushContextObjects(in, theResponse);
                    AsynchronousDispatcher.this.invokeSuper(in, theResponse, invoker);
                }
                catch (Exception ignored) {
                    LogMessages.LOGGER.failedToInvokeAsynchronously(ignored);
                }
                finally {
                    AsynchronousDispatcher.this.clearContextData();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.AsynchronousDispatcher$2", 2.class, null, null);
            }
        };
        this.executor.execute(runnable);
        response.setStatus(202);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.AsynchronousDispatcher", AsynchronousDispatcher.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class SecureRandomWrapper {
        private static final int DEFAULT_MAX_USES = 100;
        private SecureRandom random;
        private int maxUses = -1;
        private int uses = 0;
        static final long serialVersionUID = -8736768728406471467L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SecureRandomWrapper() {
        }

        public synchronized int nextInt() {
            if (++this.uses > this.maxUses) {
                this.reset();
            }
            return this.random.nextInt();
        }

        private void reset() {
            if (this.maxUses < 0) {
                this.maxUses = this.getMaxUses();
            }
            this.random = new SecureRandom();
            this.random.nextBytes(new byte[20]);
            this.uses = 0;
        }

        private int getMaxUses() {
            String s;
            this.maxUses = 100;
            ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
            if (context != null && (s = context.getParameter("resteasy.secure.random.max.use")) != null) {
                try {
                    this.maxUses = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    LogMessages.LOGGER.invalidFormat("resteasy.secure.random.max.use", Integer.toString(100));
                }
            }
            return this.maxUses;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.AsynchronousDispatcher$SecureRandomWrapper", SecureRandomWrapper.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class Cache
    extends LinkedHashMap<String, Future<MockHttpResponse>> {
        private int maxSize = 100;
        static final long serialVersionUID = 4618168571743340971L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Future<MockHttpResponse>> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.AsynchronousDispatcher$Cache", Cache.class, null, null);
        }
    }
}

