/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATCoordinatorTran
extends WSATTransaction {
    private static final String CLASS_NAME = WSATCoordinatorTran.class.getName();
    private static final TraceComponent TC = Tr.register(WSATCoordinatorTran.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private final Map<String, WSATParticipant> participants = new HashMap<String, WSATParticipant>();
    private final AtomicInteger participantIds = new AtomicInteger();
    static final long serialVersionUID = 8000494276945243217L;

    public WSATCoordinatorTran(String id, long timeout) {
        super(id, timeout);
    }

    public WSATCoordinatorTran(String id, long timeout, boolean recovery) {
        super(id, timeout, recovery);
    }

    public synchronized WSATParticipant addParticipant(EndpointReferenceType epr) {
        String partId = Integer.toString(this.participantIds.incrementAndGet());
        WSATParticipant participant = new WSATParticipant(this.getGlobalId(), partId, epr);
        this.participants.put(partId, participant);
        EndpointReferenceType coordEpr = this.getCoordinator().getEndpointReference(partId);
        participant.setCoordinator(new WSATCoordinator(this.getGlobalId(), coordEpr));
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Added new participant: {0}", (Object[])new Object[]{participant});
        }
        return participant;
    }

    public synchronized WSATParticipant addParticipant(WSATParticipant participant) {
        EndpointReferenceType coordEpr = this.getCoordinator().getEndpointReference(participant.getId());
        participant.setCoordinator(new WSATCoordinator(this.getGlobalId(), coordEpr));
        this.participants.put(participant.getId(), participant);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Restored recovered participant: {0}", (Object[])new Object[]{participant});
        }
        return participant;
    }

    public synchronized void removeParticipant(String partId) {
        this.participants.remove(partId);
    }

    public synchronized WSATParticipant getParticipant(String partId) {
        return this.participants.get(partId);
    }
}

