/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.tx.remote.Vote;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATTransaction {
    private static final TraceComponent TC = Tr.register(WSATTransaction.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final String globalId;
    private WSATCoordinator registration;
    private WSATCoordinator coordinator;
    private final Boolean coordinatorLock = false;
    private final boolean recoveryTran;
    private final long expiryTime;
    static final long serialVersionUID = -658391596942692867L;

    public static void putTran(WSATTransaction tran) {
        tranService.getRemoteTranMgr().putResource(tran.getGlobalId(), (Object)tran);
    }

    public static WSATTransaction getTran(String globalId) {
        return (WSATTransaction)tranService.getRemoteTranMgr().getResource(globalId);
    }

    public boolean equals(Object o) {
        return o instanceof WSATTransaction && this.globalId.equals(((WSATTransaction)o).getGlobalId());
    }

    public static WSATCoordinatorTran getCoordTran(String globalId) {
        WSATTransaction wsatTran = WSATTransaction.getTran(globalId);
        if (wsatTran != null && !(wsatTran instanceof WSATCoordinatorTran)) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Transaction is not a coordinator", (Object[])new Object[0]);
            }
            wsatTran = null;
        }
        return (WSATCoordinatorTran)wsatTran;
    }

    public WSATTransaction(String id, long timeout) {
        this(id, timeout, false);
    }

    public WSATTransaction(String id, long timeout, boolean recovery) {
        this.globalId = id;
        this.expiryTime = timeout;
        this.recoveryTran = recovery;
    }

    @Trivial
    public String getGlobalId() {
        return this.globalId;
    }

    @Trivial
    protected boolean isRecovery() {
        return this.recoveryTran;
    }

    @Trivial
    public long getTimeout() {
        return this.expiryTime;
    }

    @Trivial
    public WSATCoordinator setRegistration(EndpointReferenceType epr) {
        this.registration = new WSATCoordinator(this.globalId, epr);
        return this.registration;
    }

    @Trivial
    public WSATCoordinator getRegistration() {
        return this.registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public WSATCoordinator setCoordinator(EndpointReferenceType epr) {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            this.coordinator = new WSATCoordinator(this.globalId, epr);
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public WSATCoordinator setCoordinator(WSATCoordinator coord) {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            this.coordinator = coord;
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public WSATCoordinator getCoordinator() {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            return this.coordinator;
        }
    }

    public WSATContext getContext() {
        WSATContext ctx = null;
        if (!this.isRecovery()) {
            ctx = new WSATContext(this.getGlobalId(), this.getRegistration(), this.getTimeout());
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Transaction is in recovery mode, returning null CoordinationContext", (Object[])new Object[0]);
        }
        return ctx;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.globalId;
    }

    public synchronized void rollback() throws WSATException {
        tranService.rollbackTransaction(this.globalId);
    }

    public synchronized Vote prepare() throws WSATException {
        return tranService.prepareTransaction(this.globalId);
    }

    public synchronized void commit() throws WSATException {
        tranService.commitTransaction(this.globalId);
    }
}

