/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.MemoryStoreHelper;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.store.db.DatabaseStore;
import com.ibm.ws.session.store.db.LoggingUtil;
import com.ibm.ws.session.utils.SessionLoader;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.session.ILoader;
import com.ibm.wsspi.session.IStore;
import jakarta.servlet.ServletContext;
import jakarta.transaction.UserTransaction;
import java.util.Map;
import java.util.logging.Level;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class DatabaseStoreService
implements SessionStoreService {
    private static final String methodClassName = DatabaseStoreService.class.getSimpleName();
    private Map<String, Object> configurationProperties = null;
    private final AtomicServiceReference<EmbeddableWebSphereTransactionManager> embeddableWebSphereTransactionManagerRef = new AtomicServiceReference("embeddableWebSphereTransactionManager");
    private final AtomicServiceReference<LocalTransactionCurrent> localTransactionCurrentRef = new AtomicServiceReference("localTransactionCurrent");
    private final AtomicServiceReference<ResourceConfigFactory> resourceConfigFactoryRef = new AtomicServiceReference("resourceConfigFactory");
    private final AtomicServiceReference<ResourceFactory> dataSourceFactoryRef = new AtomicServiceReference("dataSourceFactory");
    private final AtomicServiceReference<UOWCurrent> uowCurrentRef = new AtomicServiceReference("uowCurrent");
    private final AtomicServiceReference<UserTransaction> userTransactionRef = new AtomicServiceReference("userTransaction");
    private final AtomicServiceReference<SerializationService> serializationServiceRef = new AtomicServiceReference("serializationService");
    private static boolean completedPassivation = true;

    public ResourceFactory getDataSourceFactory() {
        return (ResourceFactory)this.dataSourceFactoryRef.getService();
    }

    public LocalTransactionCurrent getLocalTransactionCurrent() {
        return (LocalTransactionCurrent)this.localTransactionCurrentRef.getService();
    }

    public ResourceConfigFactory getResourceConfigFactory() {
        return (ResourceConfigFactory)this.resourceConfigFactoryRef.getService();
    }

    public SerializationService getSerializationService() {
        return (SerializationService)this.serializationServiceRef.getService();
    }

    public synchronized void setCompletedPassivation(boolean isInProcessOfStopping) {
        completedPassivation = isInProcessOfStopping;
    }

    public synchronized boolean isCompletedPassivation() {
        return completedPassivation;
    }

    public UOWCurrent getUOWCurrent() {
        return (UOWCurrent)this.uowCurrentRef.getService();
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)this.userTransactionRef.getService();
    }

    public EmbeddableWebSphereTransactionManager getEmbeddableWebSphereTransactionManager() {
        return (EmbeddableWebSphereTransactionManager)this.embeddableWebSphereTransactionManagerRef.getService();
    }

    public IStore createStore(SessionManagerConfig smc, String smid, ServletContext sc, MemoryStoreHelper storeHelper, ClassLoader classLoader, boolean applicationSessionStore) {
        DatabaseStore store = new DatabaseStore(smc, smid, sc, storeHelper, applicationSessionStore, this);
        store.setLoader((ILoader)new SessionLoader((SerializationService)this.serializationServiceRef.getServiceWithException(), classLoader, applicationSessionStore));
        this.setCompletedPassivation(false);
        return store;
    }

    public boolean isValid() {
        return true;
    }

    public Map<String, Object> getConfiguration() {
        return this.configurationProperties;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "activate", "context=" + context);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "activate", "properties=" + properties);
        }
        this.embeddableWebSphereTransactionManagerRef.activate(context);
        this.localTransactionCurrentRef.activate(context);
        this.resourceConfigFactoryRef.activate(context);
        this.dataSourceFactoryRef.activate(context);
        this.uowCurrentRef.activate(context);
        this.userTransactionRef.activate(context);
        this.serializationServiceRef.activate(context);
        this.configurationProperties = properties;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "deactivate", "deactivating service references");
        }
        this.embeddableWebSphereTransactionManagerRef.deactivate(context);
        this.localTransactionCurrentRef.deactivate(context);
        this.resourceConfigFactoryRef.deactivate(context);
        this.dataSourceFactoryRef.deactivate(context);
        this.uowCurrentRef.deactivate(context);
        this.userTransactionRef.deactivate(context);
        if (this.isCompletedPassivation()) {
            this.serializationServiceRef.deactivate(context);
        } else {
            while (!this.isCompletedPassivation()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"180");
                }
                finally {
                    this.serializationServiceRef.deactivate(context);
                }
            }
        }
    }

    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "modified", "context=" + context);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "modified", "properties=" + properties);
        }
        this.configurationProperties = properties;
    }

    protected void setDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setDataSourceFactory", "setting " + ref);
        }
        this.dataSourceFactoryRef.setReference(ref);
    }

    protected void unsetDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetDataSourceFactory", "unsetting " + ref);
        }
        this.dataSourceFactoryRef.unsetReference(ref);
    }

    protected void setResourceConfigFactory(ServiceReference<ResourceConfigFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setResourceConfigFactory", "setting " + ref);
        }
        this.resourceConfigFactoryRef.setReference(ref);
    }

    protected void unsetResourceConfigFactory(ServiceReference<ResourceConfigFactory> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetResourceConfigFactory", "unsetting " + ref);
        }
        this.resourceConfigFactoryRef.unsetReference(ref);
    }

    protected void setLocalTransactionCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setLocalTransactionCurrent", "setting " + ref);
        }
        this.localTransactionCurrentRef.setReference(ref);
    }

    protected void unsetLocalTransactionCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetLocalTransactionCurrent", "unsetting " + ref);
        }
        this.localTransactionCurrentRef.unsetReference(ref);
    }

    protected void setEmbeddableWebSphereTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setEmbeddableWebSphereTransactionManager", "setting " + ref);
        }
        this.embeddableWebSphereTransactionManagerRef.setReference(ref);
    }

    protected void unsetEmbeddableWebSphereTransactionManager(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetEmbeddableWebSphereTransactionManager", "unsetting " + ref);
        }
        this.embeddableWebSphereTransactionManagerRef.unsetReference(ref);
    }

    protected void setUowCurrent(ServiceReference<UOWCurrent> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setUowCurrent", "setting " + ref);
        }
        this.uowCurrentRef.setReference(ref);
    }

    protected void unsetUowCurrent(ServiceReference<UOWCurrent> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetUowCurrent", "unsetting " + ref);
        }
        this.uowCurrentRef.unsetReference(ref);
    }

    protected void setUserTransaction(ServiceReference<UserTransaction> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setUserTransaction", "setting " + ref);
        }
        this.userTransactionRef.setReference(ref);
    }

    protected void unsetUserTransaction(ServiceReference<UserTransaction> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetUserTransaction", "unsetting " + ref);
        }
        this.userTransactionRef.unsetReference(ref);
    }

    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "setSerializationService", "setting " + ref);
        }
        this.serializationServiceRef.setReference(ref);
    }

    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, "unsetSerializationService", "unsetting " + ref);
        }
        this.serializationServiceRef.unsetReference(ref);
    }
}

