/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.compression;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.channel.compression.DecompressionHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DeflateInputHandler
implements DecompressionHandler {
    private static final TraceComponent tc = Tr.register(DeflateInputHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private Inflater inflater = null;
    private final byte[] buf = new byte[16384];
    private long countRead = 0L;
    private long countWritten = 0L;

    public DeflateInputHandler() {
        this.inflater = new Inflater(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a deflate input handler; " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void release(List<WsByteBuffer> list) {
        while (!list.isEmpty()) {
            list.remove(0).release();
        }
    }

    private void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object[])new Object[0]);
        }
        this.countRead += this.inflater.getBytesRead();
        this.countWritten += this.inflater.getBytesWritten();
        this.inflater.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"reset done on inflater, counters updated", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public List<WsByteBuffer> decompress(WsByteBuffer inputBuffer) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("decompress, input=" + inputBuffer), (Object[])new Object[0]);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        int dataSize = inputBuffer.remaining();
        byte[] input = new byte[dataSize];
        inputBuffer.get(input, 0, dataSize);
        int inOffset = 0;
        if (this.inflater.finished()) {
            this.reset();
        }
        if (!this.inflater.finished()) {
            this.inflater.setInput(input, inOffset, dataSize - inOffset);
        }
        long initialBytesRead = this.inflater.getBytesRead();
        int outOffset = 0;
        int len = -1;
        while (inOffset < input.length && !this.inflater.finished() && 0 != len) {
            try {
                len = this.inflater.inflate(this.buf, outOffset, this.buf.length - outOffset);
            }
            catch (DataFormatException dfe) {
                this.release(list);
                throw dfe;
            }
            long bytesRead = this.inflater.getBytesRead();
            inOffset = (int)((long)inOffset + (bytesRead - initialBytesRead));
            initialBytesRead = bytesRead;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Decompressed amount=" + len + " inOffset=" + inOffset + " read=" + this.inflater.getBytesRead() + " written=" + this.inflater.getBytesWritten() + " finished=" + this.inflater.finished()), (Object[])new Object[0]);
            }
            if ((outOffset += len) != this.buf.length) continue;
            WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocate(this.buf.length);
            buffer.put(this.buf, 0, this.buf.length);
            buffer.flip();
            list.add(buffer);
            outOffset = 0;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Storing decompressed buffer; " + buffer), (Object[])new Object[0]);
        }
        if (0 < outOffset) {
            WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocate(outOffset);
            buffer.put(this.buf, 0, outOffset);
            buffer.flip();
            list.add(buffer);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Stored final decompressed buffer; " + buffer), (Object[])new Object[0]);
            }
        }
        if (inOffset < dataSize) {
            inputBuffer.position(inputBuffer.position() - (dataSize - inOffset));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("input buffer has unused data; " + inputBuffer), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("decompress, output=" + list.size()));
        }
        return list;
    }

    @Override
    public void close() {
        this.inflater.end();
    }

    @Override
    public boolean isFinished() {
        return this.inflater.finished();
    }

    @Override
    public long getBytesRead() {
        return this.countRead + this.inflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.countWritten + this.inflater.getBytesWritten();
    }
}

