/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.AntHelper;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public abstract class AbstractLibertySupport
extends MojoSupport {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project = null;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository artifactRepository = null;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    protected Settings settings;
    @Component(role=AntHelper.class)
    protected AntHelper ant;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(property="reactorProjects", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant.setProject(this.getProject());
    }

    protected boolean isReactorMavenProject(org.apache.maven.artifact.Artifact artifact) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(artifact.getGroupId()) || !p.getArtifactId().equals(artifact.getArtifactId()) || !p.getVersion().equals(artifact.getBaseVersion())) continue;
            return true;
        }
        return false;
    }

    protected MavenProject getReactorMavenProject(org.apache.maven.artifact.Artifact artifact) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(artifact.getGroupId()) || !p.getArtifactId().equals(artifact.getArtifactId()) || !p.getVersion().equals(artifact.getBaseVersion())) continue;
            p.setArtifactFilter(new ArtifactFilter(){

                public boolean include(org.apache.maven.artifact.Artifact artifact) {
                    return "compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope());
                }
            });
            return p;
        }
        return null;
    }

    protected org.apache.maven.artifact.Artifact getArtifact(ArtifactItem item) throws MojoExecutionException {
        assert (item != null);
        org.apache.maven.artifact.Artifact artifact = null;
        if (item.getVersion() != null) {
            artifact = this.createArtifact(item);
        } else {
            artifact = this.resolveFromProjectDependencies(item);
            if (artifact != null) {
                if (!artifact.isResolved()) {
                    item.setVersion(artifact.getVersion());
                    artifact = this.createArtifact(item);
                }
            } else if (this.resolveFromProjectDepMgmt(item) != null) {
                item.setVersion(this.resolveFromProjectDepMgmt(item).getVersion());
                artifact = this.createArtifact(item);
            } else {
                throw new MojoExecutionException("Unable to find artifact version of " + item.getGroupId() + ":" + item.getArtifactId() + " in either project dependencies or in project dependencyManagement.");
            }
        }
        return artifact;
    }

    protected org.apache.maven.artifact.Artifact getArtifact(String groupId, String artifactId, String type, String version) throws MojoExecutionException {
        ArtifactItem item = new ArtifactItem();
        item.setGroupId(groupId);
        item.setArtifactId(artifactId);
        item.setType(type);
        item.setVersion(version);
        return this.getArtifact(item);
    }

    protected org.apache.maven.artifact.Artifact createArtifact(ArtifactItem item) throws MojoExecutionException {
        assert (item != null);
        if (item.getVersion() == null) {
            throw new MojoExecutionException("Unable to find artifact without version specified: " + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " in either project dependencies or in project dependencyManagement.");
        }
        if (item.getVersion().trim().startsWith("[") || item.getVersion().trim().startsWith("(")) {
            try {
                item.setVersion(this.resolveVersionRange(item.getGroupId(), item.getArtifactId(), item.getType(), item.getVersion()));
            }
            catch (VersionRangeResolutionException e) {
                throw new MojoExecutionException("Could not get the highest version from the range: " + item.getVersion(), (Exception)((Object)e));
            }
        }
        return this.resolveArtifactItem(item);
    }

    private org.apache.maven.artifact.Artifact resolveFromProjectDependencies(ArtifactItem item) {
        Set actifacts = this.getProject().getArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : actifacts) {
            if (!artifact.getGroupId().equals(item.getGroupId()) || !artifact.getArtifactId().equals(item.getArtifactId()) || !artifact.getType().equals(item.getType())) continue;
            this.log.debug((CharSequence)("Found ArtifactItem from project dependencies: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
            return artifact;
        }
        this.log.debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is not found from project dependencies."));
        return null;
    }

    private Dependency resolveFromProjectDepMgmt(ArtifactItem item) {
        if (this.getProject().getDependencyManagement() != null) {
            List list = this.getProject().getDependencyManagement().getDependencies();
            for (Dependency dependency : list) {
                if (!dependency.getGroupId().equals(item.getGroupId()) || !dependency.getArtifactId().equals(item.getArtifactId()) || !dependency.getType().equals(item.getType())) continue;
                this.log.debug((CharSequence)("Found ArtifactItem from project dependencyManagement " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                return dependency;
            }
        }
        this.log.debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is not found from project dependencyManagement."));
        return null;
    }

    private org.apache.maven.artifact.Artifact resolveArtifactItem(ArtifactItem item) throws MojoExecutionException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(item.getGroupId(), item.getArtifactId(), item.getType(), item.getVersion());
        File artifactFile = this.resolveArtifactFile((Artifact)aetherArtifact);
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(item.getGroupId(), item.getArtifactId(), item.getVersion(), "provided", item.getType(), null, (ArtifactHandler)new DefaultArtifactHandler("jar"));
        if (artifactFile != null && artifactFile.exists()) {
            artifact.setFile(artifactFile);
            artifact.setResolved(true);
            this.log.debug((CharSequence)(item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " is resolved from project repositories."));
        } else {
            this.getLog().warn((CharSequence)("Artifact " + item.getGroupId() + ":" + item.getArtifactId() + ":" + item.getVersion() + " has no attached file."));
            artifact.setResolved(false);
        }
        return artifact;
    }

    private File resolveArtifactFile(Artifact aetherArtifact) throws MojoExecutionException {
        ArtifactRequest req = new ArtifactRequest().setRepositories(this.repositories).setArtifact(aetherArtifact);
        ArtifactResult resolutionResult = null;
        try {
            resolutionResult = this.repositorySystem.resolveArtifact(this.repoSession, req);
            if (!resolutionResult.isResolved()) {
                throw new MojoExecutionException("Unable to resolve artifact: " + aetherArtifact.getGroupId() + ":" + aetherArtifact.getArtifactId() + ":" + aetherArtifact.getVersion());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact: " + aetherArtifact.getGroupId() + ":" + aetherArtifact.getArtifactId() + ":" + aetherArtifact.getVersion(), (Exception)((Object)e));
        }
        File artifactFile = resolutionResult.getArtifact().getFile();
        return artifactFile;
    }

    private String resolveVersionRange(String groupId, String artifactId, String extension, String version) throws VersionRangeResolutionException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(groupId, artifactId, extension, version);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)aetherArtifact);
        rangeRequest.setRepositories(this.repositories);
        VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(this.repoSession, rangeRequest);
        if (rangeResult == null || rangeResult.getHighestVersion() == null) {
            throw new VersionRangeResolutionException(rangeResult, "Unable to resolve version range fram " + groupId + ":" + artifactId + ":" + extension + ":" + version);
        }
        this.getLog().debug((CharSequence)("Available versions: " + rangeResult.getVersions()));
        return rangeResult.getHighestVersion().toString();
    }
}

