/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.DevUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.common.plugins.util.ServerStatusUtil;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class DevMojo
extends StartDebugMojoSupport {
    private static final String TEST_RUN_ID_PROPERTY_NAME = "liberty.dev.test.run.id";
    private static final String LIBERTY_HOSTNAME = "liberty.hostname";
    private static final String LIBERTY_HTTP_PORT = "liberty.http.port";
    private static final String LIBERTY_HTTPS_PORT = "liberty.https.port";
    private static final String MICROSHED_HOSTNAME = "microshed_hostname";
    private static final String MICROSHED_HTTP_PORT = "microshed_http_port";
    private static final String MICROSHED_HTTPS_PORT = "microshed_https_port";
    private static final String WLP_USER_DIR_PROPERTY_NAME = "wlp.user.dir";
    DevMojoUtil util = null;
    @Parameter(property="hotTests", defaultValue="false")
    private boolean hotTests;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipUTs", defaultValue="false")
    private boolean skipUTs;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="debug", defaultValue="true")
    private boolean libertyDebug;
    @Parameter(property="debugPort", defaultValue="7777")
    private int libertyDebugPort;
    @Parameter(property="compileWait", defaultValue="0.5")
    private double compileWait;
    private int runId = 0;
    private ServerTask serverTask = null;
    private Plugin boostPlugin = null;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Parameter(property="verifyTimeout", defaultValue="30")
    private int verifyTimeout;
    @Parameter(property="serverStartTimeout", defaultValue="90")
    private int serverStartTimeout;
    @Parameter(property="applications")
    private String applications;
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="pollingTest", defaultValue="false")
    protected boolean pollingTest;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.sourceDirectory}")
    private String sourceDirectoryString;
    private File sourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.testSourceDirectory}")
    private String testSourceDirectoryString;
    private File testSourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    private static ServerFeature serverFeatureUtil;

    private boolean isUsingBoost() {
        return this.boostPlugin != null;
    }

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.project.getPackaging().equals("ear")) {
            this.skipUTs = true;
        }
        this.boostPlugin = this.project.getPlugin("org.microshed.boost:boost-maven-plugin");
        if (this.serverDirectory.exists() && ServerStatusUtil.isServerRunning((File)this.installDirectory, (File)((StartDebugMojoSupport)this).outputDirectory, (String)this.serverName)) {
            throw new MojoExecutionException("The server " + this.serverName + " is already running. Terminate all instances of the server before starting dev mode. You can stop a server instance with the command 'mvn liberty:stop'.");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1, true));
        this.runCompileMojoLogWarning();
        this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
        this.runTestCompileMojoLogWarning();
        this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
        this.sourceDirectory = new File(this.sourceDirectoryString.trim());
        this.testSourceDirectory = new File(this.testSourceDirectoryString.trim());
        ArrayList<File> javaFiles = new ArrayList<File>();
        this.listFiles(this.sourceDirectory, javaFiles, ".java");
        ArrayList<File> javaTestFiles = new ArrayList<File>();
        this.listFiles(this.testSourceDirectory, javaTestFiles, ".java");
        this.log.debug((CharSequence)("Source directory: " + this.sourceDirectory));
        this.log.debug((CharSequence)("Output directory: " + this.outputDirectory));
        this.log.debug((CharSequence)("Test Source directory: " + this.testSourceDirectory));
        this.log.debug((CharSequence)("Test Output directory: " + this.testOutputDirectory));
        if (this.isUsingBoost()) {
            this.log.info((CharSequence)"Running boost:package");
            this.runBoostMojo("package");
        } else {
            this.runLibertyMojoCreate();
            this.runLibertyMojoInstallFeature(null);
            this.runLibertyMojoDeploy();
        }
        ArrayList<File> resourceDirs = new ArrayList<File>();
        if (this.outputDirectory.exists()) {
            List resources = this.project.getResources();
            for (Resource resource : resources) {
                File resourceFile = new File(resource.getDirectory());
                if (!resourceFile.exists()) continue;
                resourceDirs.add(resourceFile);
            }
        }
        if (resourceDirs.isEmpty()) {
            File defaultResourceDir = new File(this.project.getBasedir() + "/src/main/resources");
            this.log.debug((CharSequence)("No resource directory detected, using default directory: " + defaultResourceDir));
            resourceDirs.add(defaultResourceDir);
        }
        this.util = new DevMojoUtil(this.serverDirectory, this.sourceDirectory, this.testSourceDirectory, this.configDirectory, resourceDirs);
        this.util.addShutdownHook(executor);
        this.util.startServer();
        List<String> artifactPaths = this.util.getArtifacts();
        if (this.hotTests && this.testSourceDirectory.exists()) {
            this.util.runTestThread(false, executor, -1, false, false);
        } else {
            this.util.runHotkeyReaderThread(executor);
        }
        File pom = this.project.getFile();
        try {
            this.util.watchFiles(pom, this.outputDirectory, this.testOutputDirectory, executor, artifactPaths, this.serverXmlFile, this.bootstrapPropertiesFile, this.jvmOptionsFile);
        }
        catch (PluginScenarioException e) {
            if (e.getMessage() != null) {
                this.log.info((CharSequence)e.getMessage());
            }
            return;
        }
    }

    private void addArtifacts(DependencyNode root, List<File> artifacts) {
        if (root.getArtifact() != null) {
            artifacts.add(root.getArtifact().getFile());
        }
        for (DependencyNode node : root.getChildren()) {
            this.addArtifacts(node, artifacts);
        }
    }

    private List<Artifact> getNewDependencies(List<Dependency> dependencies, List<Dependency> existingDependencies) {
        ArrayList<Artifact> updatedArtifacts = new ArrayList<Artifact>();
        for (Dependency dep : dependencies) {
            boolean newDependency = true;
            try {
                Artifact artifact = this.getArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getVersion());
                for (Dependency existingDep : existingDependencies) {
                    Artifact existingArtifact = this.getArtifact(existingDep.getGroupId(), existingDep.getArtifactId(), existingDep.getType(), existingDep.getVersion());
                    if (!Objects.equals(artifact.getArtifactId(), existingArtifact.getArtifactId()) || !Objects.equals(artifact.getGroupId(), existingArtifact.getGroupId()) || !Objects.equals(artifact.getVersion(), existingArtifact.getVersion()) || !Objects.equals(artifact.getType(), existingArtifact.getType())) continue;
                    newDependency = false;
                    break;
                }
                if (!newDependency) continue;
                this.log.debug((CharSequence)("New dependency found: " + artifact.toString()));
                updatedArtifacts.add(artifact);
            }
            catch (MojoExecutionException e) {
                this.log.warn((CharSequence)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.log.warn((CharSequence)(dep.toString() + " is not valid: " + e.getMessage()));
            }
        }
        return updatedArtifacts;
    }

    private void runTestMojo(String groupId, String artifactId, String goal) throws MojoExecutionException {
        Plugin plugin = this.getPlugin(groupId, artifactId);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.log);
        if (goal.equals("test")) {
            this.injectTestId(config);
        } else if (goal.equals("integration-test")) {
            this.injectTestId(config);
            this.injectLibertyProperties(config);
            File summaryFile = null;
            Xpp3Dom summaryFileElement = config.getChild("summaryFile");
            summaryFile = summaryFileElement != null && summaryFileElement.getValue() != null ? new File(summaryFileElement.getValue()) : new File(this.project.getBuild().getDirectory() + "/failsafe-reports/failsafe-summary.xml");
            try {
                this.log.debug((CharSequence)("Looking for summary file at " + summaryFile.getCanonicalPath()));
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("Unable to resolve summary file " + e.getMessage()));
            }
            if (summaryFile.exists()) {
                boolean deleteResult = summaryFile.delete();
                this.log.debug((CharSequence)("Summary file deleted? " + deleteResult));
            } else {
                this.log.debug((CharSequence)"Summary file doesn't exist");
            }
        } else if (goal.equals("failsafe-report-only")) {
            Plugin failsafePlugin = this.getPlugin("org.apache.maven.plugins", "maven-failsafe-plugin");
            Xpp3Dom failsafeConfig = ExecuteMojoUtil.getPluginGoalConfig(failsafePlugin, "integration-test", this.log);
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (failsafeConfig != null) {
                Xpp3Dom reportsDirectoryElement = failsafeConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = failsafeConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        } else if (goal.equals("report-only")) {
            Plugin surefirePlugin = this.getPlugin("org.apache.maven.plugins", "maven-surefire-plugin");
            Xpp3Dom surefireConfig = ExecuteMojoUtil.getPluginGoalConfig(surefirePlugin, "test", this.log);
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (surefireConfig != null) {
                Xpp3Dom reportsDirectoryElement = surefireConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = surefireConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        }
        this.log.debug((CharSequence)(groupId + ":" + artifactId + " " + goal + " configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session.clone(), (BuildPluginManager)this.pluginManager));
    }

    private void injectTestId(Xpp3Dom config) {
        Xpp3Dom properties = config.getChild("properties");
        if (properties == null || properties.getChild(TEST_RUN_ID_PROPERTY_NAME) == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"properties"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)TEST_RUN_ID_PROPERTY_NAME), (String)String.valueOf(this.runId++))});
            config.addChild(e.toDom());
        } else {
            properties.getChild(TEST_RUN_ID_PROPERTY_NAME).setValue(String.valueOf(this.runId++));
        }
    }

    private void injectLibertyProperties(Xpp3Dom config) throws MojoExecutionException {
        Xpp3Dom sysProps = config.getChild("systemPropertyVariables");
        if (sysProps == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"systemPropertyVariables"), (MojoExecutor.Element[])new MojoExecutor.Element[0]);
            sysProps = e.toDom();
            config.addChild(sysProps);
        }
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTPS_PORT, this.util.getHttpsPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTPS_PORT, this.util.getHttpsPort());
        try {
            this.addDomPropertyIfNotFound(sysProps, WLP_USER_DIR_PROPERTY_NAME, this.userDirectory.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve canonical path of userDirectory parameter: " + this.userDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private void addDomPropertyIfNotFound(Xpp3Dom sysProps, String key, String value) {
        if (sysProps.getChild(key) == null && value != null) {
            sysProps.addChild(MojoExecutor.element((String)MojoExecutor.name((String)key), (String)value).toDom());
        }
    }

    private void runBoostMojo(String goal) throws MojoExecutionException, ProjectBuildingException {
        MavenProject boostProject = this.project;
        MavenSession boostSession = this.session;
        this.log.debug((CharSequence)("plugin version: " + this.boostPlugin.getVersion()));
        MojoExecutor.executeMojo((Plugin)this.boostPlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)boostProject, (MavenSession)boostSession, (BuildPluginManager)this.pluginManager));
    }

    private void listFiles(File directory, List<File> files, String suffix) {
        File[] fList;
        if (directory != null && (fList = directory.listFiles()) != null) {
            for (File file : fList) {
                if (file.isFile() && (suffix == null || file.getName().toLowerCase().endsWith("." + suffix))) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFiles(file, files, suffix);
            }
        }
    }

    private ServerFeature getServerFeatureUtil() {
        if (serverFeatureUtil == null) {
            serverFeatureUtil = new ServerFeature();
        }
        return serverFeatureUtil;
    }

    private void runCompileMojo(String goal) throws MojoExecutionException {
        Plugin plugin = this.getPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.log);
        config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"failOnError"), (String)"false")}), (Xpp3Dom)config);
        this.log.info((CharSequence)("Running maven-compiler-plugin:" + goal));
        this.log.debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void runCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("compile");
    }

    private void runTestCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("testCompile");
    }

    private class ServerFeature
    extends ServerFeatureUtil {
        private ServerFeature() {
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }
    }

    private class DevMojoUtil
    extends DevUtil {
        Set<String> existingFeatures;
        private static final String LIBERTY_BOOTSTRAP_PROP = "liberty.bootstrap.";
        private static final String LIBERTY_JVM_PROP = "liberty.jvm.";
        private static final String LIBERTY_ENV_PROP = "liberty.env.";
        private static final String LIBERTY_VAR_PROP = "liberty.var.";
        private static final String LIBERTY_DEFAULT_VAR_PROP = "liberty.defaultVar.";

        public DevMojoUtil(File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, List<File> resourceDirs) throws IOException {
            super(serverDirectory, sourceDirectory, testSourceDirectory, configDirectory, resourceDirs, DevMojo.this.hotTests, DevMojo.this.skipTests, DevMojo.this.skipUTs, DevMojo.this.skipITs, DevMojo.this.project.getArtifactId(), (long)DevMojo.this.serverStartTimeout, DevMojo.this.verifyTimeout, DevMojo.this.verifyTimeout, (long)(DevMojo.this.compileWait * 1000.0), DevMojo.this.libertyDebug, false, false, DevMojo.this.pollingTest);
            ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
            this.existingFeatures = servUtil.getServerFeatures(serverDirectory);
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }

        public void error(String msg) {
            DevMojo.this.log.error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            DevMojo.this.log.error((CharSequence)msg, e);
        }

        public boolean isDebugEnabled() {
            return DevMojo.this.log.isDebugEnabled();
        }

        public String getServerStartTimeoutExample() {
            return "'mvn liberty:dev -DserverStartTimeout=120'";
        }

        public void libertyCreate() throws PluginExecutionException {
            try {
                if (DevMojo.this.isUsingBoost()) {
                    DevMojo.this.log.info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else {
                    DevMojo.this.runLibertyMojoCreate();
                }
            }
            catch (MojoExecutionException | ProjectBuildingException e) {
                throw new PluginExecutionException(e);
            }
        }

        public void libertyInstallFeature() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoInstallFeature(null);
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void libertyDeploy() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void stopServer() {
            try {
                ServerTask serverTask = DevMojo.this.initializeJava();
                serverTask.setOperation("stop");
                serverTask.execute();
            }
            catch (Exception e) {
                DevMojo.this.log.warn((CharSequence)MessageFormat.format(messages.getString("warn.server.stopped"), DevMojo.this.serverName));
            }
        }

        public ServerTask getServerTask() throws Exception {
            if (DevMojo.this.serverTask != null) {
                return DevMojo.this.serverTask;
            }
            DevMojo.this.serverTask = DevMojo.this.initializeJava();
            DevMojo.this.copyConfigFiles();
            DevMojo.this.serverTask.setClean(DevMojo.this.clean);
            if (DevMojo.this.libertyDebug) {
                this.setLibertyDebugPort(DevMojo.this.libertyDebugPort);
                DevMojo.this.serverTask.setOperation("debug");
                DevMojo.this.serverTask.setEnvironmentVariables(this.getDebugEnvironmentVariables());
            } else {
                DevMojo.this.serverTask.setOperation("run");
            }
            return DevMojo.this.serverTask;
        }

        public List<String> getArtifacts() {
            ArrayList<String> artifactPaths = new ArrayList<String>();
            Set artifacts = DevMojo.this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                try {
                    artifactPaths.add(artifact.getFile().getCanonicalPath());
                }
                catch (IOException e) {
                    DevMojo.this.log.error((CharSequence)("Unable to resolve project artifact " + e.getMessage()));
                }
            }
            return artifactPaths;
        }

        private Properties getPropertiesWithKeyPrefix(Properties p, String prefix) {
            Properties result = new Properties();
            if (p != null) {
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(prefix)) continue;
                    result.put(key, p.get(key));
                }
            }
            return result;
        }

        private List<Dependency> getEsaDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"esa".equals(d.getType())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private List<Dependency> getCompileDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"compile".equals(d.getScope())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private boolean hasServerPropertyChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_BOOTSTRAP_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_BOOTSTRAP_PROP))) {
                return true;
            }
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_JVM_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_JVM_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_ENV_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_ENV_PROP));
        }

        private boolean hasServerVariableChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_VAR_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_DEFAULT_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_DEFAULT_VAR_PROP));
        }

        private boolean restartForLibertyMojoConfigChanged(Xpp3Dom config, Xpp3Dom oldConfig) {
            if (!Objects.equals(config.getChild("bootstrapProperties"), oldConfig.getChild("bootstrapProperties"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("bootstrapPropertiesFile"), oldConfig.getChild("bootstrapPropertiesFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptions"), oldConfig.getChild("jvmOptions"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptionsFile"), oldConfig.getChild("jvmOptionsFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnv"), oldConfig.getChild("serverEnv"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnvFile"), oldConfig.getChild("serverEnvFile"))) {
                return true;
            }
            return !Objects.equals(config.getChild("configDirectory"), oldConfig.getChild("configDirectory"));
        }

        public boolean recompileBuildFile(File buildFile, List<String> artifactPaths, ThreadPoolExecutor executor) throws PluginExecutionException {
            ProjectBuildingResult build;
            boolean restartServer = false;
            boolean createServer = false;
            boolean installFeature = false;
            boolean redeployApp = false;
            boolean runBoostPackage = false;
            try {
                build = DevMojo.this.mavenProjectBuilder.build(buildFile, DevMojo.this.session.getProjectBuildingRequest().setResolveDependencies(true));
            }
            catch (ProjectBuildingException e) {
                DevMojo.this.log.error((CharSequence)("Could not parse pom.xml. " + e.getMessage()));
                DevMojo.this.log.debug((Throwable)e);
                return false;
            }
            Plugin backupLibertyPlugin = DevMojo.this.getLibertyPlugin();
            MavenProject backupProject = DevMojo.this.project;
            DevMojo.this.project = build.getProject();
            DevMojo.this.session.setCurrentProject(DevMojo.this.project);
            Plugin libertyPlugin = DevMojo.this.getLibertyPlugin();
            try {
                List oldDeps;
                List deps;
                Xpp3Dom oldConfig;
                Xpp3Dom config;
                if (this.hasServerPropertyChanged(DevMojo.this.project, backupProject)) {
                    restartServer = true;
                }
                if (!restartServer && this.hasServerVariableChanged(DevMojo.this.project, backupProject)) {
                    createServer = true;
                }
                if (!restartServer && !Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "create", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "create", DevMojo.this.log))) {
                    createServer = true;
                    if (this.restartForLibertyMojoConfigChanged(config, oldConfig)) {
                        restartServer = true;
                    }
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "install-feature", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "install-feature", DevMojo.this.log))) {
                    installFeature = true;
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "deploy", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "deploy", DevMojo.this.log))) {
                    redeployApp = true;
                }
                if (!(deps = DevMojo.this.project.getDependencies()).equals(oldDeps = backupProject.getDependencies())) {
                    List updatedArtifacts;
                    runBoostPackage = true;
                    if (!this.getEsaDependency(deps).equals(this.getEsaDependency(oldDeps))) {
                        installFeature = true;
                    }
                    if (!this.getCompileDependency(deps).equals(this.getCompileDependency(oldDeps))) {
                        redeployApp = true;
                    }
                    if (!(updatedArtifacts = DevMojo.this.getNewDependencies(deps, oldDeps)).isEmpty()) {
                        for (Artifact artifact : updatedArtifacts) {
                            DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion());
                            org.eclipse.aether.graph.Dependency dependency = new org.eclipse.aether.graph.Dependency((org.eclipse.aether.artifact.Artifact)aetherArtifact, null, Boolean.valueOf(true));
                            CollectRequest collectRequest = new CollectRequest();
                            collectRequest.setRoot(dependency);
                            collectRequest.setRepositories(DevMojo.this.repositories);
                            ArrayList<String> addToClassPath = new ArrayList<String>();
                            DependencyRequest depRequest = new DependencyRequest(collectRequest, null);
                            DependencyResult dependencyResult = DevMojo.this.repositorySystem.resolveDependencies(DevMojo.this.repoSession, depRequest);
                            DependencyNode root = dependencyResult.getRoot();
                            ArrayList artifactsList = new ArrayList();
                            DevMojo.this.addArtifacts(root, artifactsList);
                            for (File a : artifactsList) {
                                DevMojo.this.log.debug((CharSequence)("Artifact: " + a));
                                if (!a.getCanonicalPath().endsWith(".jar")) continue;
                                addToClassPath.add(a.getCanonicalPath());
                            }
                            artifactPaths.addAll(addToClassPath);
                        }
                    }
                }
                if (restartServer) {
                    DevMojo.this.util.restartServer();
                    return true;
                }
                if (DevMojo.this.isUsingBoost() && (createServer || runBoostPackage)) {
                    DevMojo.this.log.info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else if (createServer) {
                    DevMojo.this.runLibertyMojoCreate();
                } else if (redeployApp) {
                    DevMojo.this.runLibertyMojoDeploy();
                }
                if (installFeature) {
                    DevMojo.this.runLibertyMojoInstallFeature(null);
                }
                if (!(restartServer || createServer || redeployApp || installFeature || runBoostPackage)) {
                    DevMojo.this.log.debug((CharSequence)"changes in the pom.xml are not monitored by dev mode");
                    return true;
                }
            }
            catch (IOException | MojoExecutionException | ProjectBuildingException | DependencyResolutionException e) {
                DevMojo.this.log.error((CharSequence)("An unexpected error occurred while processing changes in pom.xml. " + e.getMessage()));
                DevMojo.this.log.debug(e);
                DevMojo.this.project = backupProject;
                DevMojo.this.session.setCurrentProject(backupProject);
                return false;
            }
            return true;
        }

        public void checkConfigFile(File configFile, File serverDir) {
            try {
                ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
                Set features = servUtil.getServerFeatures(serverDir);
                if (features != null) {
                    features.removeAll(this.existingFeatures);
                    if (!features.isEmpty()) {
                        DevMojo.this.log.info((CharSequence)"Configuration features have been added");
                        MojoExecutor.Element[] featureElems = new MojoExecutor.Element[features.size() + 1];
                        featureElems[0] = MojoExecutor.element((String)MojoExecutor.name((String)"acceptLicense"), (String)"true");
                        String[] values = features.toArray(new String[features.size()]);
                        for (int i = 0; i < features.size(); ++i) {
                            featureElems[i + 1] = MojoExecutor.element((String)MojoExecutor.name((String)"feature"), (String)values[i]);
                        }
                        DevMojo.this.runLibertyMojoInstallFeature(MojoExecutor.element((String)MojoExecutor.name((String)"features"), (MojoExecutor.Element[])featureElems));
                        this.existingFeatures.addAll(features);
                    }
                }
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Failed to install features from configuration file", (Throwable)e);
            }
        }

        public boolean compile(File dir) {
            try {
                if (dir.equals(DevMojo.this.sourceDirectory)) {
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-compiler-plugin", "compile");
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                }
                if (dir.equals(DevMojo.this.testSourceDirectory)) {
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-compiler-plugin", "testCompile");
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public void runUnitTests() throws PluginExecutionException, PluginScenarioException {
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-plugin", "test");
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "report-only");
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Unit tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run unit tests", (Throwable)e);
            }
        }

        public void runIntegrationTests() throws PluginExecutionException, PluginScenarioException {
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test");
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "failsafe-report-only");
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "verify");
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Integration tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run integration tests", (Throwable)e);
            }
        }

        public void redeployApp() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException("liberty:deploy goal failed:" + e.getMessage());
            }
        }
    }
}

