/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension;

import io.pebbletemplates.pebble.attributes.AttributeResolver;
import io.pebbletemplates.pebble.extension.Extension;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.extension.NodeVisitorFactory;
import io.pebbletemplates.pebble.extension.Test;
import io.pebbletemplates.pebble.operator.BinaryOperator;
import io.pebbletemplates.pebble.operator.UnaryOperator;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionRegistry {
    private final Map<String, UnaryOperator> unaryOperators = new HashMap<String, UnaryOperator>();
    private final Map<String, BinaryOperator> binaryOperators = new HashMap<String, BinaryOperator>();
    private final Map<String, TokenParser> tokenParsers = new HashMap<String, TokenParser>();
    private final List<NodeVisitorFactory> nodeVisitors = new ArrayList<NodeVisitorFactory>();
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private final Map<String, Test> tests = new HashMap<String, Test>();
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final Map<String, Object> globalVariables = new HashMap<String, Object>();
    private final List<AttributeResolver> attributeResolver = new ArrayList<AttributeResolver>();

    public ExtensionRegistry() {
    }

    public ExtensionRegistry(Collection<? extends Extension> extensions) {
        for (Extension extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addOperatorOverridingExtension(Extension extension) {
        this.addExtension(extension, true);
    }

    public void addExtension(Extension extension) {
        this.addExtension(extension, false);
    }

    private void addExtension(Extension extension, boolean operatorOverriding) {
        List<AttributeResolver> attributeResolvers;
        List<NodeVisitorFactory> nodeVisitors;
        Map<String, Object> globalVariables;
        Map<String, Function> functions;
        Map<String, Test> tests;
        Map<String, Filter> map;
        List<UnaryOperator> list;
        List<BinaryOperator> binaryOperators;
        List<TokenParser> tokenParsers = extension.getTokenParsers();
        if (tokenParsers != null) {
            for (TokenParser tokenParser : tokenParsers) {
                this.tokenParsers.put(tokenParser.getTag(), tokenParser);
            }
        }
        if ((binaryOperators = extension.getBinaryOperators()) != null) {
            for (BinaryOperator binaryOperator : binaryOperators) {
                if (operatorOverriding) {
                    this.binaryOperators.put(binaryOperator.getSymbol(), binaryOperator);
                    continue;
                }
                this.binaryOperators.putIfAbsent(binaryOperator.getSymbol(), binaryOperator);
            }
        }
        if ((list = extension.getUnaryOperators()) != null) {
            for (UnaryOperator operator : list) {
                if (operatorOverriding) {
                    this.unaryOperators.put(operator.getSymbol(), operator);
                    continue;
                }
                this.unaryOperators.putIfAbsent(operator.getSymbol(), operator);
            }
        }
        if ((map = extension.getFilters()) != null) {
            this.filters.putAll(map);
        }
        if ((tests = extension.getTests()) != null) {
            this.tests.putAll(tests);
        }
        if ((functions = extension.getFunctions()) != null) {
            this.functions.putAll(functions);
        }
        if ((globalVariables = extension.getGlobalVariables()) != null) {
            this.globalVariables.putAll(globalVariables);
        }
        if ((nodeVisitors = extension.getNodeVisitors()) != null) {
            this.nodeVisitors.addAll(nodeVisitors);
        }
        if ((attributeResolvers = extension.getAttributeResolver()) != null) {
            this.attributeResolver.addAll(attributeResolvers);
        }
    }

    public Filter getFilter(String name) {
        return this.filters.get(name);
    }

    public Test getTest(String name) {
        return this.tests.get(name);
    }

    public Function getFunction(String name) {
        return this.functions.get(name);
    }

    public Map<String, BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public Map<String, UnaryOperator> getUnaryOperators() {
        return this.unaryOperators;
    }

    public List<NodeVisitorFactory> getNodeVisitors() {
        return this.nodeVisitors;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public Map<String, TokenParser> getTokenParsers() {
        return this.tokenParsers;
    }

    public List<AttributeResolver> getAttributeResolver() {
        return this.attributeResolver;
    }
}

