/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.core;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NumberFormatFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public NumberFormatFilter() {
        this.argumentNames.add("format");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (!(input instanceof Number)) {
            throw new PebbleException(null, "The input for the 'NumberFormat' filter has to be a number.", lineNumber, self.getName());
        }
        Number number = (Number)input;
        Locale locale = context.getLocale();
        if (args.get("format") != null) {
            DecimalFormat format = new DecimalFormat((String)args.get("format"), new DecimalFormatSymbols(locale));
            return format.format(number);
        }
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        return numberFormat.format(number);
    }
}

