/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.extension.escaper;

import io.pebbletemplates.pebble.extension.AbstractExtension;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.extension.NodeVisitorFactory;
import io.pebbletemplates.pebble.extension.escaper.EscapeFilter;
import io.pebbletemplates.pebble.extension.escaper.EscaperNodeVisitorFactory;
import io.pebbletemplates.pebble.extension.escaper.EscapingStrategy;
import io.pebbletemplates.pebble.extension.escaper.RawFilter;
import io.pebbletemplates.pebble.tokenParser.AutoEscapeTokenParser;
import io.pebbletemplates.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscaperExtension
extends AbstractExtension {
    private final EscapeFilter filter = new EscapeFilter();
    private final EscaperNodeVisitorFactory visitorFactory = new EscaperNodeVisitorFactory();

    @Override
    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("escape", this.filter);
        filters.put("raw", new RawFilter());
        return filters;
    }

    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>();
        parsers.add(new AutoEscapeTokenParser());
        return parsers;
    }

    @Override
    public List<NodeVisitorFactory> getNodeVisitors() {
        ArrayList<NodeVisitorFactory> visitors = new ArrayList<NodeVisitorFactory>();
        visitors.add(this.visitorFactory);
        return visitors;
    }

    public void setDefaultStrategy(String strategy) {
        this.filter.setDefaultStrategy(strategy);
    }

    public void setAutoEscaping(boolean auto) {
        this.visitorFactory.setAutoEscaping(auto);
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.filter.addEscapingStrategy(name, strategy);
    }
}

