/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.node;

import io.pebbletemplates.pebble.extension.NodeVisitor;
import io.pebbletemplates.pebble.node.AbstractRenderableNode;
import io.pebbletemplates.pebble.node.ImportNode;
import io.pebbletemplates.pebble.node.Node;
import io.pebbletemplates.pebble.node.RenderableNode;
import io.pebbletemplates.pebble.node.SetNode;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class BodyNode
extends AbstractRenderableNode {
    private final List<RenderableNode> children;
    private boolean onlyRenderInheritanceSafeNodes = false;
    private static List<Class<? extends Node>> nodesToRenderInChild = new ArrayList<Class<? extends Node>>();

    public BodyNode(int lineNumber, List<RenderableNode> children) {
        super(lineNumber);
        this.children = children;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        for (RenderableNode child : this.children) {
            if (this.onlyRenderInheritanceSafeNodes && context.getHierarchy().getParent() != null && !nodesToRenderInChild.contains(child.getClass())) continue;
            child.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<RenderableNode> getChildren() {
        return this.children;
    }

    public boolean isOnlyRenderInheritanceSafeNodes() {
        return this.onlyRenderInheritanceSafeNodes;
    }

    public void setOnlyRenderInheritanceSafeNodes(boolean onlyRenderInheritanceSafeNodes) {
        this.onlyRenderInheritanceSafeNodes = onlyRenderInheritanceSafeNodes;
    }

    static {
        nodesToRenderInChild.add(SetNode.class);
        nodesToRenderInChild.add(ImportNode.class);
    }
}

