/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.pebble.node.expression;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.node.expression.BinaryExpression;
import io.pebbletemplates.pebble.node.expression.Expression;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplateImpl;
import io.pebbletemplates.pebble.utils.TypeUtils;

public class OrExpression
extends BinaryExpression<Boolean> {
    @Override
    public Boolean evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
        Expression<Boolean> leftExpression = this.getLeftExpression();
        boolean left = this.evaluateExpression(self, context, leftExpression);
        if (!left) {
            Expression<Boolean> rightExpression = this.getRightExpression();
            return this.evaluateExpression(self, context, rightExpression);
        }
        return true;
    }

    private boolean evaluateExpression(PebbleTemplateImpl self, EvaluationContextImpl context, Expression<Boolean> expression) {
        Boolean evaluatedExpression = TypeUtils.compatibleCast(expression.evaluate(self, context), Boolean.class);
        if (evaluatedExpression == null) {
            if (context.isStrictVariables()) {
                throw new PebbleException(null, "null value used in and operator and strict variables is set to true", this.getLineNumber(), self.getName());
            }
            return false;
        }
        return evaluatedExpression;
    }
}

