/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyUtils.class);

    private ProxyUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static Proxy getProxy(MavenSession mavenSession, SettingsDecrypter decrypter) {
        if (mavenSession == null || mavenSession.getSettings() == null || mavenSession.getSettings().getProxies() == null || mavenSession.getSettings().getProxies().isEmpty()) {
            LOGGER.info("Proxy is not specified.");
        } else {
            List mavenProxies = mavenSession.getSettings().getProxies();
            for (Proxy proxy : mavenProxies) {
                Proxy decrypted;
                block9: {
                    if (!proxy.isActive()) continue;
                    decrypted = ProxyUtils.decryptProxy(proxy, decrypter);
                    try {
                        Socket socket = new Socket(decrypted.getHost(), decrypted.getPort());
                        Throwable throwable = null;
                        if (socket == null) break block9;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.info(String.format("Proxy: %s:%s is not available", decrypted.getHost(), decrypted.getPort()));
                        continue;
                    }
                }
                LOGGER.info(String.format("Found proxy: %s:%s", decrypted.getHost(), decrypted.getPort()));
                return proxy;
            }
            LOGGER.info("No active proxies found.");
        }
        return null;
    }

    private static Proxy decryptProxy(Proxy proxy, SettingsDecrypter decrypter) {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(proxy);
        SettingsDecryptionResult decryptedResult = decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        return decryptedResult.getProxy();
    }
}

