/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import io.setl.rdf.normalization.IdentifierIssuer;
import io.setl.rdf.normalization.NDegreeResult;
import io.setl.rdf.normalization.NQuadSerializer;
import io.setl.rdf.normalization.Permutator;
import io.setl.rdf.normalization.Position;
import io.setl.rdf.normalization.SerializedQuad;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class RdfNormalize {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final HashMap<RdfValue, RdfDataset> blankIdToQuadSet = new HashMap();
    private final IdentifierIssuer canonIssuer = new IdentifierIssuer("_:c14n");
    private final TreeMap<String, Set<RdfResource>> hashToBlankId = new TreeMap();
    private final List<RdfNQuad> quads;
    private final MessageDigest sha256;
    private HashSet<RdfValue> nonNormalized;

    static String hex(byte[] data) {
        StringBuilder builder = new StringBuilder(data.length * 2);
        for (byte b : data) {
            builder.append(HEX[(b & 0xF0) >> 4]).append(HEX[b & 0xF]);
        }
        return builder.toString();
    }

    public static RdfDataset normalize(RdfDataset input) {
        return new RdfNormalize(input).doNormalize();
    }

    public static RdfDataset normalize(RdfDataset input, String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null || algorithm.isBlank() || algorithm.equalsIgnoreCase("urdna2015")) {
            return new RdfNormalize(input).doNormalize();
        }
        throw new NoSuchAlgorithmException("Normalization algorithm is not supported:" + algorithm);
    }

    private RdfNormalize(RdfDataset input) {
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-256 is not available", e);
        }
        this.quads = input.toList();
    }

    private RdfDataset doNormalize() {
        this.findBlankNodes();
        this.setNonNormalized();
        this.issueSimpleIds();
        this.issueNDegreeIds();
        return this.makeCanonQuads();
    }

    private void findBlankNodes() {
        for (RdfNQuad quad : this.quads) {
            for (Position position : Position.CAN_BE_BLANK) {
                RdfValue value = position.get(quad);
                if (value == null || !value.isBlankNode()) continue;
                this.blankIdToQuadSet.computeIfAbsent(value, k -> Rdf.createDataset()).add(quad);
            }
        }
    }

    private String hashFirstDegree(RdfValue blankId) {
        List related = this.blankIdToQuadSet.get(blankId).toList();
        Object[] nQuads = new String[related.size()];
        int i = 0;
        for (RdfNQuad q0 : related) {
            nQuads[i] = NQuadSerializer.forBlank(q0, blankId);
            ++i;
        }
        Arrays.sort(nQuads);
        this.sha256.reset();
        for (Object s : nQuads) {
            this.sha256.update(((String)s).getBytes(StandardCharsets.UTF_8));
        }
        return RdfNormalize.hex(this.sha256.digest());
    }

    private NDegreeResult hashNDegreeQuads(RdfResource id, IdentifierIssuer issuer) {
        return new HashNDegreeQuads().hash(id, issuer);
    }

    private void issueNDegreeIds() {
        for (Map.Entry<String, Set<RdfResource>> entry : this.hashToBlankId.entrySet()) {
            ArrayList<NDegreeResult> hashPathList = new ArrayList<NDegreeResult>();
            for (RdfResource id : entry.getValue()) {
                if (this.canonIssuer.hasId(id)) continue;
                IdentifierIssuer blankIssuer = new IdentifierIssuer("_:b");
                blankIssuer.getId(id);
                NDegreeResult path = this.hashNDegreeQuads(id, blankIssuer);
                hashPathList.add(path);
            }
            hashPathList.sort(Comparator.naturalOrder());
            for (NDegreeResult result : hashPathList) {
                result.getIssuer().assign(this.canonIssuer);
            }
        }
    }

    private void issueSimpleIds() {
        boolean simple = true;
        while (simple) {
            simple = false;
            this.hashToBlankId.clear();
            for (RdfValue value : this.nonNormalized) {
                RdfResource blankId = (RdfResource)value;
                String hash = this.hashFirstDegree((RdfValue)blankId);
                this.hashToBlankId.computeIfAbsent(hash, k -> new HashSet()).add(blankId);
            }
            Iterator<Map.Entry<String, Set<RdfResource>>> iterator = this.hashToBlankId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<RdfResource>> entry = iterator.next();
                Set<RdfResource> values = entry.getValue();
                if (values.size() != 1) continue;
                RdfResource id = values.iterator().next();
                this.canonIssuer.getId(id);
                this.nonNormalized.remove(id);
                iterator.remove();
                simple = true;
            }
        }
    }

    private RdfDataset makeCanonQuads() {
        Object[] outputQuads = new SerializedQuad[this.quads.size()];
        int i = 0;
        AtomicBoolean changed = new AtomicBoolean();
        for (RdfNQuad q : this.quads) {
            changed.set(false);
            RdfResource subject = this.canonIssuer.getIfExists(q.getSubject(), changed);
            RdfValue object = this.canonIssuer.getIfExists(q.getObject(), changed);
            RdfResource graph = this.canonIssuer.getIfExists((RdfResource)q.getGraphName().orElse(null), changed);
            outputQuads[i] = changed.get() ? new SerializedQuad(Rdf.createNQuad((RdfResource)subject, (RdfResource)q.getPredicate(), (RdfValue)object, (RdfResource)graph)) : new SerializedQuad(q);
            ++i;
        }
        Arrays.sort(outputQuads);
        RdfDataset rdfDataset = Rdf.createDataset();
        for (Object quad : outputQuads) {
            rdfDataset.add(((SerializedQuad)quad).getQuad());
        }
        return rdfDataset;
    }

    private void setNonNormalized() {
        this.nonNormalized = new HashSet<RdfValue>(this.blankIdToQuadSet.keySet());
    }

    private class HashNDegreeQuads {
        IdentifierIssuer chosenIssuer = null;
        StringBuilder chosenPath = null;
        final StringBuilder dataToHash = new StringBuilder();

        private HashNDegreeQuads() {
        }

        private void appendToPath(RdfResource related, StringBuilder pathBuilder, IdentifierIssuer issuerCopy, List<RdfResource> recursionList) {
            if (RdfNormalize.this.canonIssuer.hasId(related)) {
                pathBuilder.append(RdfNormalize.this.canonIssuer.getId(related).getValue());
            } else {
                if (!issuerCopy.hasId(related)) {
                    recursionList.add(related);
                }
                pathBuilder.append(issuerCopy.getId(related).getValue());
            }
        }

        private SortedMap<String, Set<RdfResource>> createHashToRelated(RdfResource id, IdentifierIssuer issuer) {
            TreeMap<String, Set<RdfResource>> hashToRelated = new TreeMap<String, Set<RdfResource>>();
            RdfDataset refer = RdfNormalize.this.blankIdToQuadSet.get(id);
            for (RdfNQuad quad : refer.toList()) {
                for (Position position : Position.CAN_BE_BLANK) {
                    if (!position.isBlank(quad) || id.equals(position.get(quad))) continue;
                    RdfResource related = (RdfResource)position.get(quad);
                    String hash = this.hashRelatedBlankNode(related, quad, issuer, position);
                    hashToRelated.computeIfAbsent(hash, h -> new HashSet()).add(related);
                }
            }
            return hashToRelated;
        }

        private void doPermutation(RdfResource[] permutation, IdentifierIssuer issuer) {
            IdentifierIssuer issuerCopy = issuer.copy();
            StringBuilder pathBuilder = new StringBuilder();
            ArrayList<RdfResource> recursionList = new ArrayList<RdfResource>();
            for (RdfResource related : permutation) {
                this.appendToPath(related, pathBuilder, issuerCopy, recursionList);
                if (this.chosenPath.length() <= 0 || pathBuilder.compareTo(this.chosenPath) <= 0) continue;
                return;
            }
            for (RdfResource related : recursionList) {
                NDegreeResult result = RdfNormalize.this.hashNDegreeQuads(related, issuerCopy);
                pathBuilder.append(issuerCopy.getId(related).getValue()).append('<').append(result.getHash()).append('>');
                issuerCopy = result.getIssuer();
                if (this.chosenPath.length() <= 0 || pathBuilder.compareTo(this.chosenPath) <= 0) continue;
                return;
            }
            if (this.chosenPath.length() == 0 || pathBuilder.compareTo(this.chosenPath) < 0) {
                this.chosenPath.setLength(0);
                this.chosenPath.append((CharSequence)pathBuilder);
                this.chosenIssuer = issuerCopy;
            }
        }

        NDegreeResult hash(RdfResource id, IdentifierIssuer issuer) {
            SortedMap<String, Set<RdfResource>> hashToRelated = this.createHashToRelated(id, issuer);
            for (Map.Entry<String, Set<RdfResource>> entry : hashToRelated.entrySet()) {
                this.dataToHash.append(entry.getKey());
                this.chosenPath = new StringBuilder();
                this.chosenIssuer = null;
                Permutator permutator = new Permutator((RdfResource[])entry.getValue().toArray(RdfResource[]::new));
                while (permutator.hasNext()) {
                    this.doPermutation(permutator.next(), issuer);
                }
                this.dataToHash.append((CharSequence)this.chosenPath);
                issuer = this.chosenIssuer;
            }
            RdfNormalize.this.sha256.reset();
            String hash = RdfNormalize.hex(RdfNormalize.this.sha256.digest(this.dataToHash.toString().getBytes(StandardCharsets.UTF_8)));
            return new NDegreeResult(hash, issuer);
        }

        private String hashRelatedBlankNode(RdfResource related, RdfNQuad quad, IdentifierIssuer issuer, Position position) {
            String id = RdfNormalize.this.canonIssuer.hasId(related) ? RdfNormalize.this.canonIssuer.getId(related).getValue() : (issuer.hasId(related) ? issuer.getId(related).getValue() : RdfNormalize.this.hashFirstDegree((RdfValue)related));
            RdfNormalize.this.sha256.reset();
            RdfNormalize.this.sha256.update(position.tag());
            if (position != Position.GRAPH) {
                RdfNormalize.this.sha256.update((byte)60);
                RdfNormalize.this.sha256.update(quad.getPredicate().getValue().getBytes(StandardCharsets.UTF_8));
                RdfNormalize.this.sha256.update((byte)62);
            }
            RdfNormalize.this.sha256.update(id.getBytes(StandardCharsets.UTF_8));
            return RdfNormalize.hex(RdfNormalize.this.sha256.digest());
        }
    }
}

