/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import io.shardingsphere.core.constant.PoolType;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import io.shardingsphere.core.rule.DataSourceParameter;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceConfiguration {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final Collection<Class<?>> GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class});
    private static final Collection<String> SKIPPED_PROPERTY_NAMES = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private final String dataSourceClassName;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static DataSourceConfiguration getDataSourceConfiguration(DataSource dataSource) {
        DataSourceConfiguration result = new DataSourceConfiguration(dataSource.getClass().getName());
        result.getProperties().putAll(DataSourceConfiguration.findAllGetterProperties(dataSource));
        return result;
    }

    public static DataSourceConfiguration getDataSourceConfiguration(DataSourceParameter dataSourceParameter) {
        DataSourceConfiguration result = new DataSourceConfiguration(PoolType.HIKARI.getClassName());
        result.getProperties().putAll(DataSourceConfiguration.findAllGetterProperties(dataSourceParameter));
        return result;
    }

    private static Map<String, Object> findAllGetterProperties(Object target) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            for (Method each : DataSourceConfiguration.findAllGetterMethods(target.getClass())) {
                String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, each.getName().substring(GETTER_PREFIX.length()));
                if (!GENERAL_CLASS_TYPE.contains(each.getReturnType()) || SKIPPED_PROPERTY_NAMES.contains(propertyName)) continue;
                result.put(propertyName, each.invoke(target, new Object[0]));
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingConfigurationException(ex);
        }
        return result;
    }

    private static Collection<Method> findAllGetterMethods(Class<?> clazz) {
        HashSet<Method> result = new HashSet<Method>();
        for (Method each : clazz.getMethods()) {
            if (!each.getName().startsWith(GETTER_PREFIX) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    public DataSource createDataSource() {
        try {
            DataSource result = (DataSource)Class.forName(this.dataSourceClassName).newInstance();
            Method[] methods = result.getClass().getMethods();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                Optional<Method> setterMethod;
                if (SKIPPED_PROPERTY_NAMES.contains(entry.getKey()) || !(setterMethod = this.findSetterMethod(methods, entry.getKey())).isPresent()) continue;
                ((Method)setterMethod.get()).invoke((Object)result, entry.getValue());
            }
            return result;
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingConfigurationException(ex);
        }
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = Joiner.on((String)"").join((Object)SETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), new Object[0]);
        for (Method each : methods) {
            if (!each.getName().equals(setterMethodName) || 1 != each.getParameterTypes().length) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public DataSourceParameter createDataSourceParameter() {
        DataSourceParameter result = new DataSourceParameter();
        for (Field each : result.getClass().getDeclaredFields()) {
            try {
                each.setAccessible(true);
                if (!this.properties.containsKey(each.getName())) continue;
                each.set(result, this.properties.get(each.getName()));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return result;
    }

    @ConstructorProperties(value={"dataSourceClassName"})
    public DataSourceConfiguration(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

