/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.hint;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.HintManager;
import io.shardingsphere.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import java.util.Collection;

public final class HintManagerHolder {
    public static final String DB_TABLE_NAME = "DB_TABLE_NAME";
    public static final String DB_COLUMN_NAME = "DB_COLUMN_NAME";
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();

    public static void setHintManager(HintManager hintManager) {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"HintManagerHolder has previous value, please clear first.");
        HINT_MANAGER_HOLDER.set(hintManager);
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isDatabaseShardingOnly();
    }

    public static boolean isMasterRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isMasterRouteOnly();
    }

    public static Optional<ShardingValue> getDatabaseShardingValue(String logicTable) {
        if (null == HINT_MANAGER_HOLDER.get() || !HINT_MANAGER_HOLDER.get().getDatabaseShardingValues().containsKey((Object)logicTable)) {
            return Optional.absent();
        }
        return Optional.of((Object)HintManagerHolder.getShardingValue(logicTable, HINT_MANAGER_HOLDER.get().getDatabaseShardingValues().get((Object)logicTable)));
    }

    public static Optional<ShardingValue> getTableShardingValue(String logicTable) {
        if (null == HINT_MANAGER_HOLDER.get() || !HINT_MANAGER_HOLDER.get().getTableShardingValues().containsKey((Object)logicTable)) {
            return Optional.absent();
        }
        return Optional.of((Object)HintManagerHolder.getShardingValue(logicTable, HINT_MANAGER_HOLDER.get().getTableShardingValues().get((Object)logicTable)));
    }

    private static ShardingValue getShardingValue(String logicTable, Collection<Comparable<?>> values) {
        Preconditions.checkArgument((null != values && !values.isEmpty() ? 1 : 0) != 0);
        return new ListShardingValue(logicTable, DB_COLUMN_NAME, values);
    }

    public static HintManager get() {
        return HINT_MANAGER_HOLDER.get();
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
    }

    private HintManagerHolder() {
    }
}

