/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.pagination;

import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dql.common.DecoratorMergedResult;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import java.sql.SQLException;

public final class LimitDecoratorMergedResult
extends DecoratorMergedResult {
    private final Limit limit;
    private final boolean skipAll;
    private int rowNumber;

    public LimitDecoratorMergedResult(MergedResult mergedResult, Limit limit) throws SQLException {
        super(mergedResult);
        this.limit = limit;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        for (int i = 0; i < this.limit.getOffsetValue(); ++i) {
            if (this.getMergedResult().next()) continue;
            return true;
        }
        this.rowNumber = 0;
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (this.limit.getRowCountValue() < 0) {
            return this.getMergedResult().next();
        }
        return ++this.rowNumber <= this.limit.getRowCountValue() && this.getMergedResult().next();
    }
}

