/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.pagination;

import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.dql.common.DecoratorMergedResult;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import java.sql.SQLException;

public final class RowNumberDecoratorMergedResult
extends DecoratorMergedResult {
    private final Limit limit;
    private final boolean skipAll;
    private int rowNumber;

    public RowNumberDecoratorMergedResult(MergedResult mergedResult, Limit limit) throws SQLException {
        super(mergedResult);
        this.limit = limit;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        int end = null == this.limit.getOffset() ? 0 : (this.limit.getOffset().isBoundOpened() ? this.limit.getOffsetValue() - 1 : this.limit.getOffsetValue());
        for (int i = 0; i < end; ++i) {
            if (this.getMergedResult().next()) continue;
            return true;
        }
        this.rowNumber = end + 1;
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (this.limit.getRowCountValue() < 0) {
            return this.getMergedResult().next();
        }
        if (this.limit.getRowCount().isBoundOpened()) {
            return this.rowNumber++ <= this.limit.getRowCountValue() && this.getMergedResult().next();
        }
        return this.rowNumber++ < this.limit.getRowCountValue() && this.getMergedResult().next();
    }
}

