/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.dql;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.FromWhereExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.dql.GroupByExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.dql.OrderByExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.dql.SelectClauseExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.FromWhereSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.SelectClauseSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.GroupBySegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.OrderBySegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class SubqueryExtractor
implements OptionalSQLSegmentExtractor {
    private final FromWhereExtractor fromWhereExtractor = new FromWhereExtractor();
    private final GroupByExtractor groupByExtractor = new GroupByExtractor();
    private final OrderByExtractor orderByExtractor = new OrderByExtractor();

    public Optional<SubquerySegment> extract(ParserRuleContext subqueryNode) {
        Optional<ParserRuleContext> aliasNode;
        Optional<OrderBySegment> orderBySegment;
        Optional<GroupBySegment> groupBySegment;
        Optional<FromWhereSegment> fromWhereSegment;
        if (!RuleName.SUBQUERY.getName().endsWith(subqueryNode.getClass().getSimpleName())) {
            return Optional.absent();
        }
        boolean subqueryInFrom = false;
        for (ParserRuleContext parentNode = subqueryNode.getParent(); null != parentNode; parentNode = parentNode.getParent()) {
            if (!RuleName.FROM_CLAUSE.getName().equals(parentNode.getClass().getSimpleName())) continue;
            subqueryInFrom = true;
            break;
        }
        SubquerySegment result = new SubquerySegment(subqueryInFrom);
        Optional<SelectClauseSegment> selectClauseSegment = new SelectClauseExtractor().extract(subqueryNode);
        if (selectClauseSegment.isPresent()) {
            result.setSelectClauseSegment((SelectClauseSegment)selectClauseSegment.get());
        }
        if ((fromWhereSegment = this.fromWhereExtractor.extract(subqueryNode)).isPresent()) {
            result.setFromWhereSegment((FromWhereSegment)fromWhereSegment.get());
        }
        if ((groupBySegment = this.groupByExtractor.extract(subqueryNode)).isPresent()) {
            result.setGroupBySegment((GroupBySegment)groupBySegment.get());
        }
        if ((orderBySegment = this.orderByExtractor.extract(subqueryNode)).isPresent()) {
            result.setOrderBySegment((OrderBySegment)orderBySegment.get());
        }
        if ((aliasNode = ExtractorUtils.findFirstChildNode(subqueryNode.getParent(), RuleName.ALIAS)).isPresent()) {
            result.setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
        return Optional.of((Object)result);
    }
}

