/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.context.selectitem;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class DistinctSelectItem
implements SelectItem {
    private final Set<String> distinctColumnNames;
    private final Optional<String> alias;

    @Override
    public String getExpression() {
        return this.isSingleColumnWithAlias() ? SQLUtil.getExactlyValue(DefaultKeyword.DISTINCT.name() + " " + this.distinctColumnNames.iterator().next() + "AS" + (String)this.alias.get()) : SQLUtil.getExactlyValue(DefaultKeyword.DISTINCT + " " + Joiner.on((String)", ").join(this.distinctColumnNames));
    }

    public Collection<String> getDistinctColumnLabels() {
        return this.isSingleColumnWithAlias() ? Collections.singletonList(this.alias.get()) : this.distinctColumnNames;
    }

    private boolean isSingleColumnWithAlias() {
        return 1 == this.distinctColumnNames.size() && this.alias.isPresent();
    }

    @ConstructorProperties(value={"distinctColumnNames", "alias"})
    public DistinctSelectItem(Set<String> distinctColumnNames, Optional<String> alias) {
        this.distinctColumnNames = distinctColumnNames;
        this.alias = alias;
    }

    public Set<String> getDistinctColumnNames() {
        return this.distinctColumnNames;
    }

    @Override
    public Optional<String> getAlias() {
        return this.alias;
    }
}

