/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.processors;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.io.Files;
import io.swagger.oas.inflector.controllers.OpenAPIOperationController;
import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.validators.ValidationError;
import io.swagger.oas.inflector.validators.ValidationException;
import io.swagger.oas.inflector.validators.ValidationMessage;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryProcessor
implements EntityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryProcessor.class);
    private static List<javax.ws.rs.core.MediaType> SUPPORTED_TYPES = new ArrayList<javax.ws.rs.core.MediaType>();

    @Override
    public List<javax.ws.rs.core.MediaType> getSupportedMediaTypes() {
        return new ArrayList<javax.ws.rs.core.MediaType>(SUPPORTED_TYPES);
    }

    @Override
    public void enableType(javax.ws.rs.core.MediaType type) {
        javax.ws.rs.core.MediaType t = type;
        if (t != null && !SUPPORTED_TYPES.contains(t)) {
            SUPPORTED_TYPES.add(type);
        }
    }

    @Override
    public boolean supports(javax.ws.rs.core.MediaType mediaType) {
        for (javax.ws.rs.core.MediaType item : SUPPORTED_TYPES) {
            if (!item.isCompatible(mediaType) || mediaType.isWildcardType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object process(javax.ws.rs.core.MediaType mediaType, InputStream entityStream, Class<?> cls) throws ConversionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object process(javax.ws.rs.core.MediaType mediaType, InputStream entityStream, Class<?> cls, OpenAPIOperationController controller) throws ConversionException {
        block47: {
            Object argument = null;
            Map<String, String> headers = new HashMap<String, String>();
            String name = null;
            HashMap<Object, Map<String, String>> formMap = new HashMap<Object, Map<String, String>>();
            HashMap<Object, File> inputStreams = new HashMap<Object, File>();
            ArrayList<ValidationMessage> missingParams = new ArrayList<ValidationMessage>();
            Object[] args = new Object[controller.getParameterClasses().length];
            try {
                Schema schema;
                if (mediaType.equals((Object)javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                    JavaType[] parameters = controller.getParameterClasses();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (parameters[i].getRawClass().equals(InputStream.class)) {
                            argument = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)entityStream));
                            continue;
                        }
                        if (parameters[i].getRawClass().equals(File.class)) {
                            File file = File.createTempFile("inflector", ".tmp");
                            file.deleteOnExit();
                            FileUtils.copyInputStreamToFile((InputStream)entityStream, (File)file);
                            argument = file;
                            continue;
                        }
                        if (!parameters[i].getRawClass().equals(byte[].class)) continue;
                        argument = IOUtils.toByteArray((InputStream)entityStream);
                    }
                    return argument;
                }
                if (mediaType.isCompatible(javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
                    block46: {
                        int i = 1;
                        String boundary = (String)mediaType.getParameters().get("boundary");
                        if (boundary != null) {
                            try {
                                InputStream inputStream = entityStream;
                                MultipartStream multipartStream = new MultipartStream(inputStream, boundary.getBytes());
                                boolean nextPart = multipartStream.skipPreamble();
                                while (nextPart) {
                                    String filename;
                                    String header = multipartStream.readHeaders();
                                    if (header != null) {
                                        CSVFormat format = CSVFormat.DEFAULT.withDelimiter(';').withRecordSeparator("=");
                                        CSVParser records = format.parse((Reader)new StringReader(header));
                                        for (CSVRecord r : records) {
                                            for (int j = 0; j < r.size(); ++j) {
                                                String string = r.get(j);
                                                CSVParser outerString = CSVFormat.DEFAULT.withDelimiter('=').parse((Reader)new StringReader(string));
                                                for (CSVRecord outerKvPair : outerString) {
                                                    if (outerKvPair.size() == 2) {
                                                        String key = outerKvPair.get(0).trim();
                                                        String value = outerKvPair.get(1).trim();
                                                        if ("name".equals(key)) {
                                                            name = value;
                                                        }
                                                        headers.put(key, value);
                                                        continue;
                                                    }
                                                    CSVParser innerString = CSVFormat.DEFAULT.withDelimiter(':').parse((Reader)new StringReader(string));
                                                    for (CSVRecord innerKVPair : innerString) {
                                                        if (innerKVPair.size() != 2) continue;
                                                        String key = innerKVPair.get(0).trim();
                                                        String value = innerKVPair.get(1).trim();
                                                        if ("name".equals(key)) {
                                                            name = value;
                                                        }
                                                        headers.put(key, value);
                                                    }
                                                }
                                                if (name == null) continue;
                                                formMap.put(name, headers);
                                            }
                                        }
                                    }
                                    if ((filename = BinaryProcessor.extractFilenameFromHeaders(headers)) != null) {
                                        try {
                                            File file = new File(Files.createTempDir(), filename);
                                            file.deleteOnExit();
                                            file.getParentFile().deleteOnExit();
                                            FileOutputStream fo = new FileOutputStream(file);
                                            multipartStream.readBodyData((OutputStream)fo);
                                            inputStreams.put(name, file);
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Failed to extract uploaded file", (Throwable)e);
                                        }
                                    } else {
                                        ByteArrayOutputStream bo = new ByteArrayOutputStream();
                                        multipartStream.readBodyData((OutputStream)bo);
                                        String value = bo.toString();
                                        headers.put(name, value);
                                    }
                                    if (name != null) {
                                        formMap.put(name, headers);
                                    }
                                    headers = new HashMap();
                                    name = null;
                                    nextPart = multipartStream.readBoundary();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Schema schema2;
                            MediaType media;
                            if (controller.getOperation().getRequestBody().getContent() == null || (media = (MediaType)controller.getOperation().getRequestBody().getContent().get((Object)"multipart/form-data")).getSchema() == null || (schema2 = media.getSchema()).getProperties() == null) break block46;
                            Map properties = schema2.getProperties();
                            for (String key : properties.keySet()) {
                                headers = (Map)formMap.get(key);
                                if (headers != null && headers.size() > 0) {
                                    if ("binary".equals(((Schema)properties.get(key)).getFormat())) {
                                        argument = inputStreams.get(key);
                                    } else {
                                        String obj = headers.get(key);
                                        if (obj != null) {
                                            JavaType jt = controller.getParameterClasses()[i];
                                            cls = jt.getRawClass();
                                            List<String> stringHeaders = Arrays.asList(obj.toString());
                                            try {
                                                argument = controller.getValidator().convertAndValidate(stringHeaders, controller.getOperation().getRequestBody(), cls, controller.getDefinitions());
                                            }
                                            catch (ConversionException e) {
                                                missingParams.add(e.getError());
                                            }
                                            catch (ValidationException e) {
                                                missingParams.add(e.getValidationMessage());
                                            }
                                        }
                                    }
                                }
                                args[i] = argument;
                                argument = null;
                                ++i;
                            }
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Couldn't find body ( ) to " + controller.getParameterClasses()[i], (Throwable)e);
                        }
                    }
                    return args;
                }
                if (!mediaType.isCompatible(javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE)) break block47;
                int i = 1;
                HashSet<String> existingKeys = new HashSet<String>();
                String formDataString = null;
                String[] parts = null;
                try {
                    formDataString = IOUtils.toString((InputStream)entityStream, (String)"UTF-8");
                    for (String part : parts = formDataString.split("&")) {
                        String[] kv = part.split("=");
                        existingKeys.add(kv[0] + ": fp");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                MediaType media = (MediaType)controller.getOperation().getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded");
                if (formDataString != null && media.getSchema() != null && (schema = media.getSchema()).getProperties() != null) {
                    Map properties = schema.getProperties();
                    for (String property : properties.keySet()) {
                        for (String part : parts) {
                            String[] kv = part.split("=");
                            if (kv == null) continue;
                            if (kv.length > 0) {
                                existingKeys.remove(kv[0] + ": fp");
                            }
                            if (kv.length != 2) continue;
                            String key = kv[0];
                            try {
                                String value = URLDecoder.decode(kv[1], "utf-8");
                                if (!property.equals(key)) continue;
                                JavaType jt = controller.getParameterClasses()[i];
                                cls = jt.getRawClass();
                                try {
                                    args[i] = argument = controller.getValidator().convertAndValidate(Arrays.asList(value), controller.getOperation().getRequestBody(), cls, controller.getDefinitions());
                                    argument = null;
                                    ++i;
                                }
                                catch (ConversionException e) {
                                    missingParams.add(e.getError());
                                }
                                catch (ValidationException e) {
                                    missingParams.add(e.getValidationMessage());
                                }
                            }
                            catch (UnsupportedEncodingException e) {
                                LOGGER.error("unable to decode value for " + key);
                            }
                        }
                    }
                }
                return args;
            }
            catch (Exception e) {
                LOGGER.trace("unable to extract entity from content-type `" + mediaType, (Throwable)e);
                throw new ConversionException().message(new ValidationMessage().code(ValidationError.UNACCEPTABLE_VALUE).message("unable to convert input to " + cls.getCanonicalName()));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object process(javax.ws.rs.core.MediaType mediaType, InputStream entityStream, JavaType javaType) {
        try {
            if (mediaType.equals((Object)javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                return entityStream;
            }
            if (!mediaType.equals((Object)javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE) && !mediaType.equals((Object)javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE)) return null;
        }
        catch (Exception e) {
            LOGGER.error("unable to extract entity from content-type `" + mediaType, (Throwable)e);
        }
        return null;
    }

    public static String extractFilenameFromHeaders(Map<String, String> headers) {
        String filename = headers.get("filename");
        if (StringUtils.isBlank((String)filename)) {
            return null;
        }
        int ix = (filename = filename.trim()).lastIndexOf(File.separatorChar);
        if (ix != -1 && StringUtils.isBlank((String)(filename = filename.substring(ix + 1).trim()))) {
            return null;
        }
        return filename;
    }

    static {
        SUPPORTED_TYPES.add(javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE);
        SUPPORTED_TYPES.add(javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        SUPPORTED_TYPES.add(javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE);
    }
}

