/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.utils;

import io.swagger.oas.inflector.Constants;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.HashMap;
import java.util.Map;

public class ExtensionsUtil {
    private Map<String, Schema> schemas;

    public void addExtensions(OpenAPI openAPI) {
        if (openAPI.getComponents() != null) {
            if (openAPI.getComponents().getSchemas() != null) {
                this.schemas = openAPI.getComponents().getSchemas();
                if (this.schemas == null) {
                    this.schemas = new HashMap<String, Schema>();
                }
            }
            for (String name : this.schemas.keySet()) {
                Schema schema = this.schemas.get(name);
                if (schema.getExtensions() != null) {
                    if (schema.getExtensions().containsKey(Constants.X_SWAGGER_ROUTER_MODEL)) continue;
                    schema.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
                    continue;
                }
                schema.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)name);
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation operation : pathItem.readOperations()) {
            Object parameter2;
            if (operation.getParameters() != null) {
                for (Object parameter2 : operation.getParameters()) {
                    Object constant;
                    Schema resolved;
                    if (parameter2.getSchema() != null && (resolved = parameter2.getSchema()) != null) {
                        for (String name : this.schemas.keySet()) {
                            Schema schema = this.schemas.get(name);
                            if (!resolved.equals((Object)schema) || (constant = (String)schema.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) == null) continue;
                            resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, constant);
                        }
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    Content content = parameter2.getContent();
                    for (String key : content.keySet()) {
                        Schema resolved2;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved2 = ((MediaType)content.get(key)).getSchema()) == null) continue;
                        constant = this.schemas.keySet().iterator();
                        while (constant.hasNext()) {
                            String constant2;
                            String name = (String)constant.next();
                            Schema schema = this.schemas.get(name);
                            if (!resolved2.equals((Object)schema) || (constant2 = (String)schema.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) == null) continue;
                            resolved2.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant2);
                        }
                        ((MediaType)content.get(key)).setSchema(resolved2);
                    }
                }
            }
            if (operation.getCallbacks() != null) {
                Map callbacks = operation.getCallbacks();
                parameter2 = callbacks.keySet().iterator();
                while (parameter2.hasNext()) {
                    String name = (String)parameter2.next();
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    for (String callbackName : callback.keySet()) {
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                Content content = operation.getRequestBody().getContent();
                parameter2 = content.keySet().iterator();
                while (parameter2.hasNext()) {
                    Schema resolved;
                    String key = (String)parameter2.next();
                    if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = ((MediaType)content.get(key)).getSchema()) == null) continue;
                    for (String name : this.schemas.keySet()) {
                        String constant;
                        Schema schema = this.schemas.get(name);
                        if (!resolved.equals((Object)schema) || (constant = (String)schema.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) == null) continue;
                        resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                    }
                    ((MediaType)content.get(key)).setSchema(resolved);
                }
            }
            if (operation.getResponses() == null) continue;
            for (String code : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content = response.getContent();
                for (String mediaType : content.keySet()) {
                    Schema resolved;
                    if (((MediaType)content.get(mediaType)).getSchema() == null || (resolved = ((MediaType)content.get(mediaType)).getSchema()) == null) continue;
                    for (String name : this.schemas.keySet()) {
                        String constant;
                        Schema schema = this.schemas.get(name);
                        if (!resolved.equals((Object)schema) || (constant = (String)schema.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL)) == null) continue;
                        resolved.addExtension(Constants.X_SWAGGER_ROUTER_MODEL, (Object)constant);
                    }
                    ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                }
            }
        }
    }
}

